/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.RandomLayout;
import noesis.model.random.GilbertNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class GilbertNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeCountEditor;
    Editor<Double> probabilityEditor;

    public GilbertNetworkUI(Application app) {
        super(app, "New Gilbert random network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.nodeCountEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeCountEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeCountEditor.setData(100);
        this.add(this.nodeCountEditor);
        RealModel probabilityModel = new RealModel();
        probabilityModel.setMinimumValue(0.0);
        probabilityModel.setMaximumValue(1.0);
        this.probabilityEditor = new Editor<Double>("Link probability", probabilityModel);
        this.probabilityEditor.setIcon(app.url("icons/calculator.png"));
        this.probabilityEditor.setData(0.1);
        this.add(this.probabilityEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new ConnectedRandomNetworkAction(this));
        this.add(ok);
    }

    public class ConnectedRandomNetworkAction
    extends Action {
        private GilbertNetworkUI ui;

        public ConnectedRandomNetworkAction(GilbertNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeCountEditor.getData();
            double probability = (Double)this.ui.probabilityEditor.getData();
            GilbertNetwork random = new GilbertNetwork(nodes, probability);
            AttributeNetwork network = GilbertNetworkUI.this.createAttributeNetwork(random, "Gilbert random network", new RandomLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

