/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.HypercubeLayout;
import noesis.model.regular.HypercubeNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class HypercubeNetworkUI
extends NewNetworkUI {
    Editor<Integer> dimensionEditor;
    Editor<Integer> columnEditor;

    public HypercubeNetworkUI(Application app) {
        super(app, "New hypercube network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel dimensionModel = new IntegerModel();
        dimensionModel.setMinimumValue(0);
        dimensionModel.setMaximumValue(10);
        this.dimensionEditor = new Editor<Integer>("Hypercube dimension", dimensionModel);
        this.dimensionEditor.setIcon(app.url("icons/calculator.png"));
        this.dimensionEditor.setData(3);
        this.add(this.dimensionEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new HypercubeNetworkAction(this));
        this.add(ok);
    }

    public class HypercubeNetworkAction
    extends Action {
        private HypercubeNetworkUI ui;

        public HypercubeNetworkAction(HypercubeNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int dimension = (Integer)this.ui.dimensionEditor.getData();
            HypercubeNetwork regular = new HypercubeNetwork(dimension);
            AttributeNetwork network = HypercubeNetworkUI.this.createAttributeNetwork(regular, "Hypercube network", new HypercubeLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

