/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.MeshLayout;
import noesis.model.regular.MeshNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class MeshNetworkUI
extends NewNetworkUI {
    Editor<Integer> rowEditor;
    Editor<Integer> columnEditor;

    public MeshNetworkUI(Application app) {
        super(app, "New mesh network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(100);
        this.rowEditor = new Editor<Integer>("Number of mesh rows", nodeCountModel);
        this.rowEditor.setIcon(app.url("icons/calculator.png"));
        this.rowEditor.setData(10);
        this.add(this.rowEditor);
        this.columnEditor = new Editor<Integer>("Number of mesh columns", nodeCountModel);
        this.columnEditor.setIcon(app.url("icons/calculator.png"));
        this.columnEditor.setData(10);
        this.add(this.columnEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new MeshNetworkAction(this));
        this.add(ok);
    }

    public class MeshNetworkAction
    extends Action {
        private MeshNetworkUI ui;

        public MeshNetworkAction(MeshNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int rows = (Integer)this.ui.rowEditor.getData();
            int columns = (Integer)this.ui.columnEditor.getData();
            MeshNetwork regular = new MeshNetwork(rows, columns);
            AttributeNetwork network = MeshNetworkUI.this.createAttributeNetwork(regular, "Complete network", new MeshLayout(rows, columns));
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

