/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.FruchtermanReingoldLayout;
import noesis.model.random.PriceCitationNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class PriceCitationNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeEditor;
    Editor<Integer> degreeEditor;
    Editor<Integer> freeEditor;

    public PriceCitationNetworkUI(Application app) {
        super(app, "New Price's citation network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.nodeEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeEditor.setData(50);
        this.add(this.nodeEditor);
        IntegerModel degreeModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.degreeEditor = new Editor<Integer>("Citations per paper (mean out-degree)", degreeModel);
        this.degreeEditor.setIcon(app.url("icons/calculator.png"));
        this.degreeEditor.setData(4);
        this.add(this.degreeEditor);
        this.freeEditor = new Editor<Integer>("Random citations ('free' citations)", degreeModel);
        this.freeEditor.setIcon(app.url("icons/calculator.png"));
        this.freeEditor.setData(1);
        this.add(this.freeEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new PriceCitationNetworkAction(this));
        this.add(ok);
    }

    public class PriceCitationNetworkAction
    extends Action {
        private PriceCitationNetworkUI ui;

        public PriceCitationNetworkAction(PriceCitationNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeEditor.getData();
            int citations = (Integer)this.ui.degreeEditor.getData();
            int free = (Integer)this.ui.freeEditor.getData();
            PriceCitationNetwork random = new PriceCitationNetwork(nodes, citations, free);
            AttributeNetwork network = PriceCitationNetworkUI.this.createAttributeNetwork(random, "Price's citation network", new FruchtermanReingoldLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

