/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.StarLayout;
import noesis.model.regular.StarNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class StarNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeCountEditor;

    public StarNetworkUI(Application app) {
        super(app, "New star network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(101);
        this.nodeCountEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeCountEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeCountEditor.setData(15);
        this.add(this.nodeCountEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new StarNetworkAction(this));
        this.add(ok);
    }

    public class StarNetworkAction
    extends Action {
        private StarNetworkUI ui;

        public StarNetworkAction(StarNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeCountEditor.getData();
            StarNetwork regular = new StarNetwork(nodes);
            AttributeNetwork network = StarNetworkUI.this.createAttributeNetwork(regular, "Star network", new StarLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

