/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.LinearLayout;
import noesis.model.regular.TandemNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class TandemNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeCountEditor;

    public TandemNetworkUI(Application app) {
        super(app, "New tandem network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(100);
        this.nodeCountEditor = new Editor<Integer>("Number of tandem nodes", nodeCountModel);
        this.nodeCountEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeCountEditor.setData(15);
        this.add(this.nodeCountEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new TandemNetworkAction(this));
        this.add(ok);
    }

    public class TandemNetworkAction
    extends Action {
        private TandemNetworkUI ui;

        public TandemNetworkAction(TandemNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeCountEditor.getData();
            TandemNetwork regular = new TandemNetwork(nodes);
            AttributeNetwork network = TandemNetworkUI.this.createAttributeNetwork(regular, "Tandem network", new LinearLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

