/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.ToroidalLayout;
import noesis.model.regular.ToroidalNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class ToroidalNetworkUI
extends NewNetworkUI {
    Editor<Integer> rowEditor;
    Editor<Integer> columnEditor;

    public ToroidalNetworkUI(Application app) {
        super(app, "New 2D toroidal network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(100);
        this.rowEditor = new Editor<Integer>("Number of torus rows", nodeCountModel);
        this.rowEditor.setIcon(app.url("icons/calculator.png"));
        this.rowEditor.setData(10);
        this.add(this.rowEditor);
        this.columnEditor = new Editor<Integer>("Number of torus columns", nodeCountModel);
        this.columnEditor.setIcon(app.url("icons/calculator.png"));
        this.columnEditor.setData(10);
        this.add(this.columnEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new ToroidalNetworkAction(this));
        this.add(ok);
    }

    public class ToroidalNetworkAction
    extends Action {
        private ToroidalNetworkUI ui;

        public ToroidalNetworkAction(ToroidalNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int rows = (Integer)this.ui.rowEditor.getData();
            int columns = (Integer)this.ui.columnEditor.getData();
            ToroidalNetwork regular = new ToroidalNetwork(rows, columns);
            AttributeNetwork network = ToroidalNetworkUI.this.createAttributeNetwork(regular, "Complete network", new ToroidalLayout(rows, columns));
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

