/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.CircularLayout;
import noesis.model.random.WattsStrogatzNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class WattsStrogatzNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeEditor;
    Editor<Integer> degreeEditor;
    Editor<Double> probabilityEditor;

    public WattsStrogatzNetworkUI(Application app) {
        super(app, "New Watts-Strogatz small world network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.nodeEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeEditor.setData(50);
        this.add(this.nodeEditor);
        IntegerModel degreeModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.degreeEditor = new Editor<Integer>("Mean degree", degreeModel);
        this.degreeEditor.setIcon(app.url("icons/calculator.png"));
        this.degreeEditor.setData(4);
        this.add(this.degreeEditor);
        RealModel probabilityModel = new RealModel();
        probabilityModel.setMinimumValue(0.0);
        probabilityModel.setMaximumValue(1.0);
        this.probabilityEditor = new Editor<Double>("Link rewiring probability", probabilityModel);
        this.probabilityEditor.setIcon(app.url("icons/calculator.png"));
        this.probabilityEditor.setData(0.1);
        this.add(this.probabilityEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new WattsStrogatzNetworkAction(this));
        this.add(ok);
    }

    public class WattsStrogatzNetworkAction
    extends Action {
        private WattsStrogatzNetworkUI ui;

        public WattsStrogatzNetworkAction(WattsStrogatzNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeEditor.getData();
            int neighbors = (Integer)this.ui.degreeEditor.getData();
            double rewiringProbability = (Double)this.ui.probabilityEditor.getData();
            WattsStrogatzNetwork random = new WattsStrogatzNetwork(nodes, neighbors, rewiringProbability);
            AttributeNetwork network = WattsStrogatzNetworkUI.this.createAttributeNetwork(random, "Watts-Strogatz's small world network", new CircularLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

