import socketserver
from _typeshed import Incomplete
from typing import Dict
from vinyl.infra.pg_proxy.core import BVType as BVType, Connection as Connection, Extension as Extension, QueryResult as QueryResult, Session as Session
from vinyl.infra.pg_proxy.rewrite import Rewriter as Rewriter

logger: Incomplete
NULL_BYTE: bytes

class ServerResponse:
    """Byte codes for server responses in the PG wire protocol."""
    AUTHENTICATION_REQUEST: bytes
    BACKEND_KEY_DATA: bytes
    BIND_COMPLETE: bytes
    CLOSE_COMPLETE: bytes
    COMMAND_COMPLETE: bytes
    DATA_ROW: bytes
    EMPTY_QUERY_RESPONSE: bytes
    ERROR_RESPONSE: bytes
    NO_DATA: bytes
    NOTICE_RESPONSE: bytes
    PARAMETER_DESCRIPTION: bytes
    PARAMETER_STATUS: bytes
    PARSE_COMPLETE: bytes
    PORTAL_SUSPENDED: bytes
    READY_FOR_QUERY: bytes
    ROW_DESCRIPTION: bytes

class TransactionStatus:
    IDLE: bytes
    IN_TRANSACTION: bytes
    IN_FAILED_TRANSACTION: bytes

class ClientCommand:
    """Byte codes for client commands in the PG wire protocol."""
    BIND: bytes
    CLOSE: bytes
    DESCRIBE: bytes
    EXECUTE: bytes
    FLUSH: bytes
    QUERY: bytes
    PARSE: bytes
    PASSWORD_MESSAGE: bytes
    SYNC: bytes
    TERMINATE: bytes

PG_UNKNOWN: Incomplete
BVTYPE_TO_PGTYPE: Incomplete

class BVBuffer:
    """A helper for reading and writing bytes in the format the PG wire protocol expects."""
    stream: Incomplete
    def __init__(self, stream: Incomplete | None = None) -> None: ...
    def read_bytes(self, n) -> bytes: ...
    def read_byte(self) -> bytes: ...
    def read_int16(self) -> int: ...
    def read_uint32(self) -> int: ...
    def read_int32(self) -> int: ...
    def write_bytes(self, value: bytes): ...
    def write_byte(self, value) -> None: ...
    def write_int16(self, value: int): ...
    def write_int32(self, value: int): ...
    def write_string(self, value) -> None: ...
    def get_value(self) -> bytes: ...

class BVContext:
    """Manages the state of a single connection to the server."""
    session: Incomplete
    rewriter: Incomplete
    params: Incomplete
    process_id: Incomplete
    secret_key: Incomplete
    stmts: Incomplete
    portals: Incomplete
    result_cache: Incomplete
    has_error: bool
    authenticated: bool
    salt: Incomplete
    def __init__(self, session: Session, rewriter: Rewriter | None, params: Dict[str, str]) -> None: ...
    def get_hashed_password(self, auth: dict) -> str: ...
    def mark_error(self) -> None: ...
    def transaction_status(self): ...
    def execute_sql(self, sql: str, params: Incomplete | None = None, result_fmt: Incomplete | None = None) -> QueryResult: ...
    def describe_portal(self, name: str) -> QueryResult: ...
    def describe_statement(self, name: str) -> QueryResult: ...
    def execute_portal(self, name: str) -> QueryResult: ...
    def add_statement(self, name: str, sql: str, param_oids: list[int]): ...
    def close_statement(self, name: str): ...
    def add_portal(self, name: str, stmt: str, params: Dict[str, str], result_formats: list[int]): ...
    def close_portal(self, name: str): ...
    def flush(self) -> None: ...
    def sync(self) -> None: ...

class ProxyServerHandler(socketserver.StreamRequestHandler):
    r: Incomplete
    def handle(self) -> None: ...
    def handle_startup(self, conn: Connection) -> BVContext: ...
    def send_auth_request(self, ctx: BVContext): ...
    def send_authentication_ok(self) -> None: ...
    def send_authentication_md5(self, ctx: BVContext): ...
    def handle_md5_password(self, ctx: BVContext, payload: bytes): ...
    def handle_post_auth(self, ctx: BVContext): ...
    def handle_query(self, ctx: BVContext, payload: bytes): ...
    def handle_parse(self, ctx: BVContext, payload: bytes): ...
    def handle_bind(self, ctx: BVContext, payload: bytes): ...
    def handle_describe(self, ctx: BVContext, payload: bytes): ...
    def handle_execute(self, ctx: BVContext, payload: bytes): ...
    def handle_close(self, ctx: BVContext, payload: bytes): ...
    def send_row_description(self, query_result: QueryResult): ...
    def send_data_rows(self, query_result: QueryResult, limit: int = 0) -> int: ...
    def send_error(self, exception, ctx: BVContext | None = None): ...
    def send_notice(self) -> None: ...
    def send_backend_key_data(self, ctx) -> None: ...
    def send_ready_for_query(self, ctx: BVContext | None): ...
    def send_parameter_status(self, params: Dict[str, str]): ...
    def send_parse_complete(self) -> None: ...
    def send_bind_complete(self) -> None: ...
    def send_close_complete(self) -> None: ...
    def send_command_complete(self, tag: str): ...

class ProxyServer(socketserver.ThreadingTCPServer):
    allow_reuse_address: bool
    conn: Incomplete
    rewriter: Incomplete
    extensions: Incomplete
    ctxts: Incomplete
    auth: Incomplete
    def __init__(self, server_address, conn: Connection, *, rewriter: Rewriter | None = None, extensions: list[Extension] = [], auth: Dict[str, str] | None = None) -> None: ...
    def verify_request(self, request, client_address) -> bool:
        """Ensure all requests come from localhost until auth is in place"""
