#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const s3 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-s3');
const inventoryBucket = new s3.Bucket(stack, 'InventoryBucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const myBucket = new s3.Bucket(stack, 'MyBucket', {
    inventories: [
        {
            destination: {
                bucket: inventoryBucket,
                prefix: 'reports',
            },
            frequency: s3.InventoryFrequency.DAILY,
            format: s3.InventoryFormat.PARQUET,
        },
    ],
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const secondInventoryBucket = new s3.Bucket(stack, 'SecondBucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
myBucket.addInventory({
    destination: {
        bucket: secondInventoryBucket,
    },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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