# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

import relayer_pb2 as relayer__pb2


class RelayerStub(object):
    """/ Relayers offer a TPU and TPU forward proxy for Solana validators.
    / Validators can connect and fetch the TPU configuration for the relayer and start to advertise the
    / relayer's information in gossip.
    / They can also subscribe to packets which arrived on the TPU ports at the relayer
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetTpuConfigs = channel.unary_unary(
                '/relayer.Relayer/GetTpuConfigs',
                request_serializer=relayer__pb2.GetTpuConfigsRequest.SerializeToString,
                response_deserializer=relayer__pb2.GetTpuConfigsResponse.FromString,
                )
        self.SubscribePackets = channel.unary_stream(
                '/relayer.Relayer/SubscribePackets',
                request_serializer=relayer__pb2.SubscribePacketsRequest.SerializeToString,
                response_deserializer=relayer__pb2.SubscribePacketsResponse.FromString,
                )


class RelayerServicer(object):
    """/ Relayers offer a TPU and TPU forward proxy for Solana validators.
    / Validators can connect and fetch the TPU configuration for the relayer and start to advertise the
    / relayer's information in gossip.
    / They can also subscribe to packets which arrived on the TPU ports at the relayer
    """

    def GetTpuConfigs(self, request, context):
        """The relayer has TPU and TPU forward sockets that validators can leverage.
        A validator can fetch this config and change its TPU and TPU forward port in gossip.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubscribePackets(self, request, context):
        """Validators can subscribe to packets from the relayer and receive a multiplexed signal that contains a mixture
        of packets and heartbeats
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RelayerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetTpuConfigs': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTpuConfigs,
                    request_deserializer=relayer__pb2.GetTpuConfigsRequest.FromString,
                    response_serializer=relayer__pb2.GetTpuConfigsResponse.SerializeToString,
            ),
            'SubscribePackets': grpc.unary_stream_rpc_method_handler(
                    servicer.SubscribePackets,
                    request_deserializer=relayer__pb2.SubscribePacketsRequest.FromString,
                    response_serializer=relayer__pb2.SubscribePacketsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'relayer.Relayer', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Relayer(object):
    """/ Relayers offer a TPU and TPU forward proxy for Solana validators.
    / Validators can connect and fetch the TPU configuration for the relayer and start to advertise the
    / relayer's information in gossip.
    / They can also subscribe to packets which arrived on the TPU ports at the relayer
    """

    @staticmethod
    def GetTpuConfigs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/relayer.Relayer/GetTpuConfigs',
            relayer__pb2.GetTpuConfigsRequest.SerializeToString,
            relayer__pb2.GetTpuConfigsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubscribePackets(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/relayer.Relayer/SubscribePackets',
            relayer__pb2.SubscribePacketsRequest.SerializeToString,
            relayer__pb2.SubscribePacketsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
