"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import collections.abc
import grpc
import relayer_pb2

class RelayerStub:
    """/ Relayers offer a TPU and TPU forward proxy for Solana validators.
    / Validators can connect and fetch the TPU configuration for the relayer and start to advertise the
    / relayer's information in gossip.
    / They can also subscribe to packets which arrived on the TPU ports at the relayer
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    GetTpuConfigs: grpc.UnaryUnaryMultiCallable[
        relayer_pb2.GetTpuConfigsRequest,
        relayer_pb2.GetTpuConfigsResponse,
    ]
    """The relayer has TPU and TPU forward sockets that validators can leverage.
    A validator can fetch this config and change its TPU and TPU forward port in gossip.
    """
    SubscribePackets: grpc.UnaryStreamMultiCallable[
        relayer_pb2.SubscribePacketsRequest,
        relayer_pb2.SubscribePacketsResponse,
    ]
    """Validators can subscribe to packets from the relayer and receive a multiplexed signal that contains a mixture
    of packets and heartbeats
    """

class RelayerServicer(metaclass=abc.ABCMeta):
    """/ Relayers offer a TPU and TPU forward proxy for Solana validators.
    / Validators can connect and fetch the TPU configuration for the relayer and start to advertise the
    / relayer's information in gossip.
    / They can also subscribe to packets which arrived on the TPU ports at the relayer
    """

    @abc.abstractmethod
    def GetTpuConfigs(
        self,
        request: relayer_pb2.GetTpuConfigsRequest,
        context: grpc.ServicerContext,
    ) -> relayer_pb2.GetTpuConfigsResponse:
        """The relayer has TPU and TPU forward sockets that validators can leverage.
        A validator can fetch this config and change its TPU and TPU forward port in gossip.
        """
    @abc.abstractmethod
    def SubscribePackets(
        self,
        request: relayer_pb2.SubscribePacketsRequest,
        context: grpc.ServicerContext,
    ) -> collections.abc.Iterator[relayer_pb2.SubscribePacketsResponse]:
        """Validators can subscribe to packets from the relayer and receive a multiplexed signal that contains a mixture
        of packets and heartbeats
        """

def add_RelayerServicer_to_server(servicer: RelayerServicer, server: grpc.Server) -> None: ...
