from setuptools import setup, find_namespace_packages

def _make_requirements(req_file: str):
    with open(req_file) as f:
        return f.read().splitlines()

core_packages = find_namespace_packages(include=['kosmoy_sdk*'], exclude=['kosmoy_sdk.langchain*'])
langchain_packages = find_namespace_packages(include=['kosmoy_sdk.langchain*'])

setup(
    name="kosmoy-sdk",
    version="0.0.8-dev",
    packages=core_packages,
    include_package_data=True,
    install_requires=_make_requirements("requirements.txt"),
    author="Olsi Hoxha",
    author_email="olsi.hoxha@kosmoy.com",
    description="A Gateway SDK for making API requests",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/KosmoyAI/kosmoy-sdk",
    extras_require={
        'langchain': _make_requirements("requirements-langchain.txt")
    },
    options={
        'extras_require': {
            'langchain': langchain_packages
        }
    }
)
