
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "sparse_tensor"

@_ods_cext.register_operation(_Dialect)
class ExtractIterSpaceOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.extract_iteration_space"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, loLvl, hiLvl, *, parentIter=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    if parentIter is not None: operands.append(_get_op_result_or_value(parentIter))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["loLvl"] = (loLvl if (
    isinstance(loLvl, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LevelAttr')) else
      _ods_ir.AttrBuilder.get('LevelAttr')(loLvl, context=_ods_context))
    attributes["hiLvl"] = (hiLvl if (
    isinstance(hiLvl, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LevelAttr')) else
      _ods_ir.AttrBuilder.get('LevelAttr')(hiLvl, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def parentIter(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def loLvl(self):
    return self.operation.attributes["loLvl"]

  @loLvl.setter
  def loLvl(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["loLvl"] = value

  @builtins.property
  def hiLvl(self):
    return self.operation.attributes["hiLvl"]

  @hiLvl.setter
  def hiLvl(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["hiLvl"] = value

  @builtins.property
  def extractedSpace(self):
    return self.operation.results[0]

def extract_iteration_space(tensor, lo_lvl, hi_lvl, *, parent_iter=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExtractIterSpaceOp(tensor=tensor, loLvl=lo_lvl, hiLvl=hi_lvl, parentIter=parent_iter, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractValOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.extract_value"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, iterator, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.append(_get_op_result_or_value(iterator))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def iterator(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def extract_value(tensor, iterator, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExtractValOp(tensor=tensor, iterator=iterator, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IterateOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.iterate"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, iterSpace, initArgs, crdUsedLvls, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(iterSpace))
    operands.extend(_get_op_results_or_values(initArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["crdUsedLvls"] = (crdUsedLvls if (
    isinstance(crdUsedLvls, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64BitSetAttr')) else
      _ods_ir.AttrBuilder.get('I64BitSetAttr')(crdUsedLvls, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iterSpace(self):
    return self.operation.operands[0]

  @builtins.property
  def initArgs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def crdUsedLvls(self):
    return self.operation.attributes["crdUsedLvls"]

  @crdUsedLvls.setter
  def crdUsedLvls(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["crdUsedLvls"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def iterate(results_, iter_space, init_args, crd_used_lvls, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IterateOp(results_=results_, iterSpace=iter_space, initArgs=init_args, crdUsedLvls=crd_used_lvls, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssembleOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.assemble"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, levels, values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(levels))
    operands.append(_get_op_result_or_value(values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def levels(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def assemble(result, levels, values, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AssembleOp(result=result, levels=levels, values=values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BinaryOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.binary"

  _ODS_REGIONS = (3, True)

  def __init__(self, output, x, y, *, left_identity=None, right_identity=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    operands.append(_get_op_result_or_value(y))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(left_identity): attributes["left_identity"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(right_identity): attributes["right_identity"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def y(self):
    return self.operation.operands[1]

  @builtins.property
  def left_identity(self):
    return "left_identity" in self.operation.attributes

  @left_identity.setter
  def left_identity(self, value):
    if bool(value):
      self.operation.attributes["left_identity"] = _ods_ir.UnitAttr.get()
    elif "left_identity" in self.operation.attributes:
      del self.operation.attributes["left_identity"]

  @left_identity.deleter
  def left_identity(self):
    del self.operation.attributes["left_identity"]

  @builtins.property
  def right_identity(self):
    return "right_identity" in self.operation.attributes

  @right_identity.setter
  def right_identity(self, value):
    if bool(value):
      self.operation.attributes["right_identity"] = _ods_ir.UnitAttr.get()
    elif "right_identity" in self.operation.attributes:
      del self.operation.attributes["right_identity"]

  @right_identity.deleter
  def right_identity(self):
    del self.operation.attributes["right_identity"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

  @builtins.property
  def overlapRegion(self):
    return self.regions[0]

  @builtins.property
  def leftRegion(self):
    return self.regions[1]

  @builtins.property
  def rightRegion(self):
    return self.regions[2]

def binary(output, x, y, *, left_identity=None, right_identity=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(BinaryOp(output=output, x=x, y=y, left_identity=left_identity, right_identity=right_identity, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoIterateOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.coiterate"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (0, False)

  def __init__(self, results_, iterSpaces, initArgs, crdUsedLvls, cases, num_caseRegions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(iterSpaces))
    operands.append(_get_op_results_or_values(initArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["crdUsedLvls"] = (crdUsedLvls if (
    isinstance(crdUsedLvls, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64BitSetAttr')) else
      _ods_ir.AttrBuilder.get('I64BitSetAttr')(crdUsedLvls, context=_ods_context))
    attributes["cases"] = (cases if (
    isinstance(cases, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64BitSetArrayAttr')) else
      _ods_ir.AttrBuilder.get('I64BitSetArrayAttr')(cases, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    regions = 0 + num_caseRegions
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iterSpaces(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def initArgs(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def crdUsedLvls(self):
    return self.operation.attributes["crdUsedLvls"]

  @crdUsedLvls.setter
  def crdUsedLvls(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["crdUsedLvls"] = value

  @builtins.property
  def cases(self):
    return self.operation.attributes["cases"]

  @cases.setter
  def cases(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cases"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def caseRegions(self):
    return self.regions[0:]

def coiterate(results_, iter_spaces, init_args, crd_used_lvls, cases, num_case_regions, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoIterateOp(results_=results_, iterSpaces=iter_spaces, initArgs=init_args, crdUsedLvls=crd_used_lvls, cases=cases, num_caseRegions=num_case_regions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CompressOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.compress"

  _ODS_REGIONS = (0, True)

  def __init__(self, values, filled, added, count, tensor, lvlCoords, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(values))
    operands.append(_get_op_result_or_value(filled))
    operands.append(_get_op_result_or_value(added))
    operands.append(_get_op_result_or_value(count))
    operands.append(_get_op_result_or_value(tensor))
    operands.extend(_get_op_results_or_values(lvlCoords))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def values(self):
    return self.operation.operands[0]

  @builtins.property
  def filled(self):
    return self.operation.operands[1]

  @builtins.property
  def added(self):
    return self.operation.operands[2]

  @builtins.property
  def count(self):
    return self.operation.operands[3]

  @builtins.property
  def tensor(self):
    return self.operation.operands[4]

  @builtins.property
  def lvlCoords(self):
    _ods_variadic_group_length = len(self.operation.operands) - 6 + 1
    return self.operation.operands[5:5 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def compress(values, filled, added, count, tensor, lvl_coords, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CompressOp(values=values, filled=filled, added=added, count=count, tensor=tensor, lvlCoords=lvl_coords, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConcatenateOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.concatenate"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DimensionAttr')) else
      _ods_ir.AttrBuilder.get('DimensionAttr')(dimension, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def concatenate(result, inputs, dimension, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConcatenateOp(result=result, inputs=inputs, dimension=dimension, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConvertOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.convert"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def convert(dest, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConvertOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CrdTranslateOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.crd_translate"

  _ODS_REGIONS = (0, True)

  def __init__(self, out_crds, in_crds, direction, encoder, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(in_crds))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["direction"] = (direction if (
    isinstance(direction, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorCrdTransDirectionAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorCrdTransDirectionAttr')(direction, context=_ods_context))
    attributes["encoder"] = (encoder if (
    isinstance(encoder, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorEncodingAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorEncodingAttr')(encoder, context=_ods_context))
    results.extend(out_crds)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_crds(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def direction(self):
    return self.operation.attributes["direction"]

  @direction.setter
  def direction(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["direction"] = value

  @builtins.property
  def encoder(self):
    return self.operation.attributes["encoder"]

  @encoder.setter
  def encoder(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["encoder"] = value

  @builtins.property
  def out_crds(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def crd_translate(out_crds, in_crds, direction, encoder, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CrdTranslateOp(out_crds=out_crds, in_crds=in_crds, direction=direction, encoder=encoder, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DisassembleOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.disassemble"

  _ODS_REGIONS = (0, True)

  def __init__(self, ret_levels, ret_values, lvl_lens, val_len, tensor, out_levels, out_values, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.extend(_get_op_results_or_values(out_levels))
    operands.append(_get_op_result_or_value(out_values))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(ret_levels)
    results.append(ret_values)
    results.extend(lvl_lens)
    results.append(val_len)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def out_levels(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def out_values(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

  @builtins.property
  def ret_levels(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.results, 2, 2, 0, 0)
    return self.operation.results[start:start + elements_per_group]

  @builtins.property
  def ret_values(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.results, 2, 2, 0, 1)
    return self.operation.results[start]

  @builtins.property
  def lvl_lens(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.results, 2, 2, 1, 1)
    return self.operation.results[start:start + elements_per_group]

  @builtins.property
  def val_len(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.results, 2, 2, 1, 2)
    return self.operation.results[start]

def disassemble(ret_levels, ret_values, lvl_lens, val_len, tensor, out_levels, out_values, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(DisassembleOp(ret_levels=ret_levels, ret_values=ret_values, lvl_lens=lvl_lens, val_len=val_len, tensor=tensor, out_levels=out_levels, out_values=out_values, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpandOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.expand"

  _ODS_REGIONS = (0, True)

  def __init__(self, values, filled, added, count, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(values)
    results.append(filled)
    results.append(added)
    results.append(count)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def values(self):
    return self.operation.results[0]

  @builtins.property
  def filled(self):
    return self.operation.results[1]

  @builtins.property
  def added(self):
    return self.operation.results[2]

  @builtins.property
  def count(self):
    return self.operation.results[3]

def expand(values, filled, added, count, tensor, *, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(ExpandOp(values=values, filled=filled, added=added, count=count, tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForeachOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.foreach"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, tensor, initArgs, *, order=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.extend(_get_op_results_or_values(initArgs))
    _ods_context = _ods_get_default_loc_context(loc)
    if order is not None: attributes["order"] = (order if (
        isinstance(order, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
          _ods_ir.AttrBuilder.get('AffineMapAttr')(order, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def initArgs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def order(self):
    if "order" not in self.operation.attributes:
      return None
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value):
    if value is not None:
      self.operation.attributes["order"] = value
    elif "order" in self.operation.attributes:
      del self.operation.attributes["order"]

  @order.deleter
  def order(self):
    del self.operation.attributes["order"]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def foreach(results_, tensor, init_args, *, order=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ForeachOp(results_=results_, tensor=tensor, initArgs=init_args, order=order, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GetStorageSpecifierOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.storage_specifier.get"

  _ODS_REGIONS = (0, True)

  def __init__(self, specifier, specifierKind, *, level=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(specifier))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["specifierKind"] = (specifierKind if (
    isinstance(specifierKind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorStorageSpecifierKindAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorStorageSpecifierKindAttr')(specifierKind, context=_ods_context))
    if level is not None: attributes["level"] = (level if (
        isinstance(level, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LevelAttr')) else
          _ods_ir.AttrBuilder.get('LevelAttr')(level, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def specifier(self):
    return self.operation.operands[0]

  @builtins.property
  def specifierKind(self):
    return self.operation.attributes["specifierKind"]

  @specifierKind.setter
  def specifierKind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["specifierKind"] = value

  @builtins.property
  def level(self):
    if "level" not in self.operation.attributes:
      return None
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is not None:
      self.operation.attributes["level"] = value
    elif "level" in self.operation.attributes:
      del self.operation.attributes["level"]

  @level.deleter
  def level(self):
    del self.operation.attributes["level"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def storage_specifier_get(specifier, specifier_kind, *, level=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(GetStorageSpecifierOp(specifier=specifier, specifierKind=specifier_kind, level=level, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HasRuntimeLibraryOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.has_runtime_library"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def has_runtime_library(*, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(HasRuntimeLibraryOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, hasInserts=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(hasInserts): attributes["hasInserts"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def hasInserts(self):
    return "hasInserts" in self.operation.attributes

  @hasInserts.setter
  def hasInserts(self, value):
    if bool(value):
      self.operation.attributes["hasInserts"] = _ods_ir.UnitAttr.get()
    elif "hasInserts" in self.operation.attributes:
      del self.operation.attributes["hasInserts"]

  @hasInserts.deleter
  def hasInserts(self):
    del self.operation.attributes["hasInserts"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def load(tensor, *, has_inserts=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LoadOp(tensor=tensor, hasInserts=has_inserts, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LvlOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.lvl"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def lvl(source, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LvlOp(source=source, index=index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NewOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.new"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def new(result, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(NewOp(result=result, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NumberOfEntriesOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.number_of_entries"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def number_of_entries(tensor, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(NumberOfEntriesOp(tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OutOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.out"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, dest, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.operands[1]

def out(tensor, dest, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(OutOp(tensor=tensor, dest=dest, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PrintOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.print"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

def print_(tensor, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(PrintOp(tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PushBackOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.push_back"

  _ODS_REGIONS = (0, True)

  def __init__(self, curSize, inBuffer, value, *, n=None, inbounds=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(curSize))
    operands.append(_get_op_result_or_value(inBuffer))
    operands.append(_get_op_result_or_value(value))
    if n is not None: operands.append(_get_op_result_or_value(n))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(inbounds): attributes["inbounds"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def curSize(self):
    return self.operation.operands[0]

  @builtins.property
  def inBuffer(self):
    return self.operation.operands[1]

  @builtins.property
  def value(self):
    return self.operation.operands[2]

  @builtins.property
  def n(self):
    return None if len(self.operation.operands) < 4 else self.operation.operands[3]

  @builtins.property
  def inbounds(self):
    return "inbounds" in self.operation.attributes

  @inbounds.setter
  def inbounds(self, value):
    if bool(value):
      self.operation.attributes["inbounds"] = _ods_ir.UnitAttr.get()
    elif "inbounds" in self.operation.attributes:
      del self.operation.attributes["inbounds"]

  @inbounds.deleter
  def inbounds(self):
    del self.operation.attributes["inbounds"]

  @builtins.property
  def outBuffer(self):
    return self.operation.results[0]

  @builtins.property
  def newSize(self):
    return self.operation.results[1]

def push_back(cur_size, in_buffer, value, *, n=None, inbounds=None, loc=None, ip=None) -> _Sequence[_ods_ir.Value]:
  return _get_op_result_or_op_results(PushBackOp(curSize=cur_size, inBuffer=in_buffer, value=value, n=n, inbounds=inbounds, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, x, y, identity, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    operands.append(_get_op_result_or_value(y))
    operands.append(_get_op_result_or_value(identity))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def y(self):
    return self.operation.operands[1]

  @builtins.property
  def identity(self):
    return self.operation.operands[2]

  @builtins.property
  def output(self):
    return self.operation.results[0]

  @builtins.property
  def region(self):
    return self.regions[0]

def reduce(x, y, identity, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReduceOp(x=x, y=y, identity=identity, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReinterpretMapOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.reinterpret_map"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def reinterpret_map(dest, source, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReinterpretMapOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReorderCOOOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.reorder_coo"

  _ODS_REGIONS = (0, True)

  def __init__(self, result_coo, input_coo, algorithm, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input_coo))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["algorithm"] = (algorithm if (
    isinstance(algorithm, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorSortKindAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorSortKindAttr')(algorithm, context=_ods_context))
    results.append(result_coo)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input_coo(self):
    return self.operation.operands[0]

  @builtins.property
  def algorithm(self):
    return self.operation.attributes["algorithm"]

  @algorithm.setter
  def algorithm(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["algorithm"] = value

  @builtins.property
  def result_coo(self):
    return self.operation.results[0]

def reorder_coo(result_coo, input_coo, algorithm, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReorderCOOOp(result_coo=result_coo, input_coo=input_coo, algorithm=algorithm, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SelectOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.select"

  _ODS_REGIONS = (1, True)

  def __init__(self, x, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

  @builtins.property
  def region(self):
    return self.regions[0]

def select(x, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SelectOp(x=x, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SetStorageSpecifierOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.storage_specifier.set"

  _ODS_REGIONS = (0, True)

  def __init__(self, specifier, specifierKind, value, *, level=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(specifier))
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["specifierKind"] = (specifierKind if (
    isinstance(specifierKind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorStorageSpecifierKindAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorStorageSpecifierKindAttr')(specifierKind, context=_ods_context))
    if level is not None: attributes["level"] = (level if (
        isinstance(level, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LevelAttr')) else
          _ods_ir.AttrBuilder.get('LevelAttr')(level, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def specifier(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

  @builtins.property
  def specifierKind(self):
    return self.operation.attributes["specifierKind"]

  @specifierKind.setter
  def specifierKind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["specifierKind"] = value

  @builtins.property
  def level(self):
    if "level" not in self.operation.attributes:
      return None
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is not None:
      self.operation.attributes["level"] = value
    elif "level" in self.operation.attributes:
      del self.operation.attributes["level"]

  @level.deleter
  def level(self):
    del self.operation.attributes["level"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def storage_specifier_set(specifier, specifier_kind, value, *, level=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SetStorageSpecifierOp(specifier=specifier, specifierKind=specifier_kind, value=value, level=level, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SortOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.sort"

  _ODS_REGIONS = (0, True)

  def __init__(self, n, xy, ys, perm_map, algorithm, *, ny=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(n))
    operands.append(_get_op_result_or_value(xy))
    operands.extend(_get_op_results_or_values(ys))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["perm_map"] = (perm_map if (
    isinstance(perm_map, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(perm_map, context=_ods_context))
    if ny is not None: attributes["ny"] = (ny if (
        isinstance(ny, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('IndexAttr')) else
          _ods_ir.AttrBuilder.get('IndexAttr')(ny, context=_ods_context))
    attributes["algorithm"] = (algorithm if (
    isinstance(algorithm, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SparseTensorSortKindAttr')) else
      _ods_ir.AttrBuilder.get('SparseTensorSortKindAttr')(algorithm, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def n(self):
    return self.operation.operands[0]

  @builtins.property
  def xy(self):
    return self.operation.operands[1]

  @builtins.property
  def ys(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def perm_map(self):
    return self.operation.attributes["perm_map"]

  @perm_map.setter
  def perm_map(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["perm_map"] = value

  @builtins.property
  def ny(self):
    if "ny" not in self.operation.attributes:
      return None
    return self.operation.attributes["ny"]

  @ny.setter
  def ny(self, value):
    if value is not None:
      self.operation.attributes["ny"] = value
    elif "ny" in self.operation.attributes:
      del self.operation.attributes["ny"]

  @ny.deleter
  def ny(self):
    del self.operation.attributes["ny"]

  @builtins.property
  def algorithm(self):
    return self.operation.attributes["algorithm"]

  @algorithm.setter
  def algorithm(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["algorithm"] = value

def sort(n, xy, ys, perm_map, algorithm, *, ny=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SortOp(n=n, xy=xy, ys=ys, perm_map=perm_map, algorithm=algorithm, ny=ny, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StorageSpecifierInitOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.storage_specifier.init"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, source=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if source is not None: operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def storage_specifier_init(result, *, source=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StorageSpecifierInitOp(result=result, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToCoordinatesBufferOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.coordinates_buffer"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def coordinates_buffer(tensor, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToCoordinatesBufferOp(tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToCoordinatesOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.coordinates"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, level, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LevelAttr')) else
      _ods_ir.AttrBuilder.get('LevelAttr')(level, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def level(self):
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def coordinates(tensor, level, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToCoordinatesOp(tensor=tensor, level=level, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToPositionsOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.positions"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, level, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LevelAttr')) else
      _ods_ir.AttrBuilder.get('LevelAttr')(level, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def level(self):
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def positions(tensor, level, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToPositionsOp(tensor=tensor, level=level, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToSliceOffsetOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.slice.offset"

  _ODS_REGIONS = (0, True)

  def __init__(self, slice, dim, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(slice))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(dim, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def slice(self):
    return self.operation.operands[0]

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def offset(self):
    return self.operation.results[0]

def slice_offset(slice, dim, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToSliceOffsetOp(slice=slice, dim=dim, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToSliceStrideOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.slice.stride"

  _ODS_REGIONS = (0, True)

  def __init__(self, slice, dim, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(slice))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(dim, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def slice(self):
    return self.operation.operands[0]

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def stride(self):
    return self.operation.results[0]

def slice_stride(slice, dim, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToSliceStrideOp(slice=slice, dim=dim, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ToValuesOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.values"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def values(tensor, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ToValuesOp(tensor=tensor, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnaryOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.unary"

  _ODS_REGIONS = (2, True)

  def __init__(self, output, x, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

  @builtins.property
  def presentRegion(self):
    return self.regions[0]

  @builtins.property
  def absentRegion(self):
    return self.regions[1]

def unary(output, x, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnaryOp(output=output, x=x, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "sparse_tensor.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(YieldOp(results_=results_, loc=loc, ip=ip))
