"""
Descriptors derived from a molecule's 3D structure

"""
from __future__ import annotations
from rdkit.Chem.Descriptors import _isCallable
from rdkit.Chem import rdMolDescriptors
__all__ = ['CalcMolDescriptors3D', 'descList', 'rdMolDescriptors']
def CalcMolDescriptors3D(mol, confId = None):
    """
    
    Compute all 3D descriptors of a molecule
    
    Arguments:
    - mol: the molecule to work with
    - confId: conformer ID to work with. If not specified the default (-1) is used
    
    Return:
    
    dict
        A dictionary with decriptor names as keys and the descriptor values as values
    
    raises a ValueError 
        If the molecule does not have conformers
    """
def _setupDescriptors(namespace):
    ...
descList: list  # value = [('PMI1', <function <lambda> at 0xffff8e652e80>), ('PMI2', <function <lambda> at 0xffff8e653060>), ('PMI3', <function <lambda> at 0xffff8e6536a0>), ('NPR1', <function <lambda> at 0xffff8e653740>), ('NPR2', <function <lambda> at 0xffff8e6537e0>), ('RadiusOfGyration', <function <lambda> at 0xffff8e653880>), ('InertialShapeFactor', <function <lambda> at 0xffff8e653920>), ('Eccentricity', <function <lambda> at 0xffff8e6539c0>), ('Asphericity', <function <lambda> at 0xffff8e653a60>), ('SpherocityIndex', <function <lambda> at 0xffff8e653b00>), ('PBF', <function <lambda> at 0xffff8e653ba0>)]
