import infraflow.cdk.iam._actions as actions
from infraflow.cdk.iam.base import IamAction


class A4B:
    all = IamAction("a4b", all=True)
    AssociateDeviceWithRoom = actions.A4BAssociateDeviceWithRoom()
    AssociateSkillGroupWithRoom = actions.A4BAssociateSkillGroupWithRoom()
    CreateProfile = actions.A4BCreateProfile()
    CreateRoom = actions.A4BCreateRoom()
    CreateSkillGroup = actions.A4BCreateSkillGroup()
    CreateUser = actions.A4BCreateUser()
    DeleteProfile = actions.A4BDeleteProfile()
    DeleteRoom = actions.A4BDeleteRoom()
    DeleteRoomSkillParameter = actions.A4BDeleteRoomSkillParameter()
    DeleteSkillGroup = actions.A4BDeleteSkillGroup()
    DeleteUser = actions.A4BDeleteUser()
    DisassociateDeviceFromRoom = actions.A4BDisassociateDeviceFromRoom()
    DisassociateSkillGroupFromRoom = actions.A4BDisassociateSkillGroupFromRoom()
    GetDevice = actions.A4BGetDevice()
    GetProfile = actions.A4BGetProfile()
    GetRoom = actions.A4BGetRoom()
    GetRoomSkillParameter = actions.A4BGetRoomSkillParameter()
    GetSkillGroup = actions.A4BGetSkillGroup()
    ListSkills = actions.A4BListSkills()
    ListTags = actions.A4BListTags()
    PutRoomSkillParameter = actions.A4BPutRoomSkillParameter()
    ResolveRoom = actions.A4BResolveRoom()
    RevokeInvitation = actions.A4BRevokeInvitation()
    SearchDevices = actions.A4BSearchDevices()
    SearchProfiles = actions.A4BSearchProfiles()
    SearchRooms = actions.A4BSearchRooms()
    SearchSkillGroups = actions.A4BSearchSkillGroups()
    SearchUsers = actions.A4BSearchUsers()
    SendInvitation = actions.A4BSendInvitation()
    StartDeviceSync = actions.A4BStartDeviceSync()
    TagResource = actions.A4BTagResource()
    UntagResource = actions.A4BUntagResource()
    UpdateDevice = actions.A4BUpdateDevice()
    UpdateProfile = actions.A4BUpdateProfile()
    UpdateRoom = actions.A4BUpdateRoom()
    UpdateSkillGroup = actions.A4BUpdateSkillGroup()


class Acm:
    all = IamAction("acm", all=True)
    AddTagsToCertificate = actions.AcmAddTagsToCertificate()
    DeleteCertificate = actions.AcmDeleteCertificate()
    DescribeCertificate = actions.AcmDescribeCertificate()
    GetCertificate = actions.AcmGetCertificate()
    ImportCertificate = actions.AcmImportCertificate()
    ListCertificates = actions.AcmListCertificates()
    ListTagsForCertificate = actions.AcmListTagsForCertificate()
    RemoveTagsFromCertificate = actions.AcmRemoveTagsFromCertificate()
    RequestCertificate = actions.AcmRequestCertificate()
    ResendValidationEmail = actions.AcmResendValidationEmail()


class ApiGateway:
    all = IamAction("apigateway", all=True)
    DELETE = actions.ApiGatewayDELETE()
    GET = actions.ApiGatewayGET()
    HEAD = actions.ApiGatewayHEAD()
    OPTIONS = actions.ApiGatewayOPTIONS()
    PATCH = actions.ApiGatewayPATCH()
    POST = actions.ApiGatewayPOST()
    PUT = actions.ApiGatewayPUT()


class ApplicationAutoscaling:
    all = IamAction("application-autoscaling", all=True)
    DeleteScalingPolicy = actions.ApplicationAutoscalingDeleteScalingPolicy()
    DeleteScheduledAction = actions.ApplicationAutoscalingDeleteScheduledAction()
    DeregisterScalableTarget = actions.ApplicationAutoscalingDeregisterScalableTarget()
    DescribeScalableTargets = actions.ApplicationAutoscalingDescribeScalableTargets()
    DescribeScalingActivities = actions.ApplicationAutoscalingDescribeScalingActivities()
    DescribeScalingPolicies = actions.ApplicationAutoscalingDescribeScalingPolicies()
    DescribeScheduledActions = actions.ApplicationAutoscalingDescribeScheduledActions()
    PutScalingPolicy = actions.ApplicationAutoscalingPutScalingPolicy()
    PutScheduledAction = actions.ApplicationAutoscalingPutScheduledAction()
    RegisterScalableTarget = actions.ApplicationAutoscalingRegisterScalableTarget()


class AppStream:
    all = IamAction("appstream", all=True)
    AssociateFleet = actions.AppstreamAssociateFleet()
    CreateDirectoryConfig = actions.AppstreamCreateDirectoryConfig()
    CreateFleet = actions.AppstreamCreateFleet()
    CreateImageBuilder = actions.AppstreamCreateImageBuilder()
    CreateImageBuilderStreamingURL = actions.AppstreamCreateImageBuilderStreamingURL()
    CreateStack = actions.AppstreamCreateStack()
    CreateStreamingURL = actions.AppstreamCreateStreamingURL()
    DeleteDirectoryConfig = actions.AppstreamDeleteDirectoryConfig()
    DeleteFleet = actions.AppstreamDeleteFleet()
    DeleteImage = actions.AppstreamDeleteImage()
    DeleteImageBuilder = actions.AppstreamDeleteImageBuilder()
    DeleteStack = actions.AppstreamDeleteStack()
    DescribeDirectoryConfigs = actions.AppstreamDescribeDirectoryConfigs()
    DescribeFleets = actions.AppstreamDescribeFleets()
    DescribeImageBuilders = actions.AppstreamDescribeImageBuilders()
    DescribeImages = actions.AppstreamDescribeImages()
    DescribeSessions = actions.AppstreamDescribeSessions()
    DescribeStacks = actions.AppstreamDescribeStacks()
    DisassociateFleet = actions.AppstreamDisassociateFleet()
    ExpireSession = actions.AppstreamExpireSession()
    ListAssociatedFleets = actions.AppstreamListAssociatedFleets()
    ListAssociatedStacks = actions.AppstreamListAssociatedStacks()
    ListTagsForResource = actions.AppstreamListTagsForResource()
    StartFleet = actions.AppstreamStartFleet()
    StartImageBuilder = actions.AppstreamStartImageBuilder()
    StopFleet = actions.AppstreamStopFleet()
    StopImageBuilder = actions.AppstreamStopImageBuilder()
    Stream = actions.AppstreamStream()
    TagResource = actions.AppstreamTagResource()
    UntagResource = actions.AppstreamUntagResource()
    UpdateDirectoryConfig = actions.AppstreamUpdateDirectoryConfig()
    UpdateFleet = actions.AppstreamUpdateFleet()
    UpdateStack = actions.AppstreamUpdateStack()


class AppSync:
    all = IamAction("appsync", all=True)
    CreateApiKey = actions.AppsyncCreateApiKey()
    CreateDataSource = actions.AppsyncCreateDataSource()
    CreateGraphqlApi = actions.AppsyncCreateGraphqlApi()
    CreateResolver = actions.AppsyncCreateResolver()
    CreateType = actions.AppsyncCreateType()
    DeleteApiKey = actions.AppsyncDeleteApiKey()
    DeleteDataSource = actions.AppsyncDeleteDataSource()
    DeleteGraphqlApi = actions.AppsyncDeleteGraphqlApi()
    DeleteResolver = actions.AppsyncDeleteResolver()
    DeleteType = actions.AppsyncDeleteType()
    GetDataSource = actions.AppsyncGetDataSource()
    GetGraphqlApi = actions.AppsyncGetGraphqlApi()
    GetIntrospectionSchema = actions.AppsyncGetIntrospectionSchema()
    GetResolver = actions.AppsyncGetResolver()
    GetSchemaCreationStatus = actions.AppsyncGetSchemaCreationStatus()
    GetType = actions.AppsyncGetType()
    GraphQL = actions.AppsyncGraphQL()
    ListApiKeys = actions.AppsyncListApiKeys()
    ListDataSources = actions.AppsyncListDataSources()
    ListGraphqlApis = actions.AppsyncListGraphqlApis()
    ListResolvers = actions.AppsyncListResolvers()
    ListTypes = actions.AppsyncListTypes()
    StartSchemaCreation = actions.AppsyncStartSchemaCreation()
    UpdateApiKey = actions.AppsyncUpdateApiKey()
    UpdateDataSource = actions.AppsyncUpdateDataSource()
    UpdateGraphqlApi = actions.AppsyncUpdateGraphqlApi()
    UpdateResolver = actions.AppsyncUpdateResolver()
    UpdateType = actions.AppsyncUpdateType()


class Artifact:
    all = IamAction("artifact", all=True)
    AcceptAgreement = actions.ArtifactAcceptAgreement()
    DownloadAgreement = actions.ArtifactDownloadAgreement()
    Get = actions.ArtifactGet()
    TerminateAgreement = actions.ArtifactTerminateAgreement()


class Athena:
    all = IamAction("athena", all=True)
    BatchGetNamedQuery = actions.AthenaBatchGetNamedQuery()
    BatchGetQueryExecution = actions.AthenaBatchGetQueryExecution()
    CancelQueryExecution = actions.AthenaCancelQueryExecution()
    CreateNamedQuery = actions.AthenaCreateNamedQuery()
    DeleteNamedQuery = actions.AthenaDeleteNamedQuery()
    GetCatalogs = actions.AthenaGetCatalogs()
    GetExecutionEngine = actions.AthenaGetExecutionEngine()
    GetExecutionEngines = actions.AthenaGetExecutionEngines()
    GetNamedQuery = actions.AthenaGetNamedQuery()
    GetNamespace = actions.AthenaGetNamespace()
    GetNamespaces = actions.AthenaGetNamespaces()
    GetQueryExecution = actions.AthenaGetQueryExecution()
    GetQueryExecutions = actions.AthenaGetQueryExecutions()
    GetQueryResults = actions.AthenaGetQueryResults()
    GetTable = actions.AthenaGetTable()
    GetTables = actions.AthenaGetTables()
    ListNamedQueries = actions.AthenaListNamedQueries()
    ListQueryExecutions = actions.AthenaListQueryExecutions()
    RunQuery = actions.AthenaRunQuery()
    StartQueryExecution = actions.AthenaStartQueryExecution()
    StopQueryExecution = actions.AthenaStopQueryExecution()


class AutoScalingPlans:
    all = IamAction("autoscaling-plans", all=True)
    CreateScalingPlan = actions.AutoscalingPlansCreateScalingPlan()
    DeleteScalingPlan = actions.AutoscalingPlansDeleteScalingPlan()
    DescribeScalingPlanResources = actions.AutoscalingPlansDescribeScalingPlanResources()
    DescribeScalingPlans = actions.AutoscalingPlansDescribeScalingPlans()


class AutoScaling:
    all = IamAction("autoscaling", all=True)
    AttachInstances = actions.AutoscalingAttachInstances()
    AttachLoadBalancerTargetGroups = actions.AutoscalingAttachLoadBalancerTargetGroups()
    AttachLoadBalancers = actions.AutoscalingAttachLoadBalancers()
    CompleteLifecycleAction = actions.AutoscalingCompleteLifecycleAction()
    CreateAutoScalingGroup = actions.AutoscalingCreateAutoScalingGroup()
    CreateLaunchConfiguration = actions.AutoscalingCreateLaunchConfiguration()
    CreateOrUpdateTags = actions.AutoscalingCreateOrUpdateTags()
    DeleteAutoScalingGroup = actions.AutoscalingDeleteAutoScalingGroup()
    DeleteLaunchConfiguration = actions.AutoscalingDeleteLaunchConfiguration()
    DeleteLifecycleHook = actions.AutoscalingDeleteLifecycleHook()
    DeleteNotificationConfiguration = actions.AutoscalingDeleteNotificationConfiguration()
    DeletePolicy = actions.AutoscalingDeletePolicy()
    DeleteScheduledAction = actions.AutoscalingDeleteScheduledAction()
    DeleteTags = actions.AutoscalingDeleteTags()
    DescribeAccountLimits = actions.AutoscalingDescribeAccountLimits()
    DescribeAdjustmentTypes = actions.AutoscalingDescribeAdjustmentTypes()
    DescribeAutoScalingGroups = actions.AutoscalingDescribeAutoScalingGroups()
    DescribeAutoScalingInstances = actions.AutoscalingDescribeAutoScalingInstances()
    DescribeAutoScalingNotificationTypes = actions.AutoscalingDescribeAutoScalingNotificationTypes()
    DescribeLaunchConfigurations = actions.AutoscalingDescribeLaunchConfigurations()
    DescribeLifecycleHookTypes = actions.AutoscalingDescribeLifecycleHookTypes()
    DescribeLifecycleHooks = actions.AutoscalingDescribeLifecycleHooks()
    DescribeLoadBalancerTargetGroups = actions.AutoscalingDescribeLoadBalancerTargetGroups()
    DescribeLoadBalancers = actions.AutoscalingDescribeLoadBalancers()
    DescribeMetricCollectionTypes = actions.AutoscalingDescribeMetricCollectionTypes()
    DescribeNotificationConfigurations = actions.AutoscalingDescribeNotificationConfigurations()
    DescribePolicies = actions.AutoscalingDescribePolicies()
    DescribeScalingActivities = actions.AutoscalingDescribeScalingActivities()
    DescribeScalingProcessTypes = actions.AutoscalingDescribeScalingProcessTypes()
    DescribeScheduledActions = actions.AutoscalingDescribeScheduledActions()
    DescribeTags = actions.AutoscalingDescribeTags()
    DescribeTerminationPolicyTypes = actions.AutoscalingDescribeTerminationPolicyTypes()
    DetachInstances = actions.AutoscalingDetachInstances()
    DetachLoadBalancerTargetGroups = actions.AutoscalingDetachLoadBalancerTargetGroups()
    DetachLoadBalancers = actions.AutoscalingDetachLoadBalancers()
    DisableMetricsCollection = actions.AutoscalingDisableMetricsCollection()
    EnableMetricsCollection = actions.AutoscalingEnableMetricsCollection()
    EnterStandby = actions.AutoscalingEnterStandby()
    ExecutePolicy = actions.AutoscalingExecutePolicy()
    ExitStandby = actions.AutoscalingExitStandby()
    PutLifecycleHook = actions.AutoscalingPutLifecycleHook()
    PutNotificationConfiguration = actions.AutoscalingPutNotificationConfiguration()
    PutScalingPolicy = actions.AutoscalingPutScalingPolicy()
    PutScheduledUpdateGroupAction = actions.AutoscalingPutScheduledUpdateGroupAction()
    RecordLifecycleActionHeartbeat = actions.AutoscalingRecordLifecycleActionHeartbeat()
    ResumeProcesses = actions.AutoscalingResumeProcesses()
    SetDesiredCapacity = actions.AutoscalingSetDesiredCapacity()
    SetInstanceHealth = actions.AutoscalingSetInstanceHealth()
    SetInstanceProtection = actions.AutoscalingSetInstanceProtection()
    SuspendProcesses = actions.AutoscalingSuspendProcesses()
    TerminateInstanceInAutoScalingGroup = actions.AutoscalingTerminateInstanceInAutoScalingGroup()
    UpdateAutoScalingGroup = actions.AutoscalingUpdateAutoScalingGroup()


class AwsMarketplaceManagement:
    all = IamAction("aws-marketplace-management", all=True)
    uploadFiles = actions.AwsMarketplaceManagementuploadFiles()
    viewMarketing = actions.AwsMarketplaceManagementviewMarketing()
    viewReports = actions.AwsMarketplaceManagementviewReports()
    viewSupport = actions.AwsMarketplaceManagementviewSupport()


class AwsMarketplace:
    all = IamAction("aws-marketplace", all=True)
    BatchMeterUsage = actions.AwsMarketplaceBatchMeterUsage()
    MeterUsage = actions.AwsMarketplaceMeterUsage()
    ResolveCustomer = actions.AwsMarketplaceResolveCustomer()
    Subscribe = actions.AwsMarketplaceSubscribe()
    Unsubscribe = actions.AwsMarketplaceUnsubscribe()
    ViewSubscriptions = actions.AwsMarketplaceViewSubscriptions()


class AwsPortal:
    all = IamAction("aws-portal", all=True)
    ModifyAccount = actions.AwsPortalModifyAccount()
    ModifyBilling = actions.AwsPortalModifyBilling()
    ModifyPaymentMethods = actions.AwsPortalModifyPaymentMethods()
    ViewAccount = actions.AwsPortalViewAccount()
    ViewBilling = actions.AwsPortalViewBilling()
    ViewPaymentMethods = actions.AwsPortalViewPaymentMethods()
    ViewUsage = actions.AwsPortalViewUsage()


class Batch:
    all = IamAction("batch", all=True)
    CancelJob = actions.BatchCancelJob()
    CreateComputeEnvironment = actions.BatchCreateComputeEnvironment()
    CreateJobQueue = actions.BatchCreateJobQueue()
    DeleteComputeEnvironment = actions.BatchDeleteComputeEnvironment()
    DeleteJobQueue = actions.BatchDeleteJobQueue()
    DeregisterJobDefinition = actions.BatchDeregisterJobDefinition()
    DescribeComputeEnvironments = actions.BatchDescribeComputeEnvironments()
    DescribeJobDefinitions = actions.BatchDescribeJobDefinitions()
    DescribeJobQueues = actions.BatchDescribeJobQueues()
    DescribeJobs = actions.BatchDescribeJobs()
    ListJobs = actions.BatchListJobs()
    RegisterJobDefinition = actions.BatchRegisterJobDefinition()
    SubmitJob = actions.BatchSubmitJob()
    TerminateJob = actions.BatchTerminateJob()
    UpdateComputeEnvironment = actions.BatchUpdateComputeEnvironment()
    UpdateJobQueue = actions.BatchUpdateJobQueue()


class Budgets:
    all = IamAction("budgets", all=True)
    ModifyBudget = actions.BudgetsModifyBudget()
    ViewBudget = actions.BudgetsViewBudget()


class Ce:
    all = IamAction("ce", all=True)
    GetCostAndUsage = actions.CeGetCostAndUsage()
    GetDimensionValues = actions.CeGetDimensionValues()
    GetReservationUtilization = actions.CeGetReservationUtilization()
    GetTags = actions.CeGetTags()


class Chime:
    all = IamAction("chime", all=True)
    AcceptDelegate = actions.ChimeAcceptDelegate()
    ActivateUsers = actions.ChimeActivateUsers()
    AddDomain = actions.ChimeAddDomain()
    AddOrUpdateGroups = actions.ChimeAddOrUpdateGroups()
    AuthorizeDirectory = actions.ChimeAuthorizeDirectory()
    ConnectDirectory = actions.ChimeConnectDirectory()
    CreateAccount = actions.ChimeCreateAccount()
    CreateCDRBucket = actions.ChimeCreateCDRBucket()
    DeleteAccount = actions.ChimeDeleteAccount()
    DeleteCDRBucket = actions.ChimeDeleteCDRBucket()
    DeleteDelegate = actions.ChimeDeleteDelegate()
    DeleteDomain = actions.ChimeDeleteDomain()
    DeleteGroups = actions.ChimeDeleteGroups()
    DisconnectDirectory = actions.ChimeDisconnectDirectory()
    GetAccount = actions.ChimeGetAccount()
    GetAccountResource = actions.ChimeGetAccountResource()
    GetAccountSettings = actions.ChimeGetAccountSettings()
    GetCDRBucket = actions.ChimeGetCDRBucket()
    GetDomain = actions.ChimeGetDomain()
    GetUser = actions.ChimeGetUser()
    GetUserByEmail = actions.ChimeGetUserByEmail()
    InviteDelegate = actions.ChimeInviteDelegate()
    InviteUsers = actions.ChimeInviteUsers()
    ListAccounts = actions.ChimeListAccounts()
    ListCDRBucket = actions.ChimeListCDRBucket()
    ListDelegates = actions.ChimeListDelegates()
    ListDirectories = actions.ChimeListDirectories()
    ListDomains = actions.ChimeListDomains()
    ListGroups = actions.ChimeListGroups()
    ListUsers = actions.ChimeListUsers()
    LogoutUser = actions.ChimeLogoutUser()
    RenameAccount = actions.ChimeRenameAccount()
    RenewDelegate = actions.ChimeRenewDelegate()
    ResetAccountResource = actions.ChimeResetAccountResource()
    ResetPersonalPin = actions.ChimeResetPersonalPin()
    SubmitSupportRequest = actions.ChimeSubmitSupportRequest()
    SuspendUsers = actions.ChimeSuspendUsers()
    UnauthorizeDirectory = actions.ChimeUnauthorizeDirectory()
    UpdateAccountResource = actions.ChimeUpdateAccountResource()
    UpdateAccountSettings = actions.ChimeUpdateAccountSettings()
    UpdateCDRBucket = actions.ChimeUpdateCDRBucket()
    UpdateSupportedLicenses = actions.ChimeUpdateSupportedLicenses()
    UpdateUserLicenses = actions.ChimeUpdateUserLicenses()
    ValidateAccountResource = actions.ChimeValidateAccountResource()
    ValidateDelegate = actions.ChimeValidateDelegate()


class Cloud9:
    all = IamAction("cloud9", all=True)
    CreateEnvironmentEC2 = actions.Cloud9CreateEnvironmentEC2()
    CreateEnvironmentMembership = actions.Cloud9CreateEnvironmentMembership()
    CreateEnvironmentSSH = actions.Cloud9CreateEnvironmentSSH()
    DeleteEnvironment = actions.Cloud9DeleteEnvironment()
    DeleteEnvironmentMembership = actions.Cloud9DeleteEnvironmentMembership()
    DescribeEnvironmentMemberships = actions.Cloud9DescribeEnvironmentMemberships()
    DescribeEnvironmentStatus = actions.Cloud9DescribeEnvironmentStatus()
    DescribeEnvironments = actions.Cloud9DescribeEnvironments()
    GetUserPublicKey = actions.Cloud9GetUserPublicKey()
    ListEnvironments = actions.Cloud9ListEnvironments()
    UpdateEnvironment = actions.Cloud9UpdateEnvironment()
    UpdateEnvironmentMembership = actions.Cloud9UpdateEnvironmentMembership()
    ValidateEnvironmentName = actions.Cloud9ValidateEnvironmentName()


class CloudDirectory:
    all = IamAction("clouddirectory", all=True)
    AddFacetToObject = actions.ClouddirectoryAddFacetToObject()
    ApplySchema = actions.ClouddirectoryApplySchema()
    AttachObject = actions.ClouddirectoryAttachObject()
    AttachPolicy = actions.ClouddirectoryAttachPolicy()
    AttachToIndex = actions.ClouddirectoryAttachToIndex()
    AttachTypedLink = actions.ClouddirectoryAttachTypedLink()
    BatchRead = actions.ClouddirectoryBatchRead()
    BatchWrite = actions.ClouddirectoryBatchWrite()
    CreateDirectory = actions.ClouddirectoryCreateDirectory()
    CreateFacet = actions.ClouddirectoryCreateFacet()
    CreateIndex = actions.ClouddirectoryCreateIndex()
    CreateObject = actions.ClouddirectoryCreateObject()
    CreateSchema = actions.ClouddirectoryCreateSchema()
    CreateTypedLinkFacet = actions.ClouddirectoryCreateTypedLinkFacet()
    DeleteDirectory = actions.ClouddirectoryDeleteDirectory()
    DeleteFacet = actions.ClouddirectoryDeleteFacet()
    DeleteObject = actions.ClouddirectoryDeleteObject()
    DeleteSchema = actions.ClouddirectoryDeleteSchema()
    DeleteTypedLinkFacet = actions.ClouddirectoryDeleteTypedLinkFacet()
    DetachFromIndex = actions.ClouddirectoryDetachFromIndex()
    DetachObject = actions.ClouddirectoryDetachObject()
    DetachPolicy = actions.ClouddirectoryDetachPolicy()
    DetachTypedLink = actions.ClouddirectoryDetachTypedLink()
    DisableDirectory = actions.ClouddirectoryDisableDirectory()
    EnableDirectory = actions.ClouddirectoryEnableDirectory()
    GetDirectory = actions.ClouddirectoryGetDirectory()
    GetFacet = actions.ClouddirectoryGetFacet()
    GetObjectInformation = actions.ClouddirectoryGetObjectInformation()
    GetSchemaAsJson = actions.ClouddirectoryGetSchemaAsJson()
    GetTypedLinkFacetInformation = actions.ClouddirectoryGetTypedLinkFacetInformation()
    ListAppliedSchemaArns = actions.ClouddirectoryListAppliedSchemaArns()
    ListAttachedIndices = actions.ClouddirectoryListAttachedIndices()
    ListDevelopmentSchemaArns = actions.ClouddirectoryListDevelopmentSchemaArns()
    ListDirectories = actions.ClouddirectoryListDirectories()
    ListFacetAttributes = actions.ClouddirectoryListFacetAttributes()
    ListFacetNames = actions.ClouddirectoryListFacetNames()
    ListIncomingTypedLinks = actions.ClouddirectoryListIncomingTypedLinks()
    ListIndex = actions.ClouddirectoryListIndex()
    ListObjectAttributes = actions.ClouddirectoryListObjectAttributes()
    ListObjectChildren = actions.ClouddirectoryListObjectChildren()
    ListObjectParentPaths = actions.ClouddirectoryListObjectParentPaths()
    ListObjectParents = actions.ClouddirectoryListObjectParents()
    ListObjectPolicies = actions.ClouddirectoryListObjectPolicies()
    ListOutgoingTypedLinks = actions.ClouddirectoryListOutgoingTypedLinks()
    ListPolicyAttachments = actions.ClouddirectoryListPolicyAttachments()
    ListPublishedSchemaArns = actions.ClouddirectoryListPublishedSchemaArns()
    ListTagsForResource = actions.ClouddirectoryListTagsForResource()
    ListTypedLinkFacetAttributes = actions.ClouddirectoryListTypedLinkFacetAttributes()
    ListTypedLinkFacetNames = actions.ClouddirectoryListTypedLinkFacetNames()
    LookupPolicy = actions.ClouddirectoryLookupPolicy()
    PublishSchema = actions.ClouddirectoryPublishSchema()
    PutSchemaFromJson = actions.ClouddirectoryPutSchemaFromJson()
    RemoveFacetFromObject = actions.ClouddirectoryRemoveFacetFromObject()
    TagResource = actions.ClouddirectoryTagResource()
    UntagResource = actions.ClouddirectoryUntagResource()
    UpdateFacet = actions.ClouddirectoryUpdateFacet()
    UpdateObjectAttributes = actions.ClouddirectoryUpdateObjectAttributes()
    UpdateSchema = actions.ClouddirectoryUpdateSchema()
    UpdateTypedLinkFacet = actions.ClouddirectoryUpdateTypedLinkFacet()


class CloudFormation:
    all = IamAction("cloudformation", all=True)
    CancelUpdateStack = actions.CloudformationCancelUpdateStack()
    ContinueUpdateRollback = actions.CloudformationContinueUpdateRollback()
    CreateChangeSet = actions.CloudformationCreateChangeSet()
    CreateStack = actions.CloudformationCreateStack()
    CreateUploadBucket = actions.CloudformationCreateUploadBucket()
    DeleteChangeSet = actions.CloudformationDeleteChangeSet()
    DeleteStack = actions.CloudformationDeleteStack()
    DescribeAccountLimits = actions.CloudformationDescribeAccountLimits()
    DescribeChangeSet = actions.CloudformationDescribeChangeSet()
    DescribeStackEvents = actions.CloudformationDescribeStackEvents()
    DescribeStackResource = actions.CloudformationDescribeStackResource()
    DescribeStackResources = actions.CloudformationDescribeStackResources()
    DescribeStacks = actions.CloudformationDescribeStacks()
    EstimateTemplateCost = actions.CloudformationEstimateTemplateCost()
    ExecuteChangeSet = actions.CloudformationExecuteChangeSet()
    GetStackPolicy = actions.CloudformationGetStackPolicy()
    GetTemplate = actions.CloudformationGetTemplate()
    GetTemplateSummary = actions.CloudformationGetTemplateSummary()
    ListChangeSets = actions.CloudformationListChangeSets()
    ListExports = actions.CloudformationListExports()
    ListImports = actions.CloudformationListImports()
    ListStackResources = actions.CloudformationListStackResources()
    ListStacks = actions.CloudformationListStacks()
    PreviewStackUpdate = actions.CloudformationPreviewStackUpdate()
    SetStackPolicy = actions.CloudformationSetStackPolicy()
    SignalResource = actions.CloudformationSignalResource()
    UpdateStack = actions.CloudformationUpdateStack()
    UpdateTerminationProtection = actions.CloudformationUpdateTerminationProtection()
    ValidateTemplate = actions.CloudformationValidateTemplate()


class CloudFront:
    all = IamAction("cloudfront", all=True)
    CreateCloudFrontOriginAccessIdentity = actions.CloudfrontCreateCloudFrontOriginAccessIdentity()
    CreateDistribution = actions.CloudfrontCreateDistribution()
    CreateDistributionWithTags = actions.CloudfrontCreateDistributionWithTags()
    CreateInvalidation = actions.CloudfrontCreateInvalidation()
    CreateStreamingDistribution = actions.CloudfrontCreateStreamingDistribution()
    CreateStreamingDistributionWithTags = actions.CloudfrontCreateStreamingDistributionWithTags()
    DeleteCloudFrontOriginAccessIdentity = actions.CloudfrontDeleteCloudFrontOriginAccessIdentity()
    DeleteDistribution = actions.CloudfrontDeleteDistribution()
    DeleteStreamingDistribution = actions.CloudfrontDeleteStreamingDistribution()
    GetCloudFrontOriginAccessIdentity = actions.CloudfrontGetCloudFrontOriginAccessIdentity()
    GetCloudFrontOriginAccessIdentityConfig = actions.CloudfrontGetCloudFrontOriginAccessIdentityConfig()
    GetDistribution = actions.CloudfrontGetDistribution()
    GetDistributionConfig = actions.CloudfrontGetDistributionConfig()
    GetInvalidation = actions.CloudfrontGetInvalidation()
    GetStreamingDistribution = actions.CloudfrontGetStreamingDistribution()
    GetStreamingDistributionConfig = actions.CloudfrontGetStreamingDistributionConfig()
    ListCloudFrontOriginAccessIdentities = actions.CloudfrontListCloudFrontOriginAccessIdentities()
    ListDistributions = actions.CloudfrontListDistributions()
    ListDistributionsByWebACLId = actions.CloudfrontListDistributionsByWebACLId()
    ListInvalidations = actions.CloudfrontListInvalidations()
    ListStreamingDistributions = actions.CloudfrontListStreamingDistributions()
    ListTagsForResource = actions.CloudfrontListTagsForResource()
    TagResource = actions.CloudfrontTagResource()
    UntagResource = actions.CloudfrontUntagResource()
    UpdateCloudFrontOriginAccessIdentity = actions.CloudfrontUpdateCloudFrontOriginAccessIdentity()
    UpdateDistribution = actions.CloudfrontUpdateDistribution()
    UpdateStreamingDistribution = actions.CloudfrontUpdateStreamingDistribution()


class CloudHsm:
    all = IamAction("cloudhsm", all=True)
    AddTagsToResource = actions.CloudhsmAddTagsToResource()
    CreateHapg = actions.CloudhsmCreateHapg()
    CreateHsm = actions.CloudhsmCreateHsm()
    CreateLunaClient = actions.CloudhsmCreateLunaClient()
    DeleteHapg = actions.CloudhsmDeleteHapg()
    DeleteHsm = actions.CloudhsmDeleteHsm()
    DeleteLunaClient = actions.CloudhsmDeleteLunaClient()
    DescribeHapg = actions.CloudhsmDescribeHapg()
    DescribeHsm = actions.CloudhsmDescribeHsm()
    DescribeLunaClient = actions.CloudhsmDescribeLunaClient()
    GetConfig = actions.CloudhsmGetConfig()
    ListAvailableZones = actions.CloudhsmListAvailableZones()
    ListHapgs = actions.CloudhsmListHapgs()
    ListHsms = actions.CloudhsmListHsms()
    ListLunaClients = actions.CloudhsmListLunaClients()
    ListTagsForResource = actions.CloudhsmListTagsForResource()
    ModifyHapg = actions.CloudhsmModifyHapg()
    ModifyHsm = actions.CloudhsmModifyHsm()
    ModifyLunaClient = actions.CloudhsmModifyLunaClient()
    RemoveTagsFromResource = actions.CloudhsmRemoveTagsFromResource()


class CloudSearch:
    all = IamAction("cloudsearch", all=True)
    AddTags = actions.CloudsearchAddTags()
    BuildSuggesters = actions.CloudsearchBuildSuggesters()
    CreateDomain = actions.CloudsearchCreateDomain()
    DefineAnalysisScheme = actions.CloudsearchDefineAnalysisScheme()
    DefineExpression = actions.CloudsearchDefineExpression()
    DefineIndexField = actions.CloudsearchDefineIndexField()
    DefineSuggester = actions.CloudsearchDefineSuggester()
    DeleteAnalysisScheme = actions.CloudsearchDeleteAnalysisScheme()
    DeleteDomain = actions.CloudsearchDeleteDomain()
    DeleteExpression = actions.CloudsearchDeleteExpression()
    DeleteIndexField = actions.CloudsearchDeleteIndexField()
    DeleteSuggester = actions.CloudsearchDeleteSuggester()
    DescribeAnalysisSchemes = actions.CloudsearchDescribeAnalysisSchemes()
    DescribeAvailabilityOptions = actions.CloudsearchDescribeAvailabilityOptions()
    DescribeDomains = actions.CloudsearchDescribeDomains()
    DescribeExpressions = actions.CloudsearchDescribeExpressions()
    DescribeIndexFields = actions.CloudsearchDescribeIndexFields()
    DescribeScalingParameters = actions.CloudsearchDescribeScalingParameters()
    DescribeServiceAccessPolicies = actions.CloudsearchDescribeServiceAccessPolicies()
    DescribeSuggesters = actions.CloudsearchDescribeSuggesters()
    IndexDocuments = actions.CloudsearchIndexDocuments()
    ListDomainNames = actions.CloudsearchListDomainNames()
    ListTags = actions.CloudsearchListTags()
    RemoveTags = actions.CloudsearchRemoveTags()
    UpdateAvailabilityOptions = actions.CloudsearchUpdateAvailabilityOptions()
    UpdateScalingParameters = actions.CloudsearchUpdateScalingParameters()
    UpdateServiceAccessPolicies = actions.CloudsearchUpdateServiceAccessPolicies()
    document = actions.Cloudsearchdocument()
    search = actions.Cloudsearchsearch()
    suggest = actions.Cloudsearchsuggest()


class CloudTrail:
    all = IamAction("cloudtrail", all=True)
    AddTags = actions.CloudtrailAddTags()
    CreateTrail = actions.CloudtrailCreateTrail()
    DeleteTrail = actions.CloudtrailDeleteTrail()
    DescribeTrails = actions.CloudtrailDescribeTrails()
    GetEventSelectors = actions.CloudtrailGetEventSelectors()
    GetTrailStatus = actions.CloudtrailGetTrailStatus()
    ListPublicKeys = actions.CloudtrailListPublicKeys()
    ListTags = actions.CloudtrailListTags()
    LookupEvents = actions.CloudtrailLookupEvents()
    PutEventSelectors = actions.CloudtrailPutEventSelectors()
    RemoveTags = actions.CloudtrailRemoveTags()
    StartLogging = actions.CloudtrailStartLogging()
    StopLogging = actions.CloudtrailStopLogging()
    UpdateTrail = actions.CloudtrailUpdateTrail()


class CloudWatch:
    all = IamAction("cloudwatch", all=True)
    DeleteAlarms = actions.CloudwatchDeleteAlarms()
    DeleteDashboards = actions.CloudwatchDeleteDashboards()
    DescribeAlarmHistory = actions.CloudwatchDescribeAlarmHistory()
    DescribeAlarms = actions.CloudwatchDescribeAlarms()
    DescribeAlarmsForMetric = actions.CloudwatchDescribeAlarmsForMetric()
    DisableAlarmActions = actions.CloudwatchDisableAlarmActions()
    EnableAlarmActions = actions.CloudwatchEnableAlarmActions()
    GetDashboard = actions.CloudwatchGetDashboard()
    GetMetricData = actions.CloudwatchGetMetricData()
    GetMetricStatistics = actions.CloudwatchGetMetricStatistics()
    ListDashboards = actions.CloudwatchListDashboards()
    ListMetrics = actions.CloudwatchListMetrics()
    PutDashboard = actions.CloudwatchPutDashboard()
    PutMetricAlarm = actions.CloudwatchPutMetricAlarm()
    PutMetricData = actions.CloudwatchPutMetricData()
    SetAlarmState = actions.CloudwatchSetAlarmState()


class CodeBuild:
    all = IamAction("codebuild", all=True)
    BatchDeleteBuilds = actions.CodebuildBatchDeleteBuilds()
    BatchGetBuilds = actions.CodebuildBatchGetBuilds()
    BatchGetProjects = actions.CodebuildBatchGetProjects()
    CreateProject = actions.CodebuildCreateProject()
    DeleteProject = actions.CodebuildDeleteProject()
    ListBuilds = actions.CodebuildListBuilds()
    ListBuildsForProject = actions.CodebuildListBuildsForProject()
    ListConnectedOAuthAccounts = actions.CodebuildListConnectedOAuthAccounts()
    ListCuratedEnvironmentImages = actions.CodebuildListCuratedEnvironmentImages()
    ListProjects = actions.CodebuildListProjects()
    ListRepositories = actions.CodebuildListRepositories()
    PersistOAuthToken = actions.CodebuildPersistOAuthToken()
    StartBuild = actions.CodebuildStartBuild()
    StopBuild = actions.CodebuildStopBuild()
    UpdateProject = actions.CodebuildUpdateProject()


class CodeCommit:
    all = IamAction("codecommit", all=True)
    BatchGetPullRequests = actions.CodecommitBatchGetPullRequests()
    BatchGetRepositories = actions.CodecommitBatchGetRepositories()
    CancelUploadArchive = actions.CodecommitCancelUploadArchive()
    CreateBranch = actions.CodecommitCreateBranch()
    CreatePullRequest = actions.CodecommitCreatePullRequest()
    CreateRepository = actions.CodecommitCreateRepository()
    DeleteBranch = actions.CodecommitDeleteBranch()
    DeleteCommentContent = actions.CodecommitDeleteCommentContent()
    DeleteRepository = actions.CodecommitDeleteRepository()
    DescribePullRequestEvents = actions.CodecommitDescribePullRequestEvents()
    GetBlob = actions.CodecommitGetBlob()
    GetBranch = actions.CodecommitGetBranch()
    GetComment = actions.CodecommitGetComment()
    GetCommentsForComparedCommit = actions.CodecommitGetCommentsForComparedCommit()
    GetCommentsForPullRequest = actions.CodecommitGetCommentsForPullRequest()
    GetCommit = actions.CodecommitGetCommit()
    GetCommitHistory = actions.CodecommitGetCommitHistory()
    GetCommitsFromMergeBase = actions.CodecommitGetCommitsFromMergeBase()
    GetDifferences = actions.CodecommitGetDifferences()
    GetMergeConflicts = actions.CodecommitGetMergeConflicts()
    GetObjectIdentifier = actions.CodecommitGetObjectIdentifier()
    GetPullRequest = actions.CodecommitGetPullRequest()
    GetReferences = actions.CodecommitGetReferences()
    GetRepository = actions.CodecommitGetRepository()
    GetRepositoryTriggers = actions.CodecommitGetRepositoryTriggers()
    GetTree = actions.CodecommitGetTree()
    GetUploadArchiveStatus = actions.CodecommitGetUploadArchiveStatus()
    GitPull = actions.CodecommitGitPull()
    GitPush = actions.CodecommitGitPush()
    ListBranches = actions.CodecommitListBranches()
    ListPullRequests = actions.CodecommitListPullRequests()
    ListRepositories = actions.CodecommitListRepositories()
    MergePullRequestByFastForward = actions.CodecommitMergePullRequestByFastForward()
    PostCommentForComparedCommit = actions.CodecommitPostCommentForComparedCommit()
    PostCommentForPullRequest = actions.CodecommitPostCommentForPullRequest()
    PostCommentReply = actions.CodecommitPostCommentReply()
    PutFile = actions.CodecommitPutFile()
    PutRepositoryTriggers = actions.CodecommitPutRepositoryTriggers()
    TestRepositoryTriggers = actions.CodecommitTestRepositoryTriggers()
    UpdateComment = actions.CodecommitUpdateComment()
    UpdateDefaultBranch = actions.CodecommitUpdateDefaultBranch()
    UpdatePullRequestDescription = actions.CodecommitUpdatePullRequestDescription()
    UpdatePullRequestStatus = actions.CodecommitUpdatePullRequestStatus()
    UpdatePullRequestTitle = actions.CodecommitUpdatePullRequestTitle()
    UpdateRepositoryDescription = actions.CodecommitUpdateRepositoryDescription()
    UpdateRepositoryName = actions.CodecommitUpdateRepositoryName()
    UploadArchive = actions.CodecommitUploadArchive()


class CodeDeploy:
    all = IamAction("codedeploy", all=True)
    AddTagsToOnPremisesInstances = actions.CodedeployAddTagsToOnPremisesInstances()
    BatchGetApplicationRevisions = actions.CodedeployBatchGetApplicationRevisions()
    BatchGetApplications = actions.CodedeployBatchGetApplications()
    BatchGetDeploymentGroups = actions.CodedeployBatchGetDeploymentGroups()
    BatchGetDeploymentInstances = actions.CodedeployBatchGetDeploymentInstances()
    BatchGetDeployments = actions.CodedeployBatchGetDeployments()
    BatchGetOnPremisesInstances = actions.CodedeployBatchGetOnPremisesInstances()
    ContinueDeployment = actions.CodedeployContinueDeployment()
    CreateApplication = actions.CodedeployCreateApplication()
    CreateDeployment = actions.CodedeployCreateDeployment()
    CreateDeploymentConfig = actions.CodedeployCreateDeploymentConfig()
    CreateDeploymentGroup = actions.CodedeployCreateDeploymentGroup()
    DeleteApplication = actions.CodedeployDeleteApplication()
    DeleteDeploymentConfig = actions.CodedeployDeleteDeploymentConfig()
    DeleteDeploymentGroup = actions.CodedeployDeleteDeploymentGroup()
    DeregisterOnPremisesInstance = actions.CodedeployDeregisterOnPremisesInstance()
    GetApplication = actions.CodedeployGetApplication()
    GetApplicationRevision = actions.CodedeployGetApplicationRevision()
    GetDeployment = actions.CodedeployGetDeployment()
    GetDeploymentConfig = actions.CodedeployGetDeploymentConfig()
    GetDeploymentGroup = actions.CodedeployGetDeploymentGroup()
    GetDeploymentInstance = actions.CodedeployGetDeploymentInstance()
    GetOnPremisesInstance = actions.CodedeployGetOnPremisesInstance()
    ListApplicationRevisions = actions.CodedeployListApplicationRevisions()
    ListApplications = actions.CodedeployListApplications()
    ListDeploymentConfigs = actions.CodedeployListDeploymentConfigs()
    ListDeploymentGroups = actions.CodedeployListDeploymentGroups()
    ListDeploymentInstances = actions.CodedeployListDeploymentInstances()
    ListDeployments = actions.CodedeployListDeployments()
    ListOnPremisesInstances = actions.CodedeployListOnPremisesInstances()
    RegisterApplicationRevision = actions.CodedeployRegisterApplicationRevision()
    RegisterOnPremisesInstance = actions.CodedeployRegisterOnPremisesInstance()
    RemoveTagsFromOnPremisesInstances = actions.CodedeployRemoveTagsFromOnPremisesInstances()
    StopDeployment = actions.CodedeployStopDeployment()
    UpdateApplication = actions.CodedeployUpdateApplication()
    UpdateDeploymentGroup = actions.CodedeployUpdateDeploymentGroup()


class CodePipeline:
    all = IamAction("codepipeline", all=True)
    AcknowledgeJob = actions.CodepipelineAcknowledgeJob()
    AcknowledgeThirdPartyJob = actions.CodepipelineAcknowledgeThirdPartyJob()
    CreateCustomActionType = actions.CodepipelineCreateCustomActionType()
    CreatePipeline = actions.CodepipelineCreatePipeline()
    DeleteCustomActionType = actions.CodepipelineDeleteCustomActionType()
    DeletePipeline = actions.CodepipelineDeletePipeline()
    DisableStageTransition = actions.CodepipelineDisableStageTransition()
    EnableStageTransition = actions.CodepipelineEnableStageTransition()
    GetJobDetails = actions.CodepipelineGetJobDetails()
    GetPipeline = actions.CodepipelineGetPipeline()
    GetPipelineExecution = actions.CodepipelineGetPipelineExecution()
    GetPipelineState = actions.CodepipelineGetPipelineState()
    GetThirdPartyJobDetails = actions.CodepipelineGetThirdPartyJobDetails()
    ListActionTypes = actions.CodepipelineListActionTypes()
    ListPipelineExecutions = actions.CodepipelineListPipelineExecutions()
    ListPipelines = actions.CodepipelineListPipelines()
    PollForJobs = actions.CodepipelinePollForJobs()
    PollForThirdPartyJobs = actions.CodepipelinePollForThirdPartyJobs()
    PutActionRevision = actions.CodepipelinePutActionRevision()
    PutApprovalResult = actions.CodepipelinePutApprovalResult()
    PutJobFailureResult = actions.CodepipelinePutJobFailureResult()
    PutJobSuccessResult = actions.CodepipelinePutJobSuccessResult()
    PutThirdPartyJobFailureResult = actions.CodepipelinePutThirdPartyJobFailureResult()
    PutThirdPartyJobSuccessResult = actions.CodepipelinePutThirdPartyJobSuccessResult()
    RetryStageExecution = actions.CodepipelineRetryStageExecution()
    StartPipelineExecution = actions.CodepipelineStartPipelineExecution()
    UpdatePipeline = actions.CodepipelineUpdatePipeline()


class CodeStar:
    all = IamAction("codestar", all=True)
    AssociateTeamMember = actions.CodestarAssociateTeamMember()
    CreateProject = actions.CodestarCreateProject()
    CreateUserProfile = actions.CodestarCreateUserProfile()
    DeleteExtendedAccess = actions.CodestarDeleteExtendedAccess()
    DeleteProject = actions.CodestarDeleteProject()
    DeleteUserProfile = actions.CodestarDeleteUserProfile()
    DescribeProject = actions.CodestarDescribeProject()
    DescribeUserProfile = actions.CodestarDescribeUserProfile()
    DisassociateTeamMember = actions.CodestarDisassociateTeamMember()
    GetExtendedAccess = actions.CodestarGetExtendedAccess()
    ListProjects = actions.CodestarListProjects()
    ListResources = actions.CodestarListResources()
    ListTeamMembers = actions.CodestarListTeamMembers()
    ListUserProfiles = actions.CodestarListUserProfiles()
    PutExtendedAccess = actions.CodestarPutExtendedAccess()
    UpdateProject = actions.CodestarUpdateProject()
    UpdateTeamMember = actions.CodestarUpdateTeamMember()
    UpdateUserProfile = actions.CodestarUpdateUserProfile()
    VerifyServiceRole = actions.CodestarVerifyServiceRole()


class CognitoIdentity:
    all = IamAction("cognito-identity", all=True)
    CreateIdentityPool = actions.CognitoIdentityCreateIdentityPool()
    DeleteIdentities = actions.CognitoIdentityDeleteIdentities()
    DeleteIdentityPool = actions.CognitoIdentityDeleteIdentityPool()
    DescribeIdentity = actions.CognitoIdentityDescribeIdentity()
    DescribeIdentityPool = actions.CognitoIdentityDescribeIdentityPool()
    GetCredentialsForIdentity = actions.CognitoIdentityGetCredentialsForIdentity()
    GetId = actions.CognitoIdentityGetId()
    GetIdentityPoolRoles = actions.CognitoIdentityGetIdentityPoolRoles()
    GetOpenIdToken = actions.CognitoIdentityGetOpenIdToken()
    GetOpenIdTokenForDeveloperIdentity = actions.CognitoIdentityGetOpenIdTokenForDeveloperIdentity()
    ListIdentities = actions.CognitoIdentityListIdentities()
    ListIdentityPools = actions.CognitoIdentityListIdentityPools()
    LookupDeveloperIdentity = actions.CognitoIdentityLookupDeveloperIdentity()
    MergeDeveloperIdentities = actions.CognitoIdentityMergeDeveloperIdentities()
    SetIdentityPoolRoles = actions.CognitoIdentitySetIdentityPoolRoles()
    UnlinkDeveloperIdentity = actions.CognitoIdentityUnlinkDeveloperIdentity()
    UnlinkIdentity = actions.CognitoIdentityUnlinkIdentity()
    UpdateIdentityPool = actions.CognitoIdentityUpdateIdentityPool()


class CognitoIdp:
    all = IamAction("cognito-idp", all=True)
    AddCustomAttributes = actions.CognitoIdpAddCustomAttributes()
    AdminAddUserToGroup = actions.CognitoIdpAdminAddUserToGroup()
    AdminConfirmSignUp = actions.CognitoIdpAdminConfirmSignUp()
    AdminCreateUser = actions.CognitoIdpAdminCreateUser()
    AdminDeleteUser = actions.CognitoIdpAdminDeleteUser()
    AdminDeleteUserAttributes = actions.CognitoIdpAdminDeleteUserAttributes()
    AdminDisableUser = actions.CognitoIdpAdminDisableUser()
    AdminEnableUser = actions.CognitoIdpAdminEnableUser()
    AdminForgetDevice = actions.CognitoIdpAdminForgetDevice()
    AdminGetDevice = actions.CognitoIdpAdminGetDevice()
    AdminGetUser = actions.CognitoIdpAdminGetUser()
    AdminInitiateAuth = actions.CognitoIdpAdminInitiateAuth()
    AdminListDevices = actions.CognitoIdpAdminListDevices()
    AdminListGroupsForUser = actions.CognitoIdpAdminListGroupsForUser()
    AdminListUserAuthEvents = actions.CognitoIdpAdminListUserAuthEvents()
    AdminRemoveUserFromGroup = actions.CognitoIdpAdminRemoveUserFromGroup()
    AdminResetUserPassword = actions.CognitoIdpAdminResetUserPassword()
    AdminRespondToAuthChallenge = actions.CognitoIdpAdminRespondToAuthChallenge()
    AdminSetUserMFAPreference = actions.CognitoIdpAdminSetUserMFAPreference()
    AdminSetUserSettings = actions.CognitoIdpAdminSetUserSettings()
    AdminUpdateAuthEventFeedback = actions.CognitoIdpAdminUpdateAuthEventFeedback()
    AdminUpdateDeviceStatus = actions.CognitoIdpAdminUpdateDeviceStatus()
    AdminUpdateUserAttributes = actions.CognitoIdpAdminUpdateUserAttributes()
    AdminUserGlobalSignOut = actions.CognitoIdpAdminUserGlobalSignOut()
    ChangePassword = actions.CognitoIdpChangePassword()
    ConfirmDevice = actions.CognitoIdpConfirmDevice()
    ConfirmForgotPassword = actions.CognitoIdpConfirmForgotPassword()
    ConfirmSignUp = actions.CognitoIdpConfirmSignUp()
    CreateGroup = actions.CognitoIdpCreateGroup()
    CreateUserImportJob = actions.CognitoIdpCreateUserImportJob()
    CreateUserPool = actions.CognitoIdpCreateUserPool()
    CreateUserPoolClient = actions.CognitoIdpCreateUserPoolClient()
    DeleteGroup = actions.CognitoIdpDeleteGroup()
    DeleteUser = actions.CognitoIdpDeleteUser()
    DeleteUserAttributes = actions.CognitoIdpDeleteUserAttributes()
    DeleteUserPool = actions.CognitoIdpDeleteUserPool()
    DeleteUserPoolClient = actions.CognitoIdpDeleteUserPoolClient()
    DescribeRiskConfiguration = actions.CognitoIdpDescribeRiskConfiguration()
    DescribeUserImportJob = actions.CognitoIdpDescribeUserImportJob()
    DescribeUserPool = actions.CognitoIdpDescribeUserPool()
    DescribeUserPoolClient = actions.CognitoIdpDescribeUserPoolClient()
    ForgetDevice = actions.CognitoIdpForgetDevice()
    ForgotPassword = actions.CognitoIdpForgotPassword()
    GetCSVHeader = actions.CognitoIdpGetCSVHeader()
    GetDevice = actions.CognitoIdpGetDevice()
    GetGroup = actions.CognitoIdpGetGroup()
    GetUser = actions.CognitoIdpGetUser()
    GetUserAttributeVerificationCode = actions.CognitoIdpGetUserAttributeVerificationCode()
    GetUserPoolMfaConfig = actions.CognitoIdpGetUserPoolMfaConfig()
    GlobalSignOut = actions.CognitoIdpGlobalSignOut()
    InitiateAuth = actions.CognitoIdpInitiateAuth()
    ListDevices = actions.CognitoIdpListDevices()
    ListGroups = actions.CognitoIdpListGroups()
    ListUserImportJobs = actions.CognitoIdpListUserImportJobs()
    ListUserPoolClients = actions.CognitoIdpListUserPoolClients()
    ListUsersInGroup = actions.CognitoIdpListUsersInGroup()
    ResendConfirmationCode = actions.CognitoIdpResendConfirmationCode()
    RespondToAuthChallenge = actions.CognitoIdpRespondToAuthChallenge()
    SetRiskConfiguration = actions.CognitoIdpSetRiskConfiguration()
    SetUserMFAPreference = actions.CognitoIdpSetUserMFAPreference()
    SetUserPoolMfaConfig = actions.CognitoIdpSetUserPoolMfaConfig()
    SetUserSettings = actions.CognitoIdpSetUserSettings()
    SignUp = actions.CognitoIdpSignUp()
    StartUserImportJob = actions.CognitoIdpStartUserImportJob()
    StopUserImportJob = actions.CognitoIdpStopUserImportJob()
    UpdateAuthEventFeedback = actions.CognitoIdpUpdateAuthEventFeedback()
    UpdateDeviceStatus = actions.CognitoIdpUpdateDeviceStatus()
    UpdateGroup = actions.CognitoIdpUpdateGroup()
    UpdateUserAttributes = actions.CognitoIdpUpdateUserAttributes()
    UpdateUserPool = actions.CognitoIdpUpdateUserPool()
    UpdateUserPoolClient = actions.CognitoIdpUpdateUserPoolClient()
    VerifyUserAttribute = actions.CognitoIdpVerifyUserAttribute()


class CognitoSync:
    all = IamAction("cognito-sync", all=True)
    BulkPublish = actions.CognitoSyncBulkPublish()
    DeleteDataset = actions.CognitoSyncDeleteDataset()
    DescribeDataset = actions.CognitoSyncDescribeDataset()
    DescribeIdentityPoolUsage = actions.CognitoSyncDescribeIdentityPoolUsage()
    DescribeIdentityUsage = actions.CognitoSyncDescribeIdentityUsage()
    GetBulkPublishDetails = actions.CognitoSyncGetBulkPublishDetails()
    GetCognitoEvents = actions.CognitoSyncGetCognitoEvents()
    GetIdentityPoolConfiguration = actions.CognitoSyncGetIdentityPoolConfiguration()
    ListDatasets = actions.CognitoSyncListDatasets()
    ListIdentityPoolUsage = actions.CognitoSyncListIdentityPoolUsage()
    ListRecords = actions.CognitoSyncListRecords()
    QueryRecords = actions.CognitoSyncQueryRecords()
    RegisterDevice = actions.CognitoSyncRegisterDevice()
    SetCognitoEvents = actions.CognitoSyncSetCognitoEvents()
    SetDatasetConfiguration = actions.CognitoSyncSetDatasetConfiguration()
    SetIdentityPoolConfiguration = actions.CognitoSyncSetIdentityPoolConfiguration()
    SubscribeToDataset = actions.CognitoSyncSubscribeToDataset()
    UnsubscribeFromDataset = actions.CognitoSyncUnsubscribeFromDataset()
    UpdateRecords = actions.CognitoSyncUpdateRecords()


class Comprehend:
    all = IamAction("comprehend", all=True)
    BatchDetectDominantLanguage = actions.ComprehendBatchDetectDominantLanguage()
    BatchDetectEntities = actions.ComprehendBatchDetectEntities()
    BatchDetectKeyPhrases = actions.ComprehendBatchDetectKeyPhrases()
    BatchDetectSentiment = actions.ComprehendBatchDetectSentiment()
    DescribeTopicsDetectionJob = actions.ComprehendDescribeTopicsDetectionJob()
    DetectDominantLanguage = actions.ComprehendDetectDominantLanguage()
    DetectEntities = actions.ComprehendDetectEntities()
    DetectKeyPhrases = actions.ComprehendDetectKeyPhrases()
    DetectSentiment = actions.ComprehendDetectSentiment()
    ListTopicsDetectionJobs = actions.ComprehendListTopicsDetectionJobs()
    StartTopicsDetectionJob = actions.ComprehendStartTopicsDetectionJob()


class Config:
    all = IamAction("config", all=True)
    DeleteConfigRule = actions.ConfigDeleteConfigRule()
    DeleteConfigurationRecorder = actions.ConfigDeleteConfigurationRecorder()
    DeleteDeliveryChannel = actions.ConfigDeleteDeliveryChannel()
    DeleteEvaluationResults = actions.ConfigDeleteEvaluationResults()
    DeliverConfigSnapshot = actions.ConfigDeliverConfigSnapshot()
    DescribeComplianceByConfigRule = actions.ConfigDescribeComplianceByConfigRule()
    DescribeComplianceByResource = actions.ConfigDescribeComplianceByResource()
    DescribeConfigRuleEvaluationStatus = actions.ConfigDescribeConfigRuleEvaluationStatus()
    DescribeConfigRules = actions.ConfigDescribeConfigRules()
    DescribeConfigurationRecorderStatus = actions.ConfigDescribeConfigurationRecorderStatus()
    DescribeConfigurationRecorders = actions.ConfigDescribeConfigurationRecorders()
    DescribeDeliveryChannelStatus = actions.ConfigDescribeDeliveryChannelStatus()
    DescribeDeliveryChannels = actions.ConfigDescribeDeliveryChannels()
    GetComplianceDetailsByConfigRule = actions.ConfigGetComplianceDetailsByConfigRule()
    GetComplianceDetailsByResource = actions.ConfigGetComplianceDetailsByResource()
    GetComplianceSummaryByConfigRule = actions.ConfigGetComplianceSummaryByConfigRule()
    GetComplianceSummaryByResourceType = actions.ConfigGetComplianceSummaryByResourceType()
    GetResourceConfigHistory = actions.ConfigGetResourceConfigHistory()
    GetResources = actions.ConfigGetResources()
    GetTagKeys = actions.ConfigGetTagKeys()
    ListDiscoveredResources = actions.ConfigListDiscoveredResources()
    PutConfigRule = actions.ConfigPutConfigRule()
    PutConfigurationRecorder = actions.ConfigPutConfigurationRecorder()
    PutDeliveryChannel = actions.ConfigPutDeliveryChannel()
    PutEvaluations = actions.ConfigPutEvaluations()
    StartConfigRulesEvaluation = actions.ConfigStartConfigRulesEvaluation()
    StartConfigurationRecorder = actions.ConfigStartConfigurationRecorder()
    StopConfigurationRecorder = actions.ConfigStopConfigurationRecorder()


class Connect:
    all = IamAction("connect", all=True)
    CreateInstance = actions.ConnectCreateInstance()
    DescribeInstance = actions.ConnectDescribeInstance()
    DestroyInstance = actions.ConnectDestroyInstance()
    GetFederationToken = actions.ConnectGetFederationToken()
    GetFederationTokens = actions.ConnectGetFederationTokens()
    ListInstances = actions.ConnectListInstances()
    ModifyInstance = actions.ConnectModifyInstance()


class Crowd:
    all = IamAction("crowd", all=True)
    GetTask = actions.CrowdGetTask()
    PutTask = actions.CrowdPutTask()


class Cur:
    all = IamAction("cur", all=True)
    DeleteReportDefinition = actions.CurDeleteReportDefinition()
    DescribeReportDefinitions = actions.CurDescribeReportDefinitions()
    PutReportDefinition = actions.CurPutReportDefinition()


class Datapipeline:
    all = IamAction("datapipeline", all=True)
    ActivatePipeline = actions.DatapipelineActivatePipeline()
    AddTags = actions.DatapipelineAddTags()
    CreatePipeline = actions.DatapipelineCreatePipeline()
    DeactivatePipeline = actions.DatapipelineDeactivatePipeline()
    DeletePipeline = actions.DatapipelineDeletePipeline()
    DescribeObjects = actions.DatapipelineDescribeObjects()
    DescribePipelines = actions.DatapipelineDescribePipelines()
    EvaluateExpression = actions.DatapipelineEvaluateExpression()
    GetAccountLimits = actions.DatapipelineGetAccountLimits()
    GetPipelineDefinition = actions.DatapipelineGetPipelineDefinition()
    ListPipelines = actions.DatapipelineListPipelines()
    PollForTask = actions.DatapipelinePollForTask()
    PutAccountLimits = actions.DatapipelinePutAccountLimits()
    PutPipelineDefinition = actions.DatapipelinePutPipelineDefinition()
    QueryObjects = actions.DatapipelineQueryObjects()
    RemoveTags = actions.DatapipelineRemoveTags()
    ReportTaskProgress = actions.DatapipelineReportTaskProgress()
    ReportTaskRunnerHeartbeat = actions.DatapipelineReportTaskRunnerHeartbeat()
    SetStatus = actions.DatapipelineSetStatus()
    SetTaskStatus = actions.DatapipelineSetTaskStatus()
    ValidatePipelineDefinition = actions.DatapipelineValidatePipelineDefinition()


class Dax:
    all = IamAction("dax", all=True)
    BatchGetItem = actions.DaxBatchGetItem()
    BatchWriteItem = actions.DaxBatchWriteItem()
    CreateCluster = actions.DaxCreateCluster()
    CreateParameterGroup = actions.DaxCreateParameterGroup()
    CreateSubnetGroup = actions.DaxCreateSubnetGroup()
    DecreaseReplicationFactor = actions.DaxDecreaseReplicationFactor()
    DeleteCluster = actions.DaxDeleteCluster()
    DeleteItem = actions.DaxDeleteItem()
    DeleteParameterGroup = actions.DaxDeleteParameterGroup()
    DeleteSubnetGroup = actions.DaxDeleteSubnetGroup()
    DescribeClusters = actions.DaxDescribeClusters()
    DescribeDefaultParameters = actions.DaxDescribeDefaultParameters()
    DescribeEvents = actions.DaxDescribeEvents()
    DescribeParameterGroups = actions.DaxDescribeParameterGroups()
    DescribeParameters = actions.DaxDescribeParameters()
    DescribeSubnetGroups = actions.DaxDescribeSubnetGroups()
    DescribeTable = actions.DaxDescribeTable()
    GetItem = actions.DaxGetItem()
    IncreaseReplicationFactor = actions.DaxIncreaseReplicationFactor()
    ListTables = actions.DaxListTables()
    ListTags = actions.DaxListTags()
    PutItem = actions.DaxPutItem()
    Query = actions.DaxQuery()
    RebootNode = actions.DaxRebootNode()
    Scan = actions.DaxScan()
    TagResource = actions.DaxTagResource()
    UntagResource = actions.DaxUntagResource()
    UpdateCluster = actions.DaxUpdateCluster()
    UpdateItem = actions.DaxUpdateItem()
    UpdateParameterGroup = actions.DaxUpdateParameterGroup()
    UpdateSubnetGroup = actions.DaxUpdateSubnetGroup()


class DeviceFarm:
    all = IamAction("devicefarm", all=True)
    CreateDevicePool = actions.DevicefarmCreateDevicePool()
    CreateNetworkProfile = actions.DevicefarmCreateNetworkProfile()
    CreateProject = actions.DevicefarmCreateProject()
    CreateRemoteAccessSession = actions.DevicefarmCreateRemoteAccessSession()
    CreateUpload = actions.DevicefarmCreateUpload()
    DeleteDevicePool = actions.DevicefarmDeleteDevicePool()
    DeleteNetworkProfile = actions.DevicefarmDeleteNetworkProfile()
    DeleteProject = actions.DevicefarmDeleteProject()
    DeleteRemoteAccessSession = actions.DevicefarmDeleteRemoteAccessSession()
    DeleteRun = actions.DevicefarmDeleteRun()
    DeleteUpload = actions.DevicefarmDeleteUpload()
    GetAccountSettings = actions.DevicefarmGetAccountSettings()
    GetDevice = actions.DevicefarmGetDevice()
    GetDevicePool = actions.DevicefarmGetDevicePool()
    GetDevicePoolCompatibility = actions.DevicefarmGetDevicePoolCompatibility()
    GetJob = actions.DevicefarmGetJob()
    GetNetworkProfile = actions.DevicefarmGetNetworkProfile()
    GetOfferingStatus = actions.DevicefarmGetOfferingStatus()
    GetProject = actions.DevicefarmGetProject()
    GetRemoteAccessSession = actions.DevicefarmGetRemoteAccessSession()
    GetRun = actions.DevicefarmGetRun()
    GetSuite = actions.DevicefarmGetSuite()
    GetTest = actions.DevicefarmGetTest()
    GetUpload = actions.DevicefarmGetUpload()
    InstallToRemoteAccessSession = actions.DevicefarmInstallToRemoteAccessSession()
    ListArtifacts = actions.DevicefarmListArtifacts()
    ListDevicePools = actions.DevicefarmListDevicePools()
    ListDevices = actions.DevicefarmListDevices()
    ListJobs = actions.DevicefarmListJobs()
    ListNetworkProfiles = actions.DevicefarmListNetworkProfiles()
    ListOfferingTransactions = actions.DevicefarmListOfferingTransactions()
    ListOfferings = actions.DevicefarmListOfferings()
    ListProjects = actions.DevicefarmListProjects()
    ListRemoteAccessSessions = actions.DevicefarmListRemoteAccessSessions()
    ListRuns = actions.DevicefarmListRuns()
    ListSamples = actions.DevicefarmListSamples()
    ListSuites = actions.DevicefarmListSuites()
    ListTests = actions.DevicefarmListTests()
    ListUniqueProblems = actions.DevicefarmListUniqueProblems()
    ListUploads = actions.DevicefarmListUploads()
    PurchaseOffering = actions.DevicefarmPurchaseOffering()
    RenewOffering = actions.DevicefarmRenewOffering()
    ScheduleRun = actions.DevicefarmScheduleRun()
    StopRemoteAccessSession = actions.DevicefarmStopRemoteAccessSession()
    StopRun = actions.DevicefarmStopRun()
    UpdateDevicePool = actions.DevicefarmUpdateDevicePool()
    UpdateNetworkProfile = actions.DevicefarmUpdateNetworkProfile()
    UpdateProject = actions.DevicefarmUpdateProject()


class DirectConnect:
    all = IamAction("directconnect", all=True)
    AllocateConnectionOnInterconnect = actions.DirectconnectAllocateConnectionOnInterconnect()
    AllocatePrivateVirtualInterface = actions.DirectconnectAllocatePrivateVirtualInterface()
    AllocatePublicVirtualInterface = actions.DirectconnectAllocatePublicVirtualInterface()
    ConfirmConnection = actions.DirectconnectConfirmConnection()
    ConfirmPrivateVirtualInterface = actions.DirectconnectConfirmPrivateVirtualInterface()
    ConfirmPublicVirtualInterface = actions.DirectconnectConfirmPublicVirtualInterface()
    CreateConnection = actions.DirectconnectCreateConnection()
    CreateInterconnect = actions.DirectconnectCreateInterconnect()
    CreatePrivateVirtualInterface = actions.DirectconnectCreatePrivateVirtualInterface()
    CreatePublicVirtualInterface = actions.DirectconnectCreatePublicVirtualInterface()
    DeleteConnection = actions.DirectconnectDeleteConnection()
    DeleteInterconnect = actions.DirectconnectDeleteInterconnect()
    DeleteVirtualInterface = actions.DirectconnectDeleteVirtualInterface()
    DescribeConnectionLoa = actions.DirectconnectDescribeConnectionLoa()
    DescribeConnections = actions.DirectconnectDescribeConnections()
    DescribeConnectionsOnInterconnect = actions.DirectconnectDescribeConnectionsOnInterconnect()
    DescribeInterconnectLoa = actions.DirectconnectDescribeInterconnectLoa()
    DescribeInterconnects = actions.DirectconnectDescribeInterconnects()
    DescribeLocations = actions.DirectconnectDescribeLocations()
    DescribeVirtualGateways = actions.DirectconnectDescribeVirtualGateways()
    DescribeVirtualInterfaces = actions.DirectconnectDescribeVirtualInterfaces()


class Discovery:
    all = IamAction("discovery", all=True)
    AssociateConfigurationItemsToApplication = actions.DiscoveryAssociateConfigurationItemsToApplication()
    CreateApplication = actions.DiscoveryCreateApplication()
    CreateTags = actions.DiscoveryCreateTags()
    DeleteApplications = actions.DiscoveryDeleteApplications()
    DeleteTags = actions.DiscoveryDeleteTags()
    DescribeAgents = actions.DiscoveryDescribeAgents()
    DescribeConfigurations = actions.DiscoveryDescribeConfigurations()
    DescribeExportConfigurations = actions.DiscoveryDescribeExportConfigurations()
    DescribeTags = actions.DiscoveryDescribeTags()
    DisassociateConfigurationItemsFromApplication = actions.DiscoveryDisassociateConfigurationItemsFromApplication()
    ExportConfigurations = actions.DiscoveryExportConfigurations()
    GetDiscoverySummary = actions.DiscoveryGetDiscoverySummary()
    ListConfigurations = actions.DiscoveryListConfigurations()
    ListServerNeighbors = actions.DiscoveryListServerNeighbors()
    StartDataCollectionByAgentIds = actions.DiscoveryStartDataCollectionByAgentIds()
    StartExportTask = actions.DiscoveryStartExportTask()
    StopDataCollectionByAgentIds = actions.DiscoveryStopDataCollectionByAgentIds()
    UpdateApplication = actions.DiscoveryUpdateApplication()


class Dms:
    all = IamAction("dms", all=True)
    AddTagsToResource = actions.DmsAddTagsToResource()
    CreateEndpoint = actions.DmsCreateEndpoint()
    CreateReplicationInstance = actions.DmsCreateReplicationInstance()
    CreateReplicationSubnetGroup = actions.DmsCreateReplicationSubnetGroup()
    CreateReplicationTask = actions.DmsCreateReplicationTask()
    DeleteEndpoint = actions.DmsDeleteEndpoint()
    DeleteEventSubscription = actions.DmsDeleteEventSubscription()
    DeleteReplicationInstance = actions.DmsDeleteReplicationInstance()
    DeleteReplicationSubnetGroup = actions.DmsDeleteReplicationSubnetGroup()
    DeleteReplicationTask = actions.DmsDeleteReplicationTask()
    DescribeAccountAttributes = actions.DmsDescribeAccountAttributes()
    DescribeCertificates = actions.DmsDescribeCertificates()
    DescribeConnections = actions.DmsDescribeConnections()
    DescribeEndpointTypes = actions.DmsDescribeEndpointTypes()
    DescribeEndpoints = actions.DmsDescribeEndpoints()
    DescribeEventCategories = actions.DmsDescribeEventCategories()
    DescribeEventSubscriptions = actions.DmsDescribeEventSubscriptions()
    DescribeEvents = actions.DmsDescribeEvents()
    DescribeOrderableReplicationInstances = actions.DmsDescribeOrderableReplicationInstances()
    DescribeRefreshSchemasStatus = actions.DmsDescribeRefreshSchemasStatus()
    DescribeReplicationInstances = actions.DmsDescribeReplicationInstances()
    DescribeReplicationSubnetGroups = actions.DmsDescribeReplicationSubnetGroups()
    DescribeReplicationTasks = actions.DmsDescribeReplicationTasks()
    DescribeSchemas = actions.DmsDescribeSchemas()
    DescribeTableStatistics = actions.DmsDescribeTableStatistics()
    ListTagsForResource = actions.DmsListTagsForResource()
    ModifyEndpoint = actions.DmsModifyEndpoint()
    ModifyEventSubscription = actions.DmsModifyEventSubscription()
    ModifyReplicationInstance = actions.DmsModifyReplicationInstance()
    ModifyReplicationSubnetGroup = actions.DmsModifyReplicationSubnetGroup()
    ModifyReplicationTask = actions.DmsModifyReplicationTask()
    RefreshSchemas = actions.DmsRefreshSchemas()
    RemoveTagsFromResource = actions.DmsRemoveTagsFromResource()
    StartReplicationTask = actions.DmsStartReplicationTask()
    StopReplicationTask = actions.DmsStopReplicationTask()
    TestConnection = actions.DmsTestConnection()


class Ds:
    all = IamAction("ds", all=True)
    AddIpRoutes = actions.DsAddIpRoutes()
    AddTagsToResource = actions.DsAddTagsToResource()
    AuthorizeApplication = actions.DsAuthorizeApplication()
    CancelSchemaExtension = actions.DsCancelSchemaExtension()
    ConnectDirectory = actions.DsConnectDirectory()
    CreateAlias = actions.DsCreateAlias()
    CreateComputer = actions.DsCreateComputer()
    CreateConditionalForwarder = actions.DsCreateConditionalForwarder()
    CreateDirectory = actions.DsCreateDirectory()
    CreateMicrosoftAD = actions.DsCreateMicrosoftAD()
    CreateSnapshot = actions.DsCreateSnapshot()
    CreateTrust = actions.DsCreateTrust()
    DeleteConditionalForwarder = actions.DsDeleteConditionalForwarder()
    DeleteDirectory = actions.DsDeleteDirectory()
    DeleteSnapshot = actions.DsDeleteSnapshot()
    DeleteTrust = actions.DsDeleteTrust()
    DeregisterEventTopic = actions.DsDeregisterEventTopic()
    DescribeConditionalForwarders = actions.DsDescribeConditionalForwarders()
    DescribeDirectories = actions.DsDescribeDirectories()
    DescribeEventTopics = actions.DsDescribeEventTopics()
    DescribeSnapshots = actions.DsDescribeSnapshots()
    DescribeTrusts = actions.DsDescribeTrusts()
    DisableRadius = actions.DsDisableRadius()
    DisableSso = actions.DsDisableSso()
    EnableRadius = actions.DsEnableRadius()
    EnableSso = actions.DsEnableSso()
    GetDirectoryLimits = actions.DsGetDirectoryLimits()
    GetSnapshotLimits = actions.DsGetSnapshotLimits()
    ListAuthorizedApplications = actions.DsListAuthorizedApplications()
    ListIpRoutes = actions.DsListIpRoutes()
    ListSchemaExtensions = actions.DsListSchemaExtensions()
    ListTagsForResource = actions.DsListTagsForResource()
    RegisterEventTopic = actions.DsRegisterEventTopic()
    RemoveIpRoutes = actions.DsRemoveIpRoutes()
    RemoveTagsFromResource = actions.DsRemoveTagsFromResource()
    RestoreFromSnapshot = actions.DsRestoreFromSnapshot()
    StartSchemaExtension = actions.DsStartSchemaExtension()
    UnauthorizeApplication = actions.DsUnauthorizeApplication()
    UpdateConditionalForwarder = actions.DsUpdateConditionalForwarder()
    UpdateRadius = actions.DsUpdateRadius()
    VerifyTrust = actions.DsVerifyTrust()


class Dynamodb:
    all = IamAction("dynamodb", all=True)
    BatchGetItem = actions.DynamodbBatchGetItem()
    BatchWriteItem = actions.DynamodbBatchWriteItem()
    CreateBackup = actions.DynamodbCreateBackup()
    CreateTable = actions.DynamodbCreateTable()
    DeleteBackup = actions.DynamodbDeleteBackup()
    DeleteItem = actions.DynamodbDeleteItem()
    DeleteTable = actions.DynamodbDeleteTable()
    DescribeBackup = actions.DynamodbDescribeBackup()
    DescribeContinuousBackups = actions.DynamodbDescribeContinuousBackups()
    DescribeLimits = actions.DynamodbDescribeLimits()
    DescribeReservedCapacity = actions.DynamodbDescribeReservedCapacity()
    DescribeReservedCapacityOfferings = actions.DynamodbDescribeReservedCapacityOfferings()
    DescribeStream = actions.DynamodbDescribeStream()
    DescribeTable = actions.DynamodbDescribeTable()
    DescribeTimeToLive = actions.DynamodbDescribeTimeToLive()
    GetItem = actions.DynamodbGetItem()
    GetRecords = actions.DynamodbGetRecords()
    GetShardIterator = actions.DynamodbGetShardIterator()
    ListBackups = actions.DynamodbListBackups()
    ListStreams = actions.DynamodbListStreams()
    ListTables = actions.DynamodbListTables()
    ListTagsOfResource = actions.DynamodbListTagsOfResource()
    PurchaseReservedCapacityOfferings = actions.DynamodbPurchaseReservedCapacityOfferings()
    PutItem = actions.DynamodbPutItem()
    Query = actions.DynamodbQuery()
    RestoreTableFromBackup = actions.DynamodbRestoreTableFromBackup()
    RestoreTableToPointInTime = actions.DynamodbRestoreTableToPointInTime()
    Scan = actions.DynamodbScan()
    TagResource = actions.DynamodbTagResource()
    UntagResource = actions.DynamodbUntagResource()
    UpdateContinuousBackups = actions.DynamodbUpdateContinuousBackups()
    UpdateItem = actions.DynamodbUpdateItem()
    UpdateTable = actions.DynamodbUpdateTable()
    UpdateTimeToLive = actions.DynamodbUpdateTimeToLive()


class Ec2:
    all = IamAction("ec2", all=True)
    AcceptReservedInstancesExchangeQuote = actions.Ec2AcceptReservedInstancesExchangeQuote()
    AcceptVpcEndpointConnections = actions.Ec2AcceptVpcEndpointConnections()
    AcceptVpcPeeringConnection = actions.Ec2AcceptVpcPeeringConnection()
    AllocateAddress = actions.Ec2AllocateAddress()
    AllocateHosts = actions.Ec2AllocateHosts()
    AssignIpv6Addresses = actions.Ec2AssignIpv6Addresses()
    AssignPrivateIpAddresses = actions.Ec2AssignPrivateIpAddresses()
    AssociateAddress = actions.Ec2AssociateAddress()
    AssociateDhcpOptions = actions.Ec2AssociateDhcpOptions()
    AssociateIamInstanceProfile = actions.Ec2AssociateIamInstanceProfile()
    AssociateRouteTable = actions.Ec2AssociateRouteTable()
    AssociateSubnetCidrBlock = actions.Ec2AssociateSubnetCidrBlock()
    AssociateVpcCidrBlock = actions.Ec2AssociateVpcCidrBlock()
    AttachClassicLinkVpc = actions.Ec2AttachClassicLinkVpc()
    AttachInternetGateway = actions.Ec2AttachInternetGateway()
    AttachNetworkInterface = actions.Ec2AttachNetworkInterface()
    AttachVolume = actions.Ec2AttachVolume()
    AttachVpnGateway = actions.Ec2AttachVpnGateway()
    AuthorizeSecurityGroupEgress = actions.Ec2AuthorizeSecurityGroupEgress()
    AuthorizeSecurityGroupIngress = actions.Ec2AuthorizeSecurityGroupIngress()
    BundleInstance = actions.Ec2BundleInstance()
    CancelBundleTask = actions.Ec2CancelBundleTask()
    CancelConversionTask = actions.Ec2CancelConversionTask()
    CancelExportTask = actions.Ec2CancelExportTask()
    CancelImportTask = actions.Ec2CancelImportTask()
    CancelReservedInstancesListing = actions.Ec2CancelReservedInstancesListing()
    CancelSpotFleetRequests = actions.Ec2CancelSpotFleetRequests()
    CancelSpotInstanceRequests = actions.Ec2CancelSpotInstanceRequests()
    ConfirmProductInstance = actions.Ec2ConfirmProductInstance()
    CopyFpgaImage = actions.Ec2CopyFpgaImage()
    CopyImage = actions.Ec2CopyImage()
    CopySnapshot = actions.Ec2CopySnapshot()
    CreateCustomerGateway = actions.Ec2CreateCustomerGateway()
    CreateDefaultSubnet = actions.Ec2CreateDefaultSubnet()
    CreateDefaultVpc = actions.Ec2CreateDefaultVpc()
    CreateDhcpOptions = actions.Ec2CreateDhcpOptions()
    CreateEgressOnlyInternetGateway = actions.Ec2CreateEgressOnlyInternetGateway()
    CreateFlowLogs = actions.Ec2CreateFlowLogs()
    CreateFpgaImage = actions.Ec2CreateFpgaImage()
    CreateImage = actions.Ec2CreateImage()
    CreateInstanceExportTask = actions.Ec2CreateInstanceExportTask()
    CreateInternetGateway = actions.Ec2CreateInternetGateway()
    CreateKeyPair = actions.Ec2CreateKeyPair()
    CreateLaunchTemplate = actions.Ec2CreateLaunchTemplate()
    CreateLaunchTemplateVersion = actions.Ec2CreateLaunchTemplateVersion()
    CreateNatGateway = actions.Ec2CreateNatGateway()
    CreateNetworkAcl = actions.Ec2CreateNetworkAcl()
    CreateNetworkAclEntry = actions.Ec2CreateNetworkAclEntry()
    CreateNetworkInterface = actions.Ec2CreateNetworkInterface()
    CreateNetworkInterfacePermission = actions.Ec2CreateNetworkInterfacePermission()
    CreatePlacementGroup = actions.Ec2CreatePlacementGroup()
    CreateReservedInstancesListing = actions.Ec2CreateReservedInstancesListing()
    CreateRoute = actions.Ec2CreateRoute()
    CreateRouteTable = actions.Ec2CreateRouteTable()
    CreateSecurityGroup = actions.Ec2CreateSecurityGroup()
    CreateSnapshot = actions.Ec2CreateSnapshot()
    CreateSpotDatafeedSubscription = actions.Ec2CreateSpotDatafeedSubscription()
    CreateSubnet = actions.Ec2CreateSubnet()
    CreateTags = actions.Ec2CreateTags()
    CreateVolume = actions.Ec2CreateVolume()
    CreateVpc = actions.Ec2CreateVpc()
    CreateVpcEndpoint = actions.Ec2CreateVpcEndpoint()
    CreateVpcEndpointConnectionNotification = actions.Ec2CreateVpcEndpointConnectionNotification()
    CreateVpcEndpointServiceConfiguration = actions.Ec2CreateVpcEndpointServiceConfiguration()
    CreateVpcPeeringConnection = actions.Ec2CreateVpcPeeringConnection()
    CreateVpnConnection = actions.Ec2CreateVpnConnection()
    CreateVpnConnectionRoute = actions.Ec2CreateVpnConnectionRoute()
    CreateVpnGateway = actions.Ec2CreateVpnGateway()
    DeleteCustomerGateway = actions.Ec2DeleteCustomerGateway()
    DeleteDhcpOptions = actions.Ec2DeleteDhcpOptions()
    DeleteEgressOnlyInternetGateway = actions.Ec2DeleteEgressOnlyInternetGateway()
    DeleteFlowLogs = actions.Ec2DeleteFlowLogs()
    DeleteFpgaImage = actions.Ec2DeleteFpgaImage()
    DeleteInternetGateway = actions.Ec2DeleteInternetGateway()
    DeleteKeyPair = actions.Ec2DeleteKeyPair()
    DeleteLaunchTemplate = actions.Ec2DeleteLaunchTemplate()
    DeleteLaunchTemplateVersions = actions.Ec2DeleteLaunchTemplateVersions()
    DeleteNatGateway = actions.Ec2DeleteNatGateway()
    DeleteNetworkAcl = actions.Ec2DeleteNetworkAcl()
    DeleteNetworkAclEntry = actions.Ec2DeleteNetworkAclEntry()
    DeleteNetworkInterface = actions.Ec2DeleteNetworkInterface()
    DeleteNetworkInterfacePermission = actions.Ec2DeleteNetworkInterfacePermission()
    DeletePlacementGroup = actions.Ec2DeletePlacementGroup()
    DeleteRoute = actions.Ec2DeleteRoute()
    DeleteRouteTable = actions.Ec2DeleteRouteTable()
    DeleteSecurityGroup = actions.Ec2DeleteSecurityGroup()
    DeleteSnapshot = actions.Ec2DeleteSnapshot()
    DeleteSpotDatafeedSubscription = actions.Ec2DeleteSpotDatafeedSubscription()
    DeleteSubnet = actions.Ec2DeleteSubnet()
    DeleteTags = actions.Ec2DeleteTags()
    DeleteVolume = actions.Ec2DeleteVolume()
    DeleteVpc = actions.Ec2DeleteVpc()
    DeleteVpcEndpointConnectionNotifications = actions.Ec2DeleteVpcEndpointConnectionNotifications()
    DeleteVpcEndpointServiceConfigurations = actions.Ec2DeleteVpcEndpointServiceConfigurations()
    DeleteVpcEndpoints = actions.Ec2DeleteVpcEndpoints()
    DeleteVpcPeeringConnection = actions.Ec2DeleteVpcPeeringConnection()
    DeleteVpnConnection = actions.Ec2DeleteVpnConnection()
    DeleteVpnConnectionRoute = actions.Ec2DeleteVpnConnectionRoute()
    DeleteVpnGateway = actions.Ec2DeleteVpnGateway()
    DeregisterImage = actions.Ec2DeregisterImage()
    DescribeAccountAttributes = actions.Ec2DescribeAccountAttributes()
    DescribeAddresses = actions.Ec2DescribeAddresses()
    DescribeAvailabilityZones = actions.Ec2DescribeAvailabilityZones()
    DescribeBundleTasks = actions.Ec2DescribeBundleTasks()
    DescribeClassicLinkInstances = actions.Ec2DescribeClassicLinkInstances()
    DescribeConversionTasks = actions.Ec2DescribeConversionTasks()
    DescribeCustomerGateways = actions.Ec2DescribeCustomerGateways()
    DescribeDhcpOptions = actions.Ec2DescribeDhcpOptions()
    DescribeEgressOnlyInternetGateways = actions.Ec2DescribeEgressOnlyInternetGateways()
    DescribeElasticGpus = actions.Ec2DescribeElasticGpus()
    DescribeExportTasks = actions.Ec2DescribeExportTasks()
    DescribeFlowLogs = actions.Ec2DescribeFlowLogs()
    DescribeFpgaImageAttribute = actions.Ec2DescribeFpgaImageAttribute()
    DescribeFpgaImages = actions.Ec2DescribeFpgaImages()
    DescribeHostReservationOfferings = actions.Ec2DescribeHostReservationOfferings()
    DescribeHostReservations = actions.Ec2DescribeHostReservations()
    DescribeHosts = actions.Ec2DescribeHosts()
    DescribeIamInstanceProfileAssociations = actions.Ec2DescribeIamInstanceProfileAssociations()
    DescribeIdFormat = actions.Ec2DescribeIdFormat()
    DescribeIdentityIdFormat = actions.Ec2DescribeIdentityIdFormat()
    DescribeImageAttribute = actions.Ec2DescribeImageAttribute()
    DescribeImages = actions.Ec2DescribeImages()
    DescribeImportImageTasks = actions.Ec2DescribeImportImageTasks()
    DescribeImportSnapshotTasks = actions.Ec2DescribeImportSnapshotTasks()
    DescribeInstanceAttribute = actions.Ec2DescribeInstanceAttribute()
    DescribeInstanceCreditSpecifications = actions.Ec2DescribeInstanceCreditSpecifications()
    DescribeInstanceStatus = actions.Ec2DescribeInstanceStatus()
    DescribeInstances = actions.Ec2DescribeInstances()
    DescribeInternetGateways = actions.Ec2DescribeInternetGateways()
    DescribeKeyPairs = actions.Ec2DescribeKeyPairs()
    DescribeLaunchTemplateVersions = actions.Ec2DescribeLaunchTemplateVersions()
    DescribeLaunchTemplates = actions.Ec2DescribeLaunchTemplates()
    DescribeMovingAddresses = actions.Ec2DescribeMovingAddresses()
    DescribeNatGateways = actions.Ec2DescribeNatGateways()
    DescribeNetworkAcls = actions.Ec2DescribeNetworkAcls()
    DescribeNetworkInterfaceAttribute = actions.Ec2DescribeNetworkInterfaceAttribute()
    DescribeNetworkInterfacePermissions = actions.Ec2DescribeNetworkInterfacePermissions()
    DescribeNetworkInterfaces = actions.Ec2DescribeNetworkInterfaces()
    DescribePlacementGroups = actions.Ec2DescribePlacementGroups()
    DescribePrefixLists = actions.Ec2DescribePrefixLists()
    DescribeRegions = actions.Ec2DescribeRegions()
    DescribeReservedInstances = actions.Ec2DescribeReservedInstances()
    DescribeReservedInstancesListings = actions.Ec2DescribeReservedInstancesListings()
    DescribeReservedInstancesModifications = actions.Ec2DescribeReservedInstancesModifications()
    DescribeReservedInstancesOfferings = actions.Ec2DescribeReservedInstancesOfferings()
    DescribeRouteTables = actions.Ec2DescribeRouteTables()
    DescribeScheduledInstanceAvailability = actions.Ec2DescribeScheduledInstanceAvailability()
    DescribeScheduledInstances = actions.Ec2DescribeScheduledInstances()
    DescribeSecurityGroupReferences = actions.Ec2DescribeSecurityGroupReferences()
    DescribeSecurityGroups = actions.Ec2DescribeSecurityGroups()
    DescribeSnapshotAttribute = actions.Ec2DescribeSnapshotAttribute()
    DescribeSnapshots = actions.Ec2DescribeSnapshots()
    DescribeSpotDatafeedSubscription = actions.Ec2DescribeSpotDatafeedSubscription()
    DescribeSpotFleetInstances = actions.Ec2DescribeSpotFleetInstances()
    DescribeSpotFleetRequestHistory = actions.Ec2DescribeSpotFleetRequestHistory()
    DescribeSpotFleetRequests = actions.Ec2DescribeSpotFleetRequests()
    DescribeSpotInstanceRequests = actions.Ec2DescribeSpotInstanceRequests()
    DescribeSpotPriceHistory = actions.Ec2DescribeSpotPriceHistory()
    DescribeStaleSecurityGroups = actions.Ec2DescribeStaleSecurityGroups()
    DescribeSubnets = actions.Ec2DescribeSubnets()
    DescribeTags = actions.Ec2DescribeTags()
    DescribeVolumeAttribute = actions.Ec2DescribeVolumeAttribute()
    DescribeVolumeStatus = actions.Ec2DescribeVolumeStatus()
    DescribeVolumes = actions.Ec2DescribeVolumes()
    DescribeVolumesModifications = actions.Ec2DescribeVolumesModifications()
    DescribeVpcAttribute = actions.Ec2DescribeVpcAttribute()
    DescribeVpcClassicLink = actions.Ec2DescribeVpcClassicLink()
    DescribeVpcClassicLinkDnsSupport = actions.Ec2DescribeVpcClassicLinkDnsSupport()
    DescribeVpcEndpointConnectionNotifications = actions.Ec2DescribeVpcEndpointConnectionNotifications()
    DescribeVpcEndpointConnections = actions.Ec2DescribeVpcEndpointConnections()
    DescribeVpcEndpointServiceConfigurations = actions.Ec2DescribeVpcEndpointServiceConfigurations()
    DescribeVpcEndpointServicePermissions = actions.Ec2DescribeVpcEndpointServicePermissions()
    DescribeVpcEndpointServices = actions.Ec2DescribeVpcEndpointServices()
    DescribeVpcEndpoints = actions.Ec2DescribeVpcEndpoints()
    DescribeVpcPeeringConnections = actions.Ec2DescribeVpcPeeringConnections()
    DescribeVpcs = actions.Ec2DescribeVpcs()
    DescribeVpnConnections = actions.Ec2DescribeVpnConnections()
    DescribeVpnGateways = actions.Ec2DescribeVpnGateways()
    DetachClassicLinkVpc = actions.Ec2DetachClassicLinkVpc()
    DetachInternetGateway = actions.Ec2DetachInternetGateway()
    DetachNetworkInterface = actions.Ec2DetachNetworkInterface()
    DetachVolume = actions.Ec2DetachVolume()
    DetachVpnGateway = actions.Ec2DetachVpnGateway()
    DisableVgwRoutePropagation = actions.Ec2DisableVgwRoutePropagation()
    DisableVpcClassicLink = actions.Ec2DisableVpcClassicLink()
    DisableVpcClassicLinkDnsSupport = actions.Ec2DisableVpcClassicLinkDnsSupport()
    DisassociateAddress = actions.Ec2DisassociateAddress()
    DisassociateIamInstanceProfile = actions.Ec2DisassociateIamInstanceProfile()
    DisassociateRouteTable = actions.Ec2DisassociateRouteTable()
    DisassociateSubnetCidrBlock = actions.Ec2DisassociateSubnetCidrBlock()
    DisassociateVpcCidrBlock = actions.Ec2DisassociateVpcCidrBlock()
    EnableVgwRoutePropagation = actions.Ec2EnableVgwRoutePropagation()
    EnableVolumeIO = actions.Ec2EnableVolumeIO()
    EnableVpcClassicLink = actions.Ec2EnableVpcClassicLink()
    EnableVpcClassicLinkDnsSupport = actions.Ec2EnableVpcClassicLinkDnsSupport()
    GetConsoleOutput = actions.Ec2GetConsoleOutput()
    GetConsoleScreenshot = actions.Ec2GetConsoleScreenshot()
    GetHostReservationPurchasePreview = actions.Ec2GetHostReservationPurchasePreview()
    GetLaunchTemplateData = actions.Ec2GetLaunchTemplateData()
    GetPasswordData = actions.Ec2GetPasswordData()
    GetReservedInstancesExchangeQuote = actions.Ec2GetReservedInstancesExchangeQuote()
    ImportImage = actions.Ec2ImportImage()
    ImportInstance = actions.Ec2ImportInstance()
    ImportKeyPair = actions.Ec2ImportKeyPair()
    ImportSnapshot = actions.Ec2ImportSnapshot()
    ImportVolume = actions.Ec2ImportVolume()
    ModifyFpgaImageAttribute = actions.Ec2ModifyFpgaImageAttribute()
    ModifyHosts = actions.Ec2ModifyHosts()
    ModifyIdFormat = actions.Ec2ModifyIdFormat()
    ModifyIdentityIdFormat = actions.Ec2ModifyIdentityIdFormat()
    ModifyImageAttribute = actions.Ec2ModifyImageAttribute()
    ModifyInstanceAttribute = actions.Ec2ModifyInstanceAttribute()
    ModifyInstanceCreditSpecification = actions.Ec2ModifyInstanceCreditSpecification()
    ModifyInstancePlacement = actions.Ec2ModifyInstancePlacement()
    ModifyLaunchTemplate = actions.Ec2ModifyLaunchTemplate()
    ModifyNetworkInterfaceAttribute = actions.Ec2ModifyNetworkInterfaceAttribute()
    ModifyReservedInstances = actions.Ec2ModifyReservedInstances()
    ModifySnapshotAttribute = actions.Ec2ModifySnapshotAttribute()
    ModifySpotFleetRequest = actions.Ec2ModifySpotFleetRequest()
    ModifySubnetAttribute = actions.Ec2ModifySubnetAttribute()
    ModifyVolume = actions.Ec2ModifyVolume()
    ModifyVolumeAttribute = actions.Ec2ModifyVolumeAttribute()
    ModifyVpcAttribute = actions.Ec2ModifyVpcAttribute()
    ModifyVpcEndpoint = actions.Ec2ModifyVpcEndpoint()
    ModifyVpcEndpointConnectionNotification = actions.Ec2ModifyVpcEndpointConnectionNotification()
    ModifyVpcEndpointServiceConfiguration = actions.Ec2ModifyVpcEndpointServiceConfiguration()
    ModifyVpcEndpointServicePermissions = actions.Ec2ModifyVpcEndpointServicePermissions()
    ModifyVpcPeeringConnectionOptions = actions.Ec2ModifyVpcPeeringConnectionOptions()
    ModifyVpcTenancy = actions.Ec2ModifyVpcTenancy()
    MonitorInstances = actions.Ec2MonitorInstances()
    MoveAddressToVpc = actions.Ec2MoveAddressToVpc()
    PurchaseHostReservation = actions.Ec2PurchaseHostReservation()
    PurchaseReservedInstancesOffering = actions.Ec2PurchaseReservedInstancesOffering()
    PurchaseScheduledInstances = actions.Ec2PurchaseScheduledInstances()
    RebootInstances = actions.Ec2RebootInstances()
    RegisterImage = actions.Ec2RegisterImage()
    RejectVpcEndpointConnections = actions.Ec2RejectVpcEndpointConnections()
    RejectVpcPeeringConnection = actions.Ec2RejectVpcPeeringConnection()
    ReleaseAddress = actions.Ec2ReleaseAddress()
    ReleaseHosts = actions.Ec2ReleaseHosts()
    ReplaceIamInstanceProfileAssociation = actions.Ec2ReplaceIamInstanceProfileAssociation()
    ReplaceNetworkAclAssociation = actions.Ec2ReplaceNetworkAclAssociation()
    ReplaceNetworkAclEntry = actions.Ec2ReplaceNetworkAclEntry()
    ReplaceRoute = actions.Ec2ReplaceRoute()
    ReplaceRouteTableAssociation = actions.Ec2ReplaceRouteTableAssociation()
    ReportInstanceStatus = actions.Ec2ReportInstanceStatus()
    RequestSpotFleet = actions.Ec2RequestSpotFleet()
    RequestSpotInstances = actions.Ec2RequestSpotInstances()
    ResetFpgaImageAttribute = actions.Ec2ResetFpgaImageAttribute()
    ResetImageAttribute = actions.Ec2ResetImageAttribute()
    ResetInstanceAttribute = actions.Ec2ResetInstanceAttribute()
    ResetNetworkInterfaceAttribute = actions.Ec2ResetNetworkInterfaceAttribute()
    ResetSnapshotAttribute = actions.Ec2ResetSnapshotAttribute()
    RestoreAddressToClassic = actions.Ec2RestoreAddressToClassic()
    RevokeSecurityGroupEgress = actions.Ec2RevokeSecurityGroupEgress()
    RevokeSecurityGroupIngress = actions.Ec2RevokeSecurityGroupIngress()
    RunInstances = actions.Ec2RunInstances()
    RunScheduledInstances = actions.Ec2RunScheduledInstances()
    StartInstances = actions.Ec2StartInstances()
    StopInstances = actions.Ec2StopInstances()
    TerminateInstances = actions.Ec2TerminateInstances()
    UnassignIpv6Addresses = actions.Ec2UnassignIpv6Addresses()
    UnassignPrivateIpAddresses = actions.Ec2UnassignPrivateIpAddresses()
    UnmonitorInstances = actions.Ec2UnmonitorInstances()
    UpdateSecurityGroupRuleDescriptionsEgress = actions.Ec2UpdateSecurityGroupRuleDescriptionsEgress()
    UpdateSecurityGroupRuleDescriptionsIngress = actions.Ec2UpdateSecurityGroupRuleDescriptionsIngress()


class Ec2Messages:
    all = IamAction("ec2messages", all=True)
    AcknowledgeMessage = actions.Ec2MessagesAcknowledgeMessage()
    DeleteMessage = actions.Ec2MessagesDeleteMessage()
    FailMessage = actions.Ec2MessagesFailMessage()
    GetEndpoint = actions.Ec2MessagesGetEndpoint()
    GetMessages = actions.Ec2MessagesGetMessages()
    SendReply = actions.Ec2MessagesSendReply()


class Ecr:
    all = IamAction("ecr", all=True)
    BatchCheckLayerAvailability = actions.EcrBatchCheckLayerAvailability()
    BatchDeleteImage = actions.EcrBatchDeleteImage()
    BatchGetImage = actions.EcrBatchGetImage()
    CompleteLayerUpload = actions.EcrCompleteLayerUpload()
    CreateRepository = actions.EcrCreateRepository()
    DeleteRepository = actions.EcrDeleteRepository()
    DeleteRepositoryPolicy = actions.EcrDeleteRepositoryPolicy()
    DescribeImages = actions.EcrDescribeImages()
    DescribeRepositories = actions.EcrDescribeRepositories()
    GetAuthorizationToken = actions.EcrGetAuthorizationToken()
    GetDownloadUrlForLayer = actions.EcrGetDownloadUrlForLayer()
    GetRepositoryPolicy = actions.EcrGetRepositoryPolicy()
    InitiateLayerUpload = actions.EcrInitiateLayerUpload()
    ListImages = actions.EcrListImages()
    PutImage = actions.EcrPutImage()
    SetRepositoryPolicy = actions.EcrSetRepositoryPolicy()
    UploadLayerPart = actions.EcrUploadLayerPart()


class Ecs:
    all = IamAction("ecs", all=True)
    CreateCluster = actions.EcsCreateCluster()
    CreateService = actions.EcsCreateService()
    DeleteCluster = actions.EcsDeleteCluster()
    DeleteService = actions.EcsDeleteService()
    DeregisterContainerInstance = actions.EcsDeregisterContainerInstance()
    DeregisterTaskDefinition = actions.EcsDeregisterTaskDefinition()
    DescribeClusters = actions.EcsDescribeClusters()
    DescribeContainerInstances = actions.EcsDescribeContainerInstances()
    DescribeServices = actions.EcsDescribeServices()
    DescribeTaskDefinition = actions.EcsDescribeTaskDefinition()
    DescribeTasks = actions.EcsDescribeTasks()
    DiscoverPollEndpoint = actions.EcsDiscoverPollEndpoint()
    ListClusters = actions.EcsListClusters()
    ListContainerInstances = actions.EcsListContainerInstances()
    ListServices = actions.EcsListServices()
    ListTaskDefinitionFamilies = actions.EcsListTaskDefinitionFamilies()
    ListTaskDefinitions = actions.EcsListTaskDefinitions()
    ListTasks = actions.EcsListTasks()
    Poll = actions.EcsPoll()
    RegisterContainerInstance = actions.EcsRegisterContainerInstance()
    RegisterTaskDefinition = actions.EcsRegisterTaskDefinition()
    RunTask = actions.EcsRunTask()
    StartTask = actions.EcsStartTask()
    StartTelemetrySession = actions.EcsStartTelemetrySession()
    StopTask = actions.EcsStopTask()
    SubmitContainerStateChange = actions.EcsSubmitContainerStateChange()
    SubmitTaskStateChange = actions.EcsSubmitTaskStateChange()
    UpdateContainerAgent = actions.EcsUpdateContainerAgent()
    UpdateContainerInstancesState = actions.EcsUpdateContainerInstancesState()
    UpdateService = actions.EcsUpdateService()


class Elasticache:
    all = IamAction("elasticache", all=True)
    AddTagsToResource = actions.ElasticacheAddTagsToResource()
    AuthorizeCacheSecurityGroupIngress = actions.ElasticacheAuthorizeCacheSecurityGroupIngress()
    CopySnapshot = actions.ElasticacheCopySnapshot()
    CreateCacheCluster = actions.ElasticacheCreateCacheCluster()
    CreateCacheParameterGroup = actions.ElasticacheCreateCacheParameterGroup()
    CreateCacheSecurityGroup = actions.ElasticacheCreateCacheSecurityGroup()
    CreateCacheSubnetGroup = actions.ElasticacheCreateCacheSubnetGroup()
    CreateReplicationGroup = actions.ElasticacheCreateReplicationGroup()
    CreateSnapshot = actions.ElasticacheCreateSnapshot()
    DeleteCacheCluster = actions.ElasticacheDeleteCacheCluster()
    DeleteCacheParameterGroup = actions.ElasticacheDeleteCacheParameterGroup()
    DeleteCacheSecurityGroup = actions.ElasticacheDeleteCacheSecurityGroup()
    DeleteCacheSubnetGroup = actions.ElasticacheDeleteCacheSubnetGroup()
    DeleteReplicationGroup = actions.ElasticacheDeleteReplicationGroup()
    DeleteSnapshot = actions.ElasticacheDeleteSnapshot()
    DescribeCacheClusters = actions.ElasticacheDescribeCacheClusters()
    DescribeCacheEngineVersions = actions.ElasticacheDescribeCacheEngineVersions()
    DescribeCacheParameterGroups = actions.ElasticacheDescribeCacheParameterGroups()
    DescribeCacheParameters = actions.ElasticacheDescribeCacheParameters()
    DescribeCacheSecurityGroups = actions.ElasticacheDescribeCacheSecurityGroups()
    DescribeCacheSubnetGroups = actions.ElasticacheDescribeCacheSubnetGroups()
    DescribeEngineDefaultParameters = actions.ElasticacheDescribeEngineDefaultParameters()
    DescribeEvents = actions.ElasticacheDescribeEvents()
    DescribeReplicationGroups = actions.ElasticacheDescribeReplicationGroups()
    DescribeReservedCacheNodes = actions.ElasticacheDescribeReservedCacheNodes()
    DescribeReservedCacheNodesOfferings = actions.ElasticacheDescribeReservedCacheNodesOfferings()
    DescribeSnapshots = actions.ElasticacheDescribeSnapshots()
    ListAllowedNodeTypeModifications = actions.ElasticacheListAllowedNodeTypeModifications()
    ListTagsForResource = actions.ElasticacheListTagsForResource()
    ModifyCacheCluster = actions.ElasticacheModifyCacheCluster()
    ModifyCacheParameterGroup = actions.ElasticacheModifyCacheParameterGroup()
    ModifyCacheSubnetGroup = actions.ElasticacheModifyCacheSubnetGroup()
    ModifyReplicationGroup = actions.ElasticacheModifyReplicationGroup()
    PurchaseReservedCacheNodesOffering = actions.ElasticachePurchaseReservedCacheNodesOffering()
    RebootCacheCluster = actions.ElasticacheRebootCacheCluster()
    RemoveTagsFromResource = actions.ElasticacheRemoveTagsFromResource()
    ResetCacheParameterGroup = actions.ElasticacheResetCacheParameterGroup()
    RevokeCacheSecurityGroupIngress = actions.ElasticacheRevokeCacheSecurityGroupIngress()


class ElasticBeanstalk:
    all = IamAction("elasticbeanstalk", all=True)
    AbortEnvironmentUpdate = actions.ElasticbeanstalkAbortEnvironmentUpdate()
    ApplyEnvironmentManagedAction = actions.ElasticbeanstalkApplyEnvironmentManagedAction()
    CheckDNSAvailability = actions.ElasticbeanstalkCheckDNSAvailability()
    ComposeEnvironments = actions.ElasticbeanstalkComposeEnvironments()
    CreateApplication = actions.ElasticbeanstalkCreateApplication()
    CreateApplicationVersion = actions.ElasticbeanstalkCreateApplicationVersion()
    CreateConfigurationTemplate = actions.ElasticbeanstalkCreateConfigurationTemplate()
    CreateEnvironment = actions.ElasticbeanstalkCreateEnvironment()
    CreatePlatformVersion = actions.ElasticbeanstalkCreatePlatformVersion()
    CreateStorageLocation = actions.ElasticbeanstalkCreateStorageLocation()
    DeleteApplication = actions.ElasticbeanstalkDeleteApplication()
    DeleteApplicationVersion = actions.ElasticbeanstalkDeleteApplicationVersion()
    DeleteConfigurationTemplate = actions.ElasticbeanstalkDeleteConfigurationTemplate()
    DeleteEnvironmentConfiguration = actions.ElasticbeanstalkDeleteEnvironmentConfiguration()
    DeletePlatformVersion = actions.ElasticbeanstalkDeletePlatformVersion()
    DescribeApplicationVersions = actions.ElasticbeanstalkDescribeApplicationVersions()
    DescribeApplications = actions.ElasticbeanstalkDescribeApplications()
    DescribeConfigurationOptions = actions.ElasticbeanstalkDescribeConfigurationOptions()
    DescribeConfigurationSettings = actions.ElasticbeanstalkDescribeConfigurationSettings()
    DescribeEnvironmentHealth = actions.ElasticbeanstalkDescribeEnvironmentHealth()
    DescribeEnvironmentManagedActionHistory = actions.ElasticbeanstalkDescribeEnvironmentManagedActionHistory()
    DescribeEnvironmentManagedActions = actions.ElasticbeanstalkDescribeEnvironmentManagedActions()
    DescribeEnvironmentResources = actions.ElasticbeanstalkDescribeEnvironmentResources()
    DescribeEnvironments = actions.ElasticbeanstalkDescribeEnvironments()
    DescribeEvents = actions.ElasticbeanstalkDescribeEvents()
    DescribeInstancesHealth = actions.ElasticbeanstalkDescribeInstancesHealth()
    DescribePlatformVersion = actions.ElasticbeanstalkDescribePlatformVersion()
    ListAvailableSolutionStacks = actions.ElasticbeanstalkListAvailableSolutionStacks()
    ListPlatformVersions = actions.ElasticbeanstalkListPlatformVersions()
    RebuildEnvironment = actions.ElasticbeanstalkRebuildEnvironment()
    RequestEnvironmentInfo = actions.ElasticbeanstalkRequestEnvironmentInfo()
    RestartAppServer = actions.ElasticbeanstalkRestartAppServer()
    RetrieveEnvironmentInfo = actions.ElasticbeanstalkRetrieveEnvironmentInfo()
    SwapEnvironmentCNAMEs = actions.ElasticbeanstalkSwapEnvironmentCNAMEs()
    TerminateEnvironment = actions.ElasticbeanstalkTerminateEnvironment()
    UpdateApplication = actions.ElasticbeanstalkUpdateApplication()
    UpdateApplicationResourceLifecycle = actions.ElasticbeanstalkUpdateApplicationResourceLifecycle()
    UpdateApplicationVersion = actions.ElasticbeanstalkUpdateApplicationVersion()
    UpdateConfigurationTemplate = actions.ElasticbeanstalkUpdateConfigurationTemplate()
    UpdateEnvironment = actions.ElasticbeanstalkUpdateEnvironment()
    ValidateConfigurationSettings = actions.ElasticbeanstalkValidateConfigurationSettings()


class ElasticFileSystem:
    all = IamAction("elasticfilesystem", all=True)
    CreateFileSystem = actions.ElasticfilesystemCreateFileSystem()
    CreateMountTarget = actions.ElasticfilesystemCreateMountTarget()
    CreateTags = actions.ElasticfilesystemCreateTags()
    DeleteFileSystem = actions.ElasticfilesystemDeleteFileSystem()
    DeleteMountTarget = actions.ElasticfilesystemDeleteMountTarget()
    DeleteTags = actions.ElasticfilesystemDeleteTags()
    DescribeFileSystems = actions.ElasticfilesystemDescribeFileSystems()
    DescribeMountTargetSecurityGroups = actions.ElasticfilesystemDescribeMountTargetSecurityGroups()
    DescribeMountTargets = actions.ElasticfilesystemDescribeMountTargets()
    DescribeTags = actions.ElasticfilesystemDescribeTags()
    ModifyMountTargetSecurityGroups = actions.ElasticfilesystemModifyMountTargetSecurityGroups()


class ElasticLoadBalancing:
    all = IamAction("elasticloadbalancing", all=True)
    AddTags = actions.ElasticloadbalancingAddTags()
    ApplySecurityGroupsToLoadBalancer = actions.ElasticloadbalancingApplySecurityGroupsToLoadBalancer()
    AttachLoadBalancerToSubnets = actions.ElasticloadbalancingAttachLoadBalancerToSubnets()
    ConfigureHealthCheck = actions.ElasticloadbalancingConfigureHealthCheck()
    CreateAppCookieStickinessPolicy = actions.ElasticloadbalancingCreateAppCookieStickinessPolicy()
    CreateLBCookieStickinessPolicy = actions.ElasticloadbalancingCreateLBCookieStickinessPolicy()
    CreateListener = actions.ElasticloadbalancingCreateListener()
    CreateLoadBalancer = actions.ElasticloadbalancingCreateLoadBalancer()
    CreateLoadBalancerListeners = actions.ElasticloadbalancingCreateLoadBalancerListeners()
    CreateLoadBalancerPolicy = actions.ElasticloadbalancingCreateLoadBalancerPolicy()
    CreateRule = actions.ElasticloadbalancingCreateRule()
    CreateTargetGroup = actions.ElasticloadbalancingCreateTargetGroup()
    DeleteListener = actions.ElasticloadbalancingDeleteListener()
    DeleteLoadBalancer = actions.ElasticloadbalancingDeleteLoadBalancer()
    DeleteLoadBalancerListeners = actions.ElasticloadbalancingDeleteLoadBalancerListeners()
    DeleteLoadBalancerPolicy = actions.ElasticloadbalancingDeleteLoadBalancerPolicy()
    DeleteRule = actions.ElasticloadbalancingDeleteRule()
    DeleteTargetGroup = actions.ElasticloadbalancingDeleteTargetGroup()
    DeregisterInstancesFromLoadBalancer = actions.ElasticloadbalancingDeregisterInstancesFromLoadBalancer()
    DeregisterTargets = actions.ElasticloadbalancingDeregisterTargets()
    DescribeInstanceHealth = actions.ElasticloadbalancingDescribeInstanceHealth()
    DescribeListeners = actions.ElasticloadbalancingDescribeListeners()
    DescribeLoadBalancerAttributes = actions.ElasticloadbalancingDescribeLoadBalancerAttributes()
    DescribeLoadBalancerPolicies = actions.ElasticloadbalancingDescribeLoadBalancerPolicies()
    DescribeLoadBalancerPolicyTypes = actions.ElasticloadbalancingDescribeLoadBalancerPolicyTypes()
    DescribeLoadBalancers = actions.ElasticloadbalancingDescribeLoadBalancers()
    DescribeRules = actions.ElasticloadbalancingDescribeRules()
    DescribeSSLPolicies = actions.ElasticloadbalancingDescribeSSLPolicies()
    DescribeTags = actions.ElasticloadbalancingDescribeTags()
    DescribeTargetGroupAttributes = actions.ElasticloadbalancingDescribeTargetGroupAttributes()
    DescribeTargetGroups = actions.ElasticloadbalancingDescribeTargetGroups()
    DescribeTargetHealth = actions.ElasticloadbalancingDescribeTargetHealth()
    DetachLoadBalancerFromSubnets = actions.ElasticloadbalancingDetachLoadBalancerFromSubnets()
    DisableAvailabilityZonesForLoadBalancer = actions.ElasticloadbalancingDisableAvailabilityZonesForLoadBalancer()
    EnableAvailabilityZonesForLoadBalancer = actions.ElasticloadbalancingEnableAvailabilityZonesForLoadBalancer()
    ModifyListener = actions.ElasticloadbalancingModifyListener()
    ModifyLoadBalancerAttributes = actions.ElasticloadbalancingModifyLoadBalancerAttributes()
    ModifyRule = actions.ElasticloadbalancingModifyRule()
    ModifyTargetGroup = actions.ElasticloadbalancingModifyTargetGroup()
    ModifyTargetGroupAttributes = actions.ElasticloadbalancingModifyTargetGroupAttributes()
    RegisterInstancesWithLoadBalancer = actions.ElasticloadbalancingRegisterInstancesWithLoadBalancer()
    RegisterTargets = actions.ElasticloadbalancingRegisterTargets()
    RemoveTags = actions.ElasticloadbalancingRemoveTags()
    SetIpAddressType = actions.ElasticloadbalancingSetIpAddressType()
    SetLoadBalancerListenerSSLCertificate = actions.ElasticloadbalancingSetLoadBalancerListenerSSLCertificate()
    SetLoadBalancerPoliciesForBackendServer = actions.ElasticloadbalancingSetLoadBalancerPoliciesForBackendServer()
    SetLoadBalancerPoliciesOfListener = actions.ElasticloadbalancingSetLoadBalancerPoliciesOfListener()
    SetRulePriorities = actions.ElasticloadbalancingSetRulePriorities()
    SetSecurityGroups = actions.ElasticloadbalancingSetSecurityGroups()
    SetSubnets = actions.ElasticloadbalancingSetSubnets()


class ElasticMapReduce:
    all = IamAction("elasticmapreduce", all=True)
    AddInstanceGroups = actions.ElasticmapreduceAddInstanceGroups()
    AddJobFlowSteps = actions.ElasticmapreduceAddJobFlowSteps()
    AddTags = actions.ElasticmapreduceAddTags()
    CancelSteps = actions.ElasticmapreduceCancelSteps()
    CreateSecurityConfiguration = actions.ElasticmapreduceCreateSecurityConfiguration()
    DeleteSecurityConfiguration = actions.ElasticmapreduceDeleteSecurityConfiguration()
    DescribeCluster = actions.ElasticmapreduceDescribeCluster()
    DescribeJobFlows = actions.ElasticmapreduceDescribeJobFlows()
    DescribeSecurityConfiguration = actions.ElasticmapreduceDescribeSecurityConfiguration()
    DescribeStep = actions.ElasticmapreduceDescribeStep()
    ListBootstrapActions = actions.ElasticmapreduceListBootstrapActions()
    ListClusters = actions.ElasticmapreduceListClusters()
    ListInstanceGroups = actions.ElasticmapreduceListInstanceGroups()
    ListInstances = actions.ElasticmapreduceListInstances()
    ListSecurityConfigurations = actions.ElasticmapreduceListSecurityConfigurations()
    ListSteps = actions.ElasticmapreduceListSteps()
    ModifyInstanceGroups = actions.ElasticmapreduceModifyInstanceGroups()
    PutAutoScalingPolicy = actions.ElasticmapreducePutAutoScalingPolicy()
    RemoveAutoScalingPolicy = actions.ElasticmapreduceRemoveAutoScalingPolicy()
    RemoveTags = actions.ElasticmapreduceRemoveTags()
    RunJobFlow = actions.ElasticmapreduceRunJobFlow()
    SetTerminationProtection = actions.ElasticmapreduceSetTerminationProtection()
    SetVisibleToAllUsers = actions.ElasticmapreduceSetVisibleToAllUsers()
    TerminateJobFlows = actions.ElasticmapreduceTerminateJobFlows()
    ViewEventsFromAllClustersInConsole = actions.ElasticmapreduceViewEventsFromAllClustersInConsole()


class ElasticTranscoder:
    all = IamAction("elastictranscoder", all=True)
    CancelJob = actions.ElastictranscoderCancelJob()
    CreateJob = actions.ElastictranscoderCreateJob()
    CreatePipeline = actions.ElastictranscoderCreatePipeline()
    CreatePreset = actions.ElastictranscoderCreatePreset()
    DeletePipeline = actions.ElastictranscoderDeletePipeline()
    DeletePreset = actions.ElastictranscoderDeletePreset()
    ListJobsByPipeline = actions.ElastictranscoderListJobsByPipeline()
    ListJobsByStatus = actions.ElastictranscoderListJobsByStatus()
    ListPipelines = actions.ElastictranscoderListPipelines()
    ListPresets = actions.ElastictranscoderListPresets()
    ReadJob = actions.ElastictranscoderReadJob()
    ReadPipeline = actions.ElastictranscoderReadPipeline()
    ReadPreset = actions.ElastictranscoderReadPreset()
    TestRole = actions.ElastictranscoderTestRole()
    UpdatePipeline = actions.ElastictranscoderUpdatePipeline()
    UpdatePipelineNotifications = actions.ElastictranscoderUpdatePipelineNotifications()
    UpdatePipelineStatus = actions.ElastictranscoderUpdatePipelineStatus()


class Es:
    all = IamAction("es", all=True)
    AddTags = actions.EsAddTags()
    CreateElasticsearchDomain = actions.EsCreateElasticsearchDomain()
    DeleteElasticsearchDomain = actions.EsDeleteElasticsearchDomain()
    DescribeElasticsearchDomain = actions.EsDescribeElasticsearchDomain()
    DescribeElasticsearchDomainConfig = actions.EsDescribeElasticsearchDomainConfig()
    DescribeElasticsearchDomains = actions.EsDescribeElasticsearchDomains()
    ESHttpDelete = actions.EsESHttpDelete()
    ESHttpGet = actions.EsESHttpGet()
    ESHttpHead = actions.EsESHttpHead()
    ESHttpPost = actions.EsESHttpPost()
    ESHttpPut = actions.EsESHttpPut()
    ListDomainNames = actions.EsListDomainNames()
    ListTags = actions.EsListTags()
    RemoveTags = actions.EsRemoveTags()
    UpdateElasticsearchDomainConfig = actions.EsUpdateElasticsearchDomainConfig()


class Events:
    all = IamAction("events", all=True)
    DeleteRule = actions.EventsDeleteRule()
    DescribeRule = actions.EventsDescribeRule()
    DisableRule = actions.EventsDisableRule()
    EnableRule = actions.EventsEnableRule()
    ListRuleNamesByTarget = actions.EventsListRuleNamesByTarget()
    ListRules = actions.EventsListRules()
    ListTargetsByRule = actions.EventsListTargetsByRule()
    PutEvents = actions.EventsPutEvents()
    PutRule = actions.EventsPutRule()
    PutTargets = actions.EventsPutTargets()
    RemoveTargets = actions.EventsRemoveTargets()
    TestEventPattern = actions.EventsTestEventPattern()


class ExecuteApi:
    all = IamAction("execute-api", all=True)
    InvalidateCache = actions.ExecuteApiInvalidateCache()
    Invoke = actions.ExecuteApiInvoke()


class Firehose:
    all = IamAction("firehose", all=True)
    CreateDeliveryStream = actions.FirehoseCreateDeliveryStream()
    DeleteDeliveryStream = actions.FirehoseDeleteDeliveryStream()
    DescribeDeliveryStream = actions.FirehoseDescribeDeliveryStream()
    ListDeliveryStreams = actions.FirehoseListDeliveryStreams()
    PutRecord = actions.FirehosePutRecord()
    PutRecordBatch = actions.FirehosePutRecordBatch()
    UpdateDestination = actions.FirehoseUpdateDestination()


class Freertos:
    all = IamAction("freertos", all=True)
    CreateSoftwareConfiguration = actions.FreertosCreateSoftwareConfiguration()
    DeleteSoftwareConfiguration = actions.FreertosDeleteSoftwareConfiguration()
    DescribeHardwarePlatform = actions.FreertosDescribeHardwarePlatform()
    DescribeSoftwareConfiguration = actions.FreertosDescribeSoftwareConfiguration()
    GetSoftwareURL = actions.FreertosGetSoftwareURL()
    GetSoftwareURLForConfiguration = actions.FreertosGetSoftwareURLForConfiguration()
    ListFreeRTOSVersions = actions.FreertosListFreeRTOSVersions()
    ListHardwarePlatforms = actions.FreertosListHardwarePlatforms()
    ListHardwareVendors = actions.FreertosListHardwareVendors()
    ListSoftwareConfigurations = actions.FreertosListSoftwareConfigurations()
    UpdateSoftwareConfiguration = actions.FreertosUpdateSoftwareConfiguration()


class GameLift:
    all = IamAction("gamelift", all=True)
    CreateAlias = actions.GameliftCreateAlias()
    CreateBuild = actions.GameliftCreateBuild()
    CreateFleet = actions.GameliftCreateFleet()
    CreateGameSession = actions.GameliftCreateGameSession()
    CreatePlayerSession = actions.GameliftCreatePlayerSession()
    CreatePlayerSessions = actions.GameliftCreatePlayerSessions()
    DeleteAlias = actions.GameliftDeleteAlias()
    DeleteBuild = actions.GameliftDeleteBuild()
    DeleteFleet = actions.GameliftDeleteFleet()
    DeleteScalingPolicy = actions.GameliftDeleteScalingPolicy()
    DescribeAlias = actions.GameliftDescribeAlias()
    DescribeBuild = actions.GameliftDescribeBuild()
    DescribeEC2InstanceLimits = actions.GameliftDescribeEC2InstanceLimits()
    DescribeFleetAttributes = actions.GameliftDescribeFleetAttributes()
    DescribeFleetCapacity = actions.GameliftDescribeFleetCapacity()
    DescribeFleetEvents = actions.GameliftDescribeFleetEvents()
    DescribeFleetPortSettings = actions.GameliftDescribeFleetPortSettings()
    DescribeFleetUtilization = actions.GameliftDescribeFleetUtilization()
    DescribeGameSessionDetails = actions.GameliftDescribeGameSessionDetails()
    DescribeGameSessions = actions.GameliftDescribeGameSessions()
    DescribeInstances = actions.GameliftDescribeInstances()
    DescribePlayerSessions = actions.GameliftDescribePlayerSessions()
    DescribeRuntimeConfiguration = actions.GameliftDescribeRuntimeConfiguration()
    DescribeScalingPolicies = actions.GameliftDescribeScalingPolicies()
    GetGameSessionLogUrl = actions.GameliftGetGameSessionLogUrl()
    GetInstanceAccess = actions.GameliftGetInstanceAccess()
    ListAliases = actions.GameliftListAliases()
    ListBuilds = actions.GameliftListBuilds()
    ListFleets = actions.GameliftListFleets()
    PutScalingPolicy = actions.GameliftPutScalingPolicy()
    RequestUploadCredentials = actions.GameliftRequestUploadCredentials()
    ResolveAlias = actions.GameliftResolveAlias()
    SearchGameSessions = actions.GameliftSearchGameSessions()
    UpdateAlias = actions.GameliftUpdateAlias()
    UpdateBuild = actions.GameliftUpdateBuild()
    UpdateFleetAttributes = actions.GameliftUpdateFleetAttributes()
    UpdateFleetCapacity = actions.GameliftUpdateFleetCapacity()
    UpdateFleetPortSettings = actions.GameliftUpdateFleetPortSettings()
    UpdateGameSession = actions.GameliftUpdateGameSession()
    UpdateRuntimeConfiguration = actions.GameliftUpdateRuntimeConfiguration()


class Glacier:
    all = IamAction("glacier", all=True)
    AbortMultipartUpload = actions.GlacierAbortMultipartUpload()
    AbortVaultLock = actions.GlacierAbortVaultLock()
    AddTagsToVault = actions.GlacierAddTagsToVault()
    CompleteMultipartUpload = actions.GlacierCompleteMultipartUpload()
    CompleteVaultLock = actions.GlacierCompleteVaultLock()
    CreateVault = actions.GlacierCreateVault()
    DeleteArchive = actions.GlacierDeleteArchive()
    DeleteVault = actions.GlacierDeleteVault()
    DeleteVaultAccessPolicy = actions.GlacierDeleteVaultAccessPolicy()
    DeleteVaultNotifications = actions.GlacierDeleteVaultNotifications()
    DescribeJob = actions.GlacierDescribeJob()
    DescribeVault = actions.GlacierDescribeVault()
    GetDataRetrievalPolicy = actions.GlacierGetDataRetrievalPolicy()
    GetJobOutput = actions.GlacierGetJobOutput()
    GetVaultAccessPolicy = actions.GlacierGetVaultAccessPolicy()
    GetVaultLock = actions.GlacierGetVaultLock()
    GetVaultNotifications = actions.GlacierGetVaultNotifications()
    InitiateJob = actions.GlacierInitiateJob()
    InitiateMultipartUpload = actions.GlacierInitiateMultipartUpload()
    InitiateVaultLock = actions.GlacierInitiateVaultLock()
    ListJobs = actions.GlacierListJobs()
    ListMultipartUploads = actions.GlacierListMultipartUploads()
    ListParts = actions.GlacierListParts()
    ListProvisionedCapacity = actions.GlacierListProvisionedCapacity()
    ListTagsForVault = actions.GlacierListTagsForVault()
    ListVaults = actions.GlacierListVaults()
    PurchaseProvisionedCapacity = actions.GlacierPurchaseProvisionedCapacity()
    RemoveTagsFromVault = actions.GlacierRemoveTagsFromVault()
    SetDataRetrievalPolicy = actions.GlacierSetDataRetrievalPolicy()
    SetVaultAccessPolicy = actions.GlacierSetVaultAccessPolicy()
    SetVaultNotifications = actions.GlacierSetVaultNotifications()
    UploadArchive = actions.GlacierUploadArchive()
    UploadMultipartPart = actions.GlacierUploadMultipartPart()


class Glue:
    all = IamAction("glue", all=True)
    BatchCreatePartition = actions.GlueBatchCreatePartition()
    BatchDeleteConnection = actions.GlueBatchDeleteConnection()
    BatchDeletePartition = actions.GlueBatchDeletePartition()
    BatchDeleteTable = actions.GlueBatchDeleteTable()
    BatchGetPartition = actions.GlueBatchGetPartition()
    CreateClassifier = actions.GlueCreateClassifier()
    CreateConnection = actions.GlueCreateConnection()
    CreateCrawler = actions.GlueCreateCrawler()
    CreateDatabase = actions.GlueCreateDatabase()
    CreateDevEndpoint = actions.GlueCreateDevEndpoint()
    CreateJob = actions.GlueCreateJob()
    CreatePartition = actions.GlueCreatePartition()
    CreateScript = actions.GlueCreateScript()
    CreateTable = actions.GlueCreateTable()
    CreateTrigger = actions.GlueCreateTrigger()
    CreateUserDefinedFunction = actions.GlueCreateUserDefinedFunction()
    DeleteClassifier = actions.GlueDeleteClassifier()
    DeleteConnection = actions.GlueDeleteConnection()
    DeleteCrawler = actions.GlueDeleteCrawler()
    DeleteDatabase = actions.GlueDeleteDatabase()
    DeleteDevEndpoint = actions.GlueDeleteDevEndpoint()
    DeleteJob = actions.GlueDeleteJob()
    DeletePartition = actions.GlueDeletePartition()
    DeleteTable = actions.GlueDeleteTable()
    DeleteTrigger = actions.GlueDeleteTrigger()
    DeleteUserDefinedFunction = actions.GlueDeleteUserDefinedFunction()
    GetCatalogImportStatus = actions.GlueGetCatalogImportStatus()
    GetClassifier = actions.GlueGetClassifier()
    GetClassifiers = actions.GlueGetClassifiers()
    GetConnection = actions.GlueGetConnection()
    GetConnections = actions.GlueGetConnections()
    GetCrawler = actions.GlueGetCrawler()
    GetCrawlerMetrics = actions.GlueGetCrawlerMetrics()
    GetCrawlers = actions.GlueGetCrawlers()
    GetDatabase = actions.GlueGetDatabase()
    GetDatabases = actions.GlueGetDatabases()
    GetDataflowGraph = actions.GlueGetDataflowGraph()
    GetDevEndpoint = actions.GlueGetDevEndpoint()
    GetDevEndpoints = actions.GlueGetDevEndpoints()
    GetJob = actions.GlueGetJob()
    GetJobRun = actions.GlueGetJobRun()
    GetJobRuns = actions.GlueGetJobRuns()
    GetJobs = actions.GlueGetJobs()
    GetMapping = actions.GlueGetMapping()
    GetPartition = actions.GlueGetPartition()
    GetPartitions = actions.GlueGetPartitions()
    GetPlan = actions.GlueGetPlan()
    GetTable = actions.GlueGetTable()
    GetTableVersions = actions.GlueGetTableVersions()
    GetTables = actions.GlueGetTables()
    GetTrigger = actions.GlueGetTrigger()
    GetTriggers = actions.GlueGetTriggers()
    GetUserDefinedFunction = actions.GlueGetUserDefinedFunction()
    GetUserDefinedFunctions = actions.GlueGetUserDefinedFunctions()
    ImportCatalogToGlue = actions.GlueImportCatalogToGlue()
    ResetJobBookmark = actions.GlueResetJobBookmark()
    StartCrawler = actions.GlueStartCrawler()
    StartCrawlerSchedule = actions.GlueStartCrawlerSchedule()
    StartJobRun = actions.GlueStartJobRun()
    StartTrigger = actions.GlueStartTrigger()
    StopCrawler = actions.GlueStopCrawler()
    StopCrawlerSchedule = actions.GlueStopCrawlerSchedule()
    StopTrigger = actions.GlueStopTrigger()
    UpdateClassifier = actions.GlueUpdateClassifier()
    UpdateConnection = actions.GlueUpdateConnection()
    UpdateCrawler = actions.GlueUpdateCrawler()
    UpdateDatabase = actions.GlueUpdateDatabase()
    UpdateDevEndpoint = actions.GlueUpdateDevEndpoint()
    UpdateJob = actions.GlueUpdateJob()
    UpdatePartition = actions.GlueUpdatePartition()
    UpdateTable = actions.GlueUpdateTable()
    UpdateTrigger = actions.GlueUpdateTrigger()
    UpdateUserDefinedFunction = actions.GlueUpdateUserDefinedFunction()


class Greengrass:
    all = IamAction("greengrass", all=True)
    AssociateRoleToGroup = actions.GreengrassAssociateRoleToGroup()
    AssociateServiceRoleToAccount = actions.GreengrassAssociateServiceRoleToAccount()
    CreateCoreDefinition = actions.GreengrassCreateCoreDefinition()
    CreateCoreDefinitionVersion = actions.GreengrassCreateCoreDefinitionVersion()
    CreateDeployment = actions.GreengrassCreateDeployment()
    CreateDeviceDefinition = actions.GreengrassCreateDeviceDefinition()
    CreateDeviceDefinitionVersion = actions.GreengrassCreateDeviceDefinitionVersion()
    CreateFunctionDefinition = actions.GreengrassCreateFunctionDefinition()
    CreateFunctionDefinitionVersion = actions.GreengrassCreateFunctionDefinitionVersion()
    CreateGroup = actions.GreengrassCreateGroup()
    CreateGroupCertificateAuthority = actions.GreengrassCreateGroupCertificateAuthority()
    CreateGroupVersion = actions.GreengrassCreateGroupVersion()
    CreateLoggerDefinition = actions.GreengrassCreateLoggerDefinition()
    CreateLoggerDefinitionVersion = actions.GreengrassCreateLoggerDefinitionVersion()
    CreateResourceDefinition = actions.GreengrassCreateResourceDefinition()
    CreateResourceDefinitionVersion = actions.GreengrassCreateResourceDefinitionVersion()
    CreateSoftwareUpdateJob = actions.GreengrassCreateSoftwareUpdateJob()
    CreateSubscriptionDefinition = actions.GreengrassCreateSubscriptionDefinition()
    CreateSubscriptionDefinitionVersion = actions.GreengrassCreateSubscriptionDefinitionVersion()
    DeleteCoreDefinition = actions.GreengrassDeleteCoreDefinition()
    DeleteDeviceDefinition = actions.GreengrassDeleteDeviceDefinition()
    DeleteFunctionDefinition = actions.GreengrassDeleteFunctionDefinition()
    DeleteGroup = actions.GreengrassDeleteGroup()
    DeleteLoggerDefinition = actions.GreengrassDeleteLoggerDefinition()
    DeleteResourceDefinition = actions.GreengrassDeleteResourceDefinition()
    DeleteSubscriptionDefinition = actions.GreengrassDeleteSubscriptionDefinition()
    DisassociateRoleFromGroup = actions.GreengrassDisassociateRoleFromGroup()
    DisassociateServiceRoleFromAccount = actions.GreengrassDisassociateServiceRoleFromAccount()
    GetAssociatedRole = actions.GreengrassGetAssociatedRole()
    GetConnectivityInfo = actions.GreengrassGetConnectivityInfo()
    GetCoreDefinition = actions.GreengrassGetCoreDefinition()
    GetCoreDefinitionVersion = actions.GreengrassGetCoreDefinitionVersion()
    GetDeploymentStatus = actions.GreengrassGetDeploymentStatus()
    GetDeviceDefinition = actions.GreengrassGetDeviceDefinition()
    GetDeviceDefinitionVersion = actions.GreengrassGetDeviceDefinitionVersion()
    GetFunctionDefinition = actions.GreengrassGetFunctionDefinition()
    GetFunctionDefinitionVersion = actions.GreengrassGetFunctionDefinitionVersion()
    GetGroup = actions.GreengrassGetGroup()
    GetGroupCertificateAuthority = actions.GreengrassGetGroupCertificateAuthority()
    GetGroupCertificateConfiguration = actions.GreengrassGetGroupCertificateConfiguration()
    GetGroupVersion = actions.GreengrassGetGroupVersion()
    GetLoggerDefinition = actions.GreengrassGetLoggerDefinition()
    GetLoggerDefinitionVersion = actions.GreengrassGetLoggerDefinitionVersion()
    GetResourceDefinition = actions.GreengrassGetResourceDefinition()
    GetResourceDefinitionVersion = actions.GreengrassGetResourceDefinitionVersion()
    GetServiceRoleForAccount = actions.GreengrassGetServiceRoleForAccount()
    GetSubscriptionDefinition = actions.GreengrassGetSubscriptionDefinition()
    GetSubscriptionDefinitionVersion = actions.GreengrassGetSubscriptionDefinitionVersion()
    ListCoreDefinitionVersions = actions.GreengrassListCoreDefinitionVersions()
    ListCoreDefinitions = actions.GreengrassListCoreDefinitions()
    ListDeployments = actions.GreengrassListDeployments()
    ListDeviceDefinitionVersions = actions.GreengrassListDeviceDefinitionVersions()
    ListDeviceDefinitions = actions.GreengrassListDeviceDefinitions()
    ListFunctionDefinitionVersions = actions.GreengrassListFunctionDefinitionVersions()
    ListFunctionDefinitions = actions.GreengrassListFunctionDefinitions()
    ListGroupCertificateAuthorities = actions.GreengrassListGroupCertificateAuthorities()
    ListGroupVersions = actions.GreengrassListGroupVersions()
    ListGroups = actions.GreengrassListGroups()
    ListLoggerDefinitionVersions = actions.GreengrassListLoggerDefinitionVersions()
    ListLoggerDefinitions = actions.GreengrassListLoggerDefinitions()
    ListResourceDefinitionVersions = actions.GreengrassListResourceDefinitionVersions()
    ListResourceDefinitions = actions.GreengrassListResourceDefinitions()
    ListSubscriptionDefinitionVersions = actions.GreengrassListSubscriptionDefinitionVersions()
    ListSubscriptionDefinitions = actions.GreengrassListSubscriptionDefinitions()
    ResetDeployments = actions.GreengrassResetDeployments()
    UpdateConnectivityInfo = actions.GreengrassUpdateConnectivityInfo()
    UpdateCoreDefinition = actions.GreengrassUpdateCoreDefinition()
    UpdateDeviceDefinition = actions.GreengrassUpdateDeviceDefinition()
    UpdateFunctionDefinition = actions.GreengrassUpdateFunctionDefinition()
    UpdateGroup = actions.GreengrassUpdateGroup()
    UpdateGroupCertificateConfiguration = actions.GreengrassUpdateGroupCertificateConfiguration()
    UpdateLoggerDefinition = actions.GreengrassUpdateLoggerDefinition()
    UpdateResourceDefinition = actions.GreengrassUpdateResourceDefinition()
    UpdateSubscriptionDefinition = actions.GreengrassUpdateSubscriptionDefinition()


class GuardDuty:
    all = IamAction("guardduty", all=True)
    AcceptInvitation = actions.GuarddutyAcceptInvitation()
    ArchiveFindings = actions.GuarddutyArchiveFindings()
    CreateDetector = actions.GuarddutyCreateDetector()
    CreateIPSet = actions.GuarddutyCreateIPSet()
    CreateMembers = actions.GuarddutyCreateMembers()
    CreateSampleFindings = actions.GuarddutyCreateSampleFindings()
    CreateThreatIntelSet = actions.GuarddutyCreateThreatIntelSet()
    DeclineInvitations = actions.GuarddutyDeclineInvitations()
    DeleteDetector = actions.GuarddutyDeleteDetector()
    DeleteIPSet = actions.GuarddutyDeleteIPSet()
    DeleteInvitations = actions.GuarddutyDeleteInvitations()
    DeleteMembers = actions.GuarddutyDeleteMembers()
    DeleteThreatIntelSet = actions.GuarddutyDeleteThreatIntelSet()
    DisassociateFromMasterAccount = actions.GuarddutyDisassociateFromMasterAccount()
    DisassociateMembers = actions.GuarddutyDisassociateMembers()
    GetDetector = actions.GuarddutyGetDetector()
    GetFindings = actions.GuarddutyGetFindings()
    GetFindingsStatistics = actions.GuarddutyGetFindingsStatistics()
    GetIPSet = actions.GuarddutyGetIPSet()
    GetInvitationsCount = actions.GuarddutyGetInvitationsCount()
    GetMasterAccount = actions.GuarddutyGetMasterAccount()
    GetMembers = actions.GuarddutyGetMembers()
    GetThreatIntelSet = actions.GuarddutyGetThreatIntelSet()
    InviteMembers = actions.GuarddutyInviteMembers()
    ListDetectors = actions.GuarddutyListDetectors()
    ListFindings = actions.GuarddutyListFindings()
    ListIPSets = actions.GuarddutyListIPSets()
    ListInvitations = actions.GuarddutyListInvitations()
    ListMembers = actions.GuarddutyListMembers()
    ListThreatIntelSets = actions.GuarddutyListThreatIntelSets()
    StartMonitoringMembers = actions.GuarddutyStartMonitoringMembers()
    StopMonitoringMembers = actions.GuarddutyStopMonitoringMembers()
    UnarchiveFindings = actions.GuarddutyUnarchiveFindings()
    UpdateDetector = actions.GuarddutyUpdateDetector()
    UpdateFindingsFeedback = actions.GuarddutyUpdateFindingsFeedback()
    UpdateIPSet = actions.GuarddutyUpdateIPSet()
    UpdateThreatIntelSet = actions.GuarddutyUpdateThreatIntelSet()


class Health:
    all = IamAction("health", all=True)
    DescribeAffectedEntities = actions.HealthDescribeAffectedEntities()
    DescribeEntityAggregates = actions.HealthDescribeEntityAggregates()
    DescribeEventAggregates = actions.HealthDescribeEventAggregates()
    DescribeEventDetails = actions.HealthDescribeEventDetails()
    DescribeEventTypes = actions.HealthDescribeEventTypes()
    DescribeEvents = actions.HealthDescribeEvents()


class Iam:
    all = IamAction("iam", all=True)
    AddClientIDToOpenIDConnectProvider = actions.IamAddClientIDToOpenIDConnectProvider()
    AddRoleToInstanceProfile = actions.IamAddRoleToInstanceProfile()
    AddUserToGroup = actions.IamAddUserToGroup()
    AttachGroupPolicy = actions.IamAttachGroupPolicy()
    AttachRolePolicy = actions.IamAttachRolePolicy()
    AttachUserPolicy = actions.IamAttachUserPolicy()
    ChangePassword = actions.IamChangePassword()
    CreateAccessKey = actions.IamCreateAccessKey()
    CreateAccountAlias = actions.IamCreateAccountAlias()
    CreateGroup = actions.IamCreateGroup()
    CreateInstanceProfile = actions.IamCreateInstanceProfile()
    CreateLoginProfile = actions.IamCreateLoginProfile()
    CreateOpenIDConnectProvider = actions.IamCreateOpenIDConnectProvider()
    CreatePolicy = actions.IamCreatePolicy()
    CreatePolicyVersion = actions.IamCreatePolicyVersion()
    CreateRole = actions.IamCreateRole()
    CreateSAMLProvider = actions.IamCreateSAMLProvider()
    CreateServiceLinkedRole = actions.IamCreateServiceLinkedRole()
    CreateServiceSpecificCredential = actions.IamCreateServiceSpecificCredential()
    CreateUser = actions.IamCreateUser()
    CreateVirtualMFADevice = actions.IamCreateVirtualMFADevice()
    DeactivateMFADevice = actions.IamDeactivateMFADevice()
    DeleteAccessKey = actions.IamDeleteAccessKey()
    DeleteAccountAlias = actions.IamDeleteAccountAlias()
    DeleteAccountPasswordPolicy = actions.IamDeleteAccountPasswordPolicy()
    DeleteGroup = actions.IamDeleteGroup()
    DeleteGroupPolicy = actions.IamDeleteGroupPolicy()
    DeleteInstanceProfile = actions.IamDeleteInstanceProfile()
    DeleteLoginProfile = actions.IamDeleteLoginProfile()
    DeleteOpenIDConnectProvider = actions.IamDeleteOpenIDConnectProvider()
    DeletePolicy = actions.IamDeletePolicy()
    DeletePolicyVersion = actions.IamDeletePolicyVersion()
    DeleteRole = actions.IamDeleteRole()
    DeleteRolePolicy = actions.IamDeleteRolePolicy()
    DeleteSAMLProvider = actions.IamDeleteSAMLProvider()
    DeleteSSHPublicKey = actions.IamDeleteSSHPublicKey()
    DeleteServerCertificate = actions.IamDeleteServerCertificate()
    DeleteServiceLinkedRole = actions.IamDeleteServiceLinkedRole()
    DeleteServiceSpecificCredential = actions.IamDeleteServiceSpecificCredential()
    DeleteSigningCertificate = actions.IamDeleteSigningCertificate()
    DeleteUser = actions.IamDeleteUser()
    DeleteUserPolicy = actions.IamDeleteUserPolicy()
    DeleteVirtualMFADevice = actions.IamDeleteVirtualMFADevice()
    DetachGroupPolicy = actions.IamDetachGroupPolicy()
    DetachRolePolicy = actions.IamDetachRolePolicy()
    DetachUserPolicy = actions.IamDetachUserPolicy()
    EnableMFADevice = actions.IamEnableMFADevice()
    GenerateCredentialReport = actions.IamGenerateCredentialReport()
    GenerateServiceLastAccessedDetails = actions.IamGenerateServiceLastAccessedDetails()
    GetAccessKeyLastUsed = actions.IamGetAccessKeyLastUsed()
    GetAccountAuthorizationDetails = actions.IamGetAccountAuthorizationDetails()
    GetAccountPasswordPolicy = actions.IamGetAccountPasswordPolicy()
    GetAccountSummary = actions.IamGetAccountSummary()
    GetContextKeysForCustomPolicy = actions.IamGetContextKeysForCustomPolicy()
    GetContextKeysForPrincipalPolicy = actions.IamGetContextKeysForPrincipalPolicy()
    GetCredentialReport = actions.IamGetCredentialReport()
    GetGroup = actions.IamGetGroup()
    GetGroupPolicy = actions.IamGetGroupPolicy()
    GetInstanceProfile = actions.IamGetInstanceProfile()
    GetLoginProfile = actions.IamGetLoginProfile()
    GetOpenIDConnectProvider = actions.IamGetOpenIDConnectProvider()
    GetPolicy = actions.IamGetPolicy()
    GetPolicyVersion = actions.IamGetPolicyVersion()
    GetRole = actions.IamGetRole()
    GetRolePolicy = actions.IamGetRolePolicy()
    GetSAMLProvider = actions.IamGetSAMLProvider()
    GetSSHPublicKey = actions.IamGetSSHPublicKey()
    GetServerCertificate = actions.IamGetServerCertificate()
    GetServiceLastAccessedDetails = actions.IamGetServiceLastAccessedDetails()
    GetServiceLastAccessedDetailsWithEntities = actions.IamGetServiceLastAccessedDetailsWithEntities()
    GetServiceLinkedRoleDeletionStatus = actions.IamGetServiceLinkedRoleDeletionStatus()
    GetUser = actions.IamGetUser()
    GetUserPolicy = actions.IamGetUserPolicy()
    ListAccessKeys = actions.IamListAccessKeys()
    ListAccountAliases = actions.IamListAccountAliases()
    ListAttachedGroupPolicies = actions.IamListAttachedGroupPolicies()
    ListAttachedRolePolicies = actions.IamListAttachedRolePolicies()
    ListAttachedUserPolicies = actions.IamListAttachedUserPolicies()
    ListEntitiesForPolicy = actions.IamListEntitiesForPolicy()
    ListGroupPolicies = actions.IamListGroupPolicies()
    ListGroups = actions.IamListGroups()
    ListGroupsForUser = actions.IamListGroupsForUser()
    ListInstanceProfiles = actions.IamListInstanceProfiles()
    ListInstanceProfilesForRole = actions.IamListInstanceProfilesForRole()
    ListMFADevices = actions.IamListMFADevices()
    ListOpenIDConnectProviders = actions.IamListOpenIDConnectProviders()
    ListPolicies = actions.IamListPolicies()
    ListPoliciesGrantingServiceAccess = actions.IamListPoliciesGrantingServiceAccess()
    ListPolicyVersions = actions.IamListPolicyVersions()
    ListRolePolicies = actions.IamListRolePolicies()
    ListRoles = actions.IamListRoles()
    ListSAMLProviders = actions.IamListSAMLProviders()
    ListSSHPublicKeys = actions.IamListSSHPublicKeys()
    ListServerCertificates = actions.IamListServerCertificates()
    ListServiceSpecificCredentials = actions.IamListServiceSpecificCredentials()
    ListSigningCertificates = actions.IamListSigningCertificates()
    ListUserPolicies = actions.IamListUserPolicies()
    ListUsers = actions.IamListUsers()
    ListVirtualMFADevices = actions.IamListVirtualMFADevices()
    PassRole = actions.IamPassRole()
    PutGroupPolicy = actions.IamPutGroupPolicy()
    PutRolePolicy = actions.IamPutRolePolicy()
    PutUserPolicy = actions.IamPutUserPolicy()
    RemoveClientIDFromOpenIDConnectProvider = actions.IamRemoveClientIDFromOpenIDConnectProvider()
    RemoveRoleFromInstanceProfile = actions.IamRemoveRoleFromInstanceProfile()
    RemoveUserFromGroup = actions.IamRemoveUserFromGroup()
    ResetServiceSpecificCredential = actions.IamResetServiceSpecificCredential()
    ResyncMFADevice = actions.IamResyncMFADevice()
    SetDefaultPolicyVersion = actions.IamSetDefaultPolicyVersion()
    SimulateCustomPolicy = actions.IamSimulateCustomPolicy()
    SimulatePrincipalPolicy = actions.IamSimulatePrincipalPolicy()
    UpdateAccessKey = actions.IamUpdateAccessKey()
    UpdateAccountPasswordPolicy = actions.IamUpdateAccountPasswordPolicy()
    UpdateAssumeRolePolicy = actions.IamUpdateAssumeRolePolicy()
    UpdateGroup = actions.IamUpdateGroup()
    UpdateLoginProfile = actions.IamUpdateLoginProfile()
    UpdateOpenIDConnectProviderThumbprint = actions.IamUpdateOpenIDConnectProviderThumbprint()
    UpdateRoleDescription = actions.IamUpdateRoleDescription()
    UpdateSAMLProvider = actions.IamUpdateSAMLProvider()
    UpdateSSHPublicKey = actions.IamUpdateSSHPublicKey()
    UpdateServerCertificate = actions.IamUpdateServerCertificate()
    UpdateServiceSpecificCredential = actions.IamUpdateServiceSpecificCredential()
    UpdateSigningCertificate = actions.IamUpdateSigningCertificate()
    UpdateUser = actions.IamUpdateUser()
    UploadSSHPublicKey = actions.IamUploadSSHPublicKey()
    UploadServerCertificate = actions.IamUploadServerCertificate()
    UploadSigningCertificate = actions.IamUploadSigningCertificate()


class ImportExport:
    all = IamAction("importexport", all=True)
    CancelJob = actions.ImportexportCancelJob()
    CreateJob = actions.ImportexportCreateJob()
    GetShippingLabel = actions.ImportexportGetShippingLabel()
    GetStatus = actions.ImportexportGetStatus()
    ListJobs = actions.ImportexportListJobs()
    UpdateJob = actions.ImportexportUpdateJob()


class Inspector:
    all = IamAction("inspector", all=True)
    AddAttributesToFindings = actions.InspectorAddAttributesToFindings()
    CreateAssessmentTarget = actions.InspectorCreateAssessmentTarget()
    CreateAssessmentTemplate = actions.InspectorCreateAssessmentTemplate()
    CreateResourceGroup = actions.InspectorCreateResourceGroup()
    DeleteAssessmentRun = actions.InspectorDeleteAssessmentRun()
    DeleteAssessmentTarget = actions.InspectorDeleteAssessmentTarget()
    DeleteAssessmentTemplate = actions.InspectorDeleteAssessmentTemplate()
    DescribeAssessmentRuns = actions.InspectorDescribeAssessmentRuns()
    DescribeAssessmentTargets = actions.InspectorDescribeAssessmentTargets()
    DescribeAssessmentTemplates = actions.InspectorDescribeAssessmentTemplates()
    DescribeCrossAccountAccessRole = actions.InspectorDescribeCrossAccountAccessRole()
    DescribeFindings = actions.InspectorDescribeFindings()
    DescribeResourceGroups = actions.InspectorDescribeResourceGroups()
    DescribeRulesPackages = actions.InspectorDescribeRulesPackages()
    GetTelemetryMetadata = actions.InspectorGetTelemetryMetadata()
    ListAssessmentRunAgents = actions.InspectorListAssessmentRunAgents()
    ListAssessmentRuns = actions.InspectorListAssessmentRuns()
    ListAssessmentTargets = actions.InspectorListAssessmentTargets()
    ListAssessmentTemplates = actions.InspectorListAssessmentTemplates()
    ListEventSubscriptions = actions.InspectorListEventSubscriptions()
    ListFindings = actions.InspectorListFindings()
    ListRulesPackages = actions.InspectorListRulesPackages()
    ListTagsForResource = actions.InspectorListTagsForResource()
    PreviewAgents = actions.InspectorPreviewAgents()
    RegisterCrossAccountAccessRole = actions.InspectorRegisterCrossAccountAccessRole()
    RemoveAttributesFromFindings = actions.InspectorRemoveAttributesFromFindings()
    SetTagsForResource = actions.InspectorSetTagsForResource()
    StartAssessmentRun = actions.InspectorStartAssessmentRun()
    StopAssessmentRun = actions.InspectorStopAssessmentRun()
    SubscribeToEvent = actions.InspectorSubscribeToEvent()
    UnsubscribeFromEvent = actions.InspectorUnsubscribeFromEvent()
    UpdateAssessmentTarget = actions.InspectorUpdateAssessmentTarget()


class Iot:
    all = IamAction("iot", all=True)
    AcceptCertificateTransfer = actions.IotAcceptCertificateTransfer()
    AssociateTargetsWithJob = actions.IotAssociateTargetsWithJob()
    AttachPolicy = actions.IotAttachPolicy()
    AttachPrincipalPolicy = actions.IotAttachPrincipalPolicy()
    AttachThingPrincipal = actions.IotAttachThingPrincipal()
    CancelCertificateTransfer = actions.IotCancelCertificateTransfer()
    CancelJob = actions.IotCancelJob()
    ClearDefaultAuthorizer = actions.IotClearDefaultAuthorizer()
    Connect = actions.IotConnect()
    CreateAuthorizer = actions.IotCreateAuthorizer()
    CreateCertificateFromCsr = actions.IotCreateCertificateFromCsr()
    CreateJob = actions.IotCreateJob()
    CreateKeysAndCertificate = actions.IotCreateKeysAndCertificate()
    CreateOTAUpdateJob = actions.IotCreateOTAUpdateJob()
    CreatePolicy = actions.IotCreatePolicy()
    CreatePolicyVersion = actions.IotCreatePolicyVersion()
    CreateRoleAlias = actions.IotCreateRoleAlias()
    CreateStream = actions.IotCreateStream()
    CreateThing = actions.IotCreateThing()
    CreateThingType = actions.IotCreateThingType()
    CreateTopicRule = actions.IotCreateTopicRule()
    DeleteAuthorizer = actions.IotDeleteAuthorizer()
    DeleteCACertificate = actions.IotDeleteCACertificate()
    DeleteCertificate = actions.IotDeleteCertificate()
    DeleteOTAUpdateJob = actions.IotDeleteOTAUpdateJob()
    DeletePolicy = actions.IotDeletePolicy()
    DeletePolicyVersion = actions.IotDeletePolicyVersion()
    DeleteRegistrationCode = actions.IotDeleteRegistrationCode()
    DeleteRoleAlias = actions.IotDeleteRoleAlias()
    DeleteStream = actions.IotDeleteStream()
    DeleteThing = actions.IotDeleteThing()
    DeleteThingShadow = actions.IotDeleteThingShadow()
    DeleteThingType = actions.IotDeleteThingType()
    DeleteTopicRule = actions.IotDeleteTopicRule()
    DeprecateThingType = actions.IotDeprecateThingType()
    DescribeAuthorizer = actions.IotDescribeAuthorizer()
    DescribeCACertificate = actions.IotDescribeCACertificate()
    DescribeCertificate = actions.IotDescribeCertificate()
    DescribeDefaultAuthorizer = actions.IotDescribeDefaultAuthorizer()
    DescribeEndpoint = actions.IotDescribeEndpoint()
    DescribeIndex = actions.IotDescribeIndex()
    DescribeJob = actions.IotDescribeJob()
    DescribeJobExecution = actions.IotDescribeJobExecution()
    DescribeRoleAlias = actions.IotDescribeRoleAlias()
    DescribeStream = actions.IotDescribeStream()
    DescribeThing = actions.IotDescribeThing()
    DescribeThingType = actions.IotDescribeThingType()
    DetachPolicy = actions.IotDetachPolicy()
    DetachPrincipalPolicy = actions.IotDetachPrincipalPolicy()
    DetachThingPrincipal = actions.IotDetachThingPrincipal()
    DisableTopicRule = actions.IotDisableTopicRule()
    EnableTopicRule = actions.IotEnableTopicRule()
    GetEffectivePolicies = actions.IotGetEffectivePolicies()
    GetIndexingConfiguration = actions.IotGetIndexingConfiguration()
    GetJobDocument = actions.IotGetJobDocument()
    GetLoggingOptions = actions.IotGetLoggingOptions()
    GetOTAUpdateJob = actions.IotGetOTAUpdateJob()
    GetPolicy = actions.IotGetPolicy()
    GetPolicyVersion = actions.IotGetPolicyVersion()
    GetRegistrationCode = actions.IotGetRegistrationCode()
    GetThingShadow = actions.IotGetThingShadow()
    GetTopicRule = actions.IotGetTopicRule()
    ListAttachedPolicies = actions.IotListAttachedPolicies()
    ListAuthorizers = actions.IotListAuthorizers()
    ListCACertificates = actions.IotListCACertificates()
    ListCertificates = actions.IotListCertificates()
    ListCertificatesByCA = actions.IotListCertificatesByCA()
    ListIndices = actions.IotListIndices()
    ListJobExecutionsForJob = actions.IotListJobExecutionsForJob()
    ListJobExecutionsForThing = actions.IotListJobExecutionsForThing()
    ListJobs = actions.IotListJobs()
    ListOTAUpdateJobs = actions.IotListOTAUpdateJobs()
    ListOutgoingCertificates = actions.IotListOutgoingCertificates()
    ListPolicies = actions.IotListPolicies()
    ListPolicyPrincipals = actions.IotListPolicyPrincipals()
    ListPolicyVersions = actions.IotListPolicyVersions()
    ListPrincipalPolicies = actions.IotListPrincipalPolicies()
    ListPrincipalThings = actions.IotListPrincipalThings()
    ListRoleAliases = actions.IotListRoleAliases()
    ListStreams = actions.IotListStreams()
    ListTargetsForPolicy = actions.IotListTargetsForPolicy()
    ListThingPrincipals = actions.IotListThingPrincipals()
    ListThingTypes = actions.IotListThingTypes()
    ListThings = actions.IotListThings()
    ListTopicRules = actions.IotListTopicRules()
    Publish = actions.IotPublish()
    Receive = actions.IotReceive()
    RegisterCACertificate = actions.IotRegisterCACertificate()
    RegisterCertificate = actions.IotRegisterCertificate()
    RejectCertificateTransfer = actions.IotRejectCertificateTransfer()
    ReplaceTopicRule = actions.IotReplaceTopicRule()
    SearchIndex = actions.IotSearchIndex()
    SetDefaultAuthorizer = actions.IotSetDefaultAuthorizer()
    SetDefaultPolicyVersion = actions.IotSetDefaultPolicyVersion()
    SetLoggingOptions = actions.IotSetLoggingOptions()
    Subscribe = actions.IotSubscribe()
    TestAuthorization = actions.IotTestAuthorization()
    TestInvokeAuthorizer = actions.IotTestInvokeAuthorizer()
    TransferCertificate = actions.IotTransferCertificate()
    UpdateAuthorizer = actions.IotUpdateAuthorizer()
    UpdateCACertificate = actions.IotUpdateCACertificate()
    UpdateCertificate = actions.IotUpdateCertificate()
    UpdateIndexingConfiguration = actions.IotUpdateIndexingConfiguration()
    UpdateRoleAlias = actions.IotUpdateRoleAlias()
    UpdateStream = actions.IotUpdateStream()
    UpdateThing = actions.IotUpdateThing()
    UpdateThingShadow = actions.IotUpdateThingShadow()


class IotAnalytics:
    all = IamAction("iotanalytics", all=True)
    CreateChannel = actions.IotanalyticsCreateChannel()
    CreateDataset = actions.IotanalyticsCreateDataset()
    CreateDatasetContent = actions.IotanalyticsCreateDatasetContent()
    CreateDatastore = actions.IotanalyticsCreateDatastore()
    CreatePipeline = actions.IotanalyticsCreatePipeline()
    DeleteChannel = actions.IotanalyticsDeleteChannel()
    DeleteDataset = actions.IotanalyticsDeleteDataset()
    DeleteDatasetContent = actions.IotanalyticsDeleteDatasetContent()
    DeleteDatastore = actions.IotanalyticsDeleteDatastore()
    DeletePipeline = actions.IotanalyticsDeletePipeline()
    DescribeChannel = actions.IotanalyticsDescribeChannel()
    DescribeDataset = actions.IotanalyticsDescribeDataset()
    DescribeDatastore = actions.IotanalyticsDescribeDatastore()
    DescribePipeline = actions.IotanalyticsDescribePipeline()
    GetDatasetContent = actions.IotanalyticsGetDatasetContent()
    ListChannels = actions.IotanalyticsListChannels()
    ListDatasets = actions.IotanalyticsListDatasets()
    ListDatastores = actions.IotanalyticsListDatastores()
    ListPipelines = actions.IotanalyticsListPipelines()
    UpdateDataset = actions.IotanalyticsUpdateDataset()
    UpdatePipeline = actions.IotanalyticsUpdatePipeline()


class Kinesis:
    all = IamAction("kinesis", all=True)
    AddTagsToStream = actions.KinesisAddTagsToStream()
    CreateStream = actions.KinesisCreateStream()
    DecreaseStreamRetentionPeriod = actions.KinesisDecreaseStreamRetentionPeriod()
    DeleteStream = actions.KinesisDeleteStream()
    DescribeLimits = actions.KinesisDescribeLimits()
    DescribeStream = actions.KinesisDescribeStream()
    DisableEnhancedMonitoring = actions.KinesisDisableEnhancedMonitoring()
    EnableEnhancedMonitoring = actions.KinesisEnableEnhancedMonitoring()
    GetRecords = actions.KinesisGetRecords()
    GetShardIterator = actions.KinesisGetShardIterator()
    IncreaseStreamRetentionPeriod = actions.KinesisIncreaseStreamRetentionPeriod()
    ListStreams = actions.KinesisListStreams()
    ListTagsForStream = actions.KinesisListTagsForStream()
    MergeShards = actions.KinesisMergeShards()
    PutRecord = actions.KinesisPutRecord()
    PutRecords = actions.KinesisPutRecords()
    RemoveTagsFromStream = actions.KinesisRemoveTagsFromStream()
    SplitShard = actions.KinesisSplitShard()
    UpdateShardCount = actions.KinesisUpdateShardCount()


class KinesisAnalytics:
    all = IamAction("kinesisanalytics", all=True)
    AddApplicationInput = actions.KinesisanalyticsAddApplicationInput()
    AddApplicationOutput = actions.KinesisanalyticsAddApplicationOutput()
    AddApplicationReferenceDataSource = actions.KinesisanalyticsAddApplicationReferenceDataSource()
    CreateApplication = actions.KinesisanalyticsCreateApplication()
    DeleteApplication = actions.KinesisanalyticsDeleteApplication()
    DeleteApplicationOutput = actions.KinesisanalyticsDeleteApplicationOutput()
    DeleteApplicationReferenceDataSource = actions.KinesisanalyticsDeleteApplicationReferenceDataSource()
    DescribeApplication = actions.KinesisanalyticsDescribeApplication()
    DiscoverInputSchema = actions.KinesisanalyticsDiscoverInputSchema()
    ListApplications = actions.KinesisanalyticsListApplications()
    StartApplication = actions.KinesisanalyticsStartApplication()
    StopApplication = actions.KinesisanalyticsStopApplication()
    UpdateApplication = actions.KinesisanalyticsUpdateApplication()


class KinesisVideo:
    all = IamAction("kinesisvideo", all=True)
    CreateStream = actions.KinesisvideoCreateStream()
    DeleteStream = actions.KinesisvideoDeleteStream()
    DescribeStream = actions.KinesisvideoDescribeStream()
    GetDataEndpoint = actions.KinesisvideoGetDataEndpoint()
    GetMedia = actions.KinesisvideoGetMedia()
    GetMediaForFragmentList = actions.KinesisvideoGetMediaForFragmentList()
    ListFragments = actions.KinesisvideoListFragments()
    ListStreams = actions.KinesisvideoListStreams()
    ListTagsForStream = actions.KinesisvideoListTagsForStream()
    PutMedia = actions.KinesisvideoPutMedia()
    TagStream = actions.KinesisvideoTagStream()
    UntagStream = actions.KinesisvideoUntagStream()
    UpdateDataRetention = actions.KinesisvideoUpdateDataRetention()
    UpdateStream = actions.KinesisvideoUpdateStream()


class Kms:
    all = IamAction("kms", all=True)
    CancelKeyDeletion = actions.KmsCancelKeyDeletion()
    CreateAlias = actions.KmsCreateAlias()
    CreateGrant = actions.KmsCreateGrant()
    CreateKey = actions.KmsCreateKey()
    Decrypt = actions.KmsDecrypt()
    DeleteAlias = actions.KmsDeleteAlias()
    DeleteImportedKeyMaterial = actions.KmsDeleteImportedKeyMaterial()
    DescribeKey = actions.KmsDescribeKey()
    DisableKey = actions.KmsDisableKey()
    DisableKeyRotation = actions.KmsDisableKeyRotation()
    EnableKey = actions.KmsEnableKey()
    EnableKeyRotation = actions.KmsEnableKeyRotation()
    Encrypt = actions.KmsEncrypt()
    GenerateDataKey = actions.KmsGenerateDataKey()
    GenerateDataKeyWithoutPlaintext = actions.KmsGenerateDataKeyWithoutPlaintext()
    GenerateRandom = actions.KmsGenerateRandom()
    GetKeyPolicy = actions.KmsGetKeyPolicy()
    GetKeyRotationStatus = actions.KmsGetKeyRotationStatus()
    GetParametersForImport = actions.KmsGetParametersForImport()
    ImportKeyMaterial = actions.KmsImportKeyMaterial()
    ListAliases = actions.KmsListAliases()
    ListGrants = actions.KmsListGrants()
    ListKeyPolicies = actions.KmsListKeyPolicies()
    ListKeys = actions.KmsListKeys()
    ListResourceTags = actions.KmsListResourceTags()
    ListRetirableGrants = actions.KmsListRetirableGrants()
    PutKeyPolicy = actions.KmsPutKeyPolicy()
    ReEncryptFrom = actions.KmsReEncryptFrom()
    ReEncryptTo = actions.KmsReEncryptTo()
    RetireGrant = actions.KmsRetireGrant()
    RevokeGrant = actions.KmsRevokeGrant()
    ScheduleKeyDeletion = actions.KmsScheduleKeyDeletion()
    TagResource = actions.KmsTagResource()
    UntagResource = actions.KmsUntagResource()
    UpdateAlias = actions.KmsUpdateAlias()
    UpdateKeyDescription = actions.KmsUpdateKeyDescription()


class Lambda:
    all = IamAction("lambda", all=True)
    AddPermission = actions.LambdaAddPermission()
    CreateAlias = actions.LambdaCreateAlias()
    CreateEventSourceMapping = actions.LambdaCreateEventSourceMapping()
    CreateFunction = actions.LambdaCreateFunction()
    DeleteAlias = actions.LambdaDeleteAlias()
    DeleteEventSourceMapping = actions.LambdaDeleteEventSourceMapping()
    DeleteFunction = actions.LambdaDeleteFunction()
    DeleteFunctionConcurrency = actions.LambdaDeleteFunctionConcurrency()
    EnableReplication = actions.LambdaEnableReplication()
    GetAccountSettings = actions.LambdaGetAccountSettings()
    GetAlias = actions.LambdaGetAlias()
    GetEventSourceMapping = actions.LambdaGetEventSourceMapping()
    GetFunction = actions.LambdaGetFunction()
    GetFunctionConfiguration = actions.LambdaGetFunctionConfiguration()
    GetPolicy = actions.LambdaGetPolicy()
    InvokeAsync = actions.LambdaInvokeAsync()
    InvokeFunction = actions.LambdaInvokeFunction()
    ListAliases = actions.LambdaListAliases()
    ListEventSourceMappings = actions.LambdaListEventSourceMappings()
    ListFunctions = actions.LambdaListFunctions()
    ListTags = actions.LambdaListTags()
    ListVersionsByFunction = actions.LambdaListVersionsByFunction()
    PublishVersion = actions.LambdaPublishVersion()
    PutFunctionConcurrency = actions.LambdaPutFunctionConcurrency()
    RemovePermission = actions.LambdaRemovePermission()
    TagResource = actions.LambdaTagResource()
    UntagResource = actions.LambdaUntagResource()
    UpdateAlias = actions.LambdaUpdateAlias()
    UpdateEventSourceMapping = actions.LambdaUpdateEventSourceMapping()
    UpdateFunctionCode = actions.LambdaUpdateFunctionCode()
    UpdateFunctionConfiguration = actions.LambdaUpdateFunctionConfiguration()


class Lex:
    all = IamAction("lex", all=True)
    CreateBotVersion = actions.LexCreateBotVersion()
    CreateIntentVersion = actions.LexCreateIntentVersion()
    CreateSlotTypeVersion = actions.LexCreateSlotTypeVersion()
    DeleteBot = actions.LexDeleteBot()
    DeleteBotAlias = actions.LexDeleteBotAlias()
    DeleteBotChannelAssociation = actions.LexDeleteBotChannelAssociation()
    DeleteBotVersion = actions.LexDeleteBotVersion()
    DeleteIntent = actions.LexDeleteIntent()
    DeleteIntentVersion = actions.LexDeleteIntentVersion()
    DeleteSlotType = actions.LexDeleteSlotType()
    DeleteSlotTypeVersion = actions.LexDeleteSlotTypeVersion()
    DeleteUtterances = actions.LexDeleteUtterances()
    GetBot = actions.LexGetBot()
    GetBotAlias = actions.LexGetBotAlias()
    GetBotAliases = actions.LexGetBotAliases()
    GetBotChannelAssociation = actions.LexGetBotChannelAssociation()
    GetBotChannelAssociations = actions.LexGetBotChannelAssociations()
    GetBotVersions = actions.LexGetBotVersions()
    GetBots = actions.LexGetBots()
    GetBuiltinIntent = actions.LexGetBuiltinIntent()
    GetBuiltinIntents = actions.LexGetBuiltinIntents()
    GetBuiltinSlotTypes = actions.LexGetBuiltinSlotTypes()
    GetIntent = actions.LexGetIntent()
    GetIntentVersions = actions.LexGetIntentVersions()
    GetIntents = actions.LexGetIntents()
    GetSlotType = actions.LexGetSlotType()
    GetSlotTypeVersions = actions.LexGetSlotTypeVersions()
    GetSlotTypes = actions.LexGetSlotTypes()
    GetUtterancesView = actions.LexGetUtterancesView()
    PostContent = actions.LexPostContent()
    PostText = actions.LexPostText()
    PutBot = actions.LexPutBot()
    PutBotAlias = actions.LexPutBotAlias()
    PutIntent = actions.LexPutIntent()
    PutSlotType = actions.LexPutSlotType()


class Lightsail:
    all = IamAction("lightsail", all=True)
    AllocateStaticIp = actions.LightsailAllocateStaticIp()
    AttachStaticIp = actions.LightsailAttachStaticIp()
    CloseInstancePublicPorts = actions.LightsailCloseInstancePublicPorts()
    CreateDomain = actions.LightsailCreateDomain()
    CreateDomainEntry = actions.LightsailCreateDomainEntry()
    CreateInstanceSnapshot = actions.LightsailCreateInstanceSnapshot()
    CreateInstances = actions.LightsailCreateInstances()
    CreateInstancesFromSnapshot = actions.LightsailCreateInstancesFromSnapshot()
    CreateKeyPair = actions.LightsailCreateKeyPair()
    DeleteDomain = actions.LightsailDeleteDomain()
    DeleteDomainEntry = actions.LightsailDeleteDomainEntry()
    DeleteInstance = actions.LightsailDeleteInstance()
    DeleteInstanceSnapshot = actions.LightsailDeleteInstanceSnapshot()
    DeleteKeyPair = actions.LightsailDeleteKeyPair()
    DetachStaticIp = actions.LightsailDetachStaticIp()
    DownloadDefaultKeyPair = actions.LightsailDownloadDefaultKeyPair()
    GetActiveNames = actions.LightsailGetActiveNames()
    GetBlueprints = actions.LightsailGetBlueprints()
    GetBundles = actions.LightsailGetBundles()
    GetDomain = actions.LightsailGetDomain()
    GetDomains = actions.LightsailGetDomains()
    GetInstance = actions.LightsailGetInstance()
    GetInstanceAccessDetails = actions.LightsailGetInstanceAccessDetails()
    GetInstanceMetricData = actions.LightsailGetInstanceMetricData()
    GetInstancePortStates = actions.LightsailGetInstancePortStates()
    GetInstanceSnapshot = actions.LightsailGetInstanceSnapshot()
    GetInstanceSnapshots = actions.LightsailGetInstanceSnapshots()
    GetInstanceState = actions.LightsailGetInstanceState()
    GetInstances = actions.LightsailGetInstances()
    GetKeyPair = actions.LightsailGetKeyPair()
    GetKeyPairs = actions.LightsailGetKeyPairs()
    GetOperation = actions.LightsailGetOperation()
    GetOperations = actions.LightsailGetOperations()
    GetOperationsForResource = actions.LightsailGetOperationsForResource()
    GetRegions = actions.LightsailGetRegions()
    GetStaticIp = actions.LightsailGetStaticIp()
    GetStaticIps = actions.LightsailGetStaticIps()
    ImportKeyPair = actions.LightsailImportKeyPair()
    IsVpcPeered = actions.LightsailIsVpcPeered()
    OpenInstancePublicPorts = actions.LightsailOpenInstancePublicPorts()
    PeerVpc = actions.LightsailPeerVpc()
    RebootInstance = actions.LightsailRebootInstance()
    ReleaseStaticIp = actions.LightsailReleaseStaticIp()
    StartInstance = actions.LightsailStartInstance()
    StopInstance = actions.LightsailStopInstance()
    UnpeerVpc = actions.LightsailUnpeerVpc()
    UpdateDomainEntry = actions.LightsailUpdateDomainEntry()


class Logs:
    all = IamAction("logs", all=True)
    AssociateKmsKey = actions.LogsAssociateKmsKey()
    CancelExportTask = actions.LogsCancelExportTask()
    CreateExportTask = actions.LogsCreateExportTask()
    CreateLogGroup = actions.LogsCreateLogGroup()
    CreateLogStream = actions.LogsCreateLogStream()
    DeleteDestination = actions.LogsDeleteDestination()
    DeleteLogGroup = actions.LogsDeleteLogGroup()
    DeleteLogStream = actions.LogsDeleteLogStream()
    DeleteMetricFilter = actions.LogsDeleteMetricFilter()
    DeleteResourcePolicy = actions.LogsDeleteResourcePolicy()
    DeleteRetentionPolicy = actions.LogsDeleteRetentionPolicy()
    DeleteSubscriptionFilter = actions.LogsDeleteSubscriptionFilter()
    DescribeDestinations = actions.LogsDescribeDestinations()
    DescribeExportTasks = actions.LogsDescribeExportTasks()
    DescribeLogGroups = actions.LogsDescribeLogGroups()
    DescribeLogStreams = actions.LogsDescribeLogStreams()
    DescribeMetricFilters = actions.LogsDescribeMetricFilters()
    DescribeResourcePolicies = actions.LogsDescribeResourcePolicies()
    DescribeSubscriptionFilters = actions.LogsDescribeSubscriptionFilters()
    DisassociateKmsKey = actions.LogsDisassociateKmsKey()
    FilterLogEvents = actions.LogsFilterLogEvents()
    GetLogEvents = actions.LogsGetLogEvents()
    ListTagsLogGroup = actions.LogsListTagsLogGroup()
    PutDestination = actions.LogsPutDestination()
    PutDestinationPolicy = actions.LogsPutDestinationPolicy()
    PutLogEvents = actions.LogsPutLogEvents()
    PutMetricFilter = actions.LogsPutMetricFilter()
    PutResourcePolicy = actions.LogsPutResourcePolicy()
    PutRetentionPolicy = actions.LogsPutRetentionPolicy()
    PutSubscriptionFilter = actions.LogsPutSubscriptionFilter()
    TagLogGroup = actions.LogsTagLogGroup()
    TestMetricFilter = actions.LogsTestMetricFilter()
    UntagLogGroup = actions.LogsUntagLogGroup()


class Machinelearning:
    all = IamAction("machinelearning", all=True)
    AddTags = actions.MachinelearningAddTags()
    CreateBatchPrediction = actions.MachinelearningCreateBatchPrediction()
    CreateDataSourceFromRDS = actions.MachinelearningCreateDataSourceFromRDS()
    CreateDataSourceFromRedshift = actions.MachinelearningCreateDataSourceFromRedshift()
    CreateDataSourceFromS3 = actions.MachinelearningCreateDataSourceFromS3()
    CreateEvaluation = actions.MachinelearningCreateEvaluation()
    CreateMLModel = actions.MachinelearningCreateMLModel()
    CreateRealtimeEndpoint = actions.MachinelearningCreateRealtimeEndpoint()
    DeleteBatchPrediction = actions.MachinelearningDeleteBatchPrediction()
    DeleteDataSource = actions.MachinelearningDeleteDataSource()
    DeleteEvaluation = actions.MachinelearningDeleteEvaluation()
    DeleteMLModel = actions.MachinelearningDeleteMLModel()
    DeleteRealtimeEndpoint = actions.MachinelearningDeleteRealtimeEndpoint()
    DeleteTags = actions.MachinelearningDeleteTags()
    DescribeBatchPredictions = actions.MachinelearningDescribeBatchPredictions()
    DescribeDataSources = actions.MachinelearningDescribeDataSources()
    DescribeEvaluations = actions.MachinelearningDescribeEvaluations()
    DescribeMLModels = actions.MachinelearningDescribeMLModels()
    DescribeTags = actions.MachinelearningDescribeTags()
    GetBatchPrediction = actions.MachinelearningGetBatchPrediction()
    GetDataSource = actions.MachinelearningGetDataSource()
    GetEvaluation = actions.MachinelearningGetEvaluation()
    GetMLModel = actions.MachinelearningGetMLModel()
    Predict = actions.MachinelearningPredict()
    UpdateBatchPrediction = actions.MachinelearningUpdateBatchPrediction()
    UpdateDataSource = actions.MachinelearningUpdateDataSource()
    UpdateEvaluation = actions.MachinelearningUpdateEvaluation()
    UpdateMLModel = actions.MachinelearningUpdateMLModel()


class MechanicalTurk:
    all = IamAction("mechanicalturk", all=True)
    ApproveAssignment = actions.MechanicalturkApproveAssignment()
    ApproveRejectedAssignment = actions.MechanicalturkApproveRejectedAssignment()
    AssignQualification = actions.MechanicalturkAssignQualification()
    BlockWorker = actions.MechanicalturkBlockWorker()
    ChangeHITTypeOfHIT = actions.MechanicalturkChangeHITTypeOfHIT()
    CreateHIT = actions.MechanicalturkCreateHIT()
    CreateQualificationType = actions.MechanicalturkCreateQualificationType()
    DisableHIT = actions.MechanicalturkDisableHIT()
    DisposeHIT = actions.MechanicalturkDisposeHIT()
    DisposeQualificationType = actions.MechanicalturkDisposeQualificationType()
    ExtendHIT = actions.MechanicalturkExtendHIT()
    ForceExpireHIT = actions.MechanicalturkForceExpireHIT()
    GetAccountBalance = actions.MechanicalturkGetAccountBalance()
    GetAssignment = actions.MechanicalturkGetAssignment()
    GetAssignmentsForHIT = actions.MechanicalturkGetAssignmentsForHIT()
    GetBlockedWorkers = actions.MechanicalturkGetBlockedWorkers()
    GetBonusPayments = actions.MechanicalturkGetBonusPayments()
    GetFileUploadURL = actions.MechanicalturkGetFileUploadURL()
    GetHIT = actions.MechanicalturkGetHIT()
    GetHITsForQualificationType = actions.MechanicalturkGetHITsForQualificationType()
    GetQualificationRequests = actions.MechanicalturkGetQualificationRequests()
    GetQualificationScore = actions.MechanicalturkGetQualificationScore()
    GetQualificationType = actions.MechanicalturkGetQualificationType()
    GetQualificationsForQualificationType = actions.MechanicalturkGetQualificationsForQualificationType()
    GetRequesterStatistic = actions.MechanicalturkGetRequesterStatistic()
    GetRequesterWorkerStatistic = actions.MechanicalturkGetRequesterWorkerStatistic()
    GetReviewResultsForHIT = actions.MechanicalturkGetReviewResultsForHIT()
    GetReviewableHITs = actions.MechanicalturkGetReviewableHITs()
    GrantBonus = actions.MechanicalturkGrantBonus()
    GrantQualification = actions.MechanicalturkGrantQualification()
    NotifyWorkers = actions.MechanicalturkNotifyWorkers()
    RegisterHITType = actions.MechanicalturkRegisterHITType()
    RejectAssignment = actions.MechanicalturkRejectAssignment()
    RejectQualificationRequest = actions.MechanicalturkRejectQualificationRequest()
    RevokeQualification = actions.MechanicalturkRevokeQualification()
    SearchHITs = actions.MechanicalturkSearchHITs()
    SearchQualificationTypes = actions.MechanicalturkSearchQualificationTypes()
    SendTestEventNotification = actions.MechanicalturkSendTestEventNotification()
    SetHITAsReviewing = actions.MechanicalturkSetHITAsReviewing()
    SetHITTypeNotification = actions.MechanicalturkSetHITTypeNotification()
    UnblockWorker = actions.MechanicalturkUnblockWorker()
    UpdateQualificationScore = actions.MechanicalturkUpdateQualificationScore()
    UpdateQualificationType = actions.MechanicalturkUpdateQualificationType()


class MediaConvert:
    all = IamAction("mediaconvert", all=True)
    CancelJob = actions.MediaconvertCancelJob()
    CreateJob = actions.MediaconvertCreateJob()
    CreateJobTemplate = actions.MediaconvertCreateJobTemplate()
    CreatePreset = actions.MediaconvertCreatePreset()
    CreateQueue = actions.MediaconvertCreateQueue()
    DeleteJobTemplate = actions.MediaconvertDeleteJobTemplate()
    DeletePreset = actions.MediaconvertDeletePreset()
    DeleteQueue = actions.MediaconvertDeleteQueue()
    DescribeEndpoint = actions.MediaconvertDescribeEndpoint()
    GetJob = actions.MediaconvertGetJob()
    GetJobTemplate = actions.MediaconvertGetJobTemplate()
    GetPreset = actions.MediaconvertGetPreset()
    GetQueue = actions.MediaconvertGetQueue()
    ListJobTemplates = actions.MediaconvertListJobTemplates()
    ListJobs = actions.MediaconvertListJobs()
    ListPresets = actions.MediaconvertListPresets()
    ListQueues = actions.MediaconvertListQueues()
    UpdateJobTemplate = actions.MediaconvertUpdateJobTemplate()
    UpdatePreset = actions.MediaconvertUpdatePreset()
    UpdateQueue = actions.MediaconvertUpdateQueue()


class MediaLive:
    all = IamAction("medialive", all=True)
    CreateChannel = actions.MedialiveCreateChannel()
    CreateInput = actions.MedialiveCreateInput()
    CreateInputSecurityGroup = actions.MedialiveCreateInputSecurityGroup()
    DeleteChannel = actions.MedialiveDeleteChannel()
    DeleteInput = actions.MedialiveDeleteInput()
    DeleteInputSecurityGroup = actions.MedialiveDeleteInputSecurityGroup()
    DescribeChannel = actions.MedialiveDescribeChannel()
    DescribeInput = actions.MedialiveDescribeInput()
    DescribeInputSecurityGroup = actions.MedialiveDescribeInputSecurityGroup()
    ListChannels = actions.MedialiveListChannels()
    ListInputSecurityGroups = actions.MedialiveListInputSecurityGroups()
    ListInputs = actions.MedialiveListInputs()
    StartChannel = actions.MedialiveStartChannel()
    StopChannel = actions.MedialiveStopChannel()


class MediaPackage:
    all = IamAction("mediapackage", all=True)
    CreateChannel = actions.MediapackageCreateChannel()
    CreateOriginEndpoint = actions.MediapackageCreateOriginEndpoint()
    DeleteChannel = actions.MediapackageDeleteChannel()
    DeleteOriginEndpoint = actions.MediapackageDeleteOriginEndpoint()
    DescribeChannel = actions.MediapackageDescribeChannel()
    DescribeOriginEndpoint = actions.MediapackageDescribeOriginEndpoint()
    ListChannels = actions.MediapackageListChannels()
    ListOriginEndpoints = actions.MediapackageListOriginEndpoints()
    UpdateChannel = actions.MediapackageUpdateChannel()
    UpdateOriginEndpoint = actions.MediapackageUpdateOriginEndpoint()


class MediaStore:
    all = IamAction("mediastore", all=True)
    CreateContainer = actions.MediastoreCreateContainer()
    DeleteContainer = actions.MediastoreDeleteContainer()
    DeleteContainerPolicy = actions.MediastoreDeleteContainerPolicy()
    DeleteObject = actions.MediastoreDeleteObject()
    DescribeContainer = actions.MediastoreDescribeContainer()
    DescribeObject = actions.MediastoreDescribeObject()
    GetContainerPolicy = actions.MediastoreGetContainerPolicy()
    GetObject = actions.MediastoreGetObject()
    ListContainers = actions.MediastoreListContainers()
    ListItems = actions.MediastoreListItems()
    PutContainerPolicy = actions.MediastorePutContainerPolicy()
    PutObject = actions.MediastorePutObject()


class Mgh:
    all = IamAction("mgh", all=True)
    AssociateCreatedArtifact = actions.MghAssociateCreatedArtifact()
    AssociateDiscoveredResource = actions.MghAssociateDiscoveredResource()
    CreateProgressUpdateStream = actions.MghCreateProgressUpdateStream()
    DeleteProgressUpdateStream = actions.MghDeleteProgressUpdateStream()
    DescribeApplicationState = actions.MghDescribeApplicationState()
    DescribeMigrationTask = actions.MghDescribeMigrationTask()
    DisassociateCreatedArtifact = actions.MghDisassociateCreatedArtifact()
    DisassociateDiscoveredResource = actions.MghDisassociateDiscoveredResource()
    ImportMigrationTask = actions.MghImportMigrationTask()
    ListCreatedArtifacts = actions.MghListCreatedArtifacts()
    ListDiscoveredResources = actions.MghListDiscoveredResources()
    ListMigrationTasks = actions.MghListMigrationTasks()
    ListProgressUpdateStreams = actions.MghListProgressUpdateStreams()
    NotifyApplicationState = actions.MghNotifyApplicationState()
    NotifyMigrationTaskState = actions.MghNotifyMigrationTaskState()
    PutResourceAttributes = actions.MghPutResourceAttributes()


class MobileAnalytics:
    all = IamAction("mobileanalytics", all=True)
    GetFinancialReports = actions.MobileanalyticsGetFinancialReports()
    GetReports = actions.MobileanalyticsGetReports()
    PutEvents = actions.MobileanalyticsPutEvents()


class MobileHub:
    all = IamAction("mobilehub", all=True)
    CreateProject = actions.MobilehubCreateProject()
    CreateServiceRole = actions.MobilehubCreateServiceRole()
    DeleteProject = actions.MobilehubDeleteProject()
    DeployToStage = actions.MobilehubDeployToStage()
    DescribeBundle = actions.MobilehubDescribeBundle()
    ExportBundle = actions.MobilehubExportBundle()
    ExportProject = actions.MobilehubExportProject()
    GenerateProjectParameters = actions.MobilehubGenerateProjectParameters()
    GetProject = actions.MobilehubGetProject()
    GetProjectSnapshot = actions.MobilehubGetProjectSnapshot()
    ImportProject = actions.MobilehubImportProject()
    ListAvailableConnectors = actions.MobilehubListAvailableConnectors()
    ListAvailableFeatures = actions.MobilehubListAvailableFeatures()
    ListAvailableRegions = actions.MobilehubListAvailableRegions()
    ListBundles = actions.MobilehubListBundles()
    ListProjects = actions.MobilehubListProjects()
    SynchronizeProject = actions.MobilehubSynchronizeProject()
    UpdateProject = actions.MobilehubUpdateProject()
    VerifyServiceRole = actions.MobilehubVerifyServiceRole()


class MobileTargeting:
    all = IamAction("mobiletargeting", all=True)
    CreateCampaign = actions.MobiletargetingCreateCampaign()
    CreateImportJob = actions.MobiletargetingCreateImportJob()
    CreateSegment = actions.MobiletargetingCreateSegment()
    DeleteApnsChannel = actions.MobiletargetingDeleteApnsChannel()
    DeleteCampaign = actions.MobiletargetingDeleteCampaign()
    DeleteGcmChannel = actions.MobiletargetingDeleteGcmChannel()
    DeleteSegment = actions.MobiletargetingDeleteSegment()
    GetApnsChannel = actions.MobiletargetingGetApnsChannel()
    GetApplicationSettings = actions.MobiletargetingGetApplicationSettings()
    GetCampaign = actions.MobiletargetingGetCampaign()
    GetCampaignActivities = actions.MobiletargetingGetCampaignActivities()
    GetCampaignVersion = actions.MobiletargetingGetCampaignVersion()
    GetCampaignVersions = actions.MobiletargetingGetCampaignVersions()
    GetCampaigns = actions.MobiletargetingGetCampaigns()
    GetEndpoint = actions.MobiletargetingGetEndpoint()
    GetGcmChannel = actions.MobiletargetingGetGcmChannel()
    GetImportJob = actions.MobiletargetingGetImportJob()
    GetImportJobs = actions.MobiletargetingGetImportJobs()
    GetReports = actions.MobiletargetingGetReports()
    GetSegment = actions.MobiletargetingGetSegment()
    GetSegmentImportJobs = actions.MobiletargetingGetSegmentImportJobs()
    GetSegmentVersion = actions.MobiletargetingGetSegmentVersion()
    GetSegmentVersions = actions.MobiletargetingGetSegmentVersions()
    GetSegments = actions.MobiletargetingGetSegments()
    UpdateApnsChannel = actions.MobiletargetingUpdateApnsChannel()
    UpdateApplicationSettings = actions.MobiletargetingUpdateApplicationSettings()
    UpdateCampaign = actions.MobiletargetingUpdateCampaign()
    UpdateEndpoint = actions.MobiletargetingUpdateEndpoint()
    UpdateEndpointsBatch = actions.MobiletargetingUpdateEndpointsBatch()
    UpdateGcmChannel = actions.MobiletargetingUpdateGcmChannel()
    UpdateSegment = actions.MobiletargetingUpdateSegment()


class Mq:
    all = IamAction("mq", all=True)
    CreateBroker = actions.MqCreateBroker()
    CreateConfiguration = actions.MqCreateConfiguration()
    CreateUser = actions.MqCreateUser()
    DeleteBroker = actions.MqDeleteBroker()
    DeleteUser = actions.MqDeleteUser()
    DescribeBroker = actions.MqDescribeBroker()
    DescribeConfiguration = actions.MqDescribeConfiguration()
    DescribeConfigurationRevision = actions.MqDescribeConfigurationRevision()
    DescribeUser = actions.MqDescribeUser()
    ListBrokers = actions.MqListBrokers()
    ListConfigurationRevisions = actions.MqListConfigurationRevisions()
    ListConfigurations = actions.MqListConfigurations()
    ListUsers = actions.MqListUsers()
    RebootBroker = actions.MqRebootBroker()
    UpdateBroker = actions.MqUpdateBroker()
    UpdateConfiguration = actions.MqUpdateConfiguration()
    UpdateUser = actions.MqUpdateUser()


class OpsworksCm:
    all = IamAction("opsworks-cm", all=True)
    AssociateNode = actions.OpsworksCmAssociateNode()
    CreateBackup = actions.OpsworksCmCreateBackup()
    CreateServer = actions.OpsworksCmCreateServer()
    DeleteBackup = actions.OpsworksCmDeleteBackup()
    DeleteServer = actions.OpsworksCmDeleteServer()
    DescribeAccountAttributes = actions.OpsworksCmDescribeAccountAttributes()
    DescribeBackups = actions.OpsworksCmDescribeBackups()
    DescribeEvents = actions.OpsworksCmDescribeEvents()
    DescribeNodeAssociationStatus = actions.OpsworksCmDescribeNodeAssociationStatus()
    DescribeServers = actions.OpsworksCmDescribeServers()
    DisassociateNode = actions.OpsworksCmDisassociateNode()
    RestoreServer = actions.OpsworksCmRestoreServer()
    StartMaintenance = actions.OpsworksCmStartMaintenance()
    UpdateServer = actions.OpsworksCmUpdateServer()
    UpdateServerEngineAttributes = actions.OpsworksCmUpdateServerEngineAttributes()


class Opsworks:
    all = IamAction("opsworks", all=True)
    AssignInstance = actions.OpsworksAssignInstance()
    AssignVolume = actions.OpsworksAssignVolume()
    AssociateElasticIp = actions.OpsworksAssociateElasticIp()
    AttachElasticLoadBalancer = actions.OpsworksAttachElasticLoadBalancer()
    CloneStack = actions.OpsworksCloneStack()
    CreateApp = actions.OpsworksCreateApp()
    CreateDeployment = actions.OpsworksCreateDeployment()
    CreateInstance = actions.OpsworksCreateInstance()
    CreateLayer = actions.OpsworksCreateLayer()
    CreateStack = actions.OpsworksCreateStack()
    CreateUserProfile = actions.OpsworksCreateUserProfile()
    DeleteApp = actions.OpsworksDeleteApp()
    DeleteInstance = actions.OpsworksDeleteInstance()
    DeleteLayer = actions.OpsworksDeleteLayer()
    DeleteStack = actions.OpsworksDeleteStack()
    DeleteUserProfile = actions.OpsworksDeleteUserProfile()
    DeregisterEcsCluster = actions.OpsworksDeregisterEcsCluster()
    DeregisterElasticIp = actions.OpsworksDeregisterElasticIp()
    DeregisterInstance = actions.OpsworksDeregisterInstance()
    DeregisterRdsDbInstance = actions.OpsworksDeregisterRdsDbInstance()
    DeregisterVolume = actions.OpsworksDeregisterVolume()
    DescribeAgentVersions = actions.OpsworksDescribeAgentVersions()
    DescribeApps = actions.OpsworksDescribeApps()
    DescribeCommands = actions.OpsworksDescribeCommands()
    DescribeDeployments = actions.OpsworksDescribeDeployments()
    DescribeEcsClusters = actions.OpsworksDescribeEcsClusters()
    DescribeElasticIps = actions.OpsworksDescribeElasticIps()
    DescribeElasticLoadBalancers = actions.OpsworksDescribeElasticLoadBalancers()
    DescribeInstances = actions.OpsworksDescribeInstances()
    DescribeLayers = actions.OpsworksDescribeLayers()
    DescribeLoadBasedAutoScaling = actions.OpsworksDescribeLoadBasedAutoScaling()
    DescribeMyUserProfile = actions.OpsworksDescribeMyUserProfile()
    DescribePermissions = actions.OpsworksDescribePermissions()
    DescribeRaidArrays = actions.OpsworksDescribeRaidArrays()
    DescribeRdsDbInstances = actions.OpsworksDescribeRdsDbInstances()
    DescribeServiceErrors = actions.OpsworksDescribeServiceErrors()
    DescribeStackProvisioningParameters = actions.OpsworksDescribeStackProvisioningParameters()
    DescribeStackSummary = actions.OpsworksDescribeStackSummary()
    DescribeStacks = actions.OpsworksDescribeStacks()
    DescribeTimeBasedAutoScaling = actions.OpsworksDescribeTimeBasedAutoScaling()
    DescribeUserProfiles = actions.OpsworksDescribeUserProfiles()
    DescribeVolumes = actions.OpsworksDescribeVolumes()
    DetachElasticLoadBalancer = actions.OpsworksDetachElasticLoadBalancer()
    DisassociateElasticIp = actions.OpsworksDisassociateElasticIp()
    GetHostnameSuggestion = actions.OpsworksGetHostnameSuggestion()
    GrantAccess = actions.OpsworksGrantAccess()
    ListTags = actions.OpsworksListTags()
    RebootInstance = actions.OpsworksRebootInstance()
    RegisterEcsCluster = actions.OpsworksRegisterEcsCluster()
    RegisterElasticIp = actions.OpsworksRegisterElasticIp()
    RegisterInstance = actions.OpsworksRegisterInstance()
    RegisterRdsDbInstance = actions.OpsworksRegisterRdsDbInstance()
    RegisterVolume = actions.OpsworksRegisterVolume()
    SetLoadBasedAutoScaling = actions.OpsworksSetLoadBasedAutoScaling()
    SetPermission = actions.OpsworksSetPermission()
    SetTimeBasedAutoScaling = actions.OpsworksSetTimeBasedAutoScaling()
    StartInstance = actions.OpsworksStartInstance()
    StartStack = actions.OpsworksStartStack()
    StopInstance = actions.OpsworksStopInstance()
    StopStack = actions.OpsworksStopStack()
    TagResource = actions.OpsworksTagResource()
    UnassignInstance = actions.OpsworksUnassignInstance()
    UnassignVolume = actions.OpsworksUnassignVolume()
    UntagResource = actions.OpsworksUntagResource()
    UpdateApp = actions.OpsworksUpdateApp()
    UpdateElasticIp = actions.OpsworksUpdateElasticIp()
    UpdateInstance = actions.OpsworksUpdateInstance()
    UpdateLayer = actions.OpsworksUpdateLayer()
    UpdateMyUserProfile = actions.OpsworksUpdateMyUserProfile()
    UpdateRdsDbInstance = actions.OpsworksUpdateRdsDbInstance()
    UpdateStack = actions.OpsworksUpdateStack()
    UpdateUserProfile = actions.OpsworksUpdateUserProfile()
    UpdateVolume = actions.OpsworksUpdateVolume()


class Organizations:
    all = IamAction("organizations", all=True)
    AcceptHandshake = actions.OrganizationsAcceptHandshake()
    AttachPolicy = actions.OrganizationsAttachPolicy()
    CancelHandshake = actions.OrganizationsCancelHandshake()
    CreateAccount = actions.OrganizationsCreateAccount()
    CreateOrganization = actions.OrganizationsCreateOrganization()
    CreateOrganizationalUnit = actions.OrganizationsCreateOrganizationalUnit()
    CreatePolicy = actions.OrganizationsCreatePolicy()
    DeclineHandshake = actions.OrganizationsDeclineHandshake()
    DeleteOrganization = actions.OrganizationsDeleteOrganization()
    DeleteOrganizationalUnit = actions.OrganizationsDeleteOrganizationalUnit()
    DeletePolicy = actions.OrganizationsDeletePolicy()
    DescribeAccount = actions.OrganizationsDescribeAccount()
    DescribeCreateAccountStatus = actions.OrganizationsDescribeCreateAccountStatus()
    DescribeHandshake = actions.OrganizationsDescribeHandshake()
    DescribeOrganization = actions.OrganizationsDescribeOrganization()
    DescribeOrganizationalUnit = actions.OrganizationsDescribeOrganizationalUnit()
    DescribePolicy = actions.OrganizationsDescribePolicy()
    DetachPolicy = actions.OrganizationsDetachPolicy()
    DisablePolicyType = actions.OrganizationsDisablePolicyType()
    EnableAllFeatures = actions.OrganizationsEnableAllFeatures()
    EnablePolicyType = actions.OrganizationsEnablePolicyType()
    InviteAccountToOrganization = actions.OrganizationsInviteAccountToOrganization()
    LeaveOrganization = actions.OrganizationsLeaveOrganization()
    ListAccounts = actions.OrganizationsListAccounts()
    ListAccountsForParent = actions.OrganizationsListAccountsForParent()
    ListChildren = actions.OrganizationsListChildren()
    ListCreateAccountStatus = actions.OrganizationsListCreateAccountStatus()
    ListHandshakesForAccount = actions.OrganizationsListHandshakesForAccount()
    ListHandshakesForOrganization = actions.OrganizationsListHandshakesForOrganization()
    ListOrganizationalUnitsForParent = actions.OrganizationsListOrganizationalUnitsForParent()
    ListParents = actions.OrganizationsListParents()
    ListPolicies = actions.OrganizationsListPolicies()
    ListPoliciesForTarget = actions.OrganizationsListPoliciesForTarget()
    ListRoots = actions.OrganizationsListRoots()
    ListTargetsForPolicy = actions.OrganizationsListTargetsForPolicy()
    MoveAccount = actions.OrganizationsMoveAccount()
    RemoveAccountFromOrganization = actions.OrganizationsRemoveAccountFromOrganization()
    UpdateOrganizationalUnit = actions.OrganizationsUpdateOrganizationalUnit()
    UpdatePolicy = actions.OrganizationsUpdatePolicy()


class Polly:
    all = IamAction("polly", all=True)
    DeleteLexicon = actions.PollyDeleteLexicon()
    DescribeVoices = actions.PollyDescribeVoices()
    GetLexicon = actions.PollyGetLexicon()
    ListLexicons = actions.PollyListLexicons()
    PutLexicon = actions.PollyPutLexicon()
    SynthesizeSpeech = actions.PollySynthesizeSpeech()


class Pricing:
    all = IamAction("pricing", all=True)
    DescribeServices = actions.PricingDescribeServices()
    GetAttributeValues = actions.PricingGetAttributeValues()
    GetProducts = actions.PricingGetProducts()


class Rds:
    all = IamAction("rds", all=True)
    AddRoleToDBCluster = actions.RdsAddRoleToDBCluster()
    AddSourceIdentifierToSubscription = actions.RdsAddSourceIdentifierToSubscription()
    AddTagsToResource = actions.RdsAddTagsToResource()
    ApplyPendingMaintenanceAction = actions.RdsApplyPendingMaintenanceAction()
    AuthorizeDBSecurityGroupIngress = actions.RdsAuthorizeDBSecurityGroupIngress()
    CopyDBClusterSnapshot = actions.RdsCopyDBClusterSnapshot()
    CopyDBParameterGroup = actions.RdsCopyDBParameterGroup()
    CopyDBSnapshot = actions.RdsCopyDBSnapshot()
    CopyOptionGroup = actions.RdsCopyOptionGroup()
    CreateDBCluster = actions.RdsCreateDBCluster()
    CreateDBClusterParameterGroup = actions.RdsCreateDBClusterParameterGroup()
    CreateDBClusterSnapshot = actions.RdsCreateDBClusterSnapshot()
    CreateDBInstance = actions.RdsCreateDBInstance()
    CreateDBInstanceReadReplica = actions.RdsCreateDBInstanceReadReplica()
    CreateDBParameterGroup = actions.RdsCreateDBParameterGroup()
    CreateDBSecurityGroup = actions.RdsCreateDBSecurityGroup()
    CreateDBSnapshot = actions.RdsCreateDBSnapshot()
    CreateDBSubnetGroup = actions.RdsCreateDBSubnetGroup()
    CreateEventSubscription = actions.RdsCreateEventSubscription()
    CreateOptionGroup = actions.RdsCreateOptionGroup()
    DeleteDBCluster = actions.RdsDeleteDBCluster()
    DeleteDBClusterParameterGroup = actions.RdsDeleteDBClusterParameterGroup()
    DeleteDBClusterSnapshot = actions.RdsDeleteDBClusterSnapshot()
    DeleteDBInstance = actions.RdsDeleteDBInstance()
    DeleteDBParameterGroup = actions.RdsDeleteDBParameterGroup()
    DeleteDBSecurityGroup = actions.RdsDeleteDBSecurityGroup()
    DeleteDBSnapshot = actions.RdsDeleteDBSnapshot()
    DeleteDBSubnetGroup = actions.RdsDeleteDBSubnetGroup()
    DeleteEventSubscription = actions.RdsDeleteEventSubscription()
    DeleteOptionGroup = actions.RdsDeleteOptionGroup()
    DescribeAccountAttributes = actions.RdsDescribeAccountAttributes()
    DescribeCertificates = actions.RdsDescribeCertificates()
    DescribeDBClusterParameterGroups = actions.RdsDescribeDBClusterParameterGroups()
    DescribeDBClusterParameters = actions.RdsDescribeDBClusterParameters()
    DescribeDBClusterSnapshotAttributes = actions.RdsDescribeDBClusterSnapshotAttributes()
    DescribeDBClusterSnapshots = actions.RdsDescribeDBClusterSnapshots()
    DescribeDBClusters = actions.RdsDescribeDBClusters()
    DescribeDBEngineVersions = actions.RdsDescribeDBEngineVersions()
    DescribeDBInstances = actions.RdsDescribeDBInstances()
    DescribeDBLogFiles = actions.RdsDescribeDBLogFiles()
    DescribeDBParameterGroups = actions.RdsDescribeDBParameterGroups()
    DescribeDBParameters = actions.RdsDescribeDBParameters()
    DescribeDBSecurityGroups = actions.RdsDescribeDBSecurityGroups()
    DescribeDBSnapshotAttributes = actions.RdsDescribeDBSnapshotAttributes()
    DescribeDBSnapshots = actions.RdsDescribeDBSnapshots()
    DescribeDBSubnetGroups = actions.RdsDescribeDBSubnetGroups()
    DescribeEngineDefaultClusterParameters = actions.RdsDescribeEngineDefaultClusterParameters()
    DescribeEngineDefaultParameters = actions.RdsDescribeEngineDefaultParameters()
    DescribeEventCategories = actions.RdsDescribeEventCategories()
    DescribeEventSubscriptions = actions.RdsDescribeEventSubscriptions()
    DescribeEvents = actions.RdsDescribeEvents()
    DescribeOptionGroupOptions = actions.RdsDescribeOptionGroupOptions()
    DescribeOptionGroups = actions.RdsDescribeOptionGroups()
    DescribeOrderableDBInstanceOptions = actions.RdsDescribeOrderableDBInstanceOptions()
    DescribePendingMaintenanceActions = actions.RdsDescribePendingMaintenanceActions()
    DescribeReservedDBInstances = actions.RdsDescribeReservedDBInstances()
    DescribeReservedDBInstancesOfferings = actions.RdsDescribeReservedDBInstancesOfferings()
    DownloadCompleteDBLogFile = actions.RdsDownloadCompleteDBLogFile()
    DownloadDBLogFilePortion = actions.RdsDownloadDBLogFilePortion()
    FailoverDBCluster = actions.RdsFailoverDBCluster()
    ListTagsForResource = actions.RdsListTagsForResource()
    ModifyDBCluster = actions.RdsModifyDBCluster()
    ModifyDBClusterParameterGroup = actions.RdsModifyDBClusterParameterGroup()
    ModifyDBClusterSnapshotAttribute = actions.RdsModifyDBClusterSnapshotAttribute()
    ModifyDBInstance = actions.RdsModifyDBInstance()
    ModifyDBParameterGroup = actions.RdsModifyDBParameterGroup()
    ModifyDBSnapshotAttribute = actions.RdsModifyDBSnapshotAttribute()
    ModifyDBSubnetGroup = actions.RdsModifyDBSubnetGroup()
    ModifyEventSubscription = actions.RdsModifyEventSubscription()
    ModifyOptionGroup = actions.RdsModifyOptionGroup()
    PromoteReadReplica = actions.RdsPromoteReadReplica()
    PurchaseReservedDBInstancesOffering = actions.RdsPurchaseReservedDBInstancesOffering()
    RebootDBInstance = actions.RdsRebootDBInstance()
    RemoveSourceIdentifierFromSubscription = actions.RdsRemoveSourceIdentifierFromSubscription()
    RemoveTagsFromResource = actions.RdsRemoveTagsFromResource()
    ResetDBClusterParameterGroup = actions.RdsResetDBClusterParameterGroup()
    ResetDBParameterGroup = actions.RdsResetDBParameterGroup()
    RestoreDBClusterFromSnapshot = actions.RdsRestoreDBClusterFromSnapshot()
    RestoreDBClusterToPointInTime = actions.RdsRestoreDBClusterToPointInTime()
    RestoreDBInstanceFromDBSnapshot = actions.RdsRestoreDBInstanceFromDBSnapshot()
    RestoreDBInstanceToPointInTime = actions.RdsRestoreDBInstanceToPointInTime()
    RevokeDBSecurityGroupIngress = actions.RdsRevokeDBSecurityGroupIngress()
    StartDBInstance = actions.RdsStartDBInstance()
    StopDBInstance = actions.RdsStopDBInstance()


class Redshift:
    all = IamAction("redshift", all=True)
    AuthorizeClusterSecurityGroupIngress = actions.RedshiftAuthorizeClusterSecurityGroupIngress()
    AuthorizeSnapshotAccess = actions.RedshiftAuthorizeSnapshotAccess()
    CancelQuerySession = actions.RedshiftCancelQuerySession()
    CopyClusterSnapshot = actions.RedshiftCopyClusterSnapshot()
    CreateCluster = actions.RedshiftCreateCluster()
    CreateClusterParameterGroup = actions.RedshiftCreateClusterParameterGroup()
    CreateClusterSecurityGroup = actions.RedshiftCreateClusterSecurityGroup()
    CreateClusterSnapshot = actions.RedshiftCreateClusterSnapshot()
    CreateClusterSubnetGroup = actions.RedshiftCreateClusterSubnetGroup()
    CreateClusterUser = actions.RedshiftCreateClusterUser()
    CreateEventSubscription = actions.RedshiftCreateEventSubscription()
    CreateHsmClientCertificate = actions.RedshiftCreateHsmClientCertificate()
    CreateHsmConfiguration = actions.RedshiftCreateHsmConfiguration()
    CreateSnapshotCopyGrant = actions.RedshiftCreateSnapshotCopyGrant()
    CreateTags = actions.RedshiftCreateTags()
    DeleteCluster = actions.RedshiftDeleteCluster()
    DeleteClusterParameterGroup = actions.RedshiftDeleteClusterParameterGroup()
    DeleteClusterSecurityGroup = actions.RedshiftDeleteClusterSecurityGroup()
    DeleteClusterSnapshot = actions.RedshiftDeleteClusterSnapshot()
    DeleteClusterSubnetGroup = actions.RedshiftDeleteClusterSubnetGroup()
    DeleteEventSubscription = actions.RedshiftDeleteEventSubscription()
    DeleteHsmClientCertificate = actions.RedshiftDeleteHsmClientCertificate()
    DeleteHsmConfiguration = actions.RedshiftDeleteHsmConfiguration()
    DeleteSnapshotCopyGrant = actions.RedshiftDeleteSnapshotCopyGrant()
    DeleteTags = actions.RedshiftDeleteTags()
    DescribeClusterParameterGroups = actions.RedshiftDescribeClusterParameterGroups()
    DescribeClusterParameters = actions.RedshiftDescribeClusterParameters()
    DescribeClusterSecurityGroups = actions.RedshiftDescribeClusterSecurityGroups()
    DescribeClusterSnapshots = actions.RedshiftDescribeClusterSnapshots()
    DescribeClusterSubnetGroups = actions.RedshiftDescribeClusterSubnetGroups()
    DescribeClusterVersions = actions.RedshiftDescribeClusterVersions()
    DescribeClusters = actions.RedshiftDescribeClusters()
    DescribeDefaultClusterParameters = actions.RedshiftDescribeDefaultClusterParameters()
    DescribeEventCategories = actions.RedshiftDescribeEventCategories()
    DescribeEventSubscriptions = actions.RedshiftDescribeEventSubscriptions()
    DescribeEvents = actions.RedshiftDescribeEvents()
    DescribeHsmClientCertificates = actions.RedshiftDescribeHsmClientCertificates()
    DescribeHsmConfigurations = actions.RedshiftDescribeHsmConfigurations()
    DescribeLoggingStatus = actions.RedshiftDescribeLoggingStatus()
    DescribeOrderableClusterOptions = actions.RedshiftDescribeOrderableClusterOptions()
    DescribeReservedNodeOfferings = actions.RedshiftDescribeReservedNodeOfferings()
    DescribeReservedNodes = actions.RedshiftDescribeReservedNodes()
    DescribeResize = actions.RedshiftDescribeResize()
    DescribeSnapshotCopyGrants = actions.RedshiftDescribeSnapshotCopyGrants()
    DescribeTableRestoreStatus = actions.RedshiftDescribeTableRestoreStatus()
    DescribeTags = actions.RedshiftDescribeTags()
    DisableLogging = actions.RedshiftDisableLogging()
    DisableSnapshotCopy = actions.RedshiftDisableSnapshotCopy()
    EnableLogging = actions.RedshiftEnableLogging()
    EnableSnapshotCopy = actions.RedshiftEnableSnapshotCopy()
    GetClusterCredentials = actions.RedshiftGetClusterCredentials()
    JoinGroup = actions.RedshiftJoinGroup()
    ModifyCluster = actions.RedshiftModifyCluster()
    ModifyClusterIamRoles = actions.RedshiftModifyClusterIamRoles()
    ModifyClusterParameterGroup = actions.RedshiftModifyClusterParameterGroup()
    ModifyClusterSubnetGroup = actions.RedshiftModifyClusterSubnetGroup()
    ModifyEventSubscription = actions.RedshiftModifyEventSubscription()
    ModifySnapshotCopyRetentionPeriod = actions.RedshiftModifySnapshotCopyRetentionPeriod()
    PurchaseReservedNodeOffering = actions.RedshiftPurchaseReservedNodeOffering()
    RebootCluster = actions.RedshiftRebootCluster()
    ResetClusterParameterGroup = actions.RedshiftResetClusterParameterGroup()
    RestoreFromClusterSnapshot = actions.RedshiftRestoreFromClusterSnapshot()
    RestoreTableFromClusterSnapshot = actions.RedshiftRestoreTableFromClusterSnapshot()
    RevokeClusterSecurityGroupIngress = actions.RedshiftRevokeClusterSecurityGroupIngress()
    RevokeSnapshotAccess = actions.RedshiftRevokeSnapshotAccess()
    RotateEncryptionKey = actions.RedshiftRotateEncryptionKey()
    ViewQueriesInConsole = actions.RedshiftViewQueriesInConsole()


class Rekognition:
    all = IamAction("rekognition", all=True)
    CompareFaces = actions.RekognitionCompareFaces()
    CreateCollection = actions.RekognitionCreateCollection()
    CreateStreamProcessor = actions.RekognitionCreateStreamProcessor()
    DeleteCollection = actions.RekognitionDeleteCollection()
    DeleteFaces = actions.RekognitionDeleteFaces()
    DeleteStreamProcessor = actions.RekognitionDeleteStreamProcessor()
    DescribeStreamProcessor = actions.RekognitionDescribeStreamProcessor()
    DetectFaces = actions.RekognitionDetectFaces()
    DetectLabels = actions.RekognitionDetectLabels()
    DetectModerationLabels = actions.RekognitionDetectModerationLabels()
    DetectText = actions.RekognitionDetectText()
    GetCelebrityInfo = actions.RekognitionGetCelebrityInfo()
    GetCelebrityRecognition = actions.RekognitionGetCelebrityRecognition()
    GetContentModeration = actions.RekognitionGetContentModeration()
    GetFaceDetection = actions.RekognitionGetFaceDetection()
    GetFaceSearch = actions.RekognitionGetFaceSearch()
    GetLabelDetection = actions.RekognitionGetLabelDetection()
    GetPersonTracking = actions.RekognitionGetPersonTracking()
    IndexFaces = actions.RekognitionIndexFaces()
    ListCollections = actions.RekognitionListCollections()
    ListFaces = actions.RekognitionListFaces()
    ListStreamProcessors = actions.RekognitionListStreamProcessors()
    RecognizeCelebrities = actions.RekognitionRecognizeCelebrities()
    SearchFaces = actions.RekognitionSearchFaces()
    SearchFacesByImage = actions.RekognitionSearchFacesByImage()
    StartCelebrityRecognition = actions.RekognitionStartCelebrityRecognition()
    StartContentModeration = actions.RekognitionStartContentModeration()
    StartFaceDetection = actions.RekognitionStartFaceDetection()
    StartFaceSearch = actions.RekognitionStartFaceSearch()
    StartLabelDetection = actions.RekognitionStartLabelDetection()
    StartPersonTracking = actions.RekognitionStartPersonTracking()
    StartStreamProcessor = actions.RekognitionStartStreamProcessor()
    StopStreamProcessor = actions.RekognitionStopStreamProcessor()


class ResourceGroups:
    all = IamAction("resource-groups", all=True)
    CreateGroup = actions.ResourceGroupsCreateGroup()
    DeleteGroup = actions.ResourceGroupsDeleteGroup()
    GetGroup = actions.ResourceGroupsGetGroup()
    GetGroupQuery = actions.ResourceGroupsGetGroupQuery()
    GetTags = actions.ResourceGroupsGetTags()
    ListGroupResources = actions.ResourceGroupsListGroupResources()
    ListGroups = actions.ResourceGroupsListGroups()
    SearchResources = actions.ResourceGroupsSearchResources()
    Tag = actions.ResourceGroupsTag()
    Untag = actions.ResourceGroupsUntag()
    UpdateGroup = actions.ResourceGroupsUpdateGroup()
    UpdateGroupQuery = actions.ResourceGroupsUpdateGroupQuery()


class Route53:
    all = IamAction("route53", all=True)
    AssociateVPCWithHostedZone = actions.Route53AssociateVPCWithHostedZone()
    ChangeResourceRecordSets = actions.Route53ChangeResourceRecordSets()
    ChangeTagsForResource = actions.Route53ChangeTagsForResource()
    CreateHealthCheck = actions.Route53CreateHealthCheck()
    CreateHostedZone = actions.Route53CreateHostedZone()
    CreateReusableDelegationSet = actions.Route53CreateReusableDelegationSet()
    CreateTrafficPolicy = actions.Route53CreateTrafficPolicy()
    CreateTrafficPolicyInstance = actions.Route53CreateTrafficPolicyInstance()
    CreateTrafficPolicyVersion = actions.Route53CreateTrafficPolicyVersion()
    DeleteHealthCheck = actions.Route53DeleteHealthCheck()
    DeleteHostedZone = actions.Route53DeleteHostedZone()
    DeleteReusableDelegationSet = actions.Route53DeleteReusableDelegationSet()
    DeleteTrafficPolicy = actions.Route53DeleteTrafficPolicy()
    DeleteTrafficPolicyInstance = actions.Route53DeleteTrafficPolicyInstance()
    DisableDomainAutoRenew = actions.Route53DisableDomainAutoRenew()
    DisassociateVPCFromHostedZone = actions.Route53DisassociateVPCFromHostedZone()
    EnableDomainAutoRenew = actions.Route53EnableDomainAutoRenew()
    GetChange = actions.Route53GetChange()
    GetCheckerIpRanges = actions.Route53GetCheckerIpRanges()
    GetGeoLocation = actions.Route53GetGeoLocation()
    GetHealthCheck = actions.Route53GetHealthCheck()
    GetHealthCheckCount = actions.Route53GetHealthCheckCount()
    GetHealthCheckLastFailureReason = actions.Route53GetHealthCheckLastFailureReason()
    GetHealthCheckStatus = actions.Route53GetHealthCheckStatus()
    GetHostedZone = actions.Route53GetHostedZone()
    GetHostedZoneCount = actions.Route53GetHostedZoneCount()
    GetReusableDelegationSet = actions.Route53GetReusableDelegationSet()
    GetTrafficPolicy = actions.Route53GetTrafficPolicy()
    GetTrafficPolicyInstance = actions.Route53GetTrafficPolicyInstance()
    GetTrafficPolicyInstanceCount = actions.Route53GetTrafficPolicyInstanceCount()
    ListGeoLocations = actions.Route53ListGeoLocations()
    ListHealthChecks = actions.Route53ListHealthChecks()
    ListHostedZones = actions.Route53ListHostedZones()
    ListHostedZonesByName = actions.Route53ListHostedZonesByName()
    ListResourceRecordSets = actions.Route53ListResourceRecordSets()
    ListReusableDelegationSets = actions.Route53ListReusableDelegationSets()
    ListTagsForResource = actions.Route53ListTagsForResource()
    ListTagsForResources = actions.Route53ListTagsForResources()
    ListTrafficPolicies = actions.Route53ListTrafficPolicies()
    ListTrafficPolicyInstances = actions.Route53ListTrafficPolicyInstances()
    ListTrafficPolicyInstancesByHostedZone = actions.Route53ListTrafficPolicyInstancesByHostedZone()
    ListTrafficPolicyInstancesByPolicy = actions.Route53ListTrafficPolicyInstancesByPolicy()
    ListTrafficPolicyVersions = actions.Route53ListTrafficPolicyVersions()
    TestDNSAnswer = actions.Route53TestDNSAnswer()
    UpdateHealthCheck = actions.Route53UpdateHealthCheck()
    UpdateHostedZoneComment = actions.Route53UpdateHostedZoneComment()
    UpdateTrafficPolicyComment = actions.Route53UpdateTrafficPolicyComment()
    UpdateTrafficPolicyInstance = actions.Route53UpdateTrafficPolicyInstance()


class Route53Domains:
    all = IamAction("route53domains", all=True)
    CheckDomainAvailability = actions.Route53DomainsCheckDomainAvailability()
    DeleteTagsForDomain = actions.Route53DomainsDeleteTagsForDomain()
    DisableDomainAutoRenew = actions.Route53DomainsDisableDomainAutoRenew()
    DisableDomainTransferLock = actions.Route53DomainsDisableDomainTransferLock()
    EnableDomainAutoRenew = actions.Route53DomainsEnableDomainAutoRenew()
    EnableDomainTransferLock = actions.Route53DomainsEnableDomainTransferLock()
    GetContactReachabilityStatus = actions.Route53DomainsGetContactReachabilityStatus()
    GetDomainDetail = actions.Route53DomainsGetDomainDetail()
    GetDomainSuggestions = actions.Route53DomainsGetDomainSuggestions()
    GetOperationDetail = actions.Route53DomainsGetOperationDetail()
    ListDomains = actions.Route53DomainsListDomains()
    ListOperations = actions.Route53DomainsListOperations()
    ListTagsForDomain = actions.Route53DomainsListTagsForDomain()
    RegisterDomain = actions.Route53DomainsRegisterDomain()
    RenewDomain = actions.Route53DomainsRenewDomain()
    ResendContactReachabilityEmail = actions.Route53DomainsResendContactReachabilityEmail()
    RetrieveDomainAuthCode = actions.Route53DomainsRetrieveDomainAuthCode()
    TransferDomain = actions.Route53DomainsTransferDomain()
    UpdateDomainContact = actions.Route53DomainsUpdateDomainContact()
    UpdateDomainContactPrivacy = actions.Route53DomainsUpdateDomainContactPrivacy()
    UpdateDomainNameservers = actions.Route53DomainsUpdateDomainNameservers()
    UpdateTagsForDomain = actions.Route53DomainsUpdateTagsForDomain()
    ViewBilling = actions.Route53DomainsViewBilling()


class S3:
    all = IamAction("s3", all=True)
    AbortMultipartUpload = actions.S3AbortMultipartUpload()
    CreateBucket = actions.S3CreateBucket()
    DeleteBucket = actions.S3DeleteBucket()
    DeleteBucketPolicy = actions.S3DeleteBucketPolicy()
    DeleteBucketWebsite = actions.S3DeleteBucketWebsite()
    DeleteObject = actions.S3DeleteObject()
    DeleteObjectTagging = actions.S3DeleteObjectTagging()
    DeleteObjectVersion = actions.S3DeleteObjectVersion()
    DeleteObjectVersionTagging = actions.S3DeleteObjectVersionTagging()
    GetAccelerateConfiguration = actions.S3GetAccelerateConfiguration()
    GetAnalyticsConfiguration = actions.S3GetAnalyticsConfiguration()
    GetBucketAcl = actions.S3GetBucketAcl()
    GetBucketCORS = actions.S3GetBucketCORS()
    GetBucketLocation = actions.S3GetBucketLocation()
    GetBucketLogging = actions.S3GetBucketLogging()
    GetBucketNotification = actions.S3GetBucketNotification()
    GetBucketPolicy = actions.S3GetBucketPolicy()
    GetBucketRequestPayment = actions.S3GetBucketRequestPayment()
    GetBucketTagging = actions.S3GetBucketTagging()
    GetBucketVersioning = actions.S3GetBucketVersioning()
    GetBucketWebsite = actions.S3GetBucketWebsite()
    GetInventoryConfiguration = actions.S3GetInventoryConfiguration()
    GetIpConfiguration = actions.S3GetIpConfiguration()
    GetLifecycleConfiguration = actions.S3GetLifecycleConfiguration()
    GetMetricsConfiguration = actions.S3GetMetricsConfiguration()
    GetObject = actions.S3GetObject()
    GetObjectAcl = actions.S3GetObjectAcl()
    GetObjectTagging = actions.S3GetObjectTagging()
    GetObjectTorrent = actions.S3GetObjectTorrent()
    GetObjectVersion = actions.S3GetObjectVersion()
    GetObjectVersionAcl = actions.S3GetObjectVersionAcl()
    GetObjectVersionForReplication = actions.S3GetObjectVersionForReplication()
    GetObjectVersionTagging = actions.S3GetObjectVersionTagging()
    GetObjectVersionTorrent = actions.S3GetObjectVersionTorrent()
    GetReplicationConfiguration = actions.S3GetReplicationConfiguration()
    HeadBucket = actions.S3HeadBucket()
    ListAllMyBuckets = actions.S3ListAllMyBuckets()
    ListBucket = actions.S3ListBucket()
    ListBucketByTags = actions.S3ListBucketByTags()
    ListBucketMultipartUploads = actions.S3ListBucketMultipartUploads()
    ListBucketVersions = actions.S3ListBucketVersions()
    ListMultipartUploadParts = actions.S3ListMultipartUploadParts()
    ListObjects = actions.S3ListObjects()
    ObjectOwnerOverrideToBucketOwner = actions.S3ObjectOwnerOverrideToBucketOwner()
    PutAccelerateConfiguration = actions.S3PutAccelerateConfiguration()
    PutAnalyticsConfiguration = actions.S3PutAnalyticsConfiguration()
    PutBucketAcl = actions.S3PutBucketAcl()
    PutBucketCORS = actions.S3PutBucketCORS()
    PutBucketLogging = actions.S3PutBucketLogging()
    PutBucketNotification = actions.S3PutBucketNotification()
    PutBucketPolicy = actions.S3PutBucketPolicy()
    PutBucketRequestPayment = actions.S3PutBucketRequestPayment()
    PutBucketTagging = actions.S3PutBucketTagging()
    PutBucketVersioning = actions.S3PutBucketVersioning()
    PutBucketWebsite = actions.S3PutBucketWebsite()
    PutInventoryConfiguration = actions.S3PutInventoryConfiguration()
    PutIpConfiguration = actions.S3PutIpConfiguration()
    PutLifecycleConfiguration = actions.S3PutLifecycleConfiguration()
    PutMetricsConfiguration = actions.S3PutMetricsConfiguration()
    PutObject = actions.S3PutObject()
    PutObjectAcl = actions.S3PutObjectAcl()
    PutObjectTagging = actions.S3PutObjectTagging()
    PutObjectVersionAcl = actions.S3PutObjectVersionAcl()
    PutObjectVersionTagging = actions.S3PutObjectVersionTagging()
    PutReplicationConfiguration = actions.S3PutReplicationConfiguration()
    ReplicateDelete = actions.S3ReplicateDelete()
    ReplicateObject = actions.S3ReplicateObject()
    ReplicateTags = actions.S3ReplicateTags()
    RestoreObject = actions.S3RestoreObject()


class Sagemaker:
    all = IamAction("sagemaker", all=True)
    AddTags = actions.SagemakerAddTags()
    CreateEndpoint = actions.SagemakerCreateEndpoint()
    CreateEndpointConfig = actions.SagemakerCreateEndpointConfig()
    CreateModel = actions.SagemakerCreateModel()
    CreateNotebookInstance = actions.SagemakerCreateNotebookInstance()
    CreatePresignedNotebookInstanceUrl = actions.SagemakerCreatePresignedNotebookInstanceUrl()
    CreateTrainingJob = actions.SagemakerCreateTrainingJob()
    DeleteEndpoint = actions.SagemakerDeleteEndpoint()
    DeleteEndpointConfig = actions.SagemakerDeleteEndpointConfig()
    DeleteModel = actions.SagemakerDeleteModel()
    DeleteNotebookInstance = actions.SagemakerDeleteNotebookInstance()
    DeleteTags = actions.SagemakerDeleteTags()
    DescribeEndpoint = actions.SagemakerDescribeEndpoint()
    DescribeEndpointConfig = actions.SagemakerDescribeEndpointConfig()
    DescribeModel = actions.SagemakerDescribeModel()
    DescribeNotebookInstance = actions.SagemakerDescribeNotebookInstance()
    DescribeTrainingJob = actions.SagemakerDescribeTrainingJob()
    InvokeEndpoint = actions.SagemakerInvokeEndpoint()
    ListEndpointConfigs = actions.SagemakerListEndpointConfigs()
    ListEndpoints = actions.SagemakerListEndpoints()
    ListModels = actions.SagemakerListModels()
    ListNotebookInstances = actions.SagemakerListNotebookInstances()
    ListTags = actions.SagemakerListTags()
    ListTrainingJobs = actions.SagemakerListTrainingJobs()
    StartNotebookInstance = actions.SagemakerStartNotebookInstance()
    StopNotebookInstance = actions.SagemakerStopNotebookInstance()
    StopTrainingJob = actions.SagemakerStopTrainingJob()
    UpdateEndpoint = actions.SagemakerUpdateEndpoint()
    UpdateEndpointWeightsAndCapacities = actions.SagemakerUpdateEndpointWeightsAndCapacities()
    UpdateNotebookInstance = actions.SagemakerUpdateNotebookInstance()


class Sdb:
    all = IamAction("sdb", all=True)
    BatchDeleteAttributes = actions.SdbBatchDeleteAttributes()
    BatchPutAttributes = actions.SdbBatchPutAttributes()
    CreateDomain = actions.SdbCreateDomain()
    DeleteAttributes = actions.SdbDeleteAttributes()
    DeleteDomain = actions.SdbDeleteDomain()
    DomainMetadata = actions.SdbDomainMetadata()
    GetAttributes = actions.SdbGetAttributes()
    ListDomains = actions.SdbListDomains()
    PutAttributes = actions.SdbPutAttributes()
    Select = actions.SdbSelect()


class Serverlessrepo:
    all = IamAction("serverlessrepo", all=True)
    CreateApplication = actions.ServerlessrepoCreateApplication()
    CreateApplicationVersion = actions.ServerlessrepoCreateApplicationVersion()
    CreateCloudFormationChangeSet = actions.ServerlessrepoCreateCloudFormationChangeSet()
    DeleteApplication = actions.ServerlessrepoDeleteApplication()
    GetApplication = actions.ServerlessrepoGetApplication()
    GetApplicationPolicy = actions.ServerlessrepoGetApplicationPolicy()
    ListApplicationVersions = actions.ServerlessrepoListApplicationVersions()
    ListApplications = actions.ServerlessrepoListApplications()
    PutApplicationPolicy = actions.ServerlessrepoPutApplicationPolicy()
    SearchApplications = actions.ServerlessrepoSearchApplications()
    UpdateApplication = actions.ServerlessrepoUpdateApplication()


class Servicecatalog:
    all = IamAction("servicecatalog", all=True)
    AcceptPortfolioShare = actions.ServicecatalogAcceptPortfolioShare()
    AssociatePrincipalWithPortfolio = actions.ServicecatalogAssociatePrincipalWithPortfolio()
    AssociateProductWithPortfolio = actions.ServicecatalogAssociateProductWithPortfolio()
    CreateConstraint = actions.ServicecatalogCreateConstraint()
    CreatePortfolio = actions.ServicecatalogCreatePortfolio()
    CreatePortfolioShare = actions.ServicecatalogCreatePortfolioShare()
    CreateProduct = actions.ServicecatalogCreateProduct()
    CreateProvisioningArtifact = actions.ServicecatalogCreateProvisioningArtifact()
    DeleteConstraint = actions.ServicecatalogDeleteConstraint()
    DeletePortfolio = actions.ServicecatalogDeletePortfolio()
    DeletePortfolioShare = actions.ServicecatalogDeletePortfolioShare()
    DeleteProduct = actions.ServicecatalogDeleteProduct()
    DeleteProvisioningArtifact = actions.ServicecatalogDeleteProvisioningArtifact()
    DescribeConstraint = actions.ServicecatalogDescribeConstraint()
    DescribePortfolio = actions.ServicecatalogDescribePortfolio()
    DescribeProduct = actions.ServicecatalogDescribeProduct()
    DescribeProductAsAdmin = actions.ServicecatalogDescribeProductAsAdmin()
    DescribeProductView = actions.ServicecatalogDescribeProductView()
    DescribeProvisioningArtifact = actions.ServicecatalogDescribeProvisioningArtifact()
    DescribeProvisioningParameters = actions.ServicecatalogDescribeProvisioningParameters()
    DescribeRecord = actions.ServicecatalogDescribeRecord()
    DisassociatePrincipalFromPortfolio = actions.ServicecatalogDisassociatePrincipalFromPortfolio()
    DisassociateProductFromPortfolio = actions.ServicecatalogDisassociateProductFromPortfolio()
    ListAcceptedPortfolioShares = actions.ServicecatalogListAcceptedPortfolioShares()
    ListConstraintsForPortfolio = actions.ServicecatalogListConstraintsForPortfolio()
    ListLaunchPaths = actions.ServicecatalogListLaunchPaths()
    ListPortfolioAccess = actions.ServicecatalogListPortfolioAccess()
    ListPortfolios = actions.ServicecatalogListPortfolios()
    ListPortfoliosForProduct = actions.ServicecatalogListPortfoliosForProduct()
    ListPrincipalsForPortfolio = actions.ServicecatalogListPrincipalsForPortfolio()
    ListProvisioningArtifacts = actions.ServicecatalogListProvisioningArtifacts()
    ListRecordHistory = actions.ServicecatalogListRecordHistory()
    ProvisionProduct = actions.ServicecatalogProvisionProduct()
    RejectPortfolioShare = actions.ServicecatalogRejectPortfolioShare()
    ScanProvisionedProducts = actions.ServicecatalogScanProvisionedProducts()
    SearchProducts = actions.ServicecatalogSearchProducts()
    SearchProductsAsAdmin = actions.ServicecatalogSearchProductsAsAdmin()
    TerminateProvisionedProduct = actions.ServicecatalogTerminateProvisionedProduct()
    UpdateConstraint = actions.ServicecatalogUpdateConstraint()
    UpdatePortfolio = actions.ServicecatalogUpdatePortfolio()
    UpdateProduct = actions.ServicecatalogUpdateProduct()
    UpdateProvisionedProduct = actions.ServicecatalogUpdateProvisionedProduct()
    UpdateProvisioningArtifact = actions.ServicecatalogUpdateProvisioningArtifact()


class ServiceDiscovery:
    all = IamAction("servicediscovery", all=True)
    CreatePrivateDnsNamespace = actions.ServicediscoveryCreatePrivateDnsNamespace()
    CreatePublicDnsNamespace = actions.ServicediscoveryCreatePublicDnsNamespace()
    CreateService = actions.ServicediscoveryCreateService()
    DeleteNamespace = actions.ServicediscoveryDeleteNamespace()
    DeleteService = actions.ServicediscoveryDeleteService()
    DeregisterInstance = actions.ServicediscoveryDeregisterInstance()
    GetInstance = actions.ServicediscoveryGetInstance()
    GetInstancesHealthStatus = actions.ServicediscoveryGetInstancesHealthStatus()
    GetNamespace = actions.ServicediscoveryGetNamespace()
    GetOperation = actions.ServicediscoveryGetOperation()
    GetService = actions.ServicediscoveryGetService()
    ListInstances = actions.ServicediscoveryListInstances()
    ListNamespaces = actions.ServicediscoveryListNamespaces()
    ListOperations = actions.ServicediscoveryListOperations()
    ListServices = actions.ServicediscoveryListServices()
    RegisterInstance = actions.ServicediscoveryRegisterInstance()
    UpdateInstanceHeartbeatStatus = actions.ServicediscoveryUpdateInstanceHeartbeatStatus()
    UpdateService = actions.ServicediscoveryUpdateService()


class Ses:
    all = IamAction("ses", all=True)
    CloneReceiptRuleSet = actions.SesCloneReceiptRuleSet()
    CreateConfigurationSet = actions.SesCreateConfigurationSet()
    CreateConfigurationSetEventDestination = actions.SesCreateConfigurationSetEventDestination()
    CreateConfigurationSetTrackingOptions = actions.SesCreateConfigurationSetTrackingOptions()
    CreateCustomVerificationEmailTemplate = actions.SesCreateCustomVerificationEmailTemplate()
    CreateReceiptFilter = actions.SesCreateReceiptFilter()
    CreateReceiptRule = actions.SesCreateReceiptRule()
    CreateReceiptRuleSet = actions.SesCreateReceiptRuleSet()
    CreateTemplate = actions.SesCreateTemplate()
    DeleteConfigurationSet = actions.SesDeleteConfigurationSet()
    DeleteConfigurationSetEventDestination = actions.SesDeleteConfigurationSetEventDestination()
    DeleteConfigurationSetTrackingOptions = actions.SesDeleteConfigurationSetTrackingOptions()
    DeleteCustomVerificationEmailTemplate = actions.SesDeleteCustomVerificationEmailTemplate()
    DeleteIdentity = actions.SesDeleteIdentity()
    DeleteIdentityPolicy = actions.SesDeleteIdentityPolicy()
    DeleteReceiptFilter = actions.SesDeleteReceiptFilter()
    DeleteReceiptRule = actions.SesDeleteReceiptRule()
    DeleteReceiptRuleSet = actions.SesDeleteReceiptRuleSet()
    DeleteTemplate = actions.SesDeleteTemplate()
    DeleteVerifiedEmailAddress = actions.SesDeleteVerifiedEmailAddress()
    DescribeActiveReceiptRuleSet = actions.SesDescribeActiveReceiptRuleSet()
    DescribeConfigurationSet = actions.SesDescribeConfigurationSet()
    DescribeReceiptRule = actions.SesDescribeReceiptRule()
    DescribeReceiptRuleSet = actions.SesDescribeReceiptRuleSet()
    GetAccountSendingEnabled = actions.SesGetAccountSendingEnabled()
    GetCustomVerificationEmailTemplate = actions.SesGetCustomVerificationEmailTemplate()
    GetIdentityDkimAttributes = actions.SesGetIdentityDkimAttributes()
    GetIdentityMailFromDomainAttributes = actions.SesGetIdentityMailFromDomainAttributes()
    GetIdentityNotificationAttributes = actions.SesGetIdentityNotificationAttributes()
    GetIdentityPolicies = actions.SesGetIdentityPolicies()
    GetIdentityVerificationAttributes = actions.SesGetIdentityVerificationAttributes()
    GetSendQuota = actions.SesGetSendQuota()
    GetSendStatistics = actions.SesGetSendStatistics()
    GetTemplate = actions.SesGetTemplate()
    ListConfigurationSets = actions.SesListConfigurationSets()
    ListCustomVerificationEmailTemplates = actions.SesListCustomVerificationEmailTemplates()
    ListIdentities = actions.SesListIdentities()
    ListIdentityPolicies = actions.SesListIdentityPolicies()
    ListReceiptFilters = actions.SesListReceiptFilters()
    ListReceiptRuleSets = actions.SesListReceiptRuleSets()
    ListTemplates = actions.SesListTemplates()
    ListVerifiedEmailAddresses = actions.SesListVerifiedEmailAddresses()
    PutIdentityPolicy = actions.SesPutIdentityPolicy()
    ReorderReceiptRuleSet = actions.SesReorderReceiptRuleSet()
    SendBounce = actions.SesSendBounce()
    SendBulkTemplatedEmail = actions.SesSendBulkTemplatedEmail()
    SendCustomVerificationEmail = actions.SesSendCustomVerificationEmail()
    SendEmail = actions.SesSendEmail()
    SendRawEmail = actions.SesSendRawEmail()
    SendTemplatedEmail = actions.SesSendTemplatedEmail()
    SetActiveReceiptRuleSet = actions.SesSetActiveReceiptRuleSet()
    SetIdentityDkimEnabled = actions.SesSetIdentityDkimEnabled()
    SetIdentityFeedbackForwardingEnabled = actions.SesSetIdentityFeedbackForwardingEnabled()
    SetIdentityHeadersInNotificationsEnabled = actions.SesSetIdentityHeadersInNotificationsEnabled()
    SetIdentityMailFromDomain = actions.SesSetIdentityMailFromDomain()
    SetIdentityNotificationTopic = actions.SesSetIdentityNotificationTopic()
    SetReceiptRulePosition = actions.SesSetReceiptRulePosition()
    TestRenderTemplate = actions.SesTestRenderTemplate()
    UpdateAccountSendingEnabled = actions.SesUpdateAccountSendingEnabled()
    UpdateConfigurationSetEventDestination = actions.SesUpdateConfigurationSetEventDestination()
    UpdateConfigurationSetReputationMetricsEnabled = actions.SesUpdateConfigurationSetReputationMetricsEnabled()
    UpdateConfigurationSetSendingEnabled = actions.SesUpdateConfigurationSetSendingEnabled()
    UpdateConfigurationSetTrackingOptions = actions.SesUpdateConfigurationSetTrackingOptions()
    UpdateCustomVerificationEmailTemplate = actions.SesUpdateCustomVerificationEmailTemplate()
    UpdateReceiptRule = actions.SesUpdateReceiptRule()
    UpdateTemplate = actions.SesUpdateTemplate()
    VerifyDomainDkim = actions.SesVerifyDomainDkim()
    VerifyDomainIdentity = actions.SesVerifyDomainIdentity()
    VerifyEmailAddress = actions.SesVerifyEmailAddress()
    VerifyEmailIdentity = actions.SesVerifyEmailIdentity()


class Shield:
    all = IamAction("shield", all=True)
    CreateProtection = actions.ShieldCreateProtection()
    CreateSubscription = actions.ShieldCreateSubscription()
    DeleteProtection = actions.ShieldDeleteProtection()
    DeleteSubscription = actions.ShieldDeleteSubscription()
    DescribeAttack = actions.ShieldDescribeAttack()
    DescribeProtection = actions.ShieldDescribeProtection()
    DescribeSubscription = actions.ShieldDescribeSubscription()
    ListAttacks = actions.ShieldListAttacks()
    ListProtections = actions.ShieldListProtections()


class Signer:
    all = IamAction("signer", all=True)
    DescribeSigningJob = actions.SignerDescribeSigningJob()
    ListSigningJobs = actions.SignerListSigningJobs()
    StartSigningJob = actions.SignerStartSigningJob()


class Snowball:
    all = IamAction("snowball", all=True)
    CancelCluster = actions.SnowballCancelCluster()
    CancelJob = actions.SnowballCancelJob()
    CreateAddress = actions.SnowballCreateAddress()
    CreateCluster = actions.SnowballCreateCluster()
    CreateJob = actions.SnowballCreateJob()
    DescribeAddress = actions.SnowballDescribeAddress()
    DescribeAddresses = actions.SnowballDescribeAddresses()
    DescribeCluster = actions.SnowballDescribeCluster()
    DescribeJob = actions.SnowballDescribeJob()
    GetJobManifest = actions.SnowballGetJobManifest()
    GetJobUnlockCode = actions.SnowballGetJobUnlockCode()
    GetSnowballUsage = actions.SnowballGetSnowballUsage()
    ListClusterJobs = actions.SnowballListClusterJobs()
    ListClusters = actions.SnowballListClusters()
    ListJobs = actions.SnowballListJobs()
    UpdateCluster = actions.SnowballUpdateCluster()
    UpdateJob = actions.SnowballUpdateJob()


class Sns:
    all = IamAction("sns", all=True)
    AddPermission = actions.SnsAddPermission()
    CheckIfPhoneNumberIsOptedOut = actions.SnsCheckIfPhoneNumberIsOptedOut()
    ConfirmSubscription = actions.SnsConfirmSubscription()
    CreatePlatformApplication = actions.SnsCreatePlatformApplication()
    CreatePlatformEndpoint = actions.SnsCreatePlatformEndpoint()
    CreateTopic = actions.SnsCreateTopic()
    DeleteEndpoint = actions.SnsDeleteEndpoint()
    DeletePlatformApplication = actions.SnsDeletePlatformApplication()
    DeleteTopic = actions.SnsDeleteTopic()
    GetEndpointAttributes = actions.SnsGetEndpointAttributes()
    GetPlatformApplicationAttributes = actions.SnsGetPlatformApplicationAttributes()
    GetSMSAttributes = actions.SnsGetSMSAttributes()
    GetSubscriptionAttributes = actions.SnsGetSubscriptionAttributes()
    GetTopicAttributes = actions.SnsGetTopicAttributes()
    ListEndpointsByPlatformApplication = actions.SnsListEndpointsByPlatformApplication()
    ListPhoneNumbersOptedOut = actions.SnsListPhoneNumbersOptedOut()
    ListPlatformApplications = actions.SnsListPlatformApplications()
    ListSubscriptions = actions.SnsListSubscriptions()
    ListSubscriptionsByTopic = actions.SnsListSubscriptionsByTopic()
    ListTopics = actions.SnsListTopics()
    OptInPhoneNumber = actions.SnsOptInPhoneNumber()
    Publish = actions.SnsPublish()
    RemovePermission = actions.SnsRemovePermission()
    SetEndpointAttributes = actions.SnsSetEndpointAttributes()
    SetPlatformApplicationAttributes = actions.SnsSetPlatformApplicationAttributes()
    SetSMSAttributes = actions.SnsSetSMSAttributes()
    SetSubscriptionAttributes = actions.SnsSetSubscriptionAttributes()
    SetTopicAttributes = actions.SnsSetTopicAttributes()
    Subscribe = actions.SnsSubscribe()
    Unsubscribe = actions.SnsUnsubscribe()


class Sqs:
    all = IamAction("sqs", all=True)
    AddPermission = actions.SqsAddPermission()
    ChangeMessageVisibility = actions.SqsChangeMessageVisibility()
    ChangeMessageVisibilityBatch = actions.SqsChangeMessageVisibilityBatch()
    CreateQueue = actions.SqsCreateQueue()
    DeleteMessage = actions.SqsDeleteMessage()
    DeleteMessageBatch = actions.SqsDeleteMessageBatch()
    DeleteQueue = actions.SqsDeleteQueue()
    GetQueueAttributes = actions.SqsGetQueueAttributes()
    GetQueueUrl = actions.SqsGetQueueUrl()
    ListDeadLetterSourceQueues = actions.SqsListDeadLetterSourceQueues()
    ListQueueTags = actions.SqsListQueueTags()
    ListQueues = actions.SqsListQueues()
    PurgeQueue = actions.SqsPurgeQueue()
    ReceiveMessage = actions.SqsReceiveMessage()
    RemovePermission = actions.SqsRemovePermission()
    SendMessage = actions.SqsSendMessage()
    SendMessageBatch = actions.SqsSendMessageBatch()
    SetQueueAttributes = actions.SqsSetQueueAttributes()
    TagQueue = actions.SqsTagQueue()
    UntagQueue = actions.SqsUntagQueue()


class Ssm:
    all = IamAction("ssm", all=True)
    AddTagsToResource = actions.SsmAddTagsToResource()
    CancelCommand = actions.SsmCancelCommand()
    CreateActivation = actions.SsmCreateActivation()
    CreateAssociation = actions.SsmCreateAssociation()
    CreateAssociationBatch = actions.SsmCreateAssociationBatch()
    CreateDocument = actions.SsmCreateDocument()
    CreateMaintenanceWindow = actions.SsmCreateMaintenanceWindow()
    CreatePatchBaseline = actions.SsmCreatePatchBaseline()
    CreateResourceDataSync = actions.SsmCreateResourceDataSync()
    DeleteActivation = actions.SsmDeleteActivation()
    DeleteAssociation = actions.SsmDeleteAssociation()
    DeleteDocument = actions.SsmDeleteDocument()
    DeleteMaintenanceWindow = actions.SsmDeleteMaintenanceWindow()
    DeleteParameter = actions.SsmDeleteParameter()
    DeleteParameters = actions.SsmDeleteParameters()
    DeletePatchBaseline = actions.SsmDeletePatchBaseline()
    DeleteResourceDataSync = actions.SsmDeleteResourceDataSync()
    DeregisterManagedInstance = actions.SsmDeregisterManagedInstance()
    DeregisterPatchBaselineForPatchGroup = actions.SsmDeregisterPatchBaselineForPatchGroup()
    DeregisterTargetFromMaintenanceWindow = actions.SsmDeregisterTargetFromMaintenanceWindow()
    DeregisterTaskFromMaintenanceWindow = actions.SsmDeregisterTaskFromMaintenanceWindow()
    DescribeActivations = actions.SsmDescribeActivations()
    DescribeAssociation = actions.SsmDescribeAssociation()
    DescribeAutomationExecutions = actions.SsmDescribeAutomationExecutions()
    DescribeAutomationStepExecutions = actions.SsmDescribeAutomationStepExecutions()
    DescribeAvailablePatches = actions.SsmDescribeAvailablePatches()
    DescribeDocument = actions.SsmDescribeDocument()
    DescribeDocumentParameters = actions.SsmDescribeDocumentParameters()
    DescribeDocumentPermission = actions.SsmDescribeDocumentPermission()
    DescribeEffectiveInstanceAssociations = actions.SsmDescribeEffectiveInstanceAssociations()
    DescribeEffectivePatchesForPatchBaseline = actions.SsmDescribeEffectivePatchesForPatchBaseline()
    DescribeInstanceAssociationsStatus = actions.SsmDescribeInstanceAssociationsStatus()
    DescribeInstanceInformation = actions.SsmDescribeInstanceInformation()
    DescribeInstancePatchStates = actions.SsmDescribeInstancePatchStates()
    DescribeInstancePatchStatesForPatchGroup = actions.SsmDescribeInstancePatchStatesForPatchGroup()
    DescribeInstancePatches = actions.SsmDescribeInstancePatches()
    DescribeInstanceProperties = actions.SsmDescribeInstanceProperties()
    DescribeMaintenanceWindowExecutionTaskInvocations = actions.SsmDescribeMaintenanceWindowExecutionTaskInvocations()
    DescribeMaintenanceWindowExecutionTasks = actions.SsmDescribeMaintenanceWindowExecutionTasks()
    DescribeMaintenanceWindowExecutions = actions.SsmDescribeMaintenanceWindowExecutions()
    DescribeMaintenanceWindowTargets = actions.SsmDescribeMaintenanceWindowTargets()
    DescribeMaintenanceWindowTasks = actions.SsmDescribeMaintenanceWindowTasks()
    DescribeMaintenanceWindows = actions.SsmDescribeMaintenanceWindows()
    DescribeParameters = actions.SsmDescribeParameters()
    DescribePatchBaselines = actions.SsmDescribePatchBaselines()
    DescribePatchGroupState = actions.SsmDescribePatchGroupState()
    DescribePatchGroups = actions.SsmDescribePatchGroups()
    GetAutomationExecution = actions.SsmGetAutomationExecution()
    GetCommandInvocation = actions.SsmGetCommandInvocation()
    GetDefaultPatchBaseline = actions.SsmGetDefaultPatchBaseline()
    GetDeployablePatchSnapshotForInstance = actions.SsmGetDeployablePatchSnapshotForInstance()
    GetDocument = actions.SsmGetDocument()
    GetInventory = actions.SsmGetInventory()
    GetInventorySchema = actions.SsmGetInventorySchema()
    GetMaintenanceWindow = actions.SsmGetMaintenanceWindow()
    GetMaintenanceWindowExecution = actions.SsmGetMaintenanceWindowExecution()
    GetMaintenanceWindowExecutionTask = actions.SsmGetMaintenanceWindowExecutionTask()
    GetMaintenanceWindowExecutionTaskInvocation = actions.SsmGetMaintenanceWindowExecutionTaskInvocation()
    GetMaintenanceWindowTask = actions.SsmGetMaintenanceWindowTask()
    GetManifest = actions.SsmGetManifest()
    GetParameter = actions.SsmGetParameter()
    GetParameterHistory = actions.SsmGetParameterHistory()
    GetParameters = actions.SsmGetParameters()
    GetParametersByPath = actions.SsmGetParametersByPath()
    GetPatchBaseline = actions.SsmGetPatchBaseline()
    GetPatchBaselineForPatchGroup = actions.SsmGetPatchBaselineForPatchGroup()
    ListAssociationVersions = actions.SsmListAssociationVersions()
    ListAssociations = actions.SsmListAssociations()
    ListCommandInvocations = actions.SsmListCommandInvocations()
    ListCommands = actions.SsmListCommands()
    ListDocumentVersions = actions.SsmListDocumentVersions()
    ListDocuments = actions.SsmListDocuments()
    ListInstanceAssociations = actions.SsmListInstanceAssociations()
    ListInventoryEntries = actions.SsmListInventoryEntries()
    ListResourceDataSync = actions.SsmListResourceDataSync()
    ListTagsForResource = actions.SsmListTagsForResource()
    ModifyDocumentPermission = actions.SsmModifyDocumentPermission()
    PutComplianceItems = actions.SsmPutComplianceItems()
    PutConfigurePackageResult = actions.SsmPutConfigurePackageResult()
    PutInventory = actions.SsmPutInventory()
    PutParameter = actions.SsmPutParameter()
    RegisterDefaultPatchBaseline = actions.SsmRegisterDefaultPatchBaseline()
    RegisterPatchBaselineForPatchGroup = actions.SsmRegisterPatchBaselineForPatchGroup()
    RegisterTargetWithMaintenanceWindow = actions.SsmRegisterTargetWithMaintenanceWindow()
    RegisterTaskWithMaintenanceWindow = actions.SsmRegisterTaskWithMaintenanceWindow()
    RemoveTagsFromResource = actions.SsmRemoveTagsFromResource()
    SendAutomationSignal = actions.SsmSendAutomationSignal()
    SendCommand = actions.SsmSendCommand()
    StartAssociationsOnce = actions.SsmStartAssociationsOnce()
    StartAutomationExecution = actions.SsmStartAutomationExecution()
    StopAutomationExecution = actions.SsmStopAutomationExecution()
    UpdateAssociation = actions.SsmUpdateAssociation()
    UpdateAssociationStatus = actions.SsmUpdateAssociationStatus()
    UpdateDocument = actions.SsmUpdateDocument()
    UpdateDocumentDefaultVersion = actions.SsmUpdateDocumentDefaultVersion()
    UpdateInstanceAssociationStatus = actions.SsmUpdateInstanceAssociationStatus()
    UpdateInstanceInformation = actions.SsmUpdateInstanceInformation()
    UpdateMaintenanceWindow = actions.SsmUpdateMaintenanceWindow()
    UpdateMaintenanceWindowTarget = actions.SsmUpdateMaintenanceWindowTarget()
    UpdateMaintenanceWindowTask = actions.SsmUpdateMaintenanceWindowTask()
    UpdateManagedInstanceRole = actions.SsmUpdateManagedInstanceRole()
    UpdatePatchBaseline = actions.SsmUpdatePatchBaseline()


class Sso:
    all = IamAction("sso", all=True)
    AssociateDirectory = actions.SsoAssociateDirectory()
    AssociateProfile = actions.SsoAssociateProfile()
    CreateApplicationInstance = actions.SsoCreateApplicationInstance()
    CreateApplicationInstanceCertificate = actions.SsoCreateApplicationInstanceCertificate()
    CreatePermissionSet = actions.SsoCreatePermissionSet()
    CreateProfile = actions.SsoCreateProfile()
    CreateTrust = actions.SsoCreateTrust()
    DeleteApplicationInstance = actions.SsoDeleteApplicationInstance()
    DeleteApplicationInstanceCertificate = actions.SsoDeleteApplicationInstanceCertificate()
    DeletePermissionSet = actions.SsoDeletePermissionSet()
    DeletePermissionsPolicy = actions.SsoDeletePermissionsPolicy()
    DeleteProfile = actions.SsoDeleteProfile()
    DescribePermissionsPolicies = actions.SsoDescribePermissionsPolicies()
    DisassociateDirectory = actions.SsoDisassociateDirectory()
    DisassociateProfile = actions.SsoDisassociateProfile()
    GetApplicationInstance = actions.SsoGetApplicationInstance()
    GetApplicationTemplate = actions.SsoGetApplicationTemplate()
    GetPermissionSet = actions.SsoGetPermissionSet()
    GetProfile = actions.SsoGetProfile()
    GetSSOStatus = actions.SsoGetSSOStatus()
    GetTrust = actions.SsoGetTrust()
    ImportApplicationInstanceServiceProviderMetadata = actions.SsoImportApplicationInstanceServiceProviderMetadata()
    ListApplicationInstanceCertificates = actions.SsoListApplicationInstanceCertificates()
    ListApplicationInstances = actions.SsoListApplicationInstances()
    ListApplicationTemplates = actions.SsoListApplicationTemplates()
    ListDirectoryAssociations = actions.SsoListDirectoryAssociations()
    ListPermissionSets = actions.SsoListPermissionSets()
    ListProfileAssociations = actions.SsoListProfileAssociations()
    ListProfiles = actions.SsoListProfiles()
    PutPermissionsPolicy = actions.SsoPutPermissionsPolicy()
    StartSSO = actions.SsoStartSSO()
    UpdateApplicationInstanceActiveCertificate = actions.SsoUpdateApplicationInstanceActiveCertificate()
    UpdateApplicationInstanceDisplayData = actions.SsoUpdateApplicationInstanceDisplayData()
    UpdateApplicationInstanceResponseConfiguration = actions.SsoUpdateApplicationInstanceResponseConfiguration()
    UpdateApplicationInstanceResponseSchemaConfiguration = actions.SsoUpdateApplicationInstanceResponseSchemaConfiguration()
    UpdateApplicationInstanceSecurityConfiguration = actions.SsoUpdateApplicationInstanceSecurityConfiguration()
    UpdateApplicationInstanceServiceProviderConfiguration = actions.SsoUpdateApplicationInstanceServiceProviderConfiguration()
    UpdateApplicationInstanceStatus = actions.SsoUpdateApplicationInstanceStatus()
    UpdateDirectoryAssociation = actions.SsoUpdateDirectoryAssociation()
    UpdateProfile = actions.SsoUpdateProfile()
    UpdateTrust = actions.SsoUpdateTrust()


class States:
    all = IamAction("states", all=True)
    CreateActivity = actions.StatesCreateActivity()
    CreateStateMachine = actions.StatesCreateStateMachine()
    DeleteActivity = actions.StatesDeleteActivity()
    DeleteStateMachine = actions.StatesDeleteStateMachine()
    DescribeActivity = actions.StatesDescribeActivity()
    DescribeExecution = actions.StatesDescribeExecution()
    DescribeStateMachine = actions.StatesDescribeStateMachine()
    DescribeStateMachineForExecution = actions.StatesDescribeStateMachineForExecution()
    GetActivityTask = actions.StatesGetActivityTask()
    GetExecutionHistory = actions.StatesGetExecutionHistory()
    ListActivities = actions.StatesListActivities()
    ListExecutions = actions.StatesListExecutions()
    ListStateMachines = actions.StatesListStateMachines()
    SendTaskFailure = actions.StatesSendTaskFailure()
    SendTaskHeartbeat = actions.StatesSendTaskHeartbeat()
    SendTaskSuccess = actions.StatesSendTaskSuccess()
    StartExecution = actions.StatesStartExecution()
    StopExecution = actions.StatesStopExecution()
    UpdateStateMachine = actions.StatesUpdateStateMachine()


class StorageGateway:
    all = IamAction("storagegateway", all=True)
    ActivateGateway = actions.StoragegatewayActivateGateway()
    AddCache = actions.StoragegatewayAddCache()
    AddTagsToResource = actions.StoragegatewayAddTagsToResource()
    AddUploadBuffer = actions.StoragegatewayAddUploadBuffer()
    AddWorkingStorage = actions.StoragegatewayAddWorkingStorage()
    CancelArchival = actions.StoragegatewayCancelArchival()
    CancelRetrieval = actions.StoragegatewayCancelRetrieval()
    CreateCachediSCSIVolume = actions.StoragegatewayCreateCachediSCSIVolume()
    CreateNFSFileShare = actions.StoragegatewayCreateNFSFileShare()
    CreateSnapshot = actions.StoragegatewayCreateSnapshot()
    CreateSnapshotFromVolumeRecoveryPoint = actions.StoragegatewayCreateSnapshotFromVolumeRecoveryPoint()
    CreateStorediSCSIVolume = actions.StoragegatewayCreateStorediSCSIVolume()
    CreateTapeWithBarcode = actions.StoragegatewayCreateTapeWithBarcode()
    CreateTapes = actions.StoragegatewayCreateTapes()
    DeleteBandwidthRateLimit = actions.StoragegatewayDeleteBandwidthRateLimit()
    DeleteChapCredentials = actions.StoragegatewayDeleteChapCredentials()
    DeleteFileShare = actions.StoragegatewayDeleteFileShare()
    DeleteGateway = actions.StoragegatewayDeleteGateway()
    DeleteSnapshotSchedule = actions.StoragegatewayDeleteSnapshotSchedule()
    DeleteTape = actions.StoragegatewayDeleteTape()
    DeleteTapeArchive = actions.StoragegatewayDeleteTapeArchive()
    DeleteVolume = actions.StoragegatewayDeleteVolume()
    DescribeBandwidthRateLimit = actions.StoragegatewayDescribeBandwidthRateLimit()
    DescribeCache = actions.StoragegatewayDescribeCache()
    DescribeCachediSCSIVolumes = actions.StoragegatewayDescribeCachediSCSIVolumes()
    DescribeChapCredentials = actions.StoragegatewayDescribeChapCredentials()
    DescribeGatewayInformation = actions.StoragegatewayDescribeGatewayInformation()
    DescribeMaintenanceStartTime = actions.StoragegatewayDescribeMaintenanceStartTime()
    DescribeNFSFileShares = actions.StoragegatewayDescribeNFSFileShares()
    DescribeSnapshotSchedule = actions.StoragegatewayDescribeSnapshotSchedule()
    DescribeStorediSCSIVolumes = actions.StoragegatewayDescribeStorediSCSIVolumes()
    DescribeTapeArchives = actions.StoragegatewayDescribeTapeArchives()
    DescribeTapeRecoveryPoints = actions.StoragegatewayDescribeTapeRecoveryPoints()
    DescribeTapes = actions.StoragegatewayDescribeTapes()
    DescribeUploadBuffer = actions.StoragegatewayDescribeUploadBuffer()
    DescribeVTLDevices = actions.StoragegatewayDescribeVTLDevices()
    DescribeWorkingStorage = actions.StoragegatewayDescribeWorkingStorage()
    DisableGateway = actions.StoragegatewayDisableGateway()
    ListFileShares = actions.StoragegatewayListFileShares()
    ListGateways = actions.StoragegatewayListGateways()
    ListLocalDisks = actions.StoragegatewayListLocalDisks()
    ListTagsForResource = actions.StoragegatewayListTagsForResource()
    ListTapes = actions.StoragegatewayListTapes()
    ListVolumeInitiators = actions.StoragegatewayListVolumeInitiators()
    ListVolumeRecoveryPoints = actions.StoragegatewayListVolumeRecoveryPoints()
    ListVolumes = actions.StoragegatewayListVolumes()
    RefreshCache = actions.StoragegatewayRefreshCache()
    RemoveTagsFromResource = actions.StoragegatewayRemoveTagsFromResource()
    ResetCache = actions.StoragegatewayResetCache()
    RetrieveTapeArchive = actions.StoragegatewayRetrieveTapeArchive()
    RetrieveTapeRecoveryPoint = actions.StoragegatewayRetrieveTapeRecoveryPoint()
    SetLocalConsolePassword = actions.StoragegatewaySetLocalConsolePassword()
    ShutdownGateway = actions.StoragegatewayShutdownGateway()
    StartGateway = actions.StoragegatewayStartGateway()
    UpdateBandwidthRateLimit = actions.StoragegatewayUpdateBandwidthRateLimit()
    UpdateChapCredentials = actions.StoragegatewayUpdateChapCredentials()
    UpdateGatewayInformation = actions.StoragegatewayUpdateGatewayInformation()
    UpdateGatewaySoftwareNow = actions.StoragegatewayUpdateGatewaySoftwareNow()
    UpdateMaintenanceStartTime = actions.StoragegatewayUpdateMaintenanceStartTime()
    UpdateNFSFileShare = actions.StoragegatewayUpdateNFSFileShare()
    UpdateSnapshotSchedule = actions.StoragegatewayUpdateSnapshotSchedule()
    UpdateVTLDeviceType = actions.StoragegatewayUpdateVTLDeviceType()


class Sts:
    all = IamAction("sts", all=True)
    AssumeRole = actions.StsAssumeRole()
    AssumeRoleWithSAML = actions.StsAssumeRoleWithSAML()
    AssumeRoleWithWebIdentity = actions.StsAssumeRoleWithWebIdentity()
    DecodeAuthorizationMessage = actions.StsDecodeAuthorizationMessage()
    GetCallerIdentity = actions.StsGetCallerIdentity()
    GetFederationToken = actions.StsGetFederationToken()
    GetSessionToken = actions.StsGetSessionToken()


class Support:
    all = IamAction("support", all=True)
    AddAttachmentsToSet = actions.SupportAddAttachmentsToSet()
    AddCommunicationToCase = actions.SupportAddCommunicationToCase()
    CreateCase = actions.SupportCreateCase()
    DescribeAttachment = actions.SupportDescribeAttachment()
    DescribeCases = actions.SupportDescribeCases()
    DescribeCommunications = actions.SupportDescribeCommunications()
    DescribeServices = actions.SupportDescribeServices()
    DescribeSeverityLevels = actions.SupportDescribeSeverityLevels()
    DescribeTrustedAdvisorCheckRefreshStatuses = actions.SupportDescribeTrustedAdvisorCheckRefreshStatuses()
    DescribeTrustedAdvisorCheckResult = actions.SupportDescribeTrustedAdvisorCheckResult()
    DescribeTrustedAdvisorCheckSummaries = actions.SupportDescribeTrustedAdvisorCheckSummaries()
    DescribeTrustedAdvisorChecks = actions.SupportDescribeTrustedAdvisorChecks()
    RefreshTrustedAdvisorCheck = actions.SupportRefreshTrustedAdvisorCheck()
    ResolveCase = actions.SupportResolveCase()


class Swf:
    all = IamAction("swf", all=True)
    CancelTimer = actions.SwfCancelTimer()
    CancelWorkflowExecution = actions.SwfCancelWorkflowExecution()
    CompleteWorkflowExecution = actions.SwfCompleteWorkflowExecution()
    ContinueAsNewWorkflowExecution = actions.SwfContinueAsNewWorkflowExecution()
    CountClosedWorkflowExecutions = actions.SwfCountClosedWorkflowExecutions()
    CountOpenWorkflowExecutions = actions.SwfCountOpenWorkflowExecutions()
    CountPendingActivityTasks = actions.SwfCountPendingActivityTasks()
    CountPendingDecisionTasks = actions.SwfCountPendingDecisionTasks()
    DeprecateActivityType = actions.SwfDeprecateActivityType()
    DeprecateDomain = actions.SwfDeprecateDomain()
    DeprecateWorkflowType = actions.SwfDeprecateWorkflowType()
    DescribeActivityType = actions.SwfDescribeActivityType()
    DescribeDomain = actions.SwfDescribeDomain()
    DescribeWorkflowExecution = actions.SwfDescribeWorkflowExecution()
    DescribeWorkflowType = actions.SwfDescribeWorkflowType()
    FailWorkflowExecution = actions.SwfFailWorkflowExecution()
    GetWorkflowExecutionHistory = actions.SwfGetWorkflowExecutionHistory()
    ListActivityTypes = actions.SwfListActivityTypes()
    ListClosedWorkflowExecutions = actions.SwfListClosedWorkflowExecutions()
    ListDomains = actions.SwfListDomains()
    ListOpenWorkflowExecutions = actions.SwfListOpenWorkflowExecutions()
    ListWorkflowTypes = actions.SwfListWorkflowTypes()
    PollForActivityTask = actions.SwfPollForActivityTask()
    PollForDecisionTask = actions.SwfPollForDecisionTask()
    RecordActivityTaskHeartbeat = actions.SwfRecordActivityTaskHeartbeat()
    RecordMarker = actions.SwfRecordMarker()
    RegisterActivityType = actions.SwfRegisterActivityType()
    RegisterDomain = actions.SwfRegisterDomain()
    RegisterWorkflowType = actions.SwfRegisterWorkflowType()
    RequestCancelActivityTask = actions.SwfRequestCancelActivityTask()
    RequestCancelExternalWorkflowExecution = actions.SwfRequestCancelExternalWorkflowExecution()
    RequestCancelWorkflowExecution = actions.SwfRequestCancelWorkflowExecution()
    RespondActivityTaskCanceled = actions.SwfRespondActivityTaskCanceled()
    RespondActivityTaskCompleted = actions.SwfRespondActivityTaskCompleted()
    RespondActivityTaskFailed = actions.SwfRespondActivityTaskFailed()
    RespondDecisionTaskCompleted = actions.SwfRespondDecisionTaskCompleted()
    ScheduleActivityTask = actions.SwfScheduleActivityTask()
    SignalExternalWorkflowExecution = actions.SwfSignalExternalWorkflowExecution()
    SignalWorkflowExecution = actions.SwfSignalWorkflowExecution()
    StartChildWorkflowExecution = actions.SwfStartChildWorkflowExecution()
    StartTimer = actions.SwfStartTimer()
    StartWorkflowExecution = actions.SwfStartWorkflowExecution()
    TerminateWorkflowExecution = actions.SwfTerminateWorkflowExecution()


class Tag:
    all = IamAction("tag", all=True)
    GetResources = actions.TagGetResources()
    GetTagKeys = actions.TagGetTagKeys()
    GetTagValues = actions.TagGetTagValues()
    TagResources = actions.TagTagResources()
    UntagResources = actions.TagUntagResources()


class Transcribe:
    all = IamAction("transcribe", all=True)
    GetTranscriptionJob = actions.TranscribeGetTranscriptionJob()
    ListTranscriptionJobs = actions.TranscribeListTranscriptionJobs()
    StartTranscriptionJob = actions.TranscribeStartTranscriptionJob()


class Translate:
    all = IamAction("translate", all=True)
    TranslateText = actions.TranslateTranslateText()


class TrustedAdvisor:
    all = IamAction("trustedadvisor", all=True)
    DescribeCheckItems = actions.TrustedadvisorDescribeCheckItems()
    DescribeCheckRefreshStatuses = actions.TrustedadvisorDescribeCheckRefreshStatuses()
    DescribeCheckSummaries = actions.TrustedadvisorDescribeCheckSummaries()
    DescribeNotificationPreferences = actions.TrustedadvisorDescribeNotificationPreferences()
    ExcludeCheckItems = actions.TrustedadvisorExcludeCheckItems()
    IncludeCheckItems = actions.TrustedadvisorIncludeCheckItems()
    RefreshCheck = actions.TrustedadvisorRefreshCheck()
    UpdateNotificationPreferences = actions.TrustedadvisorUpdateNotificationPreferences()


class WafRegional:
    all = IamAction("waf-regional", all=True)
    AssociateWebACL = actions.WafRegionalAssociateWebACL()
    CreateByteMatchSet = actions.WafRegionalCreateByteMatchSet()
    CreateGeoMatchSet = actions.WafRegionalCreateGeoMatchSet()
    CreateIPSet = actions.WafRegionalCreateIPSet()
    CreateRateBasedRule = actions.WafRegionalCreateRateBasedRule()
    CreateRegexMatchSet = actions.WafRegionalCreateRegexMatchSet()
    CreateRegexPatternSet = actions.WafRegionalCreateRegexPatternSet()
    CreateRule = actions.WafRegionalCreateRule()
    CreateSizeConstraintSet = actions.WafRegionalCreateSizeConstraintSet()
    CreateSqlInjectionMatchSet = actions.WafRegionalCreateSqlInjectionMatchSet()
    CreateWebACL = actions.WafRegionalCreateWebACL()
    CreateXssMatchSet = actions.WafRegionalCreateXssMatchSet()
    DeleteByteMatchSet = actions.WafRegionalDeleteByteMatchSet()
    DeleteGeoMatchSet = actions.WafRegionalDeleteGeoMatchSet()
    DeleteIPSet = actions.WafRegionalDeleteIPSet()
    DeleteRateBasedRule = actions.WafRegionalDeleteRateBasedRule()
    DeleteRegexMatchSet = actions.WafRegionalDeleteRegexMatchSet()
    DeleteRegexPatternSet = actions.WafRegionalDeleteRegexPatternSet()
    DeleteRule = actions.WafRegionalDeleteRule()
    DeleteSizeConstraintSet = actions.WafRegionalDeleteSizeConstraintSet()
    DeleteSqlInjectionMatchSet = actions.WafRegionalDeleteSqlInjectionMatchSet()
    DeleteWebACL = actions.WafRegionalDeleteWebACL()
    DeleteXssMatchSet = actions.WafRegionalDeleteXssMatchSet()
    DisassociateWebACL = actions.WafRegionalDisassociateWebACL()
    GetByteMatchSet = actions.WafRegionalGetByteMatchSet()
    GetChangeToken = actions.WafRegionalGetChangeToken()
    GetChangeTokenStatus = actions.WafRegionalGetChangeTokenStatus()
    GetGeoMatchSet = actions.WafRegionalGetGeoMatchSet()
    GetIPSet = actions.WafRegionalGetIPSet()
    GetRateBasedRule = actions.WafRegionalGetRateBasedRule()
    GetRateBasedRuleManagedKeys = actions.WafRegionalGetRateBasedRuleManagedKeys()
    GetRegexMatchSet = actions.WafRegionalGetRegexMatchSet()
    GetRegexPatternSet = actions.WafRegionalGetRegexPatternSet()
    GetRule = actions.WafRegionalGetRule()
    GetSampledRequests = actions.WafRegionalGetSampledRequests()
    GetSizeConstraintSet = actions.WafRegionalGetSizeConstraintSet()
    GetSqlInjectionMatchSet = actions.WafRegionalGetSqlInjectionMatchSet()
    GetWebACL = actions.WafRegionalGetWebACL()
    GetWebACLForResource = actions.WafRegionalGetWebACLForResource()
    GetXssMatchSet = actions.WafRegionalGetXssMatchSet()
    ListByteMatchSets = actions.WafRegionalListByteMatchSets()
    ListGeoMatchSets = actions.WafRegionalListGeoMatchSets()
    ListIPSets = actions.WafRegionalListIPSets()
    ListRateBasedRules = actions.WafRegionalListRateBasedRules()
    ListRegexMatchSets = actions.WafRegionalListRegexMatchSets()
    ListRegexPatternSets = actions.WafRegionalListRegexPatternSets()
    ListResourcesForWebACL = actions.WafRegionalListResourcesForWebACL()
    ListRules = actions.WafRegionalListRules()
    ListSizeConstraintSets = actions.WafRegionalListSizeConstraintSets()
    ListSqlInjectionMatchSets = actions.WafRegionalListSqlInjectionMatchSets()
    ListWebACLs = actions.WafRegionalListWebACLs()
    ListXssMatchSets = actions.WafRegionalListXssMatchSets()
    UpdateByteMatchSet = actions.WafRegionalUpdateByteMatchSet()
    UpdateGeoMatchSet = actions.WafRegionalUpdateGeoMatchSet()
    UpdateIPSet = actions.WafRegionalUpdateIPSet()
    UpdateRateBasedRule = actions.WafRegionalUpdateRateBasedRule()
    UpdateRegexMatchSet = actions.WafRegionalUpdateRegexMatchSet()
    UpdateRegexPatternSet = actions.WafRegionalUpdateRegexPatternSet()
    UpdateRule = actions.WafRegionalUpdateRule()
    UpdateSizeConstraintSet = actions.WafRegionalUpdateSizeConstraintSet()
    UpdateSqlInjectionMatchSet = actions.WafRegionalUpdateSqlInjectionMatchSet()
    UpdateWebACL = actions.WafRegionalUpdateWebACL()
    UpdateXssMatchSet = actions.WafRegionalUpdateXssMatchSet()


class Waf:
    all = IamAction("waf", all=True)
    CreateByteMatchSet = actions.WafCreateByteMatchSet()
    CreateGeoMatchSet = actions.WafCreateGeoMatchSet()
    CreateIPSet = actions.WafCreateIPSet()
    CreateRateBasedRule = actions.WafCreateRateBasedRule()
    CreateRegexMatchSet = actions.WafCreateRegexMatchSet()
    CreateRegexPatternSet = actions.WafCreateRegexPatternSet()
    CreateRule = actions.WafCreateRule()
    CreateSizeConstraintSet = actions.WafCreateSizeConstraintSet()
    CreateSqlInjectionMatchSet = actions.WafCreateSqlInjectionMatchSet()
    CreateWebACL = actions.WafCreateWebACL()
    CreateXssMatchSet = actions.WafCreateXssMatchSet()
    DeleteByteMatchSet = actions.WafDeleteByteMatchSet()
    DeleteGeoMatchSet = actions.WafDeleteGeoMatchSet()
    DeleteIPSet = actions.WafDeleteIPSet()
    DeleteRateBasedRule = actions.WafDeleteRateBasedRule()
    DeleteRegexMatchSet = actions.WafDeleteRegexMatchSet()
    DeleteRegexPatternSet = actions.WafDeleteRegexPatternSet()
    DeleteRule = actions.WafDeleteRule()
    DeleteSizeConstraintSet = actions.WafDeleteSizeConstraintSet()
    DeleteSqlInjectionMatchSet = actions.WafDeleteSqlInjectionMatchSet()
    DeleteWebACL = actions.WafDeleteWebACL()
    DeleteXssMatchSet = actions.WafDeleteXssMatchSet()
    GetByteMatchSet = actions.WafGetByteMatchSet()
    GetChangeToken = actions.WafGetChangeToken()
    GetChangeTokenStatus = actions.WafGetChangeTokenStatus()
    GetGeoMatchSet = actions.WafGetGeoMatchSet()
    GetIPSet = actions.WafGetIPSet()
    GetRateBasedRule = actions.WafGetRateBasedRule()
    GetRateBasedRuleManagedKeys = actions.WafGetRateBasedRuleManagedKeys()
    GetRegexMatchSet = actions.WafGetRegexMatchSet()
    GetRegexPatternSet = actions.WafGetRegexPatternSet()
    GetRule = actions.WafGetRule()
    GetSampledRequests = actions.WafGetSampledRequests()
    GetSizeConstraintSet = actions.WafGetSizeConstraintSet()
    GetSqlInjectionMatchSet = actions.WafGetSqlInjectionMatchSet()
    GetWebACL = actions.WafGetWebACL()
    GetXssMatchSet = actions.WafGetXssMatchSet()
    ListByteMatchSets = actions.WafListByteMatchSets()
    ListGeoMatchSets = actions.WafListGeoMatchSets()
    ListIPSets = actions.WafListIPSets()
    ListRateBasedRules = actions.WafListRateBasedRules()
    ListRegexMatchSets = actions.WafListRegexMatchSets()
    ListRegexPatternSets = actions.WafListRegexPatternSets()
    ListRules = actions.WafListRules()
    ListSizeConstraintSets = actions.WafListSizeConstraintSets()
    ListSqlInjectionMatchSets = actions.WafListSqlInjectionMatchSets()
    ListWebACLs = actions.WafListWebACLs()
    ListXssMatchSets = actions.WafListXssMatchSets()
    UpdateByteMatchSet = actions.WafUpdateByteMatchSet()
    UpdateGeoMatchSet = actions.WafUpdateGeoMatchSet()
    UpdateIPSet = actions.WafUpdateIPSet()
    UpdateRateBasedRule = actions.WafUpdateRateBasedRule()
    UpdateRegexMatchSet = actions.WafUpdateRegexMatchSet()
    UpdateRegexPatternSet = actions.WafUpdateRegexPatternSet()
    UpdateRule = actions.WafUpdateRule()
    UpdateSizeConstraintSet = actions.WafUpdateSizeConstraintSet()
    UpdateSqlInjectionMatchSet = actions.WafUpdateSqlInjectionMatchSet()
    UpdateWebACL = actions.WafUpdateWebACL()
    UpdateXssMatchSet = actions.WafUpdateXssMatchSet()


class Wam:
    all = IamAction("wam", all=True)
    AuthenticatePackager = actions.WamAuthenticatePackager()


class WorkDocs:
    all = IamAction("workdocs", all=True)
    AbortDocumentVersionUpload = actions.WorkdocsAbortDocumentVersionUpload()
    ActivateUser = actions.WorkdocsActivateUser()
    AddResourcePermissions = actions.WorkdocsAddResourcePermissions()
    AddUserToGroup = actions.WorkdocsAddUserToGroup()
    CheckAlias = actions.WorkdocsCheckAlias()
    CreateFolder = actions.WorkdocsCreateFolder()
    CreateInstance = actions.WorkdocsCreateInstance()
    CreateNotificationSubscription = actions.WorkdocsCreateNotificationSubscription()
    CreateUser = actions.WorkdocsCreateUser()
    DeactivateUser = actions.WorkdocsDeactivateUser()
    DeleteDocument = actions.WorkdocsDeleteDocument()
    DeleteFolder = actions.WorkdocsDeleteFolder()
    DeleteFolderContents = actions.WorkdocsDeleteFolderContents()
    DeleteInstance = actions.WorkdocsDeleteInstance()
    DeleteNotificationSubscription = actions.WorkdocsDeleteNotificationSubscription()
    DeleteUser = actions.WorkdocsDeleteUser()
    DeregisterDirectory = actions.WorkdocsDeregisterDirectory()
    DescribeAvailableDirectories = actions.WorkdocsDescribeAvailableDirectories()
    DescribeDocumentVersions = actions.WorkdocsDescribeDocumentVersions()
    DescribeFolderContents = actions.WorkdocsDescribeFolderContents()
    DescribeInstances = actions.WorkdocsDescribeInstances()
    DescribeNotificationSubscriptions = actions.WorkdocsDescribeNotificationSubscriptions()
    DescribeResourcePermissions = actions.WorkdocsDescribeResourcePermissions()
    DescribeUsers = actions.WorkdocsDescribeUsers()
    GetDocument = actions.WorkdocsGetDocument()
    GetDocumentPath = actions.WorkdocsGetDocumentPath()
    GetDocumentVersion = actions.WorkdocsGetDocumentVersion()
    GetFolder = actions.WorkdocsGetFolder()
    GetFolderPath = actions.WorkdocsGetFolderPath()
    InitiateDocumentVersionUpload = actions.WorkdocsInitiateDocumentVersionUpload()
    RegisterDirectory = actions.WorkdocsRegisterDirectory()
    RemoveAllResourcePermissions = actions.WorkdocsRemoveAllResourcePermissions()
    RemoveResourcePermission = actions.WorkdocsRemoveResourcePermission()
    RemoveUserFromGroup = actions.WorkdocsRemoveUserFromGroup()
    UpdateDocument = actions.WorkdocsUpdateDocument()
    UpdateDocumentVersion = actions.WorkdocsUpdateDocumentVersion()
    UpdateFolder = actions.WorkdocsUpdateFolder()
    UpdateInstanceAlias = actions.WorkdocsUpdateInstanceAlias()
    UpdateUser = actions.WorkdocsUpdateUser()


class WorkMail:
    all = IamAction("workmail", all=True)
    AddMembersToGroup = actions.WorkmailAddMembersToGroup()
    CreateGroup = actions.WorkmailCreateGroup()
    CreateMailDomain = actions.WorkmailCreateMailDomain()
    CreateMailUser = actions.WorkmailCreateMailUser()
    CreateOrganization = actions.WorkmailCreateOrganization()
    CreateResource = actions.WorkmailCreateResource()
    DeleteMailDomain = actions.WorkmailDeleteMailDomain()
    DeleteMobileDevice = actions.WorkmailDeleteMobileDevice()
    DeleteOrganization = actions.WorkmailDeleteOrganization()
    DescribeDirectories = actions.WorkmailDescribeDirectories()
    DescribeKmsKeys = actions.WorkmailDescribeKmsKeys()
    DescribeMailDomains = actions.WorkmailDescribeMailDomains()
    DescribeMailGroups = actions.WorkmailDescribeMailGroups()
    DescribeMailUsers = actions.WorkmailDescribeMailUsers()
    DescribeOrganizations = actions.WorkmailDescribeOrganizations()
    DisableMailGroups = actions.WorkmailDisableMailGroups()
    DisableMailUsers = actions.WorkmailDisableMailUsers()
    EnableMailDomain = actions.WorkmailEnableMailDomain()
    EnableMailGroups = actions.WorkmailEnableMailGroups()
    EnableMailUsers = actions.WorkmailEnableMailUsers()
    GetMailDomainDetails = actions.WorkmailGetMailDomainDetails()
    GetMailGroupDetails = actions.WorkmailGetMailGroupDetails()
    GetMailUserDetails = actions.WorkmailGetMailUserDetails()
    GetMobileDeviceDetails = actions.WorkmailGetMobileDeviceDetails()
    GetMobileDevicesForUser = actions.WorkmailGetMobileDevicesForUser()
    GetMobilePolicyDetails = actions.WorkmailGetMobilePolicyDetails()
    ListMembersInMailGroup = actions.WorkmailListMembersInMailGroup()
    RemoveMembersFromGroup = actions.WorkmailRemoveMembersFromGroup()
    ResetUserPassword = actions.WorkmailResetUserPassword()
    SearchMembers = actions.WorkmailSearchMembers()
    SetAdmin = actions.WorkmailSetAdmin()
    SetDefaultMailDomain = actions.WorkmailSetDefaultMailDomain()
    SetMailGroupDetails = actions.WorkmailSetMailGroupDetails()
    SetMailUserDetails = actions.WorkmailSetMailUserDetails()
    SetMobilePolicyDetails = actions.WorkmailSetMobilePolicyDetails()
    WipeMobileDevice = actions.WorkmailWipeMobileDevice()


class Workspaces:
    all = IamAction("workspaces", all=True)
    CreateTags = actions.WorkspacesCreateTags()
    CreateWorkspaces = actions.WorkspacesCreateWorkspaces()
    DeleteTags = actions.WorkspacesDeleteTags()
    DescribeTags = actions.WorkspacesDescribeTags()
    DescribeWorkspaceBundles = actions.WorkspacesDescribeWorkspaceBundles()
    DescribeWorkspaceDirectories = actions.WorkspacesDescribeWorkspaceDirectories()
    DescribeWorkspaces = actions.WorkspacesDescribeWorkspaces()
    DescribeWorkspacesConnectionStatus = actions.WorkspacesDescribeWorkspacesConnectionStatus()
    ModifyWorkspaceProperties = actions.WorkspacesModifyWorkspaceProperties()
    RebootWorkspaces = actions.WorkspacesRebootWorkspaces()
    RebuildWorkspaces = actions.WorkspacesRebuildWorkspaces()
    StartWorkspaces = actions.WorkspacesStartWorkspaces()
    StopWorkspaces = actions.WorkspacesStopWorkspaces()
    TerminateWorkspaces = actions.WorkspacesTerminateWorkspaces()


class Xray:
    all = IamAction("xray", all=True)
    BatchGetTraces = actions.XrayBatchGetTraces()
    GetServiceGraph = actions.XrayGetServiceGraph()
    GetTraceGraph = actions.XrayGetTraceGraph()
    GetTraceSummaries = actions.XrayGetTraceSummaries()
    PutTelemetryRecords = actions.XrayPutTelemetryRecords()
    PutTraceSegments = actions.XrayPutTraceSegments()
