"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineExportDialog = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const RuntimeConfigSelect_1 = __importDefault(require("./RuntimeConfigSelect"));
const FileTypeSelect = ({ fileTypes, temporarilyDisablePythonDSLForKFPSpecificPipelines }) => {
    // TODO: remove temporary workaround for KFP Python DSL export option
    // See https://github.com/elyra-ai/elyra/issues/1760 for context.
    const _fileTypes = fileTypes.filter(t => {
        if (temporarilyDisablePythonDSLForKFPSpecificPipelines && t.id === 'py') {
            return false;
        }
        return true;
    });
    return (jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "pipeline_filetype" }, { children: "Export Pipeline as:" }), void 0),
            jsx_runtime_1.jsx("br", {}, void 0),
            jsx_runtime_1.jsx("select", Object.assign({ id: "pipeline_filetype", name: "pipeline_filetype", className: "elyra-form-export-filetype", "data-form-required": true }, { children: _fileTypes.map(f => (jsx_runtime_1.jsx("option", Object.assign({ value: f.id }, { children: f.display_name }), f.id))) }), void 0)] }, void 0));
};
const PipelineExportDialog = ({ runtimeData, runtimeTypeInfo, pipelineType }) => {
    return (jsx_runtime_1.jsxs("form", Object.assign({ className: "elyra-dialog-form" }, { children: [jsx_runtime_1.jsx(RuntimeConfigSelect_1.default, Object.assign({ runtimeData: runtimeData, pipelineType: pipelineType }, { children: (platform) => {
                    var _a;
                    const info = runtimeTypeInfo.find(i => i.id === platform);
                    return (jsx_runtime_1.jsx(FileTypeSelect, { fileTypes: (_a = info === null || info === void 0 ? void 0 : info.export_file_types) !== null && _a !== void 0 ? _a : [], temporarilyDisablePythonDSLForKFPSpecificPipelines: platform === 'KUBEFLOW_PIPELINES' }, void 0));
                } }), void 0),
            jsx_runtime_1.jsx("input", { type: "checkbox", className: "elyra-Dialog-checkbox", id: "overwrite", name: "overwrite" }, void 0),
            jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "overwrite" }, { children: "Replace if file already exists" }), void 0),
            jsx_runtime_1.jsx("br", {}, void 0)] }), void 0));
};
exports.PipelineExportDialog = PipelineExportDialog;
//# sourceMappingURL=PipelineExportDialog.js.map