"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const React = __importStar(require("react"));
const RUN_LOCALLY_ID = '__elyra_local__';
const RuntimeConfigSelect = ({ runtimeData: { platforms, allowLocal }, pipelineType, children }) => {
    var _a, _b, _c;
    const filteredPlatforms = platforms.filter(p => p.configs.length > 0);
    if (allowLocal) {
        filteredPlatforms.unshift({
            id: RUN_LOCALLY_ID,
            displayName: 'Run in-place locally',
            configs: []
        });
    }
    // NOTE: platform is only selectable if pipelineType is undefined
    const [platform, setPlatform] = React.useState(pipelineType !== null && pipelineType !== void 0 ? pipelineType : (_a = filteredPlatforms[0]) === null || _a === void 0 ? void 0 : _a.id);
    const handleChange = (e) => {
        setPlatform(e.target.value);
    };
    const configs = (_c = (_b = filteredPlatforms.find(p => p.id === platform)) === null || _b === void 0 ? void 0 : _b.configs) !== null && _c !== void 0 ? _c : [];
    configs.sort((a, b) => a.displayName.localeCompare(b.displayName));
    return (jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: [!pipelineType && (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_platform" }, { children: "Runtime Platform:" }), void 0),
                    jsx_runtime_1.jsx("br", {}, void 0),
                    jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", value: platform, onChange: handleChange }, { children: filteredPlatforms.map(p => (jsx_runtime_1.jsx("option", Object.assign({ value: p.id }, { children: p.displayName }), p.id))) }), void 0)] }, void 0)),
            jsx_runtime_1.jsxs("div", Object.assign({ style: { display: platform === RUN_LOCALLY_ID ? 'none' : 'block' } }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_config" }, { children: "Runtime Configuration:" }), void 0),
                    jsx_runtime_1.jsx("br", {}, void 0),
                    jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config" }, { children: configs.map(c => (jsx_runtime_1.jsx("option", Object.assign({ value: c.id }, { children: c.displayName }), c.id))) }), void 0)] }), void 0), children === null || children === void 0 ? void 0 : children(platform)] }, void 0));
};
exports.default = RuntimeConfigSelect;
//# sourceMappingURL=RuntimeConfigSelect.js.map