"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearPipeline = exports.unsupportedFile = exports.pipelineOutOfDate = exports.unsupportedVersion = exports.elyraOutOfDate = exports.unknownError = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const apputils_1 = require("@jupyterlab/apputils");
const unknownError = (message) => ({
    title: 'Load pipeline failed!',
    body: message,
    buttons: [apputils_1.Dialog.okButton()]
});
exports.unknownError = unknownError;
exports.elyraOutOfDate = {
    title: 'Load pipeline failed!',
    body: `This pipeline corresponds to a more recent version of Elyra and cannot be used until Elyra has been upgraded.`,
    buttons: [apputils_1.Dialog.okButton()]
};
exports.unsupportedVersion = {
    title: 'Load pipeline failed!',
    body: 'This pipeline has an unrecognizable version.',
    buttons: [apputils_1.Dialog.okButton()]
};
exports.pipelineOutOfDate = {
    title: 'Migrate pipeline?',
    body: (jsx_runtime_1.jsxs("p", { children: ["This pipeline corresponds to an older version of Elyra and needs to be migrated.", jsx_runtime_1.jsx("br", {}, void 0), "Although the pipeline can be further edited and/or submitted after its update,", jsx_runtime_1.jsx("br", {}, void 0), "the migration will not be completed until the pipeline has been saved within the editor.", jsx_runtime_1.jsx("br", {}, void 0),
            jsx_runtime_1.jsx("br", {}, void 0), "Proceed with migration?"] }, void 0)),
    buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()]
};
exports.unsupportedFile = {
    title: 'Unsupported File(s)',
    body: 'Only supported files have been added to the pipeline.',
    buttons: [apputils_1.Dialog.okButton()]
};
exports.clearPipeline = {
    title: 'Clear Pipeline',
    body: 'Are you sure you want to clear the pipeline?',
    buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton({ label: 'Clear' })]
};
//# sourceMappingURL=dialogs.js.map