"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const metadata_common_1 = require("@elyra/metadata-common");
const pipeline_editor_1 = require("@elyra/pipeline-editor");
const services_1 = require("@elyra/services");
const ui_components_1 = require("@elyra/ui-components");
const application_1 = require("@jupyterlab/application");
const apputils_1 = require("@jupyterlab/apputils");
const filebrowser_1 = require("@jupyterlab/filebrowser");
const launcher_1 = require("@jupyterlab/launcher");
const mainmenu_1 = require("@jupyterlab/mainmenu");
const ui_components_2 = require("@jupyterlab/ui-components");
const PipelineEditorWidget_1 = require("./PipelineEditorWidget");
const PipelineService_1 = require("./PipelineService");
const RuntimeImagesWidget_1 = require("./RuntimeImagesWidget");
const RuntimesWidget_1 = require("./RuntimesWidget");
const SubmitFileButtonExtension_1 = require("./SubmitFileButtonExtension");
require("../style/index.css");
const PIPELINE_EDITOR = 'Pipeline Editor';
const PIPELINE = 'pipeline';
const PIPELINE_EDITOR_NAMESPACE = 'elyra-pipeline-editor-extension';
const COMPONENT_CATALOGS_SCHEMASPACE = 'component-catalogs';
const createRemoteIcon = ({ name, url }) => __awaiter(void 0, void 0, void 0, function* () {
    const svgstr = yield services_1.RequestHandler.makeServerRequest(url, {
        method: 'GET',
        type: 'text'
    });
    return new ui_components_2.LabIcon({ name, svgstr });
});
/**
 * Initialization data for the pipeline-editor-extension extension.
 */
const extension = {
    id: PIPELINE,
    autoStart: true,
    requires: [
        apputils_1.ICommandPalette,
        launcher_1.ILauncher,
        filebrowser_1.IFileBrowserFactory,
        application_1.ILayoutRestorer,
        mainmenu_1.IMainMenu
    ],
    optional: [apputils_1.IThemeManager],
    activate: (app, palette, launcher, browserFactory, restorer, menu, themeManager) => {
        console.log('Elyra - pipeline-editor extension is activated!');
        // Set up new widget Factory for .pipeline files
        const pipelineEditorFactory = new PipelineEditorWidget_1.PipelineEditorFactory({
            name: PIPELINE_EDITOR,
            fileTypes: [PIPELINE],
            defaultFor: [PIPELINE],
            shell: app.shell,
            commands: app.commands,
            browserFactory: browserFactory,
            serviceManager: app.serviceManager
        });
        // Add the default behavior of opening the widget for .pipeline files
        app.docRegistry.addFileType({
            name: PIPELINE,
            displayName: 'Pipeline',
            extensions: ['.pipeline'],
            icon: ui_components_1.pipelineIcon
        });
        app.docRegistry.addWidgetFactory(pipelineEditorFactory);
        const tracker = new apputils_1.WidgetTracker({
            namespace: PIPELINE_EDITOR_NAMESPACE
        });
        pipelineEditorFactory.widgetCreated.connect((sender, widget) => {
            void tracker.add(widget);
            // Notify the widget tracker if restore data needs to update
            widget.context.pathChanged.connect(() => {
                void tracker.save(widget);
            });
        });
        // Handle state restoration
        void restorer.restore(tracker, {
            command: PipelineEditorWidget_1.commandIDs.openDocManager,
            args: widget => ({
                path: widget.context.path,
                factory: PIPELINE_EDITOR
            }),
            name: widget => widget.context.path
        });
        // Add command to add file to pipeline
        const addFileToPipelineCommand = PipelineEditorWidget_1.commandIDs.addFileToPipeline;
        app.commands.addCommand(addFileToPipelineCommand, {
            label: 'Add File to Pipeline',
            icon: ui_components_2.addIcon,
            execute: args => {
                pipelineEditorFactory.addFileToPipelineSignal.emit(args);
            }
        });
        app.contextMenu.addItem({
            selector: '[data-file-type="notebook"]',
            command: addFileToPipelineCommand
        });
        app.contextMenu.addItem({
            selector: '[data-file-type="python"]',
            command: addFileToPipelineCommand
        });
        app.contextMenu.addItem({
            selector: '[data-file-type="r"]',
            command: addFileToPipelineCommand
        });
        // Add an application command
        const openPipelineEditorCommand = PipelineEditorWidget_1.commandIDs.openPipelineEditor;
        app.commands.addCommand(openPipelineEditorCommand, {
            label: (args) => {
                var _a, _b;
                if (args.isPalette) {
                    return `New ${PIPELINE_EDITOR}`;
                }
                if (((_a = args.runtimeType) === null || _a === void 0 ? void 0 : _a.id) === 'LOCAL') {
                    return `Generic ${PIPELINE_EDITOR}`;
                }
                if (args.isMenu) {
                    return `${(_b = args.runtimeType) === null || _b === void 0 ? void 0 : _b.display_name} ${PIPELINE_EDITOR}`;
                }
                return PIPELINE_EDITOR;
            },
            caption: (args) => {
                var _a, _b;
                if (((_a = args.runtimeType) === null || _a === void 0 ? void 0 : _a.id) === 'LOCAL') {
                    return `Generic ${PIPELINE_EDITOR}`;
                }
                return `${(_b = args.runtimeType) === null || _b === void 0 ? void 0 : _b.display_name} ${PIPELINE_EDITOR}`;
            },
            iconLabel: (args) => {
                var _a, _b;
                if (args.isPalette) {
                    return '';
                }
                if (((_a = args.runtimeType) === null || _a === void 0 ? void 0 : _a.id) === 'LOCAL') {
                    return `Generic ${PIPELINE_EDITOR}`;
                }
                return `${(_b = args.runtimeType) === null || _b === void 0 ? void 0 : _b.display_name} ${PIPELINE_EDITOR}`;
            },
            icon: (args) => {
                var _a;
                if (args.isPalette) {
                    return undefined;
                }
                return (_a = args.runtimeType) === null || _a === void 0 ? void 0 : _a.icon;
            },
            execute: (args) => {
                // Creates blank file, then opens it in a new window
                app.commands
                    .execute(PipelineEditorWidget_1.commandIDs.newDocManager, {
                    type: 'file',
                    path: browserFactory.defaultBrowser.model.path,
                    ext: '.pipeline'
                })
                    .then((model) => __awaiter(void 0, void 0, void 0, function* () {
                    var _a;
                    const platformId = (_a = args.runtimeType) === null || _a === void 0 ? void 0 : _a.id;
                    const runtime_type = platformId === 'LOCAL' ? undefined : platformId;
                    const pipelineJson = {
                        doc_type: 'pipeline',
                        version: '3.0',
                        json_schema: 'http://api.dataplatform.ibm.com/schemas/common-pipeline/pipeline-flow/pipeline-flow-v3-schema.json',
                        id: 'elyra-auto-generated-pipeline',
                        primary_pipeline: 'primary',
                        pipelines: [
                            {
                                id: 'primary',
                                nodes: [],
                                app_data: {
                                    ui_data: {
                                        comments: []
                                    },
                                    version: pipeline_editor_1.PIPELINE_CURRENT_VERSION,
                                    runtime_type
                                },
                                runtime_ref: ''
                            }
                        ],
                        schemas: []
                    };
                    const newWidget = yield app.commands.execute(PipelineEditorWidget_1.commandIDs.openDocManager, {
                        path: model.path,
                        factory: PIPELINE_EDITOR
                    });
                    newWidget.context.ready.then(() => {
                        newWidget.context.model.fromJSON(pipelineJson);
                        app.commands.execute(PipelineEditorWidget_1.commandIDs.saveDocManager, {
                            path: model.path
                        });
                    });
                }));
            }
        });
        // Add the command to the palette.
        palette.addItem({
            command: openPipelineEditorCommand,
            args: { isPalette: true },
            category: 'Elyra'
        });
        PipelineService_1.PipelineService.getRuntimeTypes()
            .then((types) => __awaiter(void 0, void 0, void 0, function* () {
            const promises = types.map((t) => __awaiter(void 0, void 0, void 0, function* () {
                return Object.assign(Object.assign({}, t), { icon: yield createRemoteIcon({
                        name: `elyra:platform:${t.id}`,
                        url: t.icon
                    }) });
            }));
            const resolvedTypes = yield Promise.all(promises);
            // Add the command to the launcher
            if (launcher) {
                for (const t of resolvedTypes) {
                    launcher.add({
                        command: openPipelineEditorCommand,
                        category: 'Elyra',
                        args: { runtimeType: t },
                        rank: t.id === 'LOCAL' ? 1 : 2
                    });
                    menu.fileMenu.newMenu.addGroup([
                        {
                            command: openPipelineEditorCommand,
                            args: { runtimeType: t, isMenu: true }
                        }
                    ], t.id === 'LOCAL' ? 30 : 31);
                }
            }
        }))
            .catch(error => ui_components_1.RequestErrors.serverError(error));
        // SubmitNotebookButtonExtension initialization code
        const notebookButtonExtension = new SubmitFileButtonExtension_1.SubmitFileButtonExtension();
        app.docRegistry.addWidgetExtension('Notebook', notebookButtonExtension);
        app.contextMenu.addItem({
            selector: '.jp-Notebook',
            command: PipelineEditorWidget_1.commandIDs.submitNotebook,
            rank: -0.5
        });
        // SubmitScriptButtonExtension initialization code
        const scriptButtonExtension = new SubmitFileButtonExtension_1.SubmitFileButtonExtension();
        app.docRegistry.addWidgetExtension('Python Editor', scriptButtonExtension);
        app.contextMenu.addItem({
            selector: '.elyra-ScriptEditor',
            command: PipelineEditorWidget_1.commandIDs.submitScript,
            rank: -0.5
        });
        app.docRegistry.addWidgetExtension('R Editor', scriptButtonExtension);
        app.contextMenu.addItem({
            selector: '.elyra-ScriptEditor',
            command: PipelineEditorWidget_1.commandIDs.submitScript,
            rank: -0.5
        });
        const runtimesWidget = new RuntimesWidget_1.RuntimesWidget({
            app,
            themeManager,
            display_name: 'Runtimes',
            schemaspace: PipelineService_1.RUNTIMES_SCHEMASPACE,
            icon: ui_components_1.runtimesIcon,
            titleContext: 'runtime configuration',
            appendToTitle: true
        });
        const runtimesWidgetID = `elyra-metadata:${PipelineService_1.RUNTIMES_SCHEMASPACE}`;
        runtimesWidget.id = runtimesWidgetID;
        runtimesWidget.title.icon = ui_components_1.runtimesIcon;
        runtimesWidget.title.caption = 'Runtimes';
        restorer.add(runtimesWidget, runtimesWidgetID);
        app.shell.add(runtimesWidget, 'left', { rank: 950 });
        const runtimeImagesWidget = new RuntimeImagesWidget_1.RuntimeImagesWidget({
            app,
            themeManager,
            display_name: 'Runtime Images',
            schemaspace: RuntimeImagesWidget_1.RUNTIME_IMAGES_SCHEMASPACE,
            icon: ui_components_1.containerIcon,
            titleContext: 'runtime image'
        });
        const runtimeImagesWidgetID = `elyra-metadata:${RuntimeImagesWidget_1.RUNTIME_IMAGES_SCHEMASPACE}`;
        runtimeImagesWidget.id = runtimeImagesWidgetID;
        runtimeImagesWidget.title.icon = ui_components_1.containerIcon;
        runtimeImagesWidget.title.caption = 'Runtime Images';
        const componentCatalogWidget = new metadata_common_1.MetadataWidget({
            app,
            themeManager,
            display_name: 'Component Catalogs',
            schemaspace: COMPONENT_CATALOGS_SCHEMASPACE,
            icon: ui_components_1.componentCatalogIcon,
            titleContext: 'component catalog'
        });
        const componentCatalogWidgetID = `elyra-metadata:${COMPONENT_CATALOGS_SCHEMASPACE}`;
        componentCatalogWidget.id = componentCatalogWidgetID;
        componentCatalogWidget.title.icon = ui_components_1.componentCatalogIcon;
        componentCatalogWidget.title.caption = 'Component Catalogs';
        restorer.add(runtimeImagesWidget, runtimeImagesWidgetID);
        app.shell.add(runtimeImagesWidget, 'left', { rank: 951 });
        app.shell.add(componentCatalogWidget, 'left', { rank: 961 });
    }
};
exports.default = extension;
//# sourceMappingURL=index.js.map