"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePalette = exports.componentFetcher = exports.sortPalette = exports.useRuntimesSchema = exports.useRuntimeImages = exports.GENERIC_CATEGORY_ID = void 0;
const services_1 = require("@elyra/services");
const ui_components_1 = require("@elyra/ui-components");
const ui_components_2 = require("@jupyterlab/ui-components");
const immer_1 = __importDefault(require("immer"));
const swr_1 = __importDefault(require("swr"));
const PipelineService_1 = require("./PipelineService");
exports.GENERIC_CATEGORY_ID = 'Elyra';
const metadataFetcher = (key) => __awaiter(void 0, void 0, void 0, function* () {
    return yield services_1.MetadataService.getMetadata(key);
});
const useRuntimeImages = () => {
    const { data, error } = swr_1.default('runtime-images', metadataFetcher);
    data === null || data === void 0 ? void 0 : data.sort((a, b) => 0 - (a.name > b.name ? -1 : 1));
    return { data, error };
};
exports.useRuntimeImages = useRuntimeImages;
const schemaFetcher = (key) => __awaiter(void 0, void 0, void 0, function* () {
    return yield services_1.MetadataService.getSchema(key);
});
// TODO: type this
const useRuntimesSchema = () => {
    const { data, error } = swr_1.default('runtimes', schemaFetcher);
    return { data, error };
};
exports.useRuntimesSchema = useRuntimesSchema;
/**
 * Sort palette in place. Takes a list of categories each containing a list of
 * components.
 * - Categories: alphabetically by "label" (exception: "generic" always first)
 * - Components: alphabetically by "op" (where is component label stored?)
 */
const sortPalette = (palette) => {
    palette.categories.sort((a, b) => {
        if (a.id === exports.GENERIC_CATEGORY_ID) {
            return -1;
        }
        if (b.id === exports.GENERIC_CATEGORY_ID) {
            return 1;
        }
        return a.label.localeCompare(b.label, undefined, { numeric: true });
    });
    for (const components of palette.categories) {
        components.node_types.sort((a, b) => a.label.localeCompare(b.label, undefined, {
            numeric: true
        }));
    }
};
exports.sortPalette = sortPalette;
// TODO: This should be enabled through `extensions`
const NodeIcons = new Map([
    [
        'execute-notebook-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_2.notebookIcon.svgstr)
    ],
    [
        'execute-python-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_1.pyIcon.svgstr)
    ],
    [
        'execute-r-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_1.rIcon.svgstr)
    ]
]);
// TODO: We should decouple components and properties to support lazy loading.
// TODO: type this
const componentFetcher = (type) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;
    const palettePromise = services_1.RequestHandler.makeGetRequest(`elyra/pipeline/components/${type}`);
    const typesPromise = PipelineService_1.PipelineService.getRuntimeTypes();
    const [palette, types] = yield Promise.all([palettePromise, typesPromise]);
    // Gather list of component IDs to fetch properties for.
    const componentList = [];
    for (const category of palette.categories) {
        for (const node of category.node_types) {
            componentList.push(node.id);
        }
    }
    const propertiesPromises = componentList.map((componentID) => __awaiter(void 0, void 0, void 0, function* () {
        const res = yield services_1.RequestHandler.makeGetRequest(`elyra/pipeline/components/${type}/${componentID}/properties`);
        return {
            id: componentID,
            properties: res
        };
    }));
    // load all of the properties in parallel instead of serially
    const properties = yield Promise.all(propertiesPromises);
    // inject properties
    for (const category of palette.categories) {
        // Use the runtime_type from the first node of the category to determine category
        // icon.
        // TODO: Ideally, this would be included in the category.
        const category_runtime_type = (_c = (_b = (_a = category.node_types) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.runtime_type) !== null && _c !== void 0 ? _c : 'LOCAL';
        const type = types.find((t) => t.id === category_runtime_type);
        const defaultIcon = `/${type === null || type === void 0 ? void 0 : type.icon}`;
        category.image = defaultIcon;
        for (const node of category.node_types) {
            // update icon
            let nodeIcon = NodeIcons.get(node.op);
            if (nodeIcon === undefined || nodeIcon === '') {
                nodeIcon = defaultIcon;
            }
            // Not sure which is needed...
            node.image = nodeIcon;
            node.app_data.image = nodeIcon;
            node.app_data.ui_data.image = nodeIcon;
            const prop = properties.find(p => p.id === node.id);
            node.app_data.properties = prop === null || prop === void 0 ? void 0 : prop.properties;
        }
    }
    exports.sortPalette(palette);
    return palette;
});
exports.componentFetcher = componentFetcher;
const usePalette = (type = 'local') => {
    const { data: runtimeImages, error: runtimeError } = exports.useRuntimeImages();
    const { data: palette, error: paletteError } = swr_1.default(type, exports.componentFetcher);
    let updatedPalette;
    if (palette !== undefined) {
        updatedPalette = immer_1.default(palette, (draft) => {
            for (const category of draft.categories) {
                for (const node of category.node_types) {
                    // update runtime images
                    const runtimeImageIndex = node.app_data.properties.uihints.parameter_info.findIndex((p) => p.parameter_ref === 'elyra_runtime_image');
                    const displayNames = (runtimeImages !== null && runtimeImages !== void 0 ? runtimeImages : []).map(i => i.display_name);
                    if (runtimeImageIndex !== -1) {
                        node.app_data.properties.uihints.parameter_info[runtimeImageIndex].data.items = displayNames;
                    }
                }
            }
        });
    }
    return { data: updatedPalette, error: runtimeError !== null && runtimeError !== void 0 ? runtimeError : paletteError };
};
exports.usePalette = usePalette;
//# sourceMappingURL=pipeline-hooks.js.map