import { IRuntime, ISchema } from './PipelineService';
export interface IRuntimeData {
    platforms: {
        id: string;
        displayName: string;
        configs: {
            id: string;
            displayName: string;
            processor: {
                id: string;
            };
        }[];
    }[];
    allowLocal: boolean;
}
export declare const createRuntimeData: ({ runtimes, schema, allowLocal }: {
    runtimes: IRuntime[];
    schema: ISchema[];
    allowLocal?: boolean | undefined;
}) => IRuntimeData;
export interface IConfigDetails {
    id: string;
    displayName: string;
    platform: {
        id: string;
        displayName: string;
    };
    processor: {
        id: string;
    };
}
export declare const getConfigDetails: (runtimeData: IRuntimeData, configId: string) => IConfigDetails | undefined;
