# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 8779317
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from uuid import UUID
from knowledge_stack.models.participant_type import ParticipantType
from knowledge_stack.models.tenant_participant_role import TenantParticipantRole
from typing import Optional, Set
from typing_extensions import Self

class RespParticipant(BaseModel):
    """
    Full participant representation.
    """ # noqa: E501
    id: UUID = Field(description="Participant ID")
    name: StrictStr = Field(description="Participant name")
    participant_type: ParticipantType = Field(description="Participant type (USER or AGENT)")
    description: Optional[StrictStr] = Field(default=None, description="Participant description")
    email: Optional[StrictStr] = Field(default=None, description="Participant email")
    idp_user_id: Optional[StrictStr] = Field(default=None, description="IdP user identifier if applicable")
    url: Optional[StrictStr] = Field(default=None, description="Agent URL if applicable")
    api_key: Optional[StrictStr] = Field(default=None, description="Agent API key if applicable")
    created_at: Optional[datetime] = Field(default=None, description="Creation timestamp")
    updated_at: Optional[datetime] = Field(default=None, description="Update timestamp")
    role: Optional[TenantParticipantRole] = Field(default=None, description="Tenant role for the participant")
    __properties: ClassVar[List[str]] = ["id", "name", "participant_type", "description", "email", "idp_user_id", "url", "api_key", "created_at", "updated_at", "role"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "participant_type": obj.get("participant_type"),
            "description": obj.get("description"),
            "email": obj.get("email"),
            "idp_user_id": obj.get("idp_user_id"),
            "url": obj.get("url"),
            "api_key": obj.get("api_key"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "role": obj.get("role")
        })
        return _obj


