# Copyright 2019 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Additional text-processing ops."""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

# Conditional Random Field
from tensorflow_addons.text.crf import crf_binary_score
from tensorflow_addons.text.crf import crf_decode
from tensorflow_addons.text.crf import crf_decode_backward
from tensorflow_addons.text.crf import crf_decode_forward
from tensorflow_addons.text.crf import crf_forward
from tensorflow_addons.text.crf import crf_log_likelihood
from tensorflow_addons.text.crf import crf_log_norm
from tensorflow_addons.text.crf import crf_multitag_sequence_score
from tensorflow_addons.text.crf import crf_sequence_score
from tensorflow_addons.text.crf import crf_unary_score
from tensorflow_addons.text.crf import viterbi_decode

# Skip Gram Sampling
from tensorflow_addons.text.skip_gram_ops import skip_gram_sample
from tensorflow_addons.text.skip_gram_ops import skip_gram_sample_with_text_vocab

# Parse Time

# Temporarily disable for windows
# Remove after: https://github.com/tensorflow/addons/issues/782
import os
if os.name != 'nt':
    from tensorflow_addons.text.parse_time_op import parse_time
