import os
import yaml
import time

local_path = os.path.dirname(os.path.realpath(__file__))
root_path = os.path.dirname(local_path)


class Config:
    def __init__(self):
        time_str = str(time.time()).replace('.', '')
        config_file_name = f'conf_{time_str}.yml'
        self.file_path = os.path.join(root_path, 'running', config_file_name)
        with open(self.file_path, 'w') as f:
            f.write('''common:
  base_url: null
  headers: null
  project: null
  web_url: null
            ''')

    def __getitem__(self, key):
        with open(self.file_path, "r", encoding="utf-8") as f:
            yaml_data = yaml.load(f.read(), Loader=yaml.FullLoader)
        try:
            return yaml_data['common'][key]
        except:
            return None

    def __setitem__(self, key, value):
        with open(self.file_path, "r", encoding="utf-8") as f:
            yaml_data = yaml.load(f.read(), Loader=yaml.FullLoader)
        # if key in yaml_data['common']:
        #     yaml_data['common'][key] = value
        # else:
        #     raise KeyError(f'{key} not in {yaml_data["common"]}')
        yaml_data['common'][key] = value
        with open(self.file_path, 'w', encoding="utf-8") as f:
            yaml.dump(yaml_data, f)

    def __len__(self):
        with open(self.file_path, "r", encoding="utf-8") as f:
            yaml_data = yaml.load(f.read(), Loader=yaml.FullLoader)
        return len(yaml_data['common'])

    def __repr__(self):  # 用于终端显示，与本博文关系不大
        with open(self.file_path, "r", encoding="utf-8") as f:
            yaml_data = yaml.load(f.read(), Loader=yaml.FullLoader)
        return str(yaml_data['common'])

    # def reset(self):
    #     with open(self.file_path, "r", encoding="utf-8") as f:
    #         yaml_data = yaml.load(f.read(), Loader=yaml.FullLoader)
    #     yaml_data['common'] = {
    #         'base_url': None,
    #         'headers': None,
    #         'project': None,
    #         'web_url': None
    #     }
    #     with open(self.file_path, 'w', encoding="utf-8") as f:
    #         yaml.dump(yaml_data, f)

    def delete(self):
        try:
            os.remove(self.file_path)
        except Exception as e:
            print(f'配置文件删除失败: {str(e)}')


kconfig = Config()


