# TOPSIS

Submitted By: **Sarthak Tiwari | 102183051**

***

## What is TOPSIS?

**T**echnique for **O**rder **P**reference by **S**imilarity to **I**deal **S**olution 
(TOPSIS) originated in the 1980s as a multi-criteria decision making method.

## How to install this package:
```bash
>> pip install -e .[dev]
```

## After installation, in Command Prompt/Terminal in pwd/current dir:
```
>> topsis <InputDataFile> <Weights> <Impacts> <ResultFileName>
```

Weights (`weights`) may not be normalised but will be normalised in the code.
**Note:** To avoid errors - 
Input file must contain three or more columns.
2nd to last columns must contain numeric values only.
Number of weights, number of impacts and number of columns (from 2 nd to last columns) must
be same.
Impacts must be either +ve or -ve.
Impacts and weights must be separated by ‘,’ (comma).

## InputDataFile (data.csv) - an example

The decision matrix should be constructed with each row representing a Model alternative and each column representing a criterion like Correlation, R<sup>2</sup>, Root Mean Squared Error, Accuracy, etc. 

Model | Corr | Rseq | RMSE | Accuracy
------------ | ------------- | ------------ | ------------- | ------------
M1 |	0.79 | 0.62	| 1.25 | 60.89
M2 |    0.66 | 0.44	| 2.89 | 63.07
M3 |	0.56 | 0.31	| 1.57 | 62.87
M4 |	0.82 | 0.67	| 2.68 | 70.19
M5 |	0.75 | 0.56	| 1.3  | 80.39

## Output file (result.csv) - 
Based on the above input file and setting weights as "1,2,1,1" and impacts as "+,-,-,+".

Model | Corr | Rseq | RMSE | Accuracy | Topsis Score | Rank
------------ | ------------- | ------------ | ------------- | ------------ | ------------- | ------------- 
M1 |	0.79 | 0.62	| 1.25 | 60.89 | 0.423744391359611 | 4
M2 |  0.66 | 0.44	| 2.89 | 63.07 | 0.0.467426368298297 | 3
M3 |	0.56 | 0.31	| 1.57 | 62.87 | 0.760230957034903 | 1
M4 |	0.82 | 0.67	| 2.68 | 70.19 | 0.207772533881566 | 5
M5 |	0.75 | 0.56	| 1.3	 | 80.39 | 0.504864457803718 | 2

The output file contains columns of input file along with two additional columns having Topsis Score and Rank.

