from typing import Any, Tuple

from typing import overload
import rollnw

class Config:
    def __init__(self, *args, **kwargs) -> None: ...
    def alias_path(self, arg0: rollnw.PathAlias) -> rollnw.Path: ...
    def nwn_ini(self) -> rollnw.Ini: ...
    def nwnplayer_ini(self) -> rollnw.Ini: ...
    def options(self) -> ConfigOptions: ...
    def resolve_alias(self, arg0: str) -> rollnw.Path: ...
    def userpatch_ini(self) -> rollnw.Ini: ...

class ConfigOptions:
    include_install: bool
    include_nwsync: bool
    install: rollnw.Path
    user: rollnw.Path
    version: rollnw.GameVersion
    def __init__(self, probe: bool = ..., version: rollnw.GameVersion = ...) -> None: ...

class EffectSystem:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_effect(self, arg0: EffectType, arg1, arg2) -> bool: ...
    def add_itemprop(self, arg0, arg1) -> bool: ...
    def apply(self, arg0: rollnw.ObjectBase, arg1: rollnw.Effect) -> bool: ...
    def create(self, arg0: EffectType) -> rollnw.Effect: ...
    def destroy(self, arg0: rollnw.Effect) -> None: ...
    def effect_limits_ability(self) -> Tuple[int,int]: ...
    def effect_limits_armor_class(self) -> Tuple[int,int]: ...
    def effect_limits_attack(self) -> Tuple[int,int]: ...
    def effect_limits_skill(self) -> Tuple[int,int]: ...
    def ip_cost_table(self, arg0: int) -> rollnw.TwoDA: ...
    def ip_definition(self, *args, **kwargs) -> Any: ...
    def ip_param_table(self, arg0: int) -> rollnw.TwoDA: ...
    def remove(self, arg0: rollnw.ObjectBase, arg1: rollnw.Effect) -> bool: ...
    def set_effect_limits_ability(self, arg0: int, arg1: int) -> None: ...
    def set_effect_limits_armor_class(self, arg0: int, arg1: int) -> None: ...
    def set_effect_limits_attack(self, arg0: int, arg1: int) -> None: ...
    def set_effect_limits_skill(self, arg0: int, arg1: int) -> None: ...
    def stats(self) -> EffectSystemStats: ...

class EffectSystemStats:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def free_list_size(self) -> int: ...
    @property
    def pool_size(self) -> int: ...

class Objects:
    def __init__(self, *args, **kwargs) -> None: ...
    def area(self, arg0: Resref) -> rollnw.Area: ...
    def creature(self, arg0: str) -> rollnw.Creature: ...
    def destroy(self, arg0: rollnw.ObjectHandle) -> None: ...
    def door(self, arg0: str) -> rollnw.Door: ...
    def encounter(self, arg0: str) -> rollnw.Encounter: ...
    def get(self, arg0: rollnw.ObjectHandle) -> rollnw.ObjectBase: ...
    def placeable(self, arg0: str) -> rollnw.Placeable: ...
    def store(self, arg0: str) -> rollnw.Store: ...
    def trigger(self, arg0: str) -> rollnw.Trigger: ...
    def valid(self, arg0: rollnw.ObjectHandle) -> bool: ...
    def waypoint(self, arg0: str) -> rollnw.Waypoint: ...

class ParsedScriptCache:
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, *args, **kwargs) -> Any: ...

class Resources(rollnw.Container):
    def __init__(self, *args, **kwargs) -> None: ...
    def demand_any(self, arg0: Resref, arg1) -> Tuple[ByteArray,rollnw.ResourceType]: ...

class Rules:
    def __init__(self, *args, **kwargs) -> None: ...

class Strings:
    def __init__(self, *args, **kwargs) -> None: ...

class TwoDACache:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def get(self, arg0: str) -> rollnw.TwoDA: ...
    @overload
    def get(self, arg0: rollnw.Resource) -> rollnw.TwoDA: ...

def config_initialize(arg0: ConfigOptions) -> None: ...
def effects() -> EffectSystem: ...
def load_module(path: rollnw.Path, manifest: str = ...) -> rollnw.Module: ...
def objects() -> Objects: ...
def parsed_scripts() -> ParsedScriptCache: ...
def resman() -> Resources: ...
def rules() -> Rules: ...
@overload
def start() -> None: ...
@overload
def start(arg0: ConfigOptions) -> None: ...
def strings() -> Strings: ...
def twodas() -> TwoDACache: ...
def unload_module() -> None: ...
