"""
Type annotations for guardduty service literal definitions.

[Open documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_guardduty/literals/)

Usage::

    ```python
    from mypy_boto3_guardduty.literals import AdminStatusType

    data: AdminStatusType = "DISABLE_IN_PROGRESS"
    ```

Copyright 2024 Vlad Emelianov
"""

import sys

if sys.version_info >= (3, 12):
    from typing import Literal
else:
    from typing_extensions import Literal

__all__ = (
    "AdminStatusType",
    "AutoEnableMembersType",
    "CoverageFilterCriterionKeyType",
    "CoverageSortKeyType",
    "CoverageStatisticsTypeType",
    "CoverageStatusType",
    "CriterionKeyType",
    "DataSourceStatusType",
    "DataSourceType",
    "DescribeMalwareScansPaginatorName",
    "DestinationTypeType",
    "DetectorFeatureResultType",
    "DetectorFeatureType",
    "DetectorStatusType",
    "EbsSnapshotPreservationType",
    "FeatureAdditionalConfigurationType",
    "FeatureStatusType",
    "FeedbackType",
    "FilterActionType",
    "FindingPublishingFrequencyType",
    "FindingResourceTypeType",
    "FindingStatisticTypeType",
    "FreeTrialFeatureResultType",
    "GroupByTypeType",
    "GuardDutyServiceName",
    "IndicatorTypeType",
    "IpSetFormatType",
    "IpSetStatusType",
    "ListCoveragePaginatorName",
    "ListDetectorsPaginatorName",
    "ListFiltersPaginatorName",
    "ListFindingsPaginatorName",
    "ListIPSetsPaginatorName",
    "ListInvitationsPaginatorName",
    "ListMembersPaginatorName",
    "ListOrganizationAdminAccountsPaginatorName",
    "ListThreatIntelSetsPaginatorName",
    "MalwareProtectionPlanStatusType",
    "MalwareProtectionPlanTaggingActionStatusType",
    "ManagementTypeType",
    "MfaStatusType",
    "NetworkDirectionType",
    "OrderByType",
    "OrgFeatureAdditionalConfigurationType",
    "OrgFeatureStatusType",
    "OrgFeatureType",
    "PaginatorName",
    "ProfileSubtypeType",
    "ProfileTypeType",
    "PublicAccessStatusType",
    "PublicAclIgnoreBehaviorType",
    "PublicBucketRestrictBehaviorType",
    "PublishingStatusType",
    "RegionName",
    "ResourceServiceName",
    "ResourceTypeType",
    "ScanCriterionKeyType",
    "ScanResultType",
    "ScanStatusType",
    "ScanTypeType",
    "ServiceName",
    "SignalTypeType",
    "ThreatIntelSetFormatType",
    "ThreatIntelSetStatusType",
    "UsageFeatureType",
    "UsageStatisticTypeType",
)

AdminStatusType = Literal["DISABLE_IN_PROGRESS", "ENABLED"]
AutoEnableMembersType = Literal["ALL", "NEW", "NONE"]
CoverageFilterCriterionKeyType = Literal[
    "ACCOUNT_ID",
    "ADDON_VERSION",
    "AGENT_VERSION",
    "CLUSTER_ARN",
    "CLUSTER_NAME",
    "COVERAGE_STATUS",
    "ECS_CLUSTER_NAME",
    "EKS_CLUSTER_NAME",
    "INSTANCE_ID",
    "MANAGEMENT_TYPE",
    "RESOURCE_TYPE",
]
CoverageSortKeyType = Literal[
    "ACCOUNT_ID",
    "ADDON_VERSION",
    "CLUSTER_NAME",
    "COVERAGE_STATUS",
    "ECS_CLUSTER_NAME",
    "EKS_CLUSTER_NAME",
    "INSTANCE_ID",
    "ISSUE",
    "UPDATED_AT",
]
CoverageStatisticsTypeType = Literal["COUNT_BY_COVERAGE_STATUS", "COUNT_BY_RESOURCE_TYPE"]
CoverageStatusType = Literal["HEALTHY", "UNHEALTHY"]
CriterionKeyType = Literal[
    "ACCOUNT_ID",
    "EC2_INSTANCE_ARN",
    "GUARDDUTY_FINDING_ID",
    "SCAN_ID",
    "SCAN_START_TIME",
    "SCAN_STATUS",
    "SCAN_TYPE",
]
DataSourceStatusType = Literal["DISABLED", "ENABLED"]
DataSourceType = Literal[
    "CLOUD_TRAIL", "DNS_LOGS", "EC2_MALWARE_SCAN", "FLOW_LOGS", "KUBERNETES_AUDIT_LOGS", "S3_LOGS"
]
DescribeMalwareScansPaginatorName = Literal["describe_malware_scans"]
DestinationTypeType = Literal["S3"]
DetectorFeatureResultType = Literal[
    "CLOUD_TRAIL",
    "DNS_LOGS",
    "EBS_MALWARE_PROTECTION",
    "EKS_AUDIT_LOGS",
    "EKS_RUNTIME_MONITORING",
    "FLOW_LOGS",
    "LAMBDA_NETWORK_LOGS",
    "RDS_LOGIN_EVENTS",
    "RUNTIME_MONITORING",
    "S3_DATA_EVENTS",
]
DetectorFeatureType = Literal[
    "EBS_MALWARE_PROTECTION",
    "EKS_AUDIT_LOGS",
    "EKS_RUNTIME_MONITORING",
    "LAMBDA_NETWORK_LOGS",
    "RDS_LOGIN_EVENTS",
    "RUNTIME_MONITORING",
    "S3_DATA_EVENTS",
]
DetectorStatusType = Literal["DISABLED", "ENABLED"]
EbsSnapshotPreservationType = Literal["NO_RETENTION", "RETENTION_WITH_FINDING"]
FeatureAdditionalConfigurationType = Literal[
    "EC2_AGENT_MANAGEMENT", "ECS_FARGATE_AGENT_MANAGEMENT", "EKS_ADDON_MANAGEMENT"
]
FeatureStatusType = Literal["DISABLED", "ENABLED"]
FeedbackType = Literal["NOT_USEFUL", "USEFUL"]
FilterActionType = Literal["ARCHIVE", "NOOP"]
FindingPublishingFrequencyType = Literal["FIFTEEN_MINUTES", "ONE_HOUR", "SIX_HOURS"]
FindingResourceTypeType = Literal[
    "ACCESS_KEY", "EC2_INSTANCE", "EC2_NETWORK_INTERFACE", "S3_BUCKET", "S3_OBJECT"
]
FindingStatisticTypeType = Literal["COUNT_BY_SEVERITY"]
FreeTrialFeatureResultType = Literal[
    "CLOUD_TRAIL",
    "DNS_LOGS",
    "EBS_MALWARE_PROTECTION",
    "EC2_RUNTIME_MONITORING",
    "EKS_AUDIT_LOGS",
    "EKS_RUNTIME_MONITORING",
    "FARGATE_RUNTIME_MONITORING",
    "FLOW_LOGS",
    "LAMBDA_NETWORK_LOGS",
    "RDS_LOGIN_EVENTS",
    "S3_DATA_EVENTS",
]
GroupByTypeType = Literal["ACCOUNT", "DATE", "FINDING_TYPE", "RESOURCE", "SEVERITY"]
IndicatorTypeType = Literal[
    "ATTACK_TACTIC",
    "ATTACK_TECHNIQUE",
    "HIGH_RISK_API",
    "MALICIOUS_IP",
    "SUSPICIOUS_NETWORK",
    "SUSPICIOUS_USER_AGENT",
    "TOR_IP",
    "UNUSUAL_API_FOR_ACCOUNT",
    "UNUSUAL_ASN_FOR_ACCOUNT",
    "UNUSUAL_ASN_FOR_USER",
]
IpSetFormatType = Literal["ALIEN_VAULT", "FIRE_EYE", "OTX_CSV", "PROOF_POINT", "STIX", "TXT"]
IpSetStatusType = Literal[
    "ACTIVATING", "ACTIVE", "DEACTIVATING", "DELETED", "DELETE_PENDING", "ERROR", "INACTIVE"
]
ListCoveragePaginatorName = Literal["list_coverage"]
ListDetectorsPaginatorName = Literal["list_detectors"]
ListFiltersPaginatorName = Literal["list_filters"]
ListFindingsPaginatorName = Literal["list_findings"]
ListIPSetsPaginatorName = Literal["list_ip_sets"]
ListInvitationsPaginatorName = Literal["list_invitations"]
ListMembersPaginatorName = Literal["list_members"]
ListOrganizationAdminAccountsPaginatorName = Literal["list_organization_admin_accounts"]
ListThreatIntelSetsPaginatorName = Literal["list_threat_intel_sets"]
MalwareProtectionPlanStatusType = Literal["ACTIVE", "ERROR", "WARNING"]
MalwareProtectionPlanTaggingActionStatusType = Literal["DISABLED", "ENABLED"]
ManagementTypeType = Literal["AUTO_MANAGED", "DISABLED", "MANUAL"]
MfaStatusType = Literal["DISABLED", "ENABLED"]
NetworkDirectionType = Literal["INBOUND", "OUTBOUND"]
OrderByType = Literal["ASC", "DESC"]
OrgFeatureAdditionalConfigurationType = Literal[
    "EC2_AGENT_MANAGEMENT", "ECS_FARGATE_AGENT_MANAGEMENT", "EKS_ADDON_MANAGEMENT"
]
OrgFeatureStatusType = Literal["ALL", "NEW", "NONE"]
OrgFeatureType = Literal[
    "EBS_MALWARE_PROTECTION",
    "EKS_AUDIT_LOGS",
    "EKS_RUNTIME_MONITORING",
    "LAMBDA_NETWORK_LOGS",
    "RDS_LOGIN_EVENTS",
    "RUNTIME_MONITORING",
    "S3_DATA_EVENTS",
]
ProfileSubtypeType = Literal["FREQUENT", "INFREQUENT", "RARE", "UNSEEN"]
ProfileTypeType = Literal["FREQUENCY"]
PublicAccessStatusType = Literal["ALLOWED", "BLOCKED"]
PublicAclIgnoreBehaviorType = Literal["IGNORED", "NOT_IGNORED"]
PublicBucketRestrictBehaviorType = Literal["NOT_RESTRICTED", "RESTRICTED"]
PublishingStatusType = Literal[
    "PENDING_VERIFICATION", "PUBLISHING", "STOPPED", "UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY"
]
ResourceTypeType = Literal["EC2", "ECS", "EKS"]
ScanCriterionKeyType = Literal["EC2_INSTANCE_TAG"]
ScanResultType = Literal["CLEAN", "INFECTED"]
ScanStatusType = Literal["COMPLETED", "FAILED", "RUNNING", "SKIPPED"]
ScanTypeType = Literal["GUARDDUTY_INITIATED", "ON_DEMAND"]
SignalTypeType = Literal["CLOUD_TRAIL", "FINDING", "S3_DATA_EVENTS"]
ThreatIntelSetFormatType = Literal[
    "ALIEN_VAULT", "FIRE_EYE", "OTX_CSV", "PROOF_POINT", "STIX", "TXT"
]
ThreatIntelSetStatusType = Literal[
    "ACTIVATING", "ACTIVE", "DEACTIVATING", "DELETED", "DELETE_PENDING", "ERROR", "INACTIVE"
]
UsageFeatureType = Literal[
    "CLOUD_TRAIL",
    "DNS_LOGS",
    "EBS_MALWARE_PROTECTION",
    "EC2_RUNTIME_MONITORING",
    "EKS_AUDIT_LOGS",
    "EKS_RUNTIME_MONITORING",
    "FARGATE_RUNTIME_MONITORING",
    "FLOW_LOGS",
    "LAMBDA_NETWORK_LOGS",
    "RDS_DBI_PROTECTION_PROVISIONED",
    "RDS_DBI_PROTECTION_SERVERLESS",
    "RDS_LOGIN_EVENTS",
    "S3_DATA_EVENTS",
]
UsageStatisticTypeType = Literal[
    "SUM_BY_ACCOUNT",
    "SUM_BY_DATA_SOURCE",
    "SUM_BY_FEATURES",
    "SUM_BY_RESOURCE",
    "TOP_ACCOUNTS_BY_FEATURE",
    "TOP_RESOURCES",
]
GuardDutyServiceName = Literal["guardduty"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appfabric",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "application-signals",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "apptest",
    "arc-zonal-shift",
    "artifact",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "b2bi",
    "backup",
    "backup-gateway",
    "batch",
    "bcm-data-exports",
    "bcm-pricing-calculator",
    "bedrock",
    "bedrock-agent",
    "bedrock-agent-runtime",
    "bedrock-runtime",
    "billing",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chatbot",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cleanrooms",
    "cleanroomsml",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudfront-keyvaluestore",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudtrail-data",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecatalyst",
    "codecommit",
    "codeconnections",
    "codedeploy",
    "codeguru-reviewer",
    "codeguru-security",
    "codeguruprofiler",
    "codepipeline",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcampaignsv2",
    "connectcases",
    "connectparticipant",
    "controlcatalog",
    "controltower",
    "cost-optimization-hub",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "datazone",
    "dax",
    "deadline",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "ds-data",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "eks-auth",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "entityresolution",
    "es",
    "events",
    "evidently",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "freetier",
    "fsx",
    "gamelift",
    "geo-maps",
    "geo-places",
    "geo-routes",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector-scan",
    "inspector2",
    "internetmonitor",
    "invoicing",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivs-realtime",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kendra-ranking",
    "keyspaces",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesis-video-webrtc-storage",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "launch-wizard",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-linux-subscriptions",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "m2",
    "machinelearning",
    "macie2",
    "mailmanager",
    "managedblockchain",
    "managedblockchain-query",
    "marketplace-agreement",
    "marketplace-catalog",
    "marketplace-deployment",
    "marketplace-entitlement",
    "marketplace-reporting",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediapackagev2",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "medical-imaging",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "neptune-graph",
    "neptunedata",
    "network-firewall",
    "networkflowmonitor",
    "networkmanager",
    "networkmonitor",
    "notifications",
    "notificationscontacts",
    "oam",
    "observabilityadmin",
    "omics",
    "opensearch",
    "opensearchserverless",
    "opsworks",
    "opsworkscm",
    "organizations",
    "osis",
    "outposts",
    "panorama",
    "partnercentral-selling",
    "payment-cryptography",
    "payment-cryptography-data",
    "pca-connector-ad",
    "pca-connector-scep",
    "pcs",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "pipes",
    "polly",
    "pricing",
    "privatenetworks",
    "proton",
    "qapps",
    "qbusiness",
    "qconnect",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "repostspace",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53profiles",
    "route53resolver",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-metrics",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "security-ir",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "simspaceweaver",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "socialmessaging",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "ssm-quicksetup",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "supplychain",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "taxsettings",
    "textract",
    "timestream-influxdb",
    "timestream-query",
    "timestream-write",
    "tnb",
    "transcribe",
    "transfer",
    "translate",
    "trustedadvisor",
    "verifiedpermissions",
    "voice-id",
    "vpc-lattice",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-thin-client",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation",
    "cloudwatch",
    "dynamodb",
    "ec2",
    "glacier",
    "iam",
    "opsworks",
    "s3",
    "sns",
    "sqs",
]
PaginatorName = Literal[
    "describe_malware_scans",
    "list_coverage",
    "list_detectors",
    "list_filters",
    "list_findings",
    "list_invitations",
    "list_ip_sets",
    "list_members",
    "list_organization_admin_accounts",
    "list_threat_intel_sets",
]
RegionName = Literal[
    "af-south-1",
    "ap-east-1",
    "ap-northeast-1",
    "ap-northeast-2",
    "ap-northeast-3",
    "ap-south-1",
    "ap-south-2",
    "ap-southeast-1",
    "ap-southeast-2",
    "ap-southeast-3",
    "ap-southeast-4",
    "ca-central-1",
    "ca-west-1",
    "eu-central-1",
    "eu-central-2",
    "eu-north-1",
    "eu-south-1",
    "eu-south-2",
    "eu-west-1",
    "eu-west-2",
    "eu-west-3",
    "il-central-1",
    "me-central-1",
    "me-south-1",
    "sa-east-1",
    "us-east-1",
    "us-east-2",
    "us-west-1",
    "us-west-2",
]
