"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonLaunchTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_autoscaling_1 = require("aws-cdk-lib/aws-autoscaling");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
/**
 * A launch template bound to a single Elastic Network Interface.
 */
class SingletonLaunchTemplate extends aws_ec2_1.LaunchTemplate {
    /**
     * Creates a new SingletonLaunchTemplate.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        const { networkInterface, associatePublicIpAddress, ...others } = props;
        super(scope, id, others);
        this.networkInterface = networkInterface;
        /*
          From the AWS docs:
    
          If you specify an existing network interface ID, you can launch only one
          instance. To do this, you must use the AWS CLI or an SDK to create the
          Auto Scaling group. When you create the group, you must specify the
          Availability Zone, but not the subnet ID. Also, you can specify an
          existing network interface only if it has a device index of 0.
        */
        const cfnLaunchTpl = this.node.defaultChild;
        cfnLaunchTpl.addPropertyDeletionOverride("LaunchTemplateData.SecurityGroupIds");
        cfnLaunchTpl.addPropertyOverride("LaunchTemplateData.NetworkInterfaces", [
            {
                DeviceIndex: "0",
                NetworkInterfaceId: networkInterface.networkInterfaceId,
            },
        ]);
    }
    get connections() {
        return this.networkInterface.connections;
    }
    addSecurityGroup(securityGroup) {
        this.networkInterface.connections.addSecurityGroup(securityGroup);
    }
    /**
     * Creates an auto-scaling group for this launch template.
     *
     * The following properties are ignored (if specified): `launchTemplate`,
     * `minCapacity`, and `maxCapacity`.
     *
     * @param id - The ID of the auto-scaling group.
     * @param props - Constructor properties of the AutoScalingGroup.
     * @returns A new auto-scaling group
     */
    createAutoScalingGroup(id, props) {
        const autoScalingGroup = new aws_autoscaling_1.AutoScalingGroup(this, id, {
            ...props,
            launchTemplate: this,
            minCapacity: 1,
            maxCapacity: 1,
        });
        const cfnAsg = autoScalingGroup.node.defaultChild;
        cfnAsg.addPropertyDeletionOverride("VPCZoneIdentifier");
        cfnAsg.addPropertyOverride("AvailabilityZones", [
            this.networkInterface.subnet.availabilityZone,
        ]);
        return autoScalingGroup;
    }
}
exports.SingletonLaunchTemplate = SingletonLaunchTemplate;
_a = JSII_RTTI_SYMBOL_1;
SingletonLaunchTemplate[_a] = { fqn: "shady-island.networking.SingletonLaunchTemplate", version: "0.1.52" };
//# sourceMappingURL=data:application/json;base64,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