"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositePrincipal = exports.StarPrincipal = exports.Anyone = exports.AnyPrincipal = exports.AccountRootPrincipal = exports.SamlConsolePrincipal = exports.SamlPrincipal = exports.OpenIdConnectPrincipal = exports.WebIdentityPrincipal = exports.FederatedPrincipal = exports.CanonicalUserPrincipal = exports.OrganizationPrincipal = exports.ServicePrincipal = exports.AccountPrincipal = exports.ArnPrincipal = exports.PrincipalPolicyFragment = exports.SessionTagsPrincipal = exports.PrincipalWithConditions = exports.PrincipalBase = exports.ComparablePrincipal = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const policy_statement_1 = require("./policy-statement");
const assume_role_policy_1 = require("./private/assume-role-policy");
const util_1 = require("./util");
/**
 * Helper class for working with `IComparablePrincipal`s
 */
class ComparablePrincipal {
    /**
     * Whether or not the given principal is a comparable principal
     */
    static isComparablePrincipal(x) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(x);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.isComparablePrincipal);
            }
            throw error;
        }
        return 'dedupeString' in x;
    }
    /**
     * Return the dedupeString of the given principal, if available
     */
    static dedupeStringFor(x) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(x);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dedupeStringFor);
            }
            throw error;
        }
        return ComparablePrincipal.isComparablePrincipal(x) ? x.dedupeString() : undefined;
    }
}
exports.ComparablePrincipal = ComparablePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ComparablePrincipal[_a] = { fqn: "@aws-cdk/aws-iam.ComparablePrincipal", version: "1.186.0" };
/**
 * Base class for policy principals
 */
class PrincipalBase {
    constructor() {
        this.grantPrincipal = this;
        this.principalAccount = undefined;
        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        this.assumeRoleAction = 'sts:AssumeRole';
    }
    addToPolicy(statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPolicy);
            }
            throw error;
        }
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(_statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPrincipalPolicy);
            }
            throw error;
        }
        // This base class is used for non-identity principals. None of them
        // have a PolicyDocument to add to.
        return { statementAdded: false };
    }
    addToAssumeRolePolicy(document) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(document);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Default implementation of this protocol, compatible with the legacy behavior
        document.addStatements(new policy_statement_1.PolicyStatement({
            actions: [this.assumeRoleAction],
            principals: [this],
        }));
    }
    toString() {
        // This is a first pass to make the object readable. Descendant principals
        // should return something nicer.
        return JSON.stringify(this.policyFragment.principalJson);
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    /**
     * Returns a new PrincipalWithConditions using this principal as the base, with the
     * passed conditions added.
     *
     * When there is a value for the same operator and key in both the principal and the
     * conditions parameter, the value from the conditions parameter will be used.
     *
     * @returns a new PrincipalWithConditions object.
     */
    withConditions(conditions) {
        return new PrincipalWithConditions(this, conditions);
    }
    /**
     * Returns a new principal using this principal as the base, with session tags enabled.
     *
     * @returns a new SessionTagsPrincipal object.
     */
    withSessionTags() {
        return new SessionTagsPrincipal(this);
    }
}
exports.PrincipalBase = PrincipalBase;
_b = JSII_RTTI_SYMBOL_1;
PrincipalBase[_b] = { fqn: "@aws-cdk/aws-iam.PrincipalBase", version: "1.186.0" };
/**
 * Base class for Principals that wrap other principals
 */
class PrincipalAdapter extends PrincipalBase {
    constructor(wrapped) {
        super();
        this.wrapped = wrapped;
        this.assumeRoleAction = this.wrapped.assumeRoleAction;
        this.principalAccount = this.wrapped.principalAccount;
    }
    get policyFragment() { return this.wrapped.policyFragment; }
    addToPolicy(statement) {
        return this.wrapped.addToPolicy(statement);
    }
    addToPrincipalPolicy(statement) {
        return this.wrapped.addToPrincipalPolicy(statement);
    }
    /**
     * Append the given string to the wrapped principal's dedupe string (if available)
     */
    appendDedupe(append) {
        const inner = ComparablePrincipal.dedupeStringFor(this.wrapped);
        return inner !== undefined ? `${this.constructor.name}:${inner}:${append}` : undefined;
    }
}
/**
 * An IAM principal with additional conditions specifying when the policy is in effect.
 *
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 */
class PrincipalWithConditions extends PrincipalAdapter {
    constructor(principal, conditions) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PrincipalWithConditions);
            }
            throw error;
        }
        this.additionalConditions = conditions;
    }
    /**
     * Add a condition to the principal
     */
    addCondition(key, value) {
        const existingValue = this.additionalConditions[key];
        this.additionalConditions[key] = existingValue ? { ...existingValue, ...value } : value;
    }
    /**
     * Adds multiple conditions to the principal
     *
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     */
    addConditions(conditions) {
        Object.entries(conditions).forEach(([key, value]) => {
            this.addCondition(key, value);
        });
    }
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    get conditions() {
        return this.mergeConditions(this.wrapped.policyFragment.conditions, this.additionalConditions);
    }
    get policyFragment() {
        return new PrincipalPolicyFragment(this.wrapped.policyFragment.principalJson, this.conditions);
    }
    toString() {
        return this.wrapped.toString();
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    dedupeString() {
        return this.appendDedupe(JSON.stringify(this.conditions));
    }
    mergeConditions(principalConditions, additionalConditions) {
        const mergedConditions = {};
        Object.entries(principalConditions).forEach(([operator, condition]) => {
            mergedConditions[operator] = condition;
        });
        Object.entries(additionalConditions).forEach(([operator, condition]) => {
            // merge the conditions if one of the additional conditions uses an
            // operator that's already used by the principal's conditions merge the
            // inner structure.
            const existing = mergedConditions[operator];
            if (!existing) {
                mergedConditions[operator] = condition;
                return; // continue
            }
            // if either the existing condition or the new one contain unresolved
            // tokens, fail the merge. this is as far as we go at this point.
            if (cdk.Token.isUnresolved(condition) || cdk.Token.isUnresolved(existing)) {
                throw new Error(`multiple "${operator}" conditions cannot be merged if one of them contains an unresolved token`);
            }
            mergedConditions[operator] = { ...existing, ...condition };
        });
        return mergedConditions;
    }
}
exports.PrincipalWithConditions = PrincipalWithConditions;
_c = JSII_RTTI_SYMBOL_1;
PrincipalWithConditions[_c] = { fqn: "@aws-cdk/aws-iam.PrincipalWithConditions", version: "1.186.0" };
/**
 * Enables session tags on role assumptions from a principal
 *
 * For more information on session tags, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
 */
class SessionTagsPrincipal extends PrincipalAdapter {
    constructor(principal) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SessionTagsPrincipal);
            }
            throw error;
        }
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Lazy import to avoid circular import dependencies during startup
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const adapter = require('./private/policydoc-adapter');
        assume_role_policy_1.defaultAddPrincipalToAssumeRole(this.wrapped, new adapter.MutatingPolicyDocumentAdapter(doc, (statement) => {
            statement.addActions('sts:TagSession');
            return statement;
        }));
    }
    dedupeString() {
        return this.appendDedupe('');
    }
}
exports.SessionTagsPrincipal = SessionTagsPrincipal;
_d = JSII_RTTI_SYMBOL_1;
SessionTagsPrincipal[_d] = { fqn: "@aws-cdk/aws-iam.SessionTagsPrincipal", version: "1.186.0" };
/**
 * A collection of the fields in a PolicyStatement that can be used to identify a principal.
 *
 * This consists of the JSON used in the "Principal" field, and optionally a
 * set of "Condition"s that need to be applied to the policy.
 *
 * Generally, a principal looks like:
 *
 *     { '<TYPE>': ['ID', 'ID', ...] }
 *
 * And this is also the type of the field `principalJson`.  However, there is a
 * special type of principal that is just the string '*', which is treated
 * differently by some services. To represent that principal, `principalJson`
 * should contain `{ 'LiteralString': ['*'] }`.
 */
class PrincipalPolicyFragment {
    /**
     *
     * @param principalJson JSON of the "Principal" section in a policy statement
     * @param conditions conditions that need to be applied to this policy
     */
    constructor(principalJson, 
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    conditions = {}) {
        this.principalJson = principalJson;
        this.conditions = conditions;
    }
}
exports.PrincipalPolicyFragment = PrincipalPolicyFragment;
_e = JSII_RTTI_SYMBOL_1;
PrincipalPolicyFragment[_e] = { fqn: "@aws-cdk/aws-iam.PrincipalPolicyFragment", version: "1.186.0" };
/**
 * Specify a principal by the Amazon Resource Name (ARN).
 * You can specify AWS accounts, IAM users, Federated SAML users, IAM roles, and specific assumed-role sessions.
 * You cannot specify IAM groups or instance profiles as principals
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
 */
class ArnPrincipal extends PrincipalBase {
    /**
     *
     * @param arn Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name)
     */
    constructor(arn) {
        super();
        this.arn = arn;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: [this.arn] });
    }
    toString() {
        return `ArnPrincipal(${this.arn})`;
    }
    /**
     * A convenience method for adding a condition that the principal is part of the specified
     * AWS Organization.
     */
    inOrganization(organizationId) {
        return this.withConditions({
            StringEquals: {
                'aws:PrincipalOrgID': organizationId,
            },
        });
    }
    dedupeString() {
        return `ArnPrincipal:${this.arn}`;
    }
}
exports.ArnPrincipal = ArnPrincipal;
_f = JSII_RTTI_SYMBOL_1;
ArnPrincipal[_f] = { fqn: "@aws-cdk/aws-iam.ArnPrincipal", version: "1.186.0" };
/**
 * Specify AWS account ID as the principal entity in a policy to delegate authority to the account.
 */
class AccountPrincipal extends ArnPrincipal {
    /**
     *
     * @param accountId AWS account ID (i.e. 123456789012)
     */
    constructor(accountId) {
        super(new StackDependentToken(stack => `arn:${stack.partition}:iam::${accountId}:root`).toString());
        this.accountId = accountId;
        if (!cdk.Token.isUnresolved(accountId) && typeof accountId !== 'string') {
            throw new Error('accountId should be of type string');
        }
        this.principalAccount = accountId;
    }
    toString() {
        return `AccountPrincipal(${this.accountId})`;
    }
}
exports.AccountPrincipal = AccountPrincipal;
_g = JSII_RTTI_SYMBOL_1;
AccountPrincipal[_g] = { fqn: "@aws-cdk/aws-iam.AccountPrincipal", version: "1.186.0" };
/**
 * An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 */
class ServicePrincipal extends PrincipalBase {
    /**
     *
     * @param service AWS service (i.e. sqs.amazonaws.com)
     */
    constructor(service, opts = {}) {
        super();
        this.service = service;
        this.opts = opts;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ServicePrincipalOpts(opts);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ServicePrincipal);
            }
            throw error;
        }
    }
    /**
     * Translate the given service principal name based on the region it's used in.
     *
     * For example, for Chinese regions this may (depending on whether that's necessary
     * for the given service principal) append `.cn` to the name.
     *
     * The `region-info` module is used to obtain this information.
     *
     * @example
     * const principalName = iam.ServicePrincipal.servicePrincipalName('ec2.amazonaws.com');
     */
    static servicePrincipalName(service) {
        return new ServicePrincipalToken(service, {}).toString();
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({
            Service: [
                new ServicePrincipalToken(this.service, this.opts).toString(),
            ],
        }, this.opts.conditions);
    }
    toString() {
        return `ServicePrincipal(${this.service})`;
    }
    dedupeString() {
        return `ServicePrincipal:${this.service}:${JSON.stringify(this.opts)}`;
    }
}
exports.ServicePrincipal = ServicePrincipal;
_h = JSII_RTTI_SYMBOL_1;
ServicePrincipal[_h] = { fqn: "@aws-cdk/aws-iam.ServicePrincipal", version: "1.186.0" };
/**
 * A principal that represents an AWS Organization
 */
class OrganizationPrincipal extends PrincipalBase {
    /**
     *
     * @param organizationId The unique identifier (ID) of an organization (i.e. o-12345abcde)
     */
    constructor(organizationId) {
        super();
        this.organizationId = organizationId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: ['*'] }, { StringEquals: { 'aws:PrincipalOrgID': this.organizationId } });
    }
    toString() {
        return `OrganizationPrincipal(${this.organizationId})`;
    }
    dedupeString() {
        return `OrganizationPrincipal:${this.organizationId}`;
    }
}
exports.OrganizationPrincipal = OrganizationPrincipal;
_j = JSII_RTTI_SYMBOL_1;
OrganizationPrincipal[_j] = { fqn: "@aws-cdk/aws-iam.OrganizationPrincipal", version: "1.186.0" };
/**
 * A policy principal for canonicalUserIds - useful for S3 bucket policies that use
 * Origin Access identities.
 *
 * See https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html
 *
 * and
 *
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 *
 * for more details.
 *
 */
class CanonicalUserPrincipal extends PrincipalBase {
    /**
     *
     * @param canonicalUserId unique identifier assigned by AWS for every account.
     *   root user and IAM users for an account all see the same ID.
     *   (i.e. 79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be)
     */
    constructor(canonicalUserId) {
        super();
        this.canonicalUserId = canonicalUserId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ CanonicalUser: [this.canonicalUserId] });
    }
    toString() {
        return `CanonicalUserPrincipal(${this.canonicalUserId})`;
    }
    dedupeString() {
        return `CanonicalUserPrincipal:${this.canonicalUserId}`;
    }
}
exports.CanonicalUserPrincipal = CanonicalUserPrincipal;
_k = JSII_RTTI_SYMBOL_1;
CanonicalUserPrincipal[_k] = { fqn: "@aws-cdk/aws-iam.CanonicalUserPrincipal", version: "1.186.0" };
/**
 * Principal entity that represents a federated identity provider such as Amazon Cognito,
 * that can be used to provide temporary security credentials to users who have been authenticated.
 * Additional condition keys are available when the temporary security credentials are used to make a request.
 * You can use these keys to write policies that limit the access of federated users.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#condition-keys-wif
 */
class FederatedPrincipal extends PrincipalBase {
    /**
     *
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(federated, conditions, assumeRoleAction = 'sts:AssumeRole') {
        super();
        this.federated = federated;
        this.conditions = conditions;
        this.assumeRoleAction = assumeRoleAction;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `FederatedPrincipal(${this.federated})`;
    }
    dedupeString() {
        return `FederatedPrincipal:${this.federated}:${this.assumeRoleAction}:${JSON.stringify(this.conditions)}`;
    }
}
exports.FederatedPrincipal = FederatedPrincipal;
_l = JSII_RTTI_SYMBOL_1;
FederatedPrincipal[_l] = { fqn: "@aws-cdk/aws-iam.FederatedPrincipal", version: "1.186.0" };
/**
 * A principal that represents a federated identity provider as Web Identity such as Cognito, Amazon,
 * Facebook, Google, etc.
 */
class WebIdentityPrincipal extends FederatedPrincipal {
    /**
     *
     * @param identityProvider identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(identityProvider, conditions = {}) {
        super(identityProvider, conditions ?? {}, 'sts:AssumeRoleWithWebIdentity');
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `WebIdentityPrincipal(${this.federated})`;
    }
}
exports.WebIdentityPrincipal = WebIdentityPrincipal;
_m = JSII_RTTI_SYMBOL_1;
WebIdentityPrincipal[_m] = { fqn: "@aws-cdk/aws-iam.WebIdentityPrincipal", version: "1.186.0" };
/**
 * A principal that represents a federated identity provider as from a OpenID Connect provider.
 */
class OpenIdConnectPrincipal extends WebIdentityPrincipal {
    /**
     *
     * @param openIdConnectProvider OpenID Connect provider
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    constructor(openIdConnectProvider, conditions = {}) {
        super(openIdConnectProvider.openIdConnectProviderArn, conditions ?? {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IOpenIdConnectProvider(openIdConnectProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OpenIdConnectPrincipal);
            }
            throw error;
        }
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `OpenIdConnectPrincipal(${this.federated})`;
    }
}
exports.OpenIdConnectPrincipal = OpenIdConnectPrincipal;
_o = JSII_RTTI_SYMBOL_1;
OpenIdConnectPrincipal[_o] = { fqn: "@aws-cdk/aws-iam.OpenIdConnectPrincipal", version: "1.186.0" };
/**
 * Principal entity that represents a SAML federated identity provider
 */
class SamlPrincipal extends FederatedPrincipal {
    constructor(samlProvider, conditions) {
        super(samlProvider.samlProviderArn, conditions, 'sts:AssumeRoleWithSAML');
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SamlPrincipal);
            }
            throw error;
        }
    }
    toString() {
        return `SamlPrincipal(${this.federated})`;
    }
}
exports.SamlPrincipal = SamlPrincipal;
_p = JSII_RTTI_SYMBOL_1;
SamlPrincipal[_p] = { fqn: "@aws-cdk/aws-iam.SamlPrincipal", version: "1.186.0" };
/**
 * Principal entity that represents a SAML federated identity provider for
 * programmatic and AWS Management Console access.
 */
class SamlConsolePrincipal extends SamlPrincipal {
    constructor(samlProvider, conditions = {}) {
        super(samlProvider, {
            ...conditions,
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SamlConsolePrincipal);
            }
            throw error;
        }
    }
    toString() {
        return `SamlConsolePrincipal(${this.federated})`;
    }
}
exports.SamlConsolePrincipal = SamlConsolePrincipal;
_q = JSII_RTTI_SYMBOL_1;
SamlConsolePrincipal[_q] = { fqn: "@aws-cdk/aws-iam.SamlConsolePrincipal", version: "1.186.0" };
/**
 * Use the AWS account into which a stack is deployed as the principal entity in a policy
 */
class AccountRootPrincipal extends AccountPrincipal {
    constructor() {
        super(new StackDependentToken(stack => stack.account).toString());
    }
    toString() {
        return 'AccountRootPrincipal()';
    }
}
exports.AccountRootPrincipal = AccountRootPrincipal;
_r = JSII_RTTI_SYMBOL_1;
AccountRootPrincipal[_r] = { fqn: "@aws-cdk/aws-iam.AccountRootPrincipal", version: "1.186.0" };
/**
 * A principal representing all AWS identities in all accounts
 *
 * Some services behave differently when you specify `Principal: '*'`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `AnyPrincipal` renders to `Principal: { AWS: "*" }`. This is correct
 * most of the time, but in cases where you need the other principal,
 * use `StarPrincipal` instead.
 */
class AnyPrincipal extends ArnPrincipal {
    constructor() {
        super('*');
    }
    toString() {
        return 'AnyPrincipal()';
    }
}
exports.AnyPrincipal = AnyPrincipal;
_s = JSII_RTTI_SYMBOL_1;
AnyPrincipal[_s] = { fqn: "@aws-cdk/aws-iam.AnyPrincipal", version: "1.186.0" };
/**
 * A principal representing all identities in all accounts
 * @deprecated use `AnyPrincipal`
 */
class Anyone extends AnyPrincipal {
}
exports.Anyone = Anyone;
_t = JSII_RTTI_SYMBOL_1;
Anyone[_t] = { fqn: "@aws-cdk/aws-iam.Anyone", version: "1.186.0" };
/**
 * A principal that uses a literal '*' in the IAM JSON language
 *
 * Some services behave differently when you specify `Principal: "*"`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `StarPrincipal` renders to `Principal: *`. Most of the time, you
 * should use `AnyPrincipal` instead.
 */
class StarPrincipal extends PrincipalBase {
    constructor() {
        super(...arguments);
        this.policyFragment = {
            principalJson: { [util_1.LITERAL_STRING_KEY]: ['*'] },
            conditions: {},
        };
    }
    toString() {
        return 'StarPrincipal()';
    }
    dedupeString() {
        return 'StarPrincipal';
    }
}
exports.StarPrincipal = StarPrincipal;
_u = JSII_RTTI_SYMBOL_1;
StarPrincipal[_u] = { fqn: "@aws-cdk/aws-iam.StarPrincipal", version: "1.186.0" };
/**
 * Represents a principal that has multiple types of principals. A composite principal cannot
 * have conditions. i.e. multiple ServicePrincipals that form a composite principal
 */
class CompositePrincipal extends PrincipalBase {
    constructor(...principals) {
        super();
        this.principals = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CompositePrincipal);
            }
            throw error;
        }
        if (principals.length === 0) {
            throw new Error('CompositePrincipals must be constructed with at least 1 Principal but none were passed.');
        }
        this.assumeRoleAction = principals[0].assumeRoleAction;
        this.addPrincipals(...principals);
    }
    /**
     * Adds IAM principals to the composite principal. Composite principals cannot have
     * conditions.
     *
     * @param principals IAM principals that will be added to the composite principal
     */
    addPrincipals(...principals) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPrincipals);
            }
            throw error;
        }
        this.principals.push(...principals);
        return this;
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        for (const p of this.principals) {
            assume_role_policy_1.defaultAddPrincipalToAssumeRole(p, doc);
        }
    }
    get policyFragment() {
        // We only have a problem with conditions if we are trying to render composite
        // princpals into a single statement (which is when `policyFragment` would get called)
        for (const p of this.principals) {
            const fragment = p.policyFragment;
            if (fragment.conditions && Object.keys(fragment.conditions).length > 0) {
                throw new Error('Components of a CompositePrincipal must not have conditions. ' +
                    `Tried to add the following fragment: ${JSON.stringify(fragment)}`);
            }
        }
        const principalJson = {};
        for (const p of this.principals) {
            util_1.mergePrincipal(principalJson, p.policyFragment.principalJson);
        }
        return new PrincipalPolicyFragment(principalJson);
    }
    toString() {
        return `CompositePrincipal(${this.principals})`;
    }
    dedupeString() {
        const inner = this.principals.map(ComparablePrincipal.dedupeStringFor);
        if (inner.some(x => x === undefined)) {
            return undefined;
        }
        return `CompositePrincipal[${inner.join(',')}]`;
    }
}
exports.CompositePrincipal = CompositePrincipal;
_v = JSII_RTTI_SYMBOL_1;
CompositePrincipal[_v] = { fqn: "@aws-cdk/aws-iam.CompositePrincipal", version: "1.186.0" };
/**
 * A lazy token that requires an instance of Stack to evaluate
 */
class StackDependentToken {
    constructor(fn) {
        this.fn = fn;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        return this.fn(cdk.Stack.of(context.scope));
    }
    toString() {
        return cdk.Token.asString(this);
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return '<unresolved-token>';
    }
}
class ServicePrincipalToken {
    constructor(service, opts) {
        this.service = service;
        this.opts = opts;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(ctx) {
        if (this.opts.region) {
            // Special case, handle it separately to not break legacy behavior.
            return region_info_1.RegionInfo.get(this.opts.region).servicePrincipal(this.service) ??
                region_info_1.Default.servicePrincipal(this.service, this.opts.region, cdk.Aws.URL_SUFFIX);
        }
        const stack = cdk.Stack.of(ctx.scope);
        return stack.regionalFact(region_info_1.FactName.servicePrincipal(this.service), region_info_1.Default.servicePrincipal(this.service, stack.region, cdk.Aws.URL_SUFFIX));
    }
    toString() {
        return cdk.Token.asString(this, {
            displayHint: this.service,
        });
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return `<${this.service}>`;
    }
}
//# sourceMappingURL=data:application/json;base64,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