# info.py:
# copyright: 2021 by pistatex (Junho Lee).
# license: LGPL3.
# Automately generated by gen_doc.py

class docs:

    ''' class for store the documentation for TRXASprefitpack '''
    
    def __init__(self):
        self.info = dict()
        return
    
    def appnd(self, name, txt):
        self.info[name] = txt
        return

__info__ = docs()

doc = dict()

doc['version'] = ' main' 
doc['description'] = '''
TRXASprefitpack: package for TRXAS pre-fitting process which aims for the
first order dynamics
version:  main

                           numpy, scipy
                                |
                                |
                                V
             ***************TRXASprefitpack***************
             | thy             -- gen_theory_data        |
             | data_process    -- automate_scaling       |
             |                 -- corr_a_method          |
             | mathfun         -- exp_conv_gau           |
             |                 -- exp_conv_cauchy        |
             |                 -- solve_model            |
	     |                 -- compute_model          |
	     |                 -- compute_signal_gau     |
             |                 -- compute_signal_cauchy  |
             |                 -- compute_signal_pvoigt  |_________
             |                 -- model_n_comp_conv      |         |
             |                 -- fact_anal_exp_conv     |         |
             | doc             -- info                   |         |
             *********************************************         |
                                |                                  |
                                |                                  |
                                |                                  | lmfit
				V                                  | matplotlib
             ****************script*******************             |
             | TRXASprefitpack_info  (exe)           |             |
             ****************script*******************             |         
             | broadening           (exe)            |             |
             | auto_scale           (exe)            |             |
             | fit_static           (exe)            |             |
	     | fit_tscan            (exe)            | <------------
             *****************************************


If you want know any information about function defined in TRXASprefitpack
type TRXASprefitpack_info func_name
'''
 
doc['licence'] = '''
TRXASprefitpack: package for TRXAS pre fitting process

Copyright (C) 2021 pistack (Junho Lee, email: pistatex@yonsei.ac.kr)
 
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
'''
 
doc['lgpl-3.0'] = '''
                  GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <https://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
'''
 
doc['gen_theory_data'] = '''
gen_theory_data(e, peaks, A, fwhm_G, fwhm_L, peak_shift, out=None)
    
   voigt broadening theoretically calculated lineshape spectrum if out
   is not none: It will make out_thy.txt: txt file for rescaled and
   boroadend calc spectrum out_thy_stk.txt: txt file for rescaled and
   shifted calc peaks

   Parameters:
      * **e** (*numpy_1d_array*) -- energy (unit: eV)

      * **A** (*float*) -- scaling parameter

      * **fwhm_G** (*float*) -- full width at half maximum of gaussian
        shape (unit: eV)

      * **fwhm_L** (*float*) -- full width at half maximum of
        lorenzian shape (unit: eV)

      * **peak_shift** (*float*) -- discrepency of peak position
        between expt data and theoretically  broadened spectrum

      * **out** (*string*) -- prefix for output txt file [optional]

   Returns:
      voigt broadened calc spectrum

   Return type:
      numpy_1d_array
''' 
 
doc['automate_scaling'] = '''    
    automate_scaling(A, e_ref_index, e, t,
                     escan_time, tscan_energy, time_zeros=None,
                     exotic_t=None, exotic_tscan_energy=None,
                     exotic_e_ref_index=None,
                     escan_data=None, escan_data_eps=None,
                     tscan_data=None, tscan_data_eps=None,
                     exotic_tscan_data=None, exotic_tscan_data_eps=None)
                     
    Automate scale escan, tscan and some exotic tscan
    If you scale tscan with fast time delay ( < 10 ps)
    time zero will change scaling factor. So, beware of the
    change of time zero.
    However, scaling parameter for tscan w.r.t. escan (r_t_i)
    may recover such effect. So, I think that for not so early time delay
    (1 ps ~ 10 ps) region time_zero shifted about +/- IRF ~ 300 fs
    neglectable.
    If escan_time[e_ref_index] < 10 ps
    I will print warning message for you.

    Automate scaling procedure

    0. Fit static spectrum with fit_static.py
       Carefully watch graphs.

    1. Scaling escan_data using A-method

    2-1. If escan_time[e_ref_index] := e_ref > 10 ps,
         then take difference flu spectrum at tscan energy
         in e_ref delay escan.
         Next take difference flu spectrum at e_ref delay in tscan.
         Now fit diff flu spec at e_ref delay in tscan to
         diff flu spec at tscan_energy in e_ref delay escan.

    2-2. If e_ref < 10 ps, you must set time_zeros for all tscan.
         Then do procedure simuliar to 2-2.

    3. Watch changes in timezero during fitting.
       If timezero changes a lot in fitting, consider simultaneous
       scaling (i.e. fitting and scaling at once.)

    4. After do automate_scaling, you need to correct scaling
       due to the prossiblity of inconsistent laser overlap.
   
    5. Correct and do automate_scaling again with corrected escan and
       A = A_ref*np.ones(A.shape).


    Warning and Error case

    Warning (no harm, just for warn)
    
    1. early delay (e_ref < 10)

    Error (it aborts procedure)

    1. early delay without time zero : e_ref < 10 but time zero is not set.

   automate_scaling: Automate scale escan, tscan

   Parameters:
      * **A** (*numpy_1d_array*) -- array of parameter A for each
        escan

      * **e_ref** (*int*) -- index for reference escan for scaling of
        escan and tscan

      * **e** (*numpy_1d_array*) -- array of energies in which we
        measured escan

      * **t** (*numpy_1d_array*) -- array of time delays in which we
        measured tscan

      * **escan_time** (*numpy_1d_array*) -- array of time delay at
        which we measure escan

      * **tscan_energy** (*numpy_1d_array*) -- array of energy at
        which we measure tscan

      * **time_zeros** (*numpy_1d_array*) -- array of time zero for
        every tscan (optional, mandatory escan_time[e_ref] < 10 ps)

      * **escan_data** (*numpy_nd_array*) -- data for escan (Note.
        escan data does not contains energy range)

      * **escan_data_eps** (*numpy_nd_array*) -- error for escan data

      * **tscan_data** (*numpy_nd_array*) -- data for tscan (Note.
        tscan data does not contains time delay range)

      * **tscan_data_eps** (*numpy_nd_array*) -- error for tscan

      * **warn** (*bool*) -- whether or not prints warning message
        [default: False]

   Returns:
      scaled_data scaled_data['escan'] : scaled data for escan
      scaled_data['escan_eps'] : scaled error for escan
      scaled_data['tscan'] : scaled data for tscan
      scaled_data['tscan_eps'] : scaled error for tscan

   Return type:
      dict
'''
 
doc['corr_a_method'] = '''
Due to inconsistent of laser overlap during experiment
We may need to correct ``A-method`` scaled escan data 
corr_a_method correct this data using reference tscan

corr_a_method(e_ref_index, e, t,
                     escan_time, ref_tscan_energy, ref_time_zeros,
                     escan_data=None, escan_data_eps=None,
                     ref_tscan_data=None, ref_tscan_data_eps=None,
                     warn=False):

   corr_a_method: Corrects the scaling of escan scaled with tscan

   Parameters:
      * **e_ref** (*int*) -- index of reference escab used for
        "A-method"

      * **e** (*numpy_1d_array*) -- array of energies in which we
        measured escan

      * **t** (*numpy_1d_array*) -- array of time delays in which we
        measured tscan

      * **escan_time** (*numpy_1d_array*) -- array of time delays at
        which we measured escan

      * **ref_tscan_energy** (*float*) -- reference energy for
        repairing scale of escan

      * **ref_time_zeros** (*float*) -- time zero for reference tscan

      * **escan_data** (*numpy_nd_array*) -- data for escan (Note.
        escan data does not contains energy range)

      * **escan_data_eps** (*numpy_nd_array*) -- error for escan data

      * **tscan_data** (*numpy_1d_array*) -- data for reference tscan

      * **tscan_data_eps** (*numpy_1d_array*) -- error for reference
        tscan

   Returns:
      corrected_data: corrected_data['escan'] : corrected data for
      escan corrected_data['escan_eps'] : corrected error for escan

   Return type:
      dict
'''
 
doc['exp_conv_gau'] = '''
exp_conv_gau(t, fwhm, k):

   Compute exponential function convolved with normalized gaussian
   distribution

   Note. We assume temporal pulse of x-ray is normalized gaussian
   distribution

      \sigma = \frac{fwhm}{2\sqrt{2\log{2}}}

      IRF(t) = \frac{1}{\sigma
      \sqrt{2\pi}}\exp\left(-\frac{t^2}{2\sigma^2}\right)

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*float*) -- full width at half maximum of x-ray
        temporal pulse

      * **k** (*float*) -- rate constant (inverse of life time)

   Returns:
      convolution of normalized gaussian distribution and exp(-kt)

      \frac{1}{2}\exp\left(\frac{k^2}{2\sigma^2}-kt\right)\left(1+{er
      f}\left(\frac{1}{\sqrt{2}}\left(\frac{t}{\sigma}-k\sigma\right)
      \right)\right)

   Return type:
      numpy_1d_array    
'''
 
doc['exp_conv_cauchy'] = '''
exp_conv_cauchy(t, fwhm, k):

   Compute exponential function convolved with normalized cauchy
   distribution

   Note. We assume temporal pulse of x-ray is normalized cauchy
   distribution

      \gamma = \frac{fwhm}{2}

      IRF(t) = \frac{\gamma}{\pi}\frac{1}{(x-t)^2+\gamma^2}

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*float*) -- full width at half maximum of x-ray
        temporal pulse

      * **k** (*float*) -- rate constant (inverse of life time)

   Returns:
      convolution of normalized cauchy distribution and exp(-kt)

      \frac{\exp(-kt)}{\pi}\Im\left(\exp(-ik\gamma)\cdot\{E1}(-kt-ik\gamma)\right)

   Return type:
      numpy_1d_array
'''
 
doc['solve_model'] = '''
 solve_model(equation, y0):

   Solve system of first order rate equation

   Parameters:
      * **equation** (*numpy_nd_array*) -- matrix corresponding to
        model

      * **y0** (*numpy_1d_array*) -- initial condition

   Returns:
      eigenvalue of equation

   Return type:
      numpy_1d_array

   Returns:
      eigenvectors for equation

   Return type:
      numpy_nd_array

   Returns:
      coefficient where y_0 = Vc

   Return type:
      numpy_1d_array
 '''
    
 
doc['compute_model'] = '''
compute_model(t, eigval, V, c):

   Compute solution of the system of rate equations solved by
   solve_model Note: eigval, V, c should be obtained from solve_model

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **eigval** (*numpy_1d_array*) -- eigenvalue for equation

      * **V** (*numpy_nd_array*) -- eigenvectors for equation

      * **c** (*numpy_1d_array*) -- coefficient

   Returns:
      solution of rate equation

   Return type:
      numpy_nd_array
'''
 
doc['compute_signal_gau'] = '''
compute_signal_gau(t, fwhm, eigval, V, c):

   Compute solution of the system of rate equations solved by
   solve_model convolved with normalized gaussian distribution Note:
   eigval, V, c should be obtained from solve_model

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*float*) -- full width at half maximum of x-ray
        temporal pulse

      * **eigval** (*numpy_1d_array*) -- eigenvalue for equation

      * **V** (*numpy_nd_array*) -- eigenvectors for equation

      * **c** (*numpy_1d_array*) -- coefficient

   Returns:
      solution of rate equation convolved with normalized gaussian
      distribution

   Return type:
      numpy_nd_array
'''
 
doc['compute_signal_cauchy'] = '''
compute_signal_cauchy(t, fwhm, eigval, V, c):

   Compute solution of the system of rate equations solved by
   solve_model convolved with normalized cauchy distribution Note:
   eigval, V, c should be obtained from solve_model

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*float*) -- full width at half maximum of x-ray
        temporal pulse

      * **eigval** (*numpy_1d_array*) -- eigenvalue for equation

      * **V** (*numpy_nd_array*) -- eigenvectors for equation

      * **c** (*numpy_1d_array*) -- coefficient

   Returns:
      solution of rate equation convolved with normalized cachy
      distribution

   Return type:
      numpy_nd_array
'''
 
doc['compute_signal_pvoigt'] = '''
compute_signal_pvoigt(t, fwhm_G, fwhm_L, eta, eigval, V, c):

   Compute solution of the system of rate equations solved by
   solve_model convolved with normalized pseudo voigt profile (pvoigt
   = (1-\eta) G(t) + \eta L(t), G(t): stands for normalized gaussian
   L(t): stands for normalized cauchy(lorenzian) distribution)

   Note: eigval, V, c should be obtained from solve_model

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm_G** (*float*) -- full width at half maximum of x-ray
        temporal pulse (gaussian part)

      * **fwhm_L** (*float*) -- full width at half maximum of x-ray
        temporal pulse (lorenzian part)

      * **eta** (*float*) -- mixing parameter

   (0 < \eta < 1)

   Parameters:
      * **eigval** (*numpy_1d_array*) -- eigenvalue for equation

      * **V** (*numpy_nd_array*) -- eigenvectors for equation

      * **c** (*numpy_1d_array*) -- coefficient

   Returns:
      solution of rate equation convolved with normalized pseudo voigt
      profile

   Return type:
      numpy_nd_array
'''
 
doc['model_n_comp_conv'] = '''
model_n_comp_conv(t, fwhm, tau, c, base=True, irf='g', eta=None):

   model for n component fitting n exponential function convolved with
   irf 'g': normalized gaussian distribution

   'c': normalized cauchy distribution

   'pv': pseudo voigt profile (1-\eta)g + \eta c

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*numpy_1d_array*) --

        fwhm of X-ray temporal pulse  if irf == 'g' or 'c' then

           fwhm = [fwhm]

        if irf == 'pv' then
           fwhm = [fwhm_G, fwhm_L]

      * **tau** (*numpy_1d_array*) -- life time for each component

      * **c** (*numpy_1d_array*) -- coefficient (num_comp+1,) if
        base=True (num_comp,)   if base=False

      * **base** (*bool**, **optional*) -- whether or not include
        baseline [default: True]

      * **irf** (*string**, **optional*) -- shape of instrumental
        response function [default: g] 'g': normalized gaussian
        distribution 'c': normalized cauchy distribution 'pv': pseudo
        voigt profile (1-\eta)g + \eta c

      * **eta** (*float**, **optional*) -- mixing parameter for pseudo
        voigt profile  (only needed for pseudo voigt profile, Default
        value is guessed according to Journal of Applied
        Crystallography. 33 (6): 1311–1316.)

   Returns:
      fit

   Return type:
      numpy_1d_array

'''
 
doc['fact_anal_exp_conv'] = '''
fact_anal_exp_conv(t, fwhm, tau, irf='g', eta=None, 
                   data=None, eps=None, base=True):

   Estimate the best coefficiets when fwhm and tau are given

   Before fitting with Escan data, you want fit your model to tscan
   data to know how many component needed for well description of
   tscan data To do this you have good initial guess for not only life
   time of each component but also coefficients. For this, It will
   solve linear least square problem

   Parameters:
      * **t** (*numpy_1d_array*) -- time

      * **fwhm** (*numpy_1d_array*) --

        fwhm of X-ray temporal pulse  if irf == 'g' or 'c' then

           fwhm = [fwhm]

        if irf == 'pv' then
           fwhm = [fwhm_G, fwhm_L]

      * **tau** (*numpy_1d_array*) -- life time for each component

      * **irf** (*string**, **optional*) -- shape of instrumental
        response function [default: g] 'g': normalized gaussian
        distribution 'c': normalized cauchy distribution 'pv': pseudo
        voigt profile (1-\eta)g + \eta c

      * **eta** (*float**, **optional*) -- mixing parameter for pseudo
        voigt profile  (only needed for pseudo voigt profile, Default
        value is guessed according to Journal of Applied
        Crystallography. 33 (6): 1311–1316.)

      * **data** (*numpy_1d_array*) -- tscan data

      * **eps** (*numpy_1d_array*) -- error for tscan data

      * **base** (*bool**, **optional*) -- whether or not include
        baseline [default: True]

   Returns:
      best coefficient for given fwhm, tau (num_comp+1,) , if
      base=True (num_comp,)   , otherwise

   Return type:
      numpy_1d_array
'''
 
doc['fit_static'] = '''
fit_static
**********

fitting static spectrum with theoretically calculated line spectrum
broadened by spectral line shape

Note:

  Currently, it uses linear baseline.

Note:

  energy unit of measured static spectrum must be KeV and energy unit
  of calc static spectrum must be eV

* usage: fit_static [-h] [-ls {v,g,l}] [-o OUT] prefix num_scan
  peak_name

* positional arguments:

  * prefix                prefix for experimental static peak files It
    will read prefix_i.txt files

  * num_scan              the number of static peak scan files

  * peak_name             filename for theoretical line shape spectrum

* optional arguments:

  * -h, --help            show this help message and exit

  * -ls {v,g,l}, --line_shape {v,g,l} line shape of spectrum v: voigt
    profile g: gaussian shape l: lorenzian shape

  * -o OUT, --out OUT     prefix for output files
'''
 
doc['fit_tscan'] = '''
fit_tscan
*********

fitting tscan data using sum of exponential decay covolved with
gaussian/cauchy(lorenzian)/pseudo voigt irf function. It uses
"fact_anal_exp_conv" to determine best c_i's where timezero, fwhm, and
time constants are given. So, to use this script what you need to give
are only timezero, fwhm, and time constants

Note:

  * If you set shape of irf to pseudo voigt (pv), then you should
    provide two full width at half maximum value for gaussian and
    cauchy parts, respectively.

  * If you did not set tau then it assume you finds the timezero of
    this scan. So, --no_base option is discouraged.

* usage: fit_tscan    [-h] [--irf {g,c,pv}] [--fwhm_G FWHM_G]
  [--fwhm_L FWHM_L] [-t0 TIME_ZEROS [TIME_ZEROS ...]] [-t0f
  TIME_ZEROS_FILE] [--tau [TAU [TAU ...]]] [--no_base] [-o OUT] prefix

* positional arguments:

  * prefix                prefix for tscan files It will read
    prefix_i.txt

* optional arguments:

  * -h, --help            show this help message and exit

  * --irf {g,c,pv}        shape of instrument response function g:
    gaussian distribution c: cauchy distribution pv: pseudo voigt
    profile, linear combination of gaussian distribution and cauchy
    distribution pv = eta*c+(1-eta)*g the mixing parameter is guessed
    according to Journal of Applied Crystallography. 33 (6):
    1311–1316.

  * --fwhm_G FWHM_G       full width at half maximum for gaussian
    shape It should not used when you set cauchy irf function

  * --fwhm_L FWHM_L       full width at half maximum for cauchy shape
    It should not used when you did not set irf or use gaussian irf
    function

  * -t0 TIME_ZEROS [TIME_ZEROS ...], --time_zeros TIME_ZEROS
    [TIME_ZEROS ...] time zeros for each tscan

  * -t0f TIME_ZEROS_FILE, --time_zeros_file TIME_ZEROS_FILE filename
    for time zeros of each tscan

  * --tau [TAU [TAU ...]] lifetime of each component

  * --no_base             exclude baseline for fitting

  * -o OUT, --out OUT     prefix for output files

**Parameter bound scheme**

* fwhm: temporal width of x-ray pulse

  * lower bound: 0.5*fwhm_init

  * upper bound: 2*fwhm_init

* t_0: timezero for each scan

  * lower bound: t_0 - 2*fwhm_init

  * upper bound: t_0 + 2*fwhm_init

* tau: life_time of each component

  * if tau < 0.1

    * lower bound: tau/2

    * upper bound: 1

  * if 0.1 < tau < 10

    * lower bound: 0.05

    * upper bound: 100

  * if 10 < tau < 100

    * lower bound: 5

    * upper bound: 500

  * if 100 < tau < 1000

    * lower bound: 50

    * upper bound: 2000

  * if 1000 < tau then

    * lower bound: tau/2

    * upper bound: np.inf

**Mixing parameter eta**

For pseudo voigt IRF function, mixing parameter eta is guessed to

   \eta =
   1.36603({fwhm}_L/f)-0.47719({fwhm}_L/f)^2+0.11116({fwhm}_L/f)^3

where

   \begin{align*} f &=
   ({fwhm}_G^5+2.69269{fwhm}_G^4{fwhm}_L+2.42843{fwhm}_G^3{fwhm}_L^2
   \\   &+ 4.47163{fwhm}_G^2{fwhm}_L^3+0.07842{fwhm}_G{fwhm}_L^4 \\
   &+ {fwhm}_L^5)^{1/5} \end{align*}

This guess is according to J. Appl. Cryst. (2000). **33**, 1311-1316
'''
 
doc['TRXASprefitpack_info'] = '''
TRXASprefitpack_info
********************

Access the document of TRXASprefitpack

Type "TRXASprefitpack_info func_name" to get a description of
func_name
'''
 
doc['auto_scale'] = '''
auto_scale
**********

Automatic scaling escan and tscan data using "A-method"

Note:

  auto_scale assume each escan have same energy range and and each
  tscan have same time range. Also it assumes energy unit of escan
  data is KeV but assumes energy unit of tscan_energy_file is eV.
  Moreover energy unit of scaled_escan is eV. However time unit for
  tscan data and escan time must be same.

* usage: auto_scale    [-h] [-p PREFIX] [-ne NUM_OF_ESCAN] [-et
  ESCAN_TIME] [-re REF_ESCAN_INDEX] [-nt NUM_OF_TSCAN] [-te
  TSCAN_ENERGY] [-t0 TIME_ZEROS] [-ti TSCAN_INDEX_TO_SCALE
  [TSCAN_INDEX_TO_SCALE ...]] [-a PARM_A] {-1,0,1,2,3,4}

* positional arguments:

  * {-1,0,1,2,3,4}        current stage, set stage to -1 get detailed
    description

* optional arguments:

  * -h, --help            show this help message and exit

  * -p PREFIX, --prefix PREFIX prefix for both escan and tscan file,
    it will read prefix_escan_i.txt and prefix_tscan_j.txt

  * -ne NUM_OF_ESCAN, --num_of_escan NUM_OF_ESCAN the number of escan
    files

  * -et ESCAN_TIME, --escan_time ESCAN_TIME filename for escan delay
    times (unit: ps)

  * -re REF_ESCAN_INDEX, --ref_escan_index REF_ESCAN_INDEX index of
    escan used to the reference for scaling

  * -nt NUM_OF_TSCAN, --num_of_tscan NUM_OF_TSCAN the number of tscan
    files

  * -te TSCAN_ENERGY, --tscan_energy TSCAN_ENERGY filename for tscan
    energy (unit: eV)

  * -t0 TIME_ZEROS, --time_zeros TIME_ZEROS filename for time zero of
    each tscan (unit: ps)

  * -ti TSCAN_INDEX_TO_SCALE [TSCAN_INDEX_TO_SCALE ...],
    --tscan_index_to_scale TSCAN_INDEX_TO_SCALE [TSCAN_INDEX_TO_SCALE
    ...] tscan index to scale, use blank separation for multiple
    arguments

  * -a PARM_A, --parm_A PARM_A filename for the parameter A obtained
    from fit_static

* Stage discription

* stage -1: description It prints the description about each stages
  and aborts.

  Note:

    For every stage except -1, requires prefix, num_of_escan,
    escan_time, num_of_tscan, tscan_energy, time_zeros

* stage 0: init scaling

  Additionally requires: ref_escan_index, tscan_index_to_scale, parm_A

  the program read escan_data from
  prefix_escan_1.txt,...,prefix_num_escan.txt and tscan_data from
  prefix_tscan_1.txt,...,prefix_tscan_num_tscan.txt Also, it read file
  for parameter A generated by fit static. Then it fits scaling of
  escan_data and tscan_i_1,...,tscan_i_N to escan_e_ref. Now it
  generates prefix_escan_scaled.txt (energy unit: eV)
  prefix_escan_eps_scaled.txt prefix_tscan_scaled.txt
  prefix_tscan_eps_scaled.txt prefix_A_ref.txt If you do not include
  tscan j for scaling. You can see (j+1) th column of
  prefix_tscan_scaled.txt and j th column of tscan_scaled_eps.txt are
  filled with zeros.

* stage 1: Correction

  Additionally requires: ref_escan_index, tscan_index_to_scale

  Note:

    ref_escan_index and tscan_index_to_scale must be set to same as
    stage 0

  the program read scaled escan data and tscan data from
  prefix_escan_scaled.txt, prefix_escan_eps_scaled.txt,
  prefix_tscan_scaled.txt, prefix_tscan_eps_scaled.txt, and then it
  corrects scaling of escan using tscan_i_1 It regenerates
  prefix_escan_scaled.txt and prefix_escan_eps_scaled.txt

* stage 2: further scaling

  Additionally requires: tscan_index_to_scale

  Note:

    in this stage do not need to give the file name for parameter A.

  the program read scaled escan data and tscan data from
  prefix_escan_scaled.txt, prefix_escan_eps_scaled.txt,
  prefix_tscan_scaled.txt, prefix_tscan_eps_scaled.txt, and then it
  fits scaling of tscan_i'_1,...,tscan_i'*N' to escan_e_ref'. (Prime
  means i_1,...,i_N and e_ref values are different from stage 0) Then
  it regenerates all prefix**.txt except prefix_A_ref.txt

* stage 3: sanity check

  In this stage, the program assume, every tscan data are scaled to
  escan data. For sanity check, it gives a graph for you.

* stage 4: Scaling with another tscan data set Scale Another set of
  tscan data using already scaled escan data

  Additionally requires: tscan_index_to_scale

  Note:

    Before proceed stage 4, you should move prefix_tscan_scaled.txt,
    prefix_tscan_eps_scaled.txt and prefix_tscan_xxx.txt to some
    backup folder and rename your another tscan data set to
    prefix_tscan_xxx.txt Also you should give time_zero and energy for
    such tscan.

  In this stage, it reads scaled escan data and eps from
  prefix_escan_scaled.txt and prefix_escan_eps_scaled.txt Then it
  reads unscaled tscan data and eps from prefix_tscan_*.txt Next, it
  scales tscan datas just like stage 1. After stage4 finished you
  should go to stage 2 and stage 3.

* A-method

  When we measure each escan, we measure static spectrum (flu_off) to
  get difference spectrum (flu_on - flu_off) Since we have theortical
  static spectrum, we can fit theortical spectrum with measured static
  spectrum using following model.

     y = A \cdot {conv}({spec}_{thy}, {voigt}({fwhm}_G, {fwhm}_L,
     {peakshift})) + {baseline}

  Also, using "fit_static", you can simultaneous fitting each escan.
  During fitting process, it assume fwhm_G, fwhm_L, peak_shift are
  same in each escan, only scaling factor A and base_line are
  different. Parameter base_line reflects environmental effects, so
  pure static signal(w/o environmental effects) is

     A \cdot {conv}({spec}_{thy}, {voigt}({fwhm}_G, {fwhm}_L,
     {peakshift}))

  Each escan has same fwhm_G, fwhm_L and peak_shift value, so
  Parameter A (scaling parameter) could tell relative scaling of each
  escan. In other words, we can fit scaling of escan data just
  multipling A_ref/A to each escan. However, due to inconsistence of
  laser overlap between energy scans, one good time delay scan is
  needed to correct the scaling of energy scans.
'''
 
doc['broadening'] = '''
broadening
**********

voigt broaden theoritical calculated lineshape spectrum

* usage: broadening [-h] [-o OUT] peak e_min e_max A fwhm_G fwhm_L
  peak_shift

* positional arguments:

  * peak               filename for calculated line shape spectrum

  * e_min              minimum energy

  * e_max              maximum energy

  * A                  scale factor

  * fwhm_G             Full Width at Half Maximum of gaussian shape

  * fwhm_L             Full Width at Half Maximum of lorenzian shape

  * peak_shift         discrepancy of peak position between theory and
    experiment

* optional arguments:

  * -h, --help         show this help message and exit

  * -o OUT, --out OUT  prefix for output files
'''
 
__info__.appnd('version', doc['version']) 
__info__.appnd('description', doc['description']) 
__info__.appnd('licence', doc['licence']) 
__info__.appnd('lgpl-3.0', doc['lgpl-3.0']) 
__info__.appnd('gen_theory_data', doc['gen_theory_data']) 
__info__.appnd('automate_scaling', doc['automate_scaling']) 
__info__.appnd('corr_a_method', doc['corr_a_method']) 
__info__.appnd('exp_conv_gau', doc['exp_conv_gau']) 
__info__.appnd('exp_conv_cauchy', doc['exp_conv_cauchy']) 
__info__.appnd('solve_model', doc['solve_model']) 
__info__.appnd('compute_model', doc['compute_model']) 
__info__.appnd('compute_signal_gau', doc['compute_signal_gau']) 
__info__.appnd('compute_signal_cauchy', doc['compute_signal_cauchy']) 
__info__.appnd('compute_signal_pvoigt', doc['compute_signal_pvoigt']) 
__info__.appnd('model_n_comp_conv', doc['model_n_comp_conv']) 
__info__.appnd('fact_anal_exp_conv', doc['fact_anal_exp_conv']) 
__info__.appnd('fit_static', doc['fit_static']) 
__info__.appnd('fit_tscan', doc['fit_tscan']) 
__info__.appnd('TRXASprefitpack_info', doc['TRXASprefitpack_info']) 
__info__.appnd('auto_scale', doc['auto_scale']) 
__info__.appnd('broadening', doc['broadening']) 
__info__ = __info__.info
del doc