"""
This type stub file was generated by pyright.
"""

from ldap.controls import LDAPControl, RequestControl, ResponseControl

"""
ldap.controls.simple - classes for some very simple LDAP controls

See https://www.python-ldap.org/ for details.
"""
class ValueLessRequestControl(RequestControl):
  """
  Base class for controls without a controlValue.
  The presence of the control in a LDAPv3 request changes the server's
  behaviour when processing the request simply based on the controlType.

  controlType
    OID of the request control
  criticality
    criticality request control
  """
  def __init__(self, controlType=..., criticality=...) -> None:
    ...
  
  def encodeControlValue(self): # -> None:
    ...
  


class OctetStringInteger(LDAPControl):
  """
  Base class with controlValue being unsigend integer values

  integerValue
    Integer to be sent as OctetString
  """
  def __init__(self, controlType=..., criticality=..., integerValue=...) -> None:
    ...
  
  def encodeControlValue(self): # -> bytes:
    ...
  
  def decodeControlValue(self, encodedControlValue): # -> None:
    ...
  


class BooleanControl(LDAPControl):
  """
  Base class for simple request controls with boolean control value.

  Constructor argument and class attribute:

  booleanValue
    Boolean (True/False or 1/0) which is the boolean controlValue.
  """
  def __init__(self, controlType=..., criticality=..., booleanValue=...) -> None:
    ...
  
  def encodeControlValue(self):
    ...
  
  def decodeControlValue(self, encodedControlValue): # -> None:
    ...
  


class ManageDSAITControl(ValueLessRequestControl):
  """
  Manage DSA IT Control
  """
  def __init__(self, criticality=...) -> None:
    ...
  


class RelaxRulesControl(ValueLessRequestControl):
  """
  Relax Rules Control
  """
  def __init__(self, criticality=...) -> None:
    ...
  


class ProxyAuthzControl(RequestControl):
  """
  Proxy Authorization Control

  authzId
    string containing the authorization ID indicating the identity
    on behalf which the server should process the request
  """
  def __init__(self, criticality, authzId) -> None:
    ...
  


class AuthorizationIdentityRequestControl(ValueLessRequestControl):
  """
  Authorization Identity Request and Response Controls
  """
  controlType = ...
  def __init__(self, criticality) -> None:
    ...
  


class AuthorizationIdentityResponseControl(ResponseControl):
  """
  Authorization Identity Request and Response Controls

  Class attributes:

  authzId
    decoded authorization identity
  """
  controlType = ...
  def decodeControlValue(self, encodedControlValue): # -> None:
    ...
  


class GetEffectiveRightsControl(RequestControl):
  """
  Get Effective Rights Control
  """
  def __init__(self, criticality, authzId=...) -> None:
    ...
  


