"""
This type stub file was generated by pyright.
"""

"""
dn.py - misc stuff for handling distinguished names (see RFC 4514)

See https://www.python-ldap.org/ for details.
"""
def escape_dn_chars(s): # -> LiteralString:
  """
  Escape all DN special characters found in s
  with a back-slash (see RFC 4514, section 2.4)
  """
  ...

def str2dn(dn, flags=...): # -> list[Any]:
  """
  This function takes a DN as string as parameter and returns
  a decomposed DN. It's the inverse to dn2str().

  flags describes the format of the dn

  See also the OpenLDAP man-page ldap_str2dn(3)
  """
  ...

def dn2str(dn): # -> LiteralString:
  """
  This function takes a decomposed DN as parameter and returns
  a single string. It's the inverse to str2dn() but will always
  return a DN in LDAPv3 format compliant to RFC 4514.
  """
  ...

def explode_dn(dn, notypes=..., flags=...): # -> list[Any]:
  """
  explode_dn(dn [, notypes=False [, flags=0]]) -> list

  This function takes a DN and breaks it up into its component parts.
  The notypes parameter is used to specify that only the component's
  attribute values be returned and not the attribute types.
  """
  ...

def explode_rdn(rdn, notypes=..., flags=...): # -> list[Any] | list[Any | str] | list[str]:
  """
  explode_rdn(rdn [, notypes=0 [, flags=0]]) -> list

  This function takes a RDN and breaks it up into its component parts
  if it is a multi-valued RDN.
  The notypes parameter is used to specify that only the component's
  attribute values be returned and not the attribute types.
  """
  ...

def is_dn(s, flags=...): # -> bool:
  """
  Returns True if `s' can be parsed by ldap.dn.str2dn() as a
  distinguished host_name (DN), otherwise False is returned.
  """
  ...

