"""
This type stub file was generated by pyright.
"""

"""
functions.py - wraps functions of module _ldap

See https://www.python-ldap.org/ for details.
"""
__all__ = ['open', 'initialize', 'init', 'explode_dn', 'explode_rdn', 'get_option', 'set_option', 'escape_str', 'strf_secs', 'strp_secs']
if __debug__:
  ...
def initialize(uri, trace_level=..., trace_file=..., trace_stack_limit=..., bytes_mode=..., fileno=..., **kwargs): # -> LDAPObject:
  """
  Return LDAPObject instance by opening LDAP connection to
  LDAP host specified by LDAP URL

  Parameters:
  uri
        LDAP URL containing at least connection scheme and hostport,
        e.g. ldap://localhost:389
  trace_level
        If non-zero a trace output of LDAP calls is generated.
  trace_file
        File object where to write the trace output to.
        Default is to use stdout.
  bytes_mode
        Whether to enable :ref:`bytes_mode` for backwards compatibility under Py2.
  fileno
        If not None the socket file descriptor is used to connect to an
        LDAP server.

  Additional keyword arguments (such as ``bytes_strictness``) are
  passed to ``LDAPObject``.
  """
  ...

def get_option(option):
  """
  get_option(name) -> value

  Get the value of an LDAP global option.
  """
  ...

def set_option(option, invalue):
  """
  set_option(name, value)

  Set the value of an LDAP global option.
  """
  ...

def escape_str(escape_func, s, *args):
  """
  Applies escape_func() to all items of `args' and returns a string based
  on format string `s'.
  """
  ...

def strf_secs(secs): # -> str:
  """
    Convert seconds since epoch to a string compliant to LDAP syntax GeneralizedTime
    """
  ...

def strp_secs(dt_str): # -> int:
  """
    Convert LDAP syntax GeneralizedTime to seconds since epoch
    """
  ...

