/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.SchemaObject;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.SortAndSlice;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.IntKeyHashMap;
import com.datapps.linkoopdb.jdbc.lib.IntValueHashMap;
import com.datapps.linkoopdb.jdbc.lib.ObjectComparator;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.AnyType;
import com.datapps.linkoopdb.jdbc.types.ArrayType;
import com.datapps.linkoopdb.jdbc.types.BinaryType;
import com.datapps.linkoopdb.jdbc.types.BinaryUUIDType;
import com.datapps.linkoopdb.jdbc.types.BitType;
import com.datapps.linkoopdb.jdbc.types.BlobType;
import com.datapps.linkoopdb.jdbc.types.BooleanType;
import com.datapps.linkoopdb.jdbc.types.CharacterType;
import com.datapps.linkoopdb.jdbc.types.Charset;
import com.datapps.linkoopdb.jdbc.types.ClobType;
import com.datapps.linkoopdb.jdbc.types.Collation;
import com.datapps.linkoopdb.jdbc.types.DateTimeType;
import com.datapps.linkoopdb.jdbc.types.GraphType;
import com.datapps.linkoopdb.jdbc.types.ImageType;
import com.datapps.linkoopdb.jdbc.types.IntervalType;
import com.datapps.linkoopdb.jdbc.types.ModelType;
import com.datapps.linkoopdb.jdbc.types.NullType;
import com.datapps.linkoopdb.jdbc.types.NumberType;
import com.datapps.linkoopdb.jdbc.types.OtherType;
import com.datapps.linkoopdb.jdbc.types.PipelineType;
import com.datapps.linkoopdb.jdbc.types.TableType;
import com.datapps.linkoopdb.jdbc.types.TypeHelper;
import com.datapps.linkoopdb.jdbc.types.UserTypeModifier;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class Type
implements SchemaObject,
Cloneable,
Serializable {
    public static final int NOT_DBLINK = 0;
    public static final int SQLSERVER_DBLINK = 1;
    public static final int ORACLE_DBLINK = 2;
    public static final int MYSQL_DBLINK = 3;
    public static final int POSTGRESQL_DBLINK = 4;
    public static final int HIVE_DBLINK = 5;
    public static final int TERADATA_DBLINK = 6;
    public static final int DM_DBLINK = 7;
    public static final int GBASE_DBLINK = 8;
    public static final int SHENGTONG_DBLINK = 9;
    public static final int KINGBASE_DBLINK = 10;
    public static final int PDMS_DBLINK = 11;
    public static final int HIVE_JDBC_DBLINK = 12;
    public static final Type[] emptyArray = new Type[0];
    public static final Type SQL_ALL_TYPES = NullType.getNullType();
    public static final CharacterType SQL_CHAR = new CharacterType(1, 1L);
    public static final CharacterType SQL_CHAR_16 = new CharacterType(1, 16L);
    public static final CharacterType SQL_CHAR_DEFAULT = new CharacterType(1, 256L);
    public static final CharacterType SQL_VARCHAR = new CharacterType(12, 0L);
    public static final CharacterType SQL_VARCHAR_DEFAULT = new CharacterType(12, 32768L);
    public static final CharacterType SQL_VARCHAR_MAX = new CharacterType(12, Integer.MAX_VALUE);
    public static final ClobType SQL_CLOB = new ClobType(0x40000000L);
    public static final BitType SQL_BIT = new BitType(14, 1L);
    public static final BitType SQL_BIT_VARYING = new BitType(15, 1L);
    public static final BitType SQL_BIT_VARYING_MAX_LENGTH = new BitType(15, 1024L);
    public static final BinaryType SQL_BINARY = new BinaryType(60, 1L);
    public static final BinaryType SQL_BINARY_16 = new BinaryType(60, 16L);
    public static final BinaryType SQL_BINARY_40 = new BinaryType(60, 40L);
    public static final BinaryType SQL_BINARY_DEFAULT = new BinaryType(60, 32768L);
    public static final BinaryType SQL_VARBINARY = new BinaryType(61, 0L);
    public static final BinaryType SQL_VARBINARY_DEFAULT = new BinaryType(61, 32768L);
    public static final BlobType SQL_BLOB = new BlobType(0x40000000L);
    public static final BinaryType SQL_GUID = new BinaryUUIDType();
    public static final OtherType OTHER = OtherType.getOtherType();
    public static final AnyType ANYTYPE = AnyType.getAnyType();
    public static final BooleanType SQL_BOOLEAN = BooleanType.getBooleanType();
    public static final NumberType SQL_NUMERIC = new NumberType(2, 38L, 0);
    public static final NumberType SQL_DECIMAL = new NumberType(3, 38L, 0);
    public static final NumberType SQL_DECIMAL_DEFAULT = new NumberType(3, 38L, 0);
    public static final NumberType SQL_DECIMAL_BIGINT_SQR = new NumberType(3, 40L, 0);
    public static final NumberType SQL_DOUBLE = new NumberType(8, 0L, 0);
    public static final NumberType SQL_FLOAT = new NumberType(6, 0L, 0);
    public static final NumberType TINYINT = new NumberType(-6, 3L, 0);
    public static final NumberType SQL_SMALLINT = new NumberType(5, 5L, 0);
    public static final NumberType SQL_INTEGER = new NumberType(4, 10L, 0);
    public static final NumberType SQL_BIGINT = new NumberType(25, 19L, 0);
    public static final DateTimeType SQL_DATE = new DateTimeType(93, 91, 0);
    public static final DateTimeType SQL_TIME = new DateTimeType(92, 92, 0);
    public static final DateTimeType SQL_TIME_WITH_TIME_ZONE = new DateTimeType(92, 94, 0);
    public static final DateTimeType SQL_TIMESTAMP = new DateTimeType(93, 93, 6);
    public static final DateTimeType SQL_TIMESTAMP_WITH_TIME_ZONE = new DateTimeType(93, 95, 6);
    public static final DateTimeType SQL_TIMESTAMP_NO_FRACTION = new DateTimeType(93, 93, 0);
    public static final IntervalType SQL_INTERVAL_YEAR = IntervalType.newIntervalType(101, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH = IntervalType.newIntervalType(102, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY = IntervalType.newIntervalType(103, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR = IntervalType.newIntervalType(104, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE = IntervalType.newIntervalType(105, 2L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND = IntervalType.newIntervalType(106, 2L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION = IntervalType.newIntervalType(106, 2L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH = IntervalType.newIntervalType(107, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_HOUR = IntervalType.newIntervalType(108, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_MINUTE = IntervalType.newIntervalType(109, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND = IntervalType.newIntervalType(110, 2L, 6);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_MINUTE = IntervalType.newIntervalType(111, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_SECOND = IntervalType.newIntervalType(112, 2L, 6);
    public static final IntervalType SQL_INTERVAL_MINUTE_TO_SECOND = IntervalType.newIntervalType(113, 2L, 6);
    public static final IntervalType SQL_INTERVAL_YEAR_MAX_PRECISION = IntervalType.newIntervalType(101, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH_MAX_PRECISION = IntervalType.newIntervalType(102, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_MAX_PRECISION = IntervalType.newIntervalType(103, 9L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_MAX_PRECISION = IntervalType.newIntervalType(104, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE_MAX_PRECISION = IntervalType.newIntervalType(105, 9L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_PRECISION = IntervalType.newIntervalType(106, 12L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION = IntervalType.newIntervalType(106, 12L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION = IntervalType.newIntervalType(107, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION = IntervalType.newIntervalType(110, 9L, 9);
    public static final ArrayType SQL_ARRAY_ALL_TYPES = new ArrayType(SQL_ALL_TYPES, 0);
    public static final ImageType IMAGE_TYPE = ImageType.getInstance();
    public static final IntValueHashMap typeAliases;
    public static final IntValueHashMap typeNames;
    public static final IntKeyHashMap jdbcConvertTypes;
    public static ThreadLocal<Integer> dbLinkType;
    public static TypeHelper typeHelper;
    public final int typeComparisonGroup;
    public final int typeDataGroup;
    public final int typeCode;
    public final long precision;
    public final int scale;
    public UserTypeModifier userTypeModifier;

    Type(int typeGroup, int type, long precision, int scale) {
        this.typeComparisonGroup = typeGroup;
        this.typeCode = type;
        this.precision = precision;
        this.scale = scale;
        this.typeDataGroup = this.typeCode == 1 ? 12 : this.typeCode;
    }

    public static TypedComparator newComparator(SessionInterface session) {
        return new TypedComparator(session);
    }

    public static ArrayType getDefaultArrayType(int type) {
        return new ArrayType(Type.getDefaultType(type), 1024);
    }

    public static Type getDefaultType(int type) {
        try {
            return Type.getType(type, SQL_VARCHAR.getCharacterSet(), SQL_VARCHAR.getCollation(), 0L, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Type getDefaultTypeWithSize(int type) {
        switch (type) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case 50: {
                return SQL_ARRAY_ALL_TYPES;
            }
            case 1: {
                return SQL_CHAR_DEFAULT;
            }
            case 12: {
                return SQL_VARCHAR_DEFAULT;
            }
            case 40: {
                return SQL_CLOB;
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 6: 
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: {
                return SQL_NUMERIC;
            }
            case 3: {
                return SQL_DECIMAL;
            }
            case 16: {
                return SQL_BOOLEAN;
            }
            case 60: {
                return SQL_BINARY_DEFAULT;
            }
            case 61: {
                return SQL_VARBINARY_DEFAULT;
            }
            case 30: {
                return SQL_BLOB;
            }
            case 14: {
                return SQL_BIT;
            }
            case 15: {
                return SQL_BIT_VARYING;
            }
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                return SQL_TIME;
            }
            case 94: {
                return SQL_TIME_WITH_TIME_ZONE;
            }
            case 93: {
                return SQL_TIMESTAMP;
            }
            case 95: {
                return SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            case 101: {
                return SQL_INTERVAL_YEAR;
            }
            case 107: {
                return SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 102: {
                return SQL_INTERVAL_MONTH;
            }
            case 103: {
                return SQL_INTERVAL_DAY;
            }
            case 108: {
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                return SQL_INTERVAL_HOUR;
            }
            case 111: {
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 112: {
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 105: {
                return SQL_INTERVAL_MINUTE;
            }
            case 113: {
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                return SQL_INTERVAL_SECOND;
            }
            case 1111: {
                return OTHER;
            }
        }
        return null;
    }

    public static int getLinkoopDBTypeCode(int jdbcTypeNumber) {
        switch (jdbcTypeNumber) {
            case -5: {
                return 25;
            }
            case -1: {
                return 12;
            }
            case 2005: {
                return 40;
            }
            case -2: {
                return 60;
            }
            case -7: {
                return 15;
            }
            case -4: 
            case -3: {
                return 61;
            }
            case 2004: {
                return 30;
            }
            case 2003: {
                return 50;
            }
        }
        return jdbcTypeNumber;
    }

    public static int getJDBCTypeCode(int type) {
        switch (type) {
            case 30: {
                return 2004;
            }
            case 40: {
                return 2005;
            }
            case 25: {
                return -5;
            }
            case 60: {
                return -2;
            }
            case 61: {
                return -3;
            }
            case 14: 
            case 15: {
                return -7;
            }
            case 50: {
                return 2003;
            }
        }
        return type;
    }

    public static Type getType(Type type, Collation collation) {
        if (type.getCollation() == collation) {
            return type;
        }
        if (type.isCharacterType()) {
            type = type.duplicate();
            ((CharacterType)type).collation = collation;
        }
        return type;
    }

    public static Type getType(int type, Charset charset, Collation collation, long precision, int scale) {
        switch (type) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case 1: 
            case 12: 
            case 40: {
                return CharacterType.getCharacterType(type, precision, collation);
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 6: {
                if (precision > 53L) {
                    throw Error.error(5592, "" + precision);
                }
                return SQL_FLOAT;
            }
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                if (precision == 0L) {
                    precision = 38L;
                }
                return NumberType.getNumberType(type, precision, scale);
            }
            case 16: {
                return SQL_BOOLEAN;
            }
            case 30: 
            case 60: 
            case 61: {
                return BinaryType.getBinaryType(type, precision);
            }
            case -11: {
                return SQL_GUID;
            }
            case 14: 
            case 15: {
                return BitType.getBitType(type, precision);
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return DateTimeType.getDateTimeType(type, scale);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalType.getIntervalType(type, precision, scale);
            }
            case 1111: {
                return OTHER;
            }
            case 11112: {
                return ANYTYPE;
            }
            case 114: {
                return new TableType();
            }
            case 115: {
                return new ModelType();
            }
            case 117: {
                return new PipelineType();
            }
            case 116: {
                return new GraphType();
            }
        }
        throw Error.runtimeError(201, "Type");
    }

    public static Type getAggregateType(Type add, Type existing) {
        if (existing == null || existing.typeCode == 0) {
            return add;
        }
        if (add == null || add.typeCode == 0) {
            return existing;
        }
        return existing.getAggregateType(add);
    }

    public static int getTypeNr(String name) {
        int i = typeNames.get((Object)name, Integer.MIN_VALUE);
        if (i == Integer.MIN_VALUE) {
            i = typeAliases.get((Object)name, Integer.MIN_VALUE);
        }
        return i;
    }

    public static Type getTypeForJDBCConvertToken(int name) {
        return (Type)jdbcConvertTypes.get(name);
    }

    public static boolean isSupportedSQLType(int typeNumber) {
        return Type.getDefaultType(typeNumber) != null;
    }

    public static boolean matches(Type[] one, Type[] other) {
        for (int i = 0; i < one.length; ++i) {
            if (one[i].typeCode == other[i].typeCode) continue;
            return false;
        }
        return true;
    }

    public static int[] getBlobTypes(Type[] types) {
        ArrayList<Integer> blobCols = new ArrayList<Integer>();
        for (int i = 0; i < types.length; ++i) {
            int code = types[i].typeCode;
            if (code != 2004 && code != 30 && code != 2005 && code != 40) continue;
            blobCols.add(i);
        }
        int[] blobs = new int[blobCols.size()];
        for (int i = 0; i < blobCols.size(); ++i) {
            blobs[i] = (Integer)blobCols.get(i);
        }
        return blobs;
    }

    @Override
    public int getType() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getType();
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getName();
    }

    public boolean sameType(Type otherType) {
        if (this instanceof ArrayType && otherType instanceof ArrayType) {
            return ((ArrayType)this).getDataType().sameType(((ArrayType)otherType).getDataType());
        }
        return this == otherType;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getCatalogName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName().schema;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getSchemaName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName();
    }

    @Override
    public Grantee getOwner() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getOwner();
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getReferences();
    }

    @Override
    public OrderedHashSet getComponents() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getComponents();
    }

    @Override
    public void compile(SessionInterface session, SchemaObject parentObject) {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        this.userTypeModifier.compile(session);
    }

    @Override
    public String getSQL() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSQL();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public Type duplicate() {
        try {
            return (Type)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Error.runtimeError(201, "Type");
        }
    }

    public abstract int displaySize();

    public abstract int getJDBCTypeCode();

    public abstract String getJDBCClassName();

    public abstract Class getJDBCClass();

    public int getJDBCScale() {
        return this.scale;
    }

    public int getJDBCPrecision() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public abstract String getNameString();

    public String getFullNameString() {
        return this.getNameString();
    }

    public abstract String getDefinition();

    public Collation getCollation() {
        return null;
    }

    public Charset getCharacterSet() {
        return null;
    }

    private boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public final String getTypeDefinition() {
        Integer value = dbLinkType.get();
        if (this.isEmpty(value)) {
            value = 0;
        }
        String type = this.getDefinition();
        switch (value) {
            case 1: {
                if ("DOUBLE".equals(type)) {
                    type = "FLOAT";
                    break;
                }
                if ("REAL".equals(type)) {
                    type = "FLOAT";
                    break;
                }
                if ("BIT(1)".equals(type)) {
                    type = "BIT";
                    break;
                }
                if ("TIMESTAMP".equals(type)) {
                    type = "DATETIME";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 8000) break;
                    type = "VARCHAR(MAX)";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "VARCHAR(MAX)";
                    break;
                }
                if (type.startsWith("VARBINARY(") || type.startsWith("BINARY(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 8000) break;
                    type = "VARBINARY(MAX)";
                    break;
                }
                if (type.startsWith("BIT VARYING(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) > 8000) {
                        type = "VARBINARY(MAX)";
                        break;
                    }
                    type = "VARBINARY(" + getSignInfo + ")";
                    break;
                }
                if (!type.startsWith("BLOB")) break;
                type = "VARBINARY(MAX)";
                break;
            }
            case 2: 
            case 7: {
                if ("DOUBLE".equals(type)) {
                    type = "FLOAT";
                    break;
                }
                if (type.startsWith("BLOB(")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 4000) break;
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARBINARY(") || type.startsWith("BINARY(") || type.startsWith("BIT(") || type.startsWith("BIT VARYING(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) > 2000) {
                        type = "BLOB";
                        break;
                    }
                    type = "RAW(" + getSignInfo + ")";
                    break;
                }
                if (!type.equals("BIGINT")) break;
                type = "NUMBER(20)";
                break;
            }
            case 3: {
                if ("DOUBLE".equals(type)) {
                    type = "FLOAT";
                    break;
                }
                if (type.startsWith("BLOB(")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 21844) break;
                    type = "TEXT";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "TEXT";
                    break;
                }
                if (type.startsWith("BINARY(") || type.startsWith("BIT(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) > 255) {
                        type = "BLOB";
                        break;
                    }
                    type = "BINARY(" + getSignInfo + ")";
                    break;
                }
                if (!type.startsWith("VARBINARY(") && !type.startsWith("BIT VARYING(")) break;
                String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                if (Integer.valueOf(getSignInfo) > 21845) {
                    type = "BLOB";
                    break;
                }
                type = "VARBINARY(" + getSignInfo + ")";
                break;
            }
            case 4: {
                String getSignInfo;
                if ("DOUBLE".equals(type) || type.equalsIgnoreCase("FLOAT")) {
                    type = "float8";
                    break;
                }
                if (type.equalsIgnoreCase("double precision") || type.equalsIgnoreCase("real")) {
                    type = "DOUBLE";
                    break;
                }
                if (type.equalsIgnoreCase("serial")) {
                    type = "INTEGER";
                    break;
                }
                if (type.equalsIgnoreCase("bigserial")) {
                    type = "BIGINT";
                    break;
                }
                if (type.equalsIgnoreCase("bytea")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("BLOB") || type.startsWith("VARBINARY") || type.startsWith("BIT VARYING") || type.startsWith("BINARY") || type.startsWith("BIT")) {
                    type = "bytea";
                    break;
                }
                if (type.startsWith("CLOB")) {
                    type = "TEXT";
                    break;
                }
                if (type.equalsIgnoreCase("TEXT")) {
                    type = "CLOB";
                    break;
                }
                if (!type.startsWith("VARCHAR(") || Integer.valueOf(getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"))) <= 0xA00000) break;
                type = "TEXT";
                break;
            }
            case 5: {
                if (type.startsWith("NUMERIC(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    type = "DECIMAL(" + getSignInfo + ")";
                    break;
                }
                if (type.startsWith("BINARY") || type.startsWith("VARBINARY") || type.startsWith("BIT") || type.startsWith("BLOB(")) {
                    type = "BINARY";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 65535) break;
                    type = "VARCHAR(65535)";
                    break;
                }
                if (!type.startsWith("CLOB(")) break;
                type = "STRING";
                break;
            }
            case 12: {
                if (type.startsWith("NUMERIC(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    type = "DECIMAL(" + getSignInfo + ")";
                    break;
                }
                if (type.startsWith("BINARY") || type.startsWith("VARBINARY") || type.startsWith("BIT") || type.startsWith("BLOB(")) {
                    type = "BINARY";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 65535) break;
                    type = "VARCHAR(65535)";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "STRING";
                    break;
                }
                if (!type.equalsIgnoreCase("INTEGER")) break;
                type = "INT";
                break;
            }
            case 6: {
                if (type.startsWith("TIME(")) {
                    type = "TIME";
                    break;
                }
                if (type.startsWith("DOUBLE")) {
                    type = "DOUBLE PRECISION";
                    break;
                }
                if (type.startsWith("BINARY") || type.startsWith("BIT(")) {
                    if (type.contains("(")) {
                        String getSignInfo = type.contains("(") ? type.substring(type.indexOf("(") + 1, type.indexOf(")")) : "";
                        type = "BYTE(" + getSignInfo + ")";
                        break;
                    }
                    type = "BYTE";
                    break;
                }
                if (!type.startsWith("VARBINARY") && !type.startsWith("BIT VARYING(")) break;
                if (type.contains("(")) {
                    String getSignInfo = type.contains("(") ? type.substring(type.indexOf("(") + 1, type.indexOf(")")) : "";
                    type = "VARBYTE(" + getSignInfo + ")";
                    break;
                }
                type = "VARBYTE";
                break;
            }
            case 8: {
                if ("DOUBLE".equals(type)) {
                    type = "FLOAT";
                    break;
                }
                if (type.startsWith("BLOB(")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 10922) break;
                    type = "TEXT";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "TEXT";
                    break;
                }
                if (type.startsWith("BINARY(") || type.startsWith("BIT(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) > 255) {
                        type = "BLOB";
                        break;
                    }
                    type = "BINARY(" + getSignInfo + ")";
                    break;
                }
                if (!type.startsWith("VARBINARY(") && !type.startsWith("BIT VARYING(")) break;
                String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                if (Integer.valueOf(getSignInfo) > Short.MAX_VALUE) {
                    type = "BLOB";
                    break;
                }
                type = "VARBINARY(" + getSignInfo + ")";
                break;
            }
            case 9: {
                if ("DOUBLE".equals(type) || type.equalsIgnoreCase("double precision")) {
                    type = "float8";
                    break;
                }
                if (type.equalsIgnoreCase("FLOAT")) {
                    type = "float(53)";
                    break;
                }
                if (type.equalsIgnoreCase("real")) {
                    type = "float4";
                    break;
                }
                if (type.startsWith("BLOB(")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 8000) break;
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARBINARY(") || type.startsWith("BINARY(")) {
                    String getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo) <= 8000) break;
                    type = "BLOB";
                    break;
                }
                if (!type.startsWith("BIT(") && !type.startsWith("BIT VARYING(")) break;
                type = "BLOB";
                break;
            }
            case 10: {
                String getSignInfo;
                if ("DOUBLE".equals(type) || type.equalsIgnoreCase("double precision")) {
                    type = "FLOAT";
                    break;
                }
                if (type.equalsIgnoreCase("FLOAT")) {
                    type = "float(53)";
                    break;
                }
                if (type.equalsIgnoreCase("real")) {
                    type = "float(24)";
                    break;
                }
                if (type.startsWith("BLOB(")) {
                    type = "BLOB";
                    break;
                }
                if (type.startsWith("CLOB(")) {
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARCHAR(")) {
                    String getSignInfo2 = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
                    if (Integer.valueOf(getSignInfo2) <= 8000) break;
                    type = "CLOB";
                    break;
                }
                if (type.startsWith("VARBINARY(") || type.startsWith("BINARY(")) {
                    type = "bytea";
                    break;
                }
                if (!type.startsWith("BIT(") && !type.startsWith("BIT VARYING(") || Integer.valueOf(getSignInfo = type.substring(type.indexOf("(") + 1, type.indexOf(")"))) <= 64000) break;
                type = "BLOB";
                break;
            }
        }
        if (this.userTypeModifier == null) {
            return type;
        }
        return this.getName().getSchemaQualifiedStatementName();
    }

    public abstract int compare(SessionInterface var1, Object var2, Object var3);

    public int compare(SessionInterface session, Object a, Object b, int opType) {
        if (a == b) {
            return 0;
        }
        return this.compare(session, a, b);
    }

    public int compare(SessionInterface session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return sort.sortNullsLast[0] ? 1 : -1;
        }
        if (b == null) {
            return sort.sortNullsLast[0] ? -1 : 1;
        }
        int result = this.compare(session, a, b);
        return sort.sortDescending[0] ? -result : result;
    }

    public abstract Object convertToTypeLimits(SessionInterface var1, Object var2);

    public Object castToType(SessionInterface session, Object a, Type type) {
        return this.convertToType(session, a, type);
    }

    public abstract Object convertToType(SessionInterface var1, Object var2, Type var3);

    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (otherType.isLobType()) {
            throw Error.error(5561);
        }
        return this.convertToType(session, a, otherType);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return a;
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        return a;
    }

    public Object convertDbToWorker(SessionInterface session, Object a) {
        return a;
    }

    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        return this.convertToType(session, a, type);
    }

    public abstract Object convertToDefaultType(SessionInterface var1, Object var2);

    public abstract String convertToString(Object var1);

    public abstract String convertToSQLString(Object var1);

    public abstract boolean canConvertFrom(Type var1);

    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        return -1;
    }

    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        return otherType.typeCode == 0 || this.typeComparisonGroup == otherType.typeComparisonGroup;
    }

    public boolean canCompareDirect(Type otherType) {
        return this.typeComparisonGroup == otherType.typeComparisonGroup;
    }

    public int arrayLimitCardinality() {
        return 0;
    }

    public Type collectionBaseType() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isMultisetType() {
        return false;
    }

    public boolean isRowType() {
        return false;
    }

    public boolean isStructuredType() {
        return false;
    }

    public boolean isCharacterType() {
        return false;
    }

    public boolean isNumberType() {
        return false;
    }

    public boolean isIntegralType() {
        return false;
    }

    public boolean isExactNumberType() {
        return false;
    }

    public boolean isDecimalType() {
        return false;
    }

    public boolean isDateTimeType() {
        return false;
    }

    public boolean isDateTimeTypeWithZone() {
        return false;
    }

    public boolean isDateOrTimestampType() {
        return false;
    }

    public boolean isTimestampType() {
        return false;
    }

    public boolean isIntervalType() {
        return false;
    }

    public boolean isIntervalYearMonthType() {
        return false;
    }

    public boolean isIntervalDaySecondType() {
        return false;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isUUIDType() {
        return false;
    }

    public boolean isBooleanType() {
        return false;
    }

    public boolean isLobType() {
        return false;
    }

    public boolean isBitType() {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isDistinctType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.schemaObjectType == 12;
    }

    public boolean isDomainType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.schemaObjectType == 13;
    }

    public int getDegree() {
        return 1;
    }

    public boolean acceptsPrecision() {
        return false;
    }

    public boolean requiresPrecision() {
        return false;
    }

    public long getMaxPrecision() {
        return 0L;
    }

    public int getMaxScale() {
        return 0;
    }

    public int getPrecisionRadix() {
        return 0;
    }

    public boolean acceptsFractionalPrecision() {
        return false;
    }

    public boolean acceptsScale() {
        return false;
    }

    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            if (this.typeCode == 50) {
                return this.collectionBaseType().precedenceDegree(other.collectionBaseType());
            }
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public abstract Type getAggregateType(Type var1);

    public abstract Type getCombinedType(SessionInterface var1, Type var2, int var3);

    public int compareToTypeRange(Object o) {
        return 0;
    }

    public Object absolute(Object a) {
        throw Error.runtimeError(201, "Type");
    }

    public Object negate(Object a) {
        throw Error.runtimeError(201, "Type");
    }

    public Object add(SessionInterface session, Object a, Object b, Type otherType) {
        throw Error.runtimeError(201, "Type");
    }

    public Object subtract(SessionInterface session, Object a, Object b, Type otherType) {
        throw Error.runtimeError(201, "Type");
    }

    public Object multiply(Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public Object divide(SessionInterface session, Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public Object concat(SessionInterface session, Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public int cardinality(SessionInterface session, Object a) {
        return 0;
    }

    public boolean isNegative(Object a) {
        return false;
    }

    int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        return a.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return ((Type)other).typeCode == this.typeCode && ((Type)other).precision == this.precision && ((Type)other).scale == this.scale && ((Type)other).userTypeModifier == this.userTypeModifier;
        }
        return false;
    }

    public int hashCode() {
        return this.typeCode + ((int)this.precision << 8) + (this.scale << 16);
    }

    public boolean isTableType() {
        return false;
    }

    public static boolean isNumericTypeOrNullType(Type type) {
        switch (type.typeCode) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: 
            case 11112: {
                return true;
            }
        }
        return false;
    }

    static {
        dbLinkType = new ThreadLocal();
        typeHelper = new TypeHelper();
        typeNames = new IntValueHashMap(37);
        typeNames.put("CHARACTER", 1);
        typeNames.put("VARCHAR", 12);
        typeNames.put("VARCHAR_IGNORECASE", 100);
        typeNames.put("NVARCHAR", 12);
        typeNames.put("DATE", 91);
        typeNames.put("TIME", 92);
        typeNames.put("TIMESTAMP", 93);
        typeNames.put("INTERVAL", 10);
        typeNames.put("TINYINT", -6);
        typeNames.put("SMALLINT", 5);
        typeNames.put("INTEGER", 4);
        typeNames.put("BIGINT", 25);
        typeNames.put("REAL", 7);
        typeNames.put("FLOAT", 6);
        typeNames.put("DOUBLE", 8);
        typeNames.put("NUMERIC", 2);
        typeNames.put("DECIMAL", 3);
        typeNames.put("BOOLEAN", 16);
        typeNames.put("BINARY", 60);
        typeNames.put("VARBINARY", 61);
        typeNames.put("CLOB", 40);
        typeNames.put("BLOB", 30);
        typeNames.put("BIT", 14);
        typeNames.put("OTHER", 1111);
        typeNames.put("ANYTYPE", 11112);
        typeNames.put("UUID", -11);
        typeNames.put("TABLE", 114);
        typeNames.put("MODEL", 115);
        typeNames.put("PIPELINE", 117);
        typeNames.put("GRAPH", 116);
        typeAliases = new IntValueHashMap(64);
        typeAliases.put("CHAR", 1);
        typeAliases.put("INT", 4);
        typeAliases.put("DEC", 3);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("DATETIME", 93);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OBJECT", 1111);
        typeNames.put("STRING", -1);
        jdbcConvertTypes = new IntKeyHashMap(37);
        jdbcConvertTypes.put(956, SQL_CHAR_DEFAULT);
        jdbcConvertTypes.put(979, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(966, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(970, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(958, SQL_DATE);
        jdbcConvertTypes.put(975, SQL_TIME);
        jdbcConvertTypes.put(976, SQL_TIMESTAMP);
        jdbcConvertTypes.put(977, TINYINT);
        jdbcConvertTypes.put(974, SQL_SMALLINT);
        jdbcConvertTypes.put(963, SQL_INTEGER);
        jdbcConvertTypes.put(951, SQL_BIGINT);
        jdbcConvertTypes.put(971, SQL_DOUBLE);
        jdbcConvertTypes.put(962, SQL_DOUBLE);
        jdbcConvertTypes.put(961, SQL_DOUBLE);
        jdbcConvertTypes.put(969, SQL_NUMERIC);
        jdbcConvertTypes.put(959, SQL_DECIMAL);
        jdbcConvertTypes.put(955, SQL_BOOLEAN);
        jdbcConvertTypes.put(952, SQL_BINARY_DEFAULT);
        jdbcConvertTypes.put(978, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(964, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(957, SQL_CLOB);
        jdbcConvertTypes.put(954, SQL_BLOB);
        jdbcConvertTypes.put(953, SQL_BIT);
    }

    public static class TypedComparator
    implements ObjectComparator {
        SessionInterface session;
        Type type;
        SortAndSlice sort;

        TypedComparator(SessionInterface session) {
            this.session = session;
        }

        public int compare(Object a, Object b) {
            return this.type.compare(this.session, a, b, this.sort);
        }

        @Override
        public int hashCode(Object a) {
            return this.type.hashCode(a);
        }

        @Override
        public long longKey(Object a) {
            return 0L;
        }

        public void setType(Type type, SortAndSlice sort) {
            this.type = type;
            this.sort = sort;
        }
    }
}

