#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KFServing

    Python SDK for KFServing  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha2ExplainerSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aix': 'V1alpha2AIXExplainerSpec',
        'alibi': 'V1alpha2AlibiExplainerSpec',
        'batcher': 'V1alpha2Batcher',
        'custom': 'V1alpha2CustomSpec',
        'logger': 'V1alpha2Logger',
        'max_replicas': 'int',
        'min_replicas': 'int',
        'parallelism': 'int',
        'service_account_name': 'str'
    }

    attribute_map = {
        'aix': 'aix',
        'alibi': 'alibi',
        'batcher': 'batcher',
        'custom': 'custom',
        'logger': 'logger',
        'max_replicas': 'maxReplicas',
        'min_replicas': 'minReplicas',
        'parallelism': 'parallelism',
        'service_account_name': 'serviceAccountName'
    }

    def __init__(self, aix=None, alibi=None, batcher=None, custom=None, logger=None, max_replicas=None, min_replicas=None, parallelism=None, service_account_name=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha2ExplainerSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._aix = None
        self._alibi = None
        self._batcher = None
        self._custom = None
        self._logger = None
        self._max_replicas = None
        self._min_replicas = None
        self._parallelism = None
        self._service_account_name = None
        self.discriminator = None

        if aix is not None:
            self.aix = aix
        if alibi is not None:
            self.alibi = alibi
        if batcher is not None:
            self.batcher = batcher
        if custom is not None:
            self.custom = custom
        if logger is not None:
            self.logger = logger
        if max_replicas is not None:
            self.max_replicas = max_replicas
        if min_replicas is not None:
            self.min_replicas = min_replicas
        if parallelism is not None:
            self.parallelism = parallelism
        if service_account_name is not None:
            self.service_account_name = service_account_name

    @property
    def aix(self):
        """Gets the aix of this V1alpha2ExplainerSpec.  # noqa: E501


        :return: The aix of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: V1alpha2AIXExplainerSpec
        """
        return self._aix

    @aix.setter
    def aix(self, aix):
        """Sets the aix of this V1alpha2ExplainerSpec.


        :param aix: The aix of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: V1alpha2AIXExplainerSpec
        """

        self._aix = aix

    @property
    def alibi(self):
        """Gets the alibi of this V1alpha2ExplainerSpec.  # noqa: E501


        :return: The alibi of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: V1alpha2AlibiExplainerSpec
        """
        return self._alibi

    @alibi.setter
    def alibi(self, alibi):
        """Sets the alibi of this V1alpha2ExplainerSpec.


        :param alibi: The alibi of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: V1alpha2AlibiExplainerSpec
        """

        self._alibi = alibi

    @property
    def batcher(self):
        """Gets the batcher of this V1alpha2ExplainerSpec.  # noqa: E501


        :return: The batcher of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: V1alpha2Batcher
        """
        return self._batcher

    @batcher.setter
    def batcher(self, batcher):
        """Sets the batcher of this V1alpha2ExplainerSpec.


        :param batcher: The batcher of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: V1alpha2Batcher
        """

        self._batcher = batcher

    @property
    def custom(self):
        """Gets the custom of this V1alpha2ExplainerSpec.  # noqa: E501


        :return: The custom of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: V1alpha2CustomSpec
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """Sets the custom of this V1alpha2ExplainerSpec.


        :param custom: The custom of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: V1alpha2CustomSpec
        """

        self._custom = custom

    @property
    def logger(self):
        """Gets the logger of this V1alpha2ExplainerSpec.  # noqa: E501


        :return: The logger of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: V1alpha2Logger
        """
        return self._logger

    @logger.setter
    def logger(self, logger):
        """Sets the logger of this V1alpha2ExplainerSpec.


        :param logger: The logger of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: V1alpha2Logger
        """

        self._logger = logger

    @property
    def max_replicas(self):
        """Gets the max_replicas of this V1alpha2ExplainerSpec.  # noqa: E501

        This is the up bound for autoscaler to scale to  # noqa: E501

        :return: The max_replicas of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: int
        """
        return self._max_replicas

    @max_replicas.setter
    def max_replicas(self, max_replicas):
        """Sets the max_replicas of this V1alpha2ExplainerSpec.

        This is the up bound for autoscaler to scale to  # noqa: E501

        :param max_replicas: The max_replicas of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: int
        """

        self._max_replicas = max_replicas

    @property
    def min_replicas(self):
        """Gets the min_replicas of this V1alpha2ExplainerSpec.  # noqa: E501

        Minimum number of replicas which defaults to 1, when minReplicas = 0 pods scale down to 0 in case of no traffic  # noqa: E501

        :return: The min_replicas of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: int
        """
        return self._min_replicas

    @min_replicas.setter
    def min_replicas(self, min_replicas):
        """Sets the min_replicas of this V1alpha2ExplainerSpec.

        Minimum number of replicas which defaults to 1, when minReplicas = 0 pods scale down to 0 in case of no traffic  # noqa: E501

        :param min_replicas: The min_replicas of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: int
        """

        self._min_replicas = min_replicas

    @property
    def parallelism(self):
        """Gets the parallelism of this V1alpha2ExplainerSpec.  # noqa: E501

        Parallelism specifies how many requests can be processed concurrently, this sets the hard limit of the container concurrency(https://knative.dev/docs/serving/autoscaling/concurrency).  # noqa: E501

        :return: The parallelism of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: int
        """
        return self._parallelism

    @parallelism.setter
    def parallelism(self, parallelism):
        """Sets the parallelism of this V1alpha2ExplainerSpec.

        Parallelism specifies how many requests can be processed concurrently, this sets the hard limit of the container concurrency(https://knative.dev/docs/serving/autoscaling/concurrency).  # noqa: E501

        :param parallelism: The parallelism of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: int
        """

        self._parallelism = parallelism

    @property
    def service_account_name(self):
        """Gets the service_account_name of this V1alpha2ExplainerSpec.  # noqa: E501

        ServiceAccountName is the name of the ServiceAccount to use to run the service  # noqa: E501

        :return: The service_account_name of this V1alpha2ExplainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._service_account_name

    @service_account_name.setter
    def service_account_name(self, service_account_name):
        """Sets the service_account_name of this V1alpha2ExplainerSpec.

        ServiceAccountName is the name of the ServiceAccount to use to run the service  # noqa: E501

        :param service_account_name: The service_account_name of this V1alpha2ExplainerSpec.  # noqa: E501
        :type: str
        """

        self._service_account_name = service_account_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha2ExplainerSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha2ExplainerSpec):
            return True

        return self.to_dict() != other.to_dict()
