#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1beta1PredictorConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'default_gpu_image_version': 'str',
        'default_image_version': 'str',
        'default_timeout': 'str',
        'image': 'str',
        'multi_model_server': 'bool',
        'supported_frameworks': 'list[str]'
    }

    attribute_map = {
        'default_gpu_image_version': 'defaultGpuImageVersion',
        'default_image_version': 'defaultImageVersion',
        'default_timeout': 'defaultTimeout',
        'image': 'image',
        'multi_model_server': 'multiModelServer',
        'supported_frameworks': 'supportedFrameworks'
    }

    def __init__(self, default_gpu_image_version=None, default_image_version=None, default_timeout=None, image=None, multi_model_server=None, supported_frameworks=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1PredictorConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._default_gpu_image_version = None
        self._default_image_version = None
        self._default_timeout = None
        self._image = None
        self._multi_model_server = None
        self._supported_frameworks = None
        self.discriminator = None

        self.default_gpu_image_version = default_gpu_image_version
        self.default_image_version = default_image_version
        if default_timeout is not None:
            self.default_timeout = default_timeout
        self.image = image
        if multi_model_server is not None:
            self.multi_model_server = multi_model_server
        self.supported_frameworks = supported_frameworks

    @property
    def default_gpu_image_version(self):
        """Gets the default_gpu_image_version of this V1beta1PredictorConfig.  # noqa: E501

        default predictor docker image version on gpu  # noqa: E501

        :return: The default_gpu_image_version of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_gpu_image_version

    @default_gpu_image_version.setter
    def default_gpu_image_version(self, default_gpu_image_version):
        """Sets the default_gpu_image_version of this V1beta1PredictorConfig.

        default predictor docker image version on gpu  # noqa: E501

        :param default_gpu_image_version: The default_gpu_image_version of this V1beta1PredictorConfig.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and default_gpu_image_version is None:  # noqa: E501
            raise ValueError("Invalid value for `default_gpu_image_version`, must not be `None`")  # noqa: E501

        self._default_gpu_image_version = default_gpu_image_version

    @property
    def default_image_version(self):
        """Gets the default_image_version of this V1beta1PredictorConfig.  # noqa: E501

        default predictor docker image version on cpu  # noqa: E501

        :return: The default_image_version of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_image_version

    @default_image_version.setter
    def default_image_version(self, default_image_version):
        """Sets the default_image_version of this V1beta1PredictorConfig.

        default predictor docker image version on cpu  # noqa: E501

        :param default_image_version: The default_image_version of this V1beta1PredictorConfig.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and default_image_version is None:  # noqa: E501
            raise ValueError("Invalid value for `default_image_version`, must not be `None`")  # noqa: E501

        self._default_image_version = default_image_version

    @property
    def default_timeout(self):
        """Gets the default_timeout of this V1beta1PredictorConfig.  # noqa: E501

        Default timeout of predictor for serving a request, in seconds  # noqa: E501

        :return: The default_timeout of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_timeout

    @default_timeout.setter
    def default_timeout(self, default_timeout):
        """Sets the default_timeout of this V1beta1PredictorConfig.

        Default timeout of predictor for serving a request, in seconds  # noqa: E501

        :param default_timeout: The default_timeout of this V1beta1PredictorConfig.  # noqa: E501
        :type: str
        """

        self._default_timeout = default_timeout

    @property
    def image(self):
        """Gets the image of this V1beta1PredictorConfig.  # noqa: E501

        predictor docker image name  # noqa: E501

        :return: The image of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this V1beta1PredictorConfig.

        predictor docker image name  # noqa: E501

        :param image: The image of this V1beta1PredictorConfig.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and image is None:  # noqa: E501
            raise ValueError("Invalid value for `image`, must not be `None`")  # noqa: E501

        self._image = image

    @property
    def multi_model_server(self):
        """Gets the multi_model_server of this V1beta1PredictorConfig.  # noqa: E501

        Flag to determine if multi-model serving is supported  # noqa: E501

        :return: The multi_model_server of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: bool
        """
        return self._multi_model_server

    @multi_model_server.setter
    def multi_model_server(self, multi_model_server):
        """Sets the multi_model_server of this V1beta1PredictorConfig.

        Flag to determine if multi-model serving is supported  # noqa: E501

        :param multi_model_server: The multi_model_server of this V1beta1PredictorConfig.  # noqa: E501
        :type: bool
        """

        self._multi_model_server = multi_model_server

    @property
    def supported_frameworks(self):
        """Gets the supported_frameworks of this V1beta1PredictorConfig.  # noqa: E501

        frameworks the model agent is able to run  # noqa: E501

        :return: The supported_frameworks of this V1beta1PredictorConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._supported_frameworks

    @supported_frameworks.setter
    def supported_frameworks(self, supported_frameworks):
        """Sets the supported_frameworks of this V1beta1PredictorConfig.

        frameworks the model agent is able to run  # noqa: E501

        :param supported_frameworks: The supported_frameworks of this V1beta1PredictorConfig.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and supported_frameworks is None:  # noqa: E501
            raise ValueError("Invalid value for `supported_frameworks`, must not be `None`")  # noqa: E501

        self._supported_frameworks = supported_frameworks

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1PredictorConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1PredictorConfig):
            return True

        return self.to_dict() != other.to_dict()
