# -*- coding: utf-8 -*-
"""
generators.py: Trivial result generation functions for illustrating
               tdda.referencetest

Source repository: http://github.com/tdda/tdda

License: MIT

Copyright (c) Stochastic Solutions Limited 2016
"""
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals

import datetime
import math

def generate_string():
    """
    Returns an HTML string that should display identically to the result
    stored in tdda/examples/reference/string_result, but which has
    four (non-semantic) differences:
        - The Copyright line is different
        - The version number line is different
        - It has a newline at the top, unlike the reference file.
        - It is missing a newline at the end of the string, which the
          reference file includes.
    """
    version = '1.0.0'
    copyright_year = '2016'
    inc_gendate = False
    date = datetime.datetime.now().strftime('    %Y-%m-%dT%H:%M:%S')
    generation_date = date if inc_gendate else ''
    spiral = generate_spiral()

    return """<!DOCTYPE html>
<html>
  <head>
    <!--
    Copyright (c) Stochastic Solutions, %(copyright_year)s
    Version %(version)s
%(generation_date)s
    -->
    <meta charset="UTF-8"/>
    <style type="text/css">
      body {font-family: Palatino, "Palatino Linotype", Times;
            text-align: center}
      h1 {font-size: large; text-align: center;}
      div {padding: 12px 0 12px 0;}
    </style>
    <title>
      Python-Generated HTML Example for tdda.referencetest
    </title>
  </head>
<body>
  <h1>Python-Generated HTML Example for tdda.referencetest</h1>
  <div>
    This page is generated by Python (as a string).
  </div>
  %(spiral)s
  <div>
    It's not terribly exciting.
    But it will serve to illustrate tdda.referencetest.
  </div>
</body>
</html>
""" % locals()


def generate_file(path):
    html = '''<!DOCTYPE html>
<html>
  <head>
    <!--
    Copyright (c) Stochastic Solutions, 2016
    Version 1.0.0
    -->
    <meta charset="UTF-8"/>
    <style type="text/css">
      body {font-family: Palatino, "Palatino Linotype", Times;
            text-align: center;}
      h1 {font-size: large; text-align: center;}
      div {padding-top: 12px; padding-bottom: 12px;}
    </style>
    <title>
      Python-Generated HTML Example for tdda.referencetest
    </title>
  </head>
<body>
  <h1>Python-Generated HTML Example for tdda.referencetest</h1>
  <div>
    This page is generated by Python (as a file).
  </div>
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200">
    <style type="text/css">text { font-family: Helvetica, Verdana, Sans;}</style>

    <!-- TDDA Test Output Version 0.0.1
         Copyright (c) Stochastic Solutions Limited 2016 -->

    <rect x="0" y="0" width="96" height="96" style="fill:#C08080"/>
    <rect x="105" y="0" width="96" height="96" style="fill:#F0C080"/>
    <rect x="0" y="104" width="96" height="96" style="fill:#F0C080"/>
    <rect x="104" y="104" width="96" height="96" style="fill:#C08080"/>
    <text x="50" y="78" font-size="80" text-anchor="middle">T</text>
    <text x="150" y="78" font-size="80" text-anchor="middle">D</text>
    <text x="50" y="178" font-size="80" text-anchor="middle">D</text>
    <text x="150" y="178" font-size="80" text-anchor="middle">A</text>
  </svg>

  <div>
    It will serve to illustrate tdda.referencetest.
  </div>
</body>
</html>
'''
    with open(path, 'w') as f:
        f.write(html)


def generate_spiral():
    points = ' '.join('%d %d L' % (t / 20 * math.cos(t * 2 * math.pi / 100),
                                   t / 20 * math.sin(t * 2 * math.pi / 100))
                      for t in range(1000))
    colour = 'red'
    return '''<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="100" height="100">
    <g transform="translate(50,50)">
        <path d="M 0 0 %(points)s z" stroke="%(colour)s" fill="none"/>
    </g>
</svg>''' % locals()
