from enum import Enum


class DWDMosmixParameter(Enum):
    # https://opendata.dwd.de/weather/lib/MetElementDefinition.xml
    TEMPERATURE_AIR_200 = "TTT"
    TEMPERATURE_DEW_POINT_200 = "Td"
    TEMPERATURE_AIR_MAX_200 = "TX"
    TEMPERATURE_AIR_MIN_200 = "TN"
    WIND_DIRECTION = "DD"
    WIND_SPEED = "FF"
    WIND_GUST_MAX_LAST_1H = "FX1"
    WIND_GUST_MAX_LAST_3H = "FX3"
    WIND_GUST_MAX_LAST_12H = "FXh"
    PRECIPITATION_CONSIST_LAST_1H = "RR1c"
    PRECIPITATION_LAST_1H = "RR1"
    PRECIPITATION_CONSIST_LAST_3H = "RR3c"
    PRECIPITATION_LAST_3H = "RR3"
    PRECIPITATION_SNOW_EQUIV_LAST_1H = "RRS1c"
    PRECIPITATION_SNOW_EQUIV_LAST_3H = "RRS3c"
    WEATHER_SIGNIFICANT = "ww"
    WEATHER_LAST_6H = "W1W2"
    CLOUD_COVER_TOTAL = "N"
    CLOUD_COVER_EFFECTIVE = "Neff"
    CLOUD_COVER_BELOW_500_FT = "N05"
    CLOUD_COVER_BELOW_1000_FT = "Nl"
    CLOUD_COVER_BETWEEN_2_TO_7_KM = "Nm"
    CLOUD_COVER_ABOVE_7_KM = "Nh"
    PRESSURE_AIR_SURFACE_REDUCED = "PPPP"
    TEMPERATURE_AIR_005 = "T5cm"
    RADIATION_SHORT_WAVE_BALANCE_LAST_3H = "RadS3"
    RADIATION_GLOBAL = "Rad1h"
    RADIATION_LONG_WAVE_BALANCE_LAST_3H = "RadL3"
    VISIBILITY = "VV"
    SUNSHINE_DURATION = "SunD1"
    PROBABILITY_WIND_GUST_GE_25_KN_LAST_12H = "FXh25"
    PROBABILITY_WIND_GUST_GE_40_KN_LAST_12H = "FXh40"
    PROBABILITY_WIND_GUST_GE_55_KN_LAST_12H = "FXh55"
    PROBABILITY_FOG_LAST_1H = "wwM"
    PROBABILITY_FOG_LAST_6H = "wwM6"
    PROBABILITY_FOG_LAST_12H = "wwMh"
    PROBABILITY_PRECIPITATION_GT_0_0_MM_LAST_12H = "Rh00"
    PROBABILITY_PRECIPITATION_GT_0_2_MM_LAST_6H = "R602"
    PROBABILITY_PRECIPITATION_GT_0_2_MM_LAST_12H = "Rh02"
    PROBABILITY_PRECIPITATION_GT_0_2_MM_LAST_24H = "Rd02"
    PROBABILITY_PRECIPITATION_GT_1_0_MM_LAST_12H = "Rh10"
    PROBABILITY_PRECIPITATION_GT_5_0_MM_LAST_6H = "R650"
    PROBABILITY_PRECIPITATION_GT_5_0_MM_LAST_12H = "Rh50"
    PROBABILITY_PRECIPITATION_GT_5_0_MM_LAST_24H = "Rd50"
    TEMPERATURE_AIR_MIN_005_LAST_12H = "TG"
    TEMPERATURE_AIR_200_LAST_24H = "TM"
    PRECIPITATION_DURATION = "DRR1"
    PROBABILITY_DRIZZLE_LAST_1H = "wwZ"
    PROBABILITY_PRECIPITATION_STRAT_LAST_1H = "wwD"
    PROBABILITY_PRECIPITATION_CONV_LAST_1H = "wwC"
    PROBABILITY_THUNDERSTORM_LAST_1H = "wwT"
    PROBABILITY_PRECIPITATION_LIQUID_LAST_1H = "wwL"
    PROBABILITY_PRECIPITATION_SOLID_LAST_1H = "wwS"
    PROBABILITY_PRECIPITATION_FREEZING_LAST_1H = "wwF"
    PROBABILITY_PRECIPITATION_LAST_1H = "wwP"
    PROBABILITY_VISIBILITY_BELOW_1000_M = "VV10"
    ERROR_ABSOLUTE_TEMPERATURE_AIR_200 = "E_TTT"
    ERROR_ABSOLUTE_WIND_SPEED = "E_FF"
    ERROR_ABSOLUTE_WIND_DIRECTION = "E_DD"
    ERROR_ABSOLUTE_TEMPERATURE_DEW_POINT_200 = "E_Td"
    PRECIPITATION_LAST_6H = "RR6"
    PRECIPITATION_CONSIST_LAST_6H = "RR6c"
    PROBABILITY_PRECIPITATION_GT_0_0_MM_LAST_6H = "R600"
    PROBABILITY_PRECIPITATION_GT_0_1_MM_LAST_1H = "R101"
    PROBABILITY_PRECIPITATION_GT_0_2_MM_LAST_1H = "R102"
    PROBABILITY_PRECIPITATION_GT_0_3_MM_LAST_1H = "R103"
    PROBABILITY_PRECIPITATION_GT_0_5_MM_LAST_1H = "R105"
    PROBABILITY_PRECIPITATION_GT_0_7_MM_LAST_1H = "R107"
    PROBABILITY_PRECIPITATION_GT_1_0_MM_LAST_1H = "R110"
    PROBABILITY_PRECIPITATION_GT_2_0_MM_LAST_1H = "R120"
    SUNSHINE_DURATION_YESTERDAY = "SunD"
    SUNSHINE_DURATION_RELATIVE_LAST_24H = "RSunD"
    PROBABILITY_SUNSHINE_DURATION_RELATIVE_GT_0_PCT_LAST_24H = "PSd00"
    PROBABILITY_SUNSHINE_DURATION_RELATIVE_GT_30_PCT_LAST_24H = "PSd30"
    PROBABILITY_SUNSHINE_DURATION_RELATIVE_GT_60_PCT_LAST_24H = "PSd60"
    PROBABILITY_RADIATION_GLOBAL_LAST_1H = "RRad1"
    EVAPOTRANSPIRATION_POTENTIAL_LAST_24H = "PEvap"
    PROBABILITY_PRECIPITATION_GT_3_0_MM_LAST_1H = "R130"
    PROBABILITY_PRECIPITATION_GT_5_0_MM_LAST_1H = "R150"
    PROBABILITY_PRECIPITATION_GT_10_0_MM_LAST_1H = "RR1o1"
    PROBABILITY_PRECIPITATION_GT_15_0_MM_LAST_1H = "RR1w1"
    PROBABILITY_PRECIPITATION_GT_25_0_MM_LAST_1H = "RR1u1"
    PROBABILITY_PRECIPITATION_STRAT_LAST_6H = "wwD6"
    PROBABILITY_PRECIPITATION_CONV_LAST_6H = "wwC6"
    PROBABILITY_THUNDERSTORM_LAST_6H = "wwT6"
    PROBABILITY_PRECIPITATION_LAST_6H = "wwP6"
    PROBABILITY_PRECIPITATION_LIQUID_LAST_6H = "wwL6"
    PROBABILITY_PRECIPITATION_FREEZING_LAST_6H = "wwF6"
    PROBABILITY_PRECIPITATION_SOLID_LAST_6H = "wwS6"
    PROBABILITY_DRIZZLE_LAST_6H = "wwZ6"
    PROBABILITY_FOG_LAST_24H = "wwMd"
    PROBABILITY_WIND_GUST_GE_25_KN_LAST_6H = "FX625"
    PROBABILITY_WIND_GUST_GE_40_KN_LAST_6H = "FX640"
    PROBABILITY_WIND_GUST_GE_55_KN_LAST_6H = "FX655"
    PROBABILITY_PRECIPITATION_STRAT_LAST_12H = "wwDh"
    PROBABILITY_PRECIPITATION_CONV_LAST_12H = "wwCh"
    PROBABILITY_THUNDERSTORM_LAST_12H = "wwTh"
    PROBABILITY_PRECIPITATION_LAST_12H = "wwPh"
    PROBABILITY_PRECIPITATION_LIQUID_LAST_12H = "wwLh"
    PROBABILITY_PRECIPITATION_FREEZING_LAST_12H = "wwFh"
    PROBABILITY_PRECIPITATION_SOLID_LAST_12H = "wwSh"
    PROBABILITY_DRIZZLE_LAST_12H = "wwZh"
    PROBABILITY_PRECIPITATION_GT_1_0_MM_LAST_6H = "R610"
    PRECIPITATION_LAST_12H = "RRh"
    PRECIPITATION_CONSIST_LAST_12H = "RRhc"
    WEATHER_SIGNIFICANT_LAST_3H = "ww3"
    PRECIPITATION_LIQUID_CONSIST_LAST_1H = "RRL1c"
    PROBABILITY_PRECIPITATION_GT_0_0_MM_LAST_24H = "Rd00"
    PROBABILITY_PRECIPITATION_GT_1_0_MM_LAST_24H = "Rd10"
    PRECIPITATION_LAST_24H = "RRd"
    PRECIPITATION_CONSIST_LAST_24H = "RRdc"
    CLOUD_COVER_BELOW_7000_M = "Nlm"
    PROBABILITY_PRECIPITATION_LAST_24H = "wwPd"
    CLOUD_BASE_CONVECTIVE = "H_BsC"
    PROBABILITY_THUNDERSTORM_LAST_24H = "wwTd"
    ERROR_ABSOLUTE_PRESSURE_AIR_SURFACE = "E_PPP"
    SUNSHINE_DURATION_LAST_3H = "SunD3"
    WEATHER_SIGNIFICANT_OPTIONAL_LAST_1H = "WPc11"
    WEATHER_SIGNIFICANT_OPTIONAL_LAST_3H = "WPc31"
    WEATHER_SIGNIFICANT_OPTIONAL_LAST_6H = "WPc61"
    WEATHER_SIGNIFICANT_OPTIONAL_LAST_12H = "WPch1"
    WEATHER_SIGNIFICANT_OPTIONAL_LAST_24H = "WPcd1"
