<!--
THIS FILE IS AUTOGENERATED, DON'T EDIT.
File to edit instead: notebooks/contributing.ipynb
-->

# Contributing

Contributions are very welcome — please do ask questions and suggest ideas in [Issues](https://github.com/nategadzhi/notoma/issues), and feel free to implement features you want and submit them via Pull Requests.

### Reporting issues

Please feel free to file a Github Issue if you found a behavior that you feel is weird or counterintuitive, bad UX, or any errors or bugs.

---

### How to participate

Notoma uses a [project board to keep track of what we're currently working on](https://github.com/nategadzhi/notoma/projects/4).

We're trying to mark issues that are small enough, and would onboard you into Notoma's internal workings with `good-first-issue` label. That said, feel free to comment on any issue that you'd like to work on, as long as it's not assigned and not in the ”In progress“ column yet. 

Also, please feel free to ask any questions if you'd want to work on something for Notoma, but you're not sure where or how to start — just create a new issue, or ask a question in the existing one. 

---

### Pull Requests

Thank you for considering writing some code for Notoma! This part describes the easiest way to get up to speed with Notoma development, and how to create a pull request.

Here's the steps you'd need to do in order to get your code merged:

1. Fork the repository
2. Development install with linters: `make contrib`
3. Make sure you regenerate documentation for anything you change: `pipenv run notoma-dev docs`
4. Commit to your fork branch and then do a PR.

#### Local dev setup

```bash
git clone git@github.com:nategadzhi/notoma.git
hub fork #or whatever

make contrib #will install dev dependencies and setup local pre-commit linters.
```

#### Linters

- [`black`](https://github.com/psf/black) for code formatting
- [`flake8`](https://gitlab.com/pycqa/flake8) for linting
- [Code Climate](https://codeclimate.com/github/nategadzhi/notoma) for code quality.

Linters are run automatically on each commit to any branch, and on pull requests as well.


#### Updating documentation

[Documentation website](https://nategadzhi.github.io/notoma/) and all of it's docs is just a Jekyll site, located in [`./docs/`](https://github.com/nategadzhi/notoma/tree/master/docs). The markdown files in there are automatically generated from Jupyter Notebooks in `./notebooks` in this repo.

Please edit the notebooks, not the markdown files directly, and please include proposed documentation changes with your pull requests.


