# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from dataclasses import dataclass
from pkgs.serialization import serial_class
from ... import base as base_t

__all__: list[str] = [
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "ExternalConditionParameterValue",
    "ExternalRecipe",
    "ExternalRecipeInput",
    "ExternalRecipeMetadata",
    "ExternalRecipeOutput",
    "ExternalRecipeStep",
    "ExternalRecipeStepGroup",
    "ExternalRecipeStepRelationship",
    "ExternalRecipeWorkflowStep",
    "ExternalSimpleExperimentGroup",
    "ExternalSimpleInput",
    "ExternalSimpleOutput",
    "ExternalSimpleOutputCondition",
    "ExternalSimpleRecipeMetadataField",
    "ExternalSimpleRecipeTag",
    "ExternalSimpleUnit",
    "ExternalSimpleUser",
    "ExternalSimpleWorkflow",
    "ExternalSimpleWorkflowStep",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/recipes/external_get_recipes_data"


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Arguments:
    recipe_ids: typing.Optional[list[int]]
    project_id: typing.Optional[int]
    offset: typing.Optional[int]
    limit: typing.Optional[int]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleRecipeMetadataField:
    metadata_id: int
    name: str
    quantity_type: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class ExternalRecipeMetadata:
    metadata_id: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleRecipeTag:
    recipe_tag_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleExperimentGroup:
    experiment_group_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleUnit:
    unit_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class ExternalRecipeOutput:
    id: int
    output_id: int
    replicate_num: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue
    curve_id: int
    output_condition_id: int


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleOutput:
    output_id: int
    name: str
    unit: typing.Optional[ExternalSimpleUnit]
    quantity_type: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclass(kw_only=True)
class ExternalConditionParameterValue:
    condition_parameter_id: int
    condition_parameter_name: str
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleOutputCondition:
    output_condition_id: int
    condition_parameter_values: list[ExternalConditionParameterValue]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleWorkflowStep:
    workflow_step_id: int
    name: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleWorkflow:
    workflow_id: int
    name: str
    workflow_steps: list[ExternalSimpleWorkflowStep]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    unconverted_values={"actual_quantity_json", "quantity_json"},
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclass(kw_only=True)
class ExternalRecipeInput:
    input_id: int
    input_lot_recipe_id: typing.Optional[int]
    recipe_step_id: int
    quantity_dec: Decimal
    quantity_json: base_t.JsonValue
    actual_quantity_dec: Decimal
    actual_quantity_json: base_t.JsonValue
    input_type: str
    behavior: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleInput:
    input_id: int
    quantity_type: str
    name: str
    is_parameter: bool
    intermediate_recipe_id: typing.Optional[int]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalRecipeStep:
    name: typing.Optional[str]
    recipe_step_id: int
    recipe_step_number: int
    instructions: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalRecipeStepGroup:
    name: typing.Optional[str]
    recipe_steps: list[ExternalRecipeStep]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalRecipeWorkflowStep:
    recipe_workflow_step_id: int
    workflow_step_id: int
    recipe_step_groups: list[ExternalRecipeStepGroup]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalSimpleUser:
    user_id: int
    display_name: str
    email: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclass(kw_only=True)
class ExternalRecipeStepRelationship:
    step_relationship_id: base_t.ObjectId
    name: typing.Optional[str]
    source_recipe_workflow_step_id: base_t.ObjectId
    target_recipe_step_id: base_t.ObjectId
    quantity_dec: typing.Optional[Decimal] = None
    actual_quantity_dec: typing.Optional[Decimal] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class ExternalRecipe:
    recipe_id: int
    create_datetime: str
    last_modified_datetime: str
    name: str
    notes: typing.Optional[str]
    workflow_id: int
    metadata: list[ExternalRecipeMetadata]
    inputs: list[ExternalRecipeInput]
    outputs: list[ExternalRecipeOutput]
    workflow_steps: list[ExternalRecipeWorkflowStep]
    tag_ids: list[int]
    experiment_group_ids: list[int]
    step_relationships: list[ExternalRecipeStepRelationship]
    creating_user_id: typing.Optional[int] = None
    barcode_value: typing.Optional[str] = None


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Data:
    recipes: list[ExternalRecipe]
    workflows: list[ExternalSimpleWorkflow]
    metadata: list[ExternalSimpleRecipeMetadataField]
    inputs: list[ExternalSimpleInput]
    outputs: list[ExternalSimpleOutput]
    output_conditions: list[ExternalSimpleOutputCondition]
    users: list[ExternalSimpleUser]
    recipe_tags: list[ExternalSimpleRecipeTag]
    experiment_groups: list[ExternalSimpleExperimentGroup]
# DO NOT MODIFY -- This file is generated by type_spec
