"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WAFIPRestrictRule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class WAFIPRestrictRule {
    constructor(props) {
        this.props = props;
    }
    allowRule(config) {
        return {
            name: config.ruleName || 'allow-ip-rule',
            priority: config.priority,
            action: { allow: {} },
            visibilityConfig: {
                cloudWatchMetricsEnabled: true,
                metricName: config.cloudWatchMetricsName || 'AllowIPMetric',
                sampledRequestsEnabled: true,
            },
            statement: {
                ipSetReferenceStatement: {
                    arn: this.props.allowIPSetArn,
                },
            },
        };
    }
    blockRule(config) {
        return {
            name: config.ruleName || 'block-other-ip-rule',
            priority: 2,
            action: { block: {} }, // 拒否アクション
            visibilityConfig: {
                cloudWatchMetricsEnabled: true,
                metricName: config.cloudWatchMetricsName || 'BlockOtherIpMetric',
                sampledRequestsEnabled: true,
            },
            statement: {
                notStatement: {
                    statement: {
                        ipSetReferenceStatement: {
                            arn: this.props.allowIPSetArn,
                        },
                    },
                },
            },
        };
    }
}
exports.WAFIPRestrictRule = WAFIPRestrictRule;
_a = JSII_RTTI_SYMBOL_1;
WAFIPRestrictRule[_a] = { fqn: "@gammarers/aws-waf-ip-restrict-rule.WAFIPRestrictRule", version: "2.1.1" };
//# sourceMappingURL=data:application/json;base64,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