# llui/llchat.h
CHAT_TYPE_WHISPER = 0
CHAT_TYPE_NORMAL = 1
CHAT_TYPE_SHOUT = 2
CHAT_TYPE_START = 4
CHAT_TYPE_STOP = 5
CHAT_TYPE_DEBUG_MSG = 6
CHAT_TYPE_REGION = 7
CHAT_TYPE_OWNER = 8
CHAT_TYPE_DIRECT = 9

# newview/llviewermessage.cpp
AU_FLAGS_NONE              = 0x00
AU_FLAGS_HIDETITLE         = 0x01
AU_FLAGS_CLIENT_AUTOPILOT  = 0x02

# llcommon/indra_constants.h
AGENT_CONTROL_AT_POS            = 0x00000001
AGENT_CONTROL_AT_NEG            = 0x00000002
AGENT_CONTROL_LEFT_POS          = 0x00000004
AGENT_CONTROL_LEFT_NEG          = 0x00000008
AGENT_CONTROL_UP_POS            = 0x00000010
AGENT_CONTROL_UP_NEG            = 0x00000020
AGENT_CONTROL_PITCH_POS         = 0x00000040
AGENT_CONTROL_PITCH_NEG         = 0x00000080
AGENT_CONTROL_YAW_POS           = 0x00000100
AGENT_CONTROL_YAW_NEG           = 0x00000200

AGENT_CONTROL_FAST_AT           = 0x00000400
AGENT_CONTROL_FAST_LEFT         = 0x00000800
AGENT_CONTROL_FAST_UP           = 0x00001000

AGENT_CONTROL_FLY               = 0x00002000
AGENT_CONTROL_STOP              = 0x00004000
AGENT_CONTROL_FINISH_ANIM       = 0x00008000
AGENT_CONTROL_STAND_UP          = 0x00010000
AGENT_CONTROL_SIT_ON_GROUND     = 0x00020000
AGENT_CONTROL_MOUSELOOK         = 0x00040000

AGENT_CONTROL_NUDGE_AT_POS      = 0x00080000
AGENT_CONTROL_NUDGE_AT_NEG      = 0x00100000
AGENT_CONTROL_NUDGE_LEFT_POS    = 0x00200000
AGENT_CONTROL_NUDGE_LEFT_NEG    = 0x00400000
AGENT_CONTROL_NUDGE_UP_POS      = 0x00800000
AGENT_CONTROL_NUDGE_UP_NEG      = 0x01000000
AGENT_CONTROL_TURN_LEFT         = 0x02000000
AGENT_CONTROL_TURN_RIGHT        = 0x04000000

AGENT_CONTROL_AWAY              = 0x08000000

AGENT_CONTROL_LBUTTON_DOWN      = 0x10000000
AGENT_CONTROL_LBUTTON_UP        = 0x20000000
AGENT_CONTROL_ML_LBUTTON_DOWN   = 0x40000000
AGENT_CONTROL_ML_LBUTTON_UP     = 0x80000000


# llmessage/llinstantmessage.h

# default. ID is meaningless, nothing in the binary bucket.
IM_NOTHING_SPECIAL = 0

# pops a messagebox with a single OK button
IM_MESSAGEBOX = 1

# pops a countdown messagebox with a single OK button
IM_MESSAGEBOX_COUNTDOWN = 2

# You've been invited to join a group.
# ID is the group id.

# The binary bucket contains a null terminated string
# representation of the officer/member status and join cost for
# the invitee. (bug # 7672) The format is 1 byte for
# officer/member (O for officer, M for member), and as many bytes
# as necessary for cost.
IM_GROUP_INVITATION = 3

# Inventory offer.
# ID is the transaction id
# Binary bucket is a list of inventory uuid and type.
IM_INVENTORY_OFFERED = 4
IM_INVENTORY_ACCEPTED = 5
IM_INVENTORY_DECLINED = 6

# Group vote
# Name is name of person who called vote.
# ID is vote ID used for internal tracking
# TODO: _DEPRECATED suffix as part of vote removal - DEV-24856
IM_GROUP_VOTE = 7

# Group message
# This means that the message is meant for everyone in the
# agent's group. This will result in a database query to find all
# participants and start an im session.
IM_GROUP_MESSAGE_DEPRECATED = 8

# Task inventory offer.
# ID is the transaction id
# Binary bucket is a (mostly) complete packed inventory item
IM_TASK_INVENTORY_OFFERED = 9
IM_TASK_INVENTORY_ACCEPTED = 10
IM_TASK_INVENTORY_DECLINED = 11

# Copied as pending, type LL_NOTHING_SPECIAL, for new users
# used by offline tools
IM_NEW_USER_DEFAULT = 12

#
# session based messaging - the way that people usually actually
# communicate with each other.
#

# Invite users to a session.
IM_SESSION_INVITE = 13

IM_SESSION_P2P_INVITE = 14

# start a session with your gruop
IM_SESSION_GROUP_START = 15

# start a session without a calling card (finder or objects)
IM_SESSION_CONFERENCE_START = 16

# send a message to a session.
IM_SESSION_SEND = 17

# leave a session
IM_SESSION_LEAVE = 18

# an instant message from an object - for differentiation on the
# viewer, since you can't IM an object yet.
IM_FROM_TASK = 19

# sent an IM to a do not disturb user, this is the auto response
IM_DO_NOT_DISTURB_AUTO_RESPONSE = 20

# Shows the message in the console and chat history
IM_CONSOLE_AND_CHAT_HISTORY = 21

# IM Types used for luring your friends
IM_LURE_USER = 22
IM_LURE_ACCEPTED = 23
IM_LURE_DECLINED = 24
IM_GODLIKE_LURE_USER = 25
IM_TELEPORT_REQUEST = 26

# IM that notifie of a new group election.
# Name is name of person who called vote.
# ID is election ID used for internal tracking
IM_GROUP_ELECTION_DEPRECATED = 27

# IM to tell the user to go to an URL. Put a text message in the
# message field, and put the url with a trailing \0 in the binary
# bucket.
IM_GOTO_URL = 28

# a message generated by a script which we don't want to
# be sent through e-mail.  Similar to IM_FROM_TASK, but
# it is shown as an alert on the viewer.
IM_FROM_TASK_AS_ALERT = 31

# IM from group officer to all group members.
IM_GROUP_NOTICE = 32
IM_GROUP_NOTICE_INVENTORY_ACCEPTED = 33
IM_GROUP_NOTICE_INVENTORY_DECLINED = 34

IM_GROUP_INVITATION_ACCEPT = 35
IM_GROUP_INVITATION_DECLINE = 36

IM_GROUP_NOTICE_REQUESTED = 37

IM_FRIENDSHIP_OFFERED = 38
IM_FRIENDSHIP_ACCEPTED = 39
IM_FRIENDSHIP_DECLINED_DEPRECATED = 40

IM_TYPING_START = 41
IM_TYPING_STOP = 42