# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousDatabaseArgs', 'AutonomousDatabase']

@pulumi.input_type
class AutonomousDatabaseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 db_name: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 are_primary_whitelisted_ips_used: Optional[pulumi.Input[bool]] = None,
                 auto_refresh_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 auto_refresh_point_lag_in_seconds: Optional[pulumi.Input[int]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_maintenance_schedule_type: Optional[pulumi.Input[str]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 byol_compute_count_limit: Optional[pulumi.Input[float]] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 clone_type: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[float]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]] = None,
                 data_safe_status: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_status: Optional[pulumi.Input[str]] = None,
                 db_tools_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 db_workload: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 in_memory_percentage: Optional[pulumi.Input[int]] = None,
                 is_access_control_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_for_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_backup_retention_locked: Optional[pulumi.Input[bool]] = None,
                 is_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_dedicated: Optional[pulumi.Input[bool]] = None,
                 is_dev_tier: Optional[pulumi.Input[bool]] = None,
                 is_free_tier: Optional[pulumi.Input[bool]] = None,
                 is_local_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_connection_required: Optional[pulumi.Input[bool]] = None,
                 is_preview_version_with_service_terms_accepted: Optional[pulumi.Input[bool]] = None,
                 is_refreshable_clone: Optional[pulumi.Input[bool]] = None,
                 is_replicate_automatic_backups: Optional[pulumi.Input[bool]] = None,
                 is_shrink_only: Optional[pulumi.Input[bool]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 local_adg_auto_failover_max_data_loss_limit: Optional[pulumi.Input[int]] = None,
                 long_term_backup_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]] = None,
                 max_cpu_core_count: Optional[pulumi.Input[int]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 open_mode: Optional[pulumi.Input[str]] = None,
                 operations_insights_status: Optional[pulumi.Input[str]] = None,
                 permission_level: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 private_endpoint_label: Optional[pulumi.Input[str]] = None,
                 refreshable_mode: Optional[pulumi.Input[str]] = None,
                 remote_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 resource_pool_leader_id: Optional[pulumi.Input[str]] = None,
                 resource_pool_summary: Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']] = None,
                 rotate_key_trigger: Optional[pulumi.Input[bool]] = None,
                 scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shrink_adb_trigger: Optional[pulumi.Input[int]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 standby_whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 switchover_to: Optional[pulumi.Input[str]] = None,
                 switchover_to_remote_peer_id: Optional[pulumi.Input[str]] = None,
                 time_of_auto_refresh_start: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input[str]] = None,
                 use_latest_available_backup_time_stamp: Optional[pulumi.Input[bool]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AutonomousDatabase resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        :param pulumi.Input[str] db_name: The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        :param pulumi.Input[str] admin_password: (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        :param pulumi.Input[bool] are_primary_whitelisted_ips_used: (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        :param pulumi.Input[int] auto_refresh_frequency_in_seconds: (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        :param pulumi.Input[int] auto_refresh_point_lag_in_seconds: (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        :param pulumi.Input[str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        :param pulumi.Input[int] backup_retention_period_in_days: (Updatable) Retention period, in days, for backups.
        :param pulumi.Input[str] character_set: The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)
               
               For an Autonomous Database on dedicated infrastructure, the allowed values are:
               
               AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        :param pulumi.Input[str] clone_type: The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
               * `FULL` - This option creates a new database that includes all source database data.
               * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        :param pulumi.Input[float] compute_count: (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[str] compute_model: (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
               * The data type must be an *integer*.
               * The minimum number of cores for all types of autonomous database is *1*
               * The maximum number of cores is as follows:
               * Autonomous Database Serverless instances: The maximum number of cores is *128*.
               * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]] customer_contacts: (Updatable) Customer Contacts.
        :param pulumi.Input[str] data_safe_status: (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Notes**
               * This parameter is only supported for dedicated Exadata infrastructure.
               * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        :param pulumi.Input[int] data_storage_size_in_tbs: (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).
               
               **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        :param pulumi.Input[str] database_edition: (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        :param pulumi.Input[str] database_management_status: Status of Database Management for this Autonomous Database.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]] db_tools_details: (Updatable) The list of database tools details.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_version: (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        :param pulumi.Input[str] db_workload: (Updatable) The Autonomous Database workload type. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disaster_recovery_type: Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        :param pulumi.Input['AutonomousDatabaseEncryptionKeyArgs'] encryption_key: (Updatable) Details of the Autonomous Database encryption key.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] in_memory_percentage: (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        :param pulumi.Input[bool] is_access_control_enabled: (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.
               
               This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        :param pulumi.Input[bool] is_auto_scaling_for_storage_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        :param pulumi.Input[bool] is_backup_retention_locked: (Updatable) True if the Autonomous Database is backup retention locked.
        :param pulumi.Input[bool] is_data_guard_enabled: (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_dedicated: True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        :param pulumi.Input[bool] is_dev_tier: (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        :param pulumi.Input[bool] is_free_tier: (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        :param pulumi.Input[bool] is_local_data_guard_enabled: (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_mtls_connection_required: (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        :param pulumi.Input[bool] is_preview_version_with_service_terms_accepted: If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        :param pulumi.Input[bool] is_refreshable_clone: (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        :param pulumi.Input[bool] is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        :param pulumi.Input[bool] is_shrink_only: (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] key_version_id: The OCID of the key version that is used in rotate key operations.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        :param pulumi.Input[int] local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]] long_term_backup_schedules: Details for the long-term backup schedule.
        :param pulumi.Input[int] max_cpu_core_count: (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        :param pulumi.Input[str] ncharacter_set: The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to be made available to the database.
               
               
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
               The following points apply:
               * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
               * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.
               
               For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        :param pulumi.Input[str] open_mode: Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        :param pulumi.Input[str] operations_insights_status: (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        :param pulumi.Input[str] permission_level: The Autonomous Database permission level. Restricted mode allows access only by admin users.
        :param pulumi.Input[str] private_endpoint_ip: The private endpoint Ip address for the resource.
        :param pulumi.Input[str] private_endpoint_label: (Updatable) (Optional) (Updatable) The resource's private endpoint label.
               * Setting the endpoint label to a non-empty string creates a private endpoint database.
               * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
               * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        :param pulumi.Input[str] refreshable_mode: (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[str] remote_disaster_recovery_type: Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] resource_pool_leader_id: (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs'] resource_pool_summary: (Updatable) The configuration details for resource pool
        :param pulumi.Input[bool] rotate_key_trigger: (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]] scheduled_operations: (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] secret_id: (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.
               
               This cannot be used in conjunction with adminPassword.
        :param pulumi.Input[int] secret_version_number: (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] source: The source of the database:
               * Use `NONE` for creating a new Autonomous Database.
               * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
               * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
               * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.
               
               For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
               * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
               * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] standby_whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] state: The current state of the Autonomous Database.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
               * For Autonomous Database, setting this will disable public secure access to the database.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[str] switchover_to: It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        :param pulumi.Input[str] switchover_to_remote_peer_id: (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        :param pulumi.Input[str] time_of_auto_refresh_start: The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        :param pulumi.Input[str] timestamp: The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        :param pulumi.Input[bool] use_latest_available_backup_time_stamp: Clone from latest available backup timestamp.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_name", db_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if are_primary_whitelisted_ips_used is not None:
            pulumi.set(__self__, "are_primary_whitelisted_ips_used", are_primary_whitelisted_ips_used)
        if auto_refresh_frequency_in_seconds is not None:
            pulumi.set(__self__, "auto_refresh_frequency_in_seconds", auto_refresh_frequency_in_seconds)
        if auto_refresh_point_lag_in_seconds is not None:
            pulumi.set(__self__, "auto_refresh_point_lag_in_seconds", auto_refresh_point_lag_in_seconds)
        if autonomous_container_database_id is not None:
            pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_database_backup_id is not None:
            pulumi.set(__self__, "autonomous_database_backup_id", autonomous_database_backup_id)
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if autonomous_maintenance_schedule_type is not None:
            pulumi.set(__self__, "autonomous_maintenance_schedule_type", autonomous_maintenance_schedule_type)
        if backup_retention_period_in_days is not None:
            pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        if byol_compute_count_limit is not None:
            pulumi.set(__self__, "byol_compute_count_limit", byol_compute_count_limit)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if clone_type is not None:
            pulumi.set(__self__, "clone_type", clone_type)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_safe_status is not None:
            pulumi.set(__self__, "data_safe_status", data_safe_status)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if database_management_status is not None:
            pulumi.set(__self__, "database_management_status", database_management_status)
        if db_tools_details is not None:
            pulumi.set(__self__, "db_tools_details", db_tools_details)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disaster_recovery_type is not None:
            pulumi.set(__self__, "disaster_recovery_type", disaster_recovery_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if in_memory_percentage is not None:
            pulumi.set(__self__, "in_memory_percentage", in_memory_percentage)
        if is_access_control_enabled is not None:
            pulumi.set(__self__, "is_access_control_enabled", is_access_control_enabled)
        if is_auto_scaling_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if is_auto_scaling_for_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_for_storage_enabled", is_auto_scaling_for_storage_enabled)
        if is_backup_retention_locked is not None:
            pulumi.set(__self__, "is_backup_retention_locked", is_backup_retention_locked)
        if is_data_guard_enabled is not None:
            pulumi.set(__self__, "is_data_guard_enabled", is_data_guard_enabled)
        if is_dedicated is not None:
            pulumi.set(__self__, "is_dedicated", is_dedicated)
        if is_dev_tier is not None:
            pulumi.set(__self__, "is_dev_tier", is_dev_tier)
        if is_free_tier is not None:
            pulumi.set(__self__, "is_free_tier", is_free_tier)
        if is_local_data_guard_enabled is not None:
            pulumi.set(__self__, "is_local_data_guard_enabled", is_local_data_guard_enabled)
        if is_mtls_connection_required is not None:
            pulumi.set(__self__, "is_mtls_connection_required", is_mtls_connection_required)
        if is_preview_version_with_service_terms_accepted is not None:
            pulumi.set(__self__, "is_preview_version_with_service_terms_accepted", is_preview_version_with_service_terms_accepted)
        if is_refreshable_clone is not None:
            pulumi.set(__self__, "is_refreshable_clone", is_refreshable_clone)
        if is_replicate_automatic_backups is not None:
            pulumi.set(__self__, "is_replicate_automatic_backups", is_replicate_automatic_backups)
        if is_shrink_only is not None:
            warnings.warn("""The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""", DeprecationWarning)
            pulumi.log.warn("""is_shrink_only is deprecated: The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""")
        if is_shrink_only is not None:
            pulumi.set(__self__, "is_shrink_only", is_shrink_only)
        if key_version_id is not None:
            pulumi.set(__self__, "key_version_id", key_version_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if local_adg_auto_failover_max_data_loss_limit is not None:
            pulumi.set(__self__, "local_adg_auto_failover_max_data_loss_limit", local_adg_auto_failover_max_data_loss_limit)
        if long_term_backup_schedules is not None:
            pulumi.set(__self__, "long_term_backup_schedules", long_term_backup_schedules)
        if max_cpu_core_count is not None:
            pulumi.set(__self__, "max_cpu_core_count", max_cpu_core_count)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if open_mode is not None:
            pulumi.set(__self__, "open_mode", open_mode)
        if operations_insights_status is not None:
            pulumi.set(__self__, "operations_insights_status", operations_insights_status)
        if permission_level is not None:
            pulumi.set(__self__, "permission_level", permission_level)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if private_endpoint_label is not None:
            pulumi.set(__self__, "private_endpoint_label", private_endpoint_label)
        if refreshable_mode is not None:
            pulumi.set(__self__, "refreshable_mode", refreshable_mode)
        if remote_disaster_recovery_type is not None:
            pulumi.set(__self__, "remote_disaster_recovery_type", remote_disaster_recovery_type)
        if resource_pool_leader_id is not None:
            pulumi.set(__self__, "resource_pool_leader_id", resource_pool_leader_id)
        if resource_pool_summary is not None:
            pulumi.set(__self__, "resource_pool_summary", resource_pool_summary)
        if rotate_key_trigger is not None:
            pulumi.set(__self__, "rotate_key_trigger", rotate_key_trigger)
        if scheduled_operations is not None:
            pulumi.set(__self__, "scheduled_operations", scheduled_operations)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_number is not None:
            pulumi.set(__self__, "secret_version_number", secret_version_number)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if shrink_adb_trigger is not None:
            pulumi.set(__self__, "shrink_adb_trigger", shrink_adb_trigger)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if standby_whitelisted_ips is not None:
            pulumi.set(__self__, "standby_whitelisted_ips", standby_whitelisted_ips)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if switchover_to is not None:
            pulumi.set(__self__, "switchover_to", switchover_to)
        if switchover_to_remote_peer_id is not None:
            pulumi.set(__self__, "switchover_to_remote_peer_id", switchover_to_remote_peer_id)
        if time_of_auto_refresh_start is not None:
            pulumi.set(__self__, "time_of_auto_refresh_start", time_of_auto_refresh_start)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if use_latest_available_backup_time_stamp is not None:
            pulumi.set(__self__, "use_latest_available_backup_time_stamp", use_latest_available_backup_time_stamp)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[str]:
        """
        The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="arePrimaryWhitelistedIpsUsed")
    def are_primary_whitelisted_ips_used(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        """
        return pulumi.get(self, "are_primary_whitelisted_ips_used")

    @are_primary_whitelisted_ips_used.setter
    def are_primary_whitelisted_ips_used(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_primary_whitelisted_ips_used", value)

    @property
    @pulumi.getter(name="autoRefreshFrequencyInSeconds")
    def auto_refresh_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        """
        return pulumi.get(self, "auto_refresh_frequency_in_seconds")

    @auto_refresh_frequency_in_seconds.setter
    def auto_refresh_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_refresh_frequency_in_seconds", value)

    @property
    @pulumi.getter(name="autoRefreshPointLagInSeconds")
    def auto_refresh_point_lag_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        """
        return pulumi.get(self, "auto_refresh_point_lag_in_seconds")

    @auto_refresh_point_lag_in_seconds.setter
    def auto_refresh_point_lag_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_refresh_point_lag_in_seconds", value)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="autonomousDatabaseBackupId")
    def autonomous_database_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_backup_id")

    @autonomous_database_backup_id.setter
    def autonomous_database_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_backup_id", value)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter(name="autonomousMaintenanceScheduleType")
    def autonomous_maintenance_schedule_type(self) -> Optional[pulumi.Input[str]]:
        """
        The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        """
        return pulumi.get(self, "autonomous_maintenance_schedule_type")

    @autonomous_maintenance_schedule_type.setter
    def autonomous_maintenance_schedule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_maintenance_schedule_type", value)

    @property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @property
    @pulumi.getter(name="byolComputeCountLimit")
    def byol_compute_count_limit(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "byol_compute_count_limit")

    @byol_compute_count_limit.setter
    def byol_compute_count_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "byol_compute_count_limit", value)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)

        For an Autonomous Database on dedicated infrastructure, the allowed values are:

        AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
        * `FULL` - This option creates a new database that includes all source database data.
        * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        """
        return pulumi.get(self, "clone_type")

    @clone_type.setter
    def clone_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clone_type", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
        * The data type must be an *integer*.
        * The minimum number of cores for all types of autonomous database is *1*
        * The maximum number of cores is as follows:
        * Autonomous Database Serverless instances: The maximum number of cores is *128*.
        * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]]:
        """
        (Updatable) Customer Contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]]):
        pulumi.set(self, "customer_contacts", value)

    @property
    @pulumi.getter(name="dataSafeStatus")
    def data_safe_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        """
        return pulumi.get(self, "data_safe_status")

    @data_safe_status.setter
    def data_safe_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_safe_status", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Notes**
        * This parameter is only supported for dedicated Exadata infrastructure.
        * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).

        **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseManagementStatus")
    def database_management_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of Database Management for this Autonomous Database.
        """
        return pulumi.get(self, "database_management_status")

    @database_management_status.setter
    def database_management_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_management_status", value)

    @property
    @pulumi.getter(name="dbToolsDetails")
    def db_tools_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]]:
        """
        (Updatable) The list of database tools details.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_tools_details")

    @db_tools_details.setter
    def db_tools_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]]):
        pulumi.set(self, "db_tools_details", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Autonomous Database workload type. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_workload", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="disasterRecoveryType")
    def disaster_recovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "disaster_recovery_type")

    @disaster_recovery_type.setter
    def disaster_recovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disaster_recovery_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']]:
        """
        (Updatable) Details of the Autonomous Database encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inMemoryPercentage")
    def in_memory_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        """
        return pulumi.get(self, "in_memory_percentage")

    @in_memory_percentage.setter
    def in_memory_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "in_memory_percentage", value)

    @property
    @pulumi.getter(name="isAccessControlEnabled")
    def is_access_control_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.

        This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        """
        return pulumi.get(self, "is_access_control_enabled")

    @is_access_control_enabled.setter
    def is_access_control_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_access_control_enabled", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="isAutoScalingForStorageEnabled")
    def is_auto_scaling_for_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_auto_scaling_for_storage_enabled")

    @is_auto_scaling_for_storage_enabled.setter
    def is_auto_scaling_for_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_scaling_for_storage_enabled", value)

    @property
    @pulumi.getter(name="isBackupRetentionLocked")
    def is_backup_retention_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if the Autonomous Database is backup retention locked.
        """
        return pulumi.get(self, "is_backup_retention_locked")

    @is_backup_retention_locked.setter
    def is_backup_retention_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_backup_retention_locked", value)

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @is_data_guard_enabled.setter
    def is_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isDedicated")
    def is_dedicated(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        """
        return pulumi.get(self, "is_dedicated")

    @is_dedicated.setter
    def is_dedicated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dedicated", value)

    @property
    @pulumi.getter(name="isDevTier")
    def is_dev_tier(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        """
        return pulumi.get(self, "is_dev_tier")

    @is_dev_tier.setter
    def is_dev_tier(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dev_tier", value)

    @property
    @pulumi.getter(name="isFreeTier")
    def is_free_tier(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        """
        return pulumi.get(self, "is_free_tier")

    @is_free_tier.setter
    def is_free_tier(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_free_tier", value)

    @property
    @pulumi.getter(name="isLocalDataGuardEnabled")
    def is_local_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_local_data_guard_enabled")

    @is_local_data_guard_enabled.setter
    def is_local_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isMtlsConnectionRequired")
    def is_mtls_connection_required(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        """
        return pulumi.get(self, "is_mtls_connection_required")

    @is_mtls_connection_required.setter
    def is_mtls_connection_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_connection_required", value)

    @property
    @pulumi.getter(name="isPreviewVersionWithServiceTermsAccepted")
    def is_preview_version_with_service_terms_accepted(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        """
        return pulumi.get(self, "is_preview_version_with_service_terms_accepted")

    @is_preview_version_with_service_terms_accepted.setter
    def is_preview_version_with_service_terms_accepted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preview_version_with_service_terms_accepted", value)

    @property
    @pulumi.getter(name="isRefreshableClone")
    def is_refreshable_clone(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        """
        return pulumi.get(self, "is_refreshable_clone")

    @is_refreshable_clone.setter
    def is_refreshable_clone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_refreshable_clone", value)

    @property
    @pulumi.getter(name="isReplicateAutomaticBackups")
    def is_replicate_automatic_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        """
        return pulumi.get(self, "is_replicate_automatic_backups")

    @is_replicate_automatic_backups.setter
    def is_replicate_automatic_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_replicate_automatic_backups", value)

    @property
    @pulumi.getter(name="isShrinkOnly")
    @_utilities.deprecated("""The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""")
    def is_shrink_only(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_shrink_only")

    @is_shrink_only.setter
    def is_shrink_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shrink_only", value)

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key version that is used in rotate key operations.
        """
        return pulumi.get(self, "key_version_id")

    @key_version_id.setter
    def key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="localAdgAutoFailoverMaxDataLossLimit")
    def local_adg_auto_failover_max_data_loss_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        """
        return pulumi.get(self, "local_adg_auto_failover_max_data_loss_limit")

    @local_adg_auto_failover_max_data_loss_limit.setter
    def local_adg_auto_failover_max_data_loss_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_adg_auto_failover_max_data_loss_limit", value)

    @property
    @pulumi.getter(name="longTermBackupSchedules")
    def long_term_backup_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]]:
        """
        Details for the long-term backup schedule.
        """
        return pulumi.get(self, "long_term_backup_schedules")

    @long_term_backup_schedules.setter
    def long_term_backup_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]]):
        pulumi.set(self, "long_term_backup_schedules", value)

    @property
    @pulumi.getter(name="maxCpuCoreCount")
    def max_cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        """
        return pulumi.get(self, "max_cpu_core_count")

    @max_cpu_core_count.setter
    def max_cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_core_count", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[str]]:
        """
        The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The number of OCPU cores to be made available to the database.


        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        The following points apply:
        * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
        * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.

        For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        """
        return pulumi.get(self, "open_mode")

    @open_mode.setter
    def open_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_mode", value)

    @property
    @pulumi.getter(name="operationsInsightsStatus")
    def operations_insights_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        """
        return pulumi.get(self, "operations_insights_status")

    @operations_insights_status.setter
    def operations_insights_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operations_insights_status", value)

    @property
    @pulumi.getter(name="permissionLevel")
    def permission_level(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Database permission level. Restricted mode allows access only by admin users.
        """
        return pulumi.get(self, "permission_level")

    @permission_level.setter
    def permission_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_level", value)

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private endpoint Ip address for the resource.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_ip", value)

    @property
    @pulumi.getter(name="privateEndpointLabel")
    def private_endpoint_label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) (Optional) (Updatable) The resource's private endpoint label.
        * Setting the endpoint label to a non-empty string creates a private endpoint database.
        * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
        * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        """
        return pulumi.get(self, "private_endpoint_label")

    @private_endpoint_label.setter
    def private_endpoint_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_label", value)

    @property
    @pulumi.getter(name="refreshableMode")
    def refreshable_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        """
        return pulumi.get(self, "refreshable_mode")

    @refreshable_mode.setter
    def refreshable_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refreshable_mode", value)

    @property
    @pulumi.getter(name="remoteDisasterRecoveryType")
    def remote_disaster_recovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "remote_disaster_recovery_type")

    @remote_disaster_recovery_type.setter
    def remote_disaster_recovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_disaster_recovery_type", value)

    @property
    @pulumi.getter(name="resourcePoolLeaderId")
    def resource_pool_leader_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_pool_leader_id")

    @resource_pool_leader_id.setter
    def resource_pool_leader_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_pool_leader_id", value)

    @property
    @pulumi.getter(name="resourcePoolSummary")
    def resource_pool_summary(self) -> Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']]:
        """
        (Updatable) The configuration details for resource pool
        """
        return pulumi.get(self, "resource_pool_summary")

    @resource_pool_summary.setter
    def resource_pool_summary(self, value: Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']]):
        pulumi.set(self, "resource_pool_summary", value)

    @property
    @pulumi.getter(name="rotateKeyTrigger")
    def rotate_key_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        """
        return pulumi.get(self, "rotate_key_trigger")

    @rotate_key_trigger.setter
    def rotate_key_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rotate_key_trigger", value)

    @property
    @pulumi.getter(name="scheduledOperations")
    def scheduled_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]]:
        """
        (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "scheduled_operations")

    @scheduled_operations.setter
    def scheduled_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]]):
        pulumi.set(self, "scheduled_operations", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.

        This cannot be used in conjunction with adminPassword.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        """
        return pulumi.get(self, "secret_version_number")

    @secret_version_number.setter
    def secret_version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secret_version_number", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter(name="shrinkAdbTrigger")
    def shrink_adb_trigger(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "shrink_adb_trigger")

    @shrink_adb_trigger.setter
    def shrink_adb_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shrink_adb_trigger", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the database:
        * Use `NONE` for creating a new Autonomous Database.
        * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
        * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
        * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.

        For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
        * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
        * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="standbyWhitelistedIps")
    def standby_whitelisted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "standby_whitelisted_ips")

    @standby_whitelisted_ips.setter
    def standby_whitelisted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "standby_whitelisted_ips", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Autonomous Database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
        * For Autonomous Database, setting this will disable public secure access to the database.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="switchoverTo")
    def switchover_to(self) -> Optional[pulumi.Input[str]]:
        """
        It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        """
        return pulumi.get(self, "switchover_to")

    @switchover_to.setter
    def switchover_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switchover_to", value)

    @property
    @pulumi.getter(name="switchoverToRemotePeerId")
    def switchover_to_remote_peer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        """
        return pulumi.get(self, "switchover_to_remote_peer_id")

    @switchover_to_remote_peer_id.setter
    def switchover_to_remote_peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switchover_to_remote_peer_id", value)

    @property
    @pulumi.getter(name="timeOfAutoRefreshStart")
    def time_of_auto_refresh_start(self) -> Optional[pulumi.Input[str]]:
        """
        The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        """
        return pulumi.get(self, "time_of_auto_refresh_start")

    @time_of_auto_refresh_start.setter
    def time_of_auto_refresh_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_auto_refresh_start", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp", value)

    @property
    @pulumi.getter(name="useLatestAvailableBackupTimeStamp")
    def use_latest_available_backup_time_stamp(self) -> Optional[pulumi.Input[bool]]:
        """
        Clone from latest available backup timestamp.
        """
        return pulumi.get(self, "use_latest_available_backup_time_stamp")

    @use_latest_available_backup_time_stamp.setter
    def use_latest_available_backup_time_stamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_available_backup_time_stamp", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        return pulumi.get(self, "whitelisted_ips")

    @whitelisted_ips.setter
    def whitelisted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelisted_ips", value)


@pulumi.input_type
class _AutonomousDatabaseState:
    def __init__(__self__, *,
                 actual_used_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 allocated_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 apex_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseApexDetailArgs']]]] = None,
                 are_primary_whitelisted_ips_used: Optional[pulumi.Input[bool]] = None,
                 auto_refresh_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 auto_refresh_point_lag_in_seconds: Optional[pulumi.Input[int]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_maintenance_schedule_type: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 available_upgrade_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseBackupConfigArgs']]]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 byol_compute_count_limit: Optional[pulumi.Input[float]] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 clone_type: Optional[pulumi.Input[str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[float]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionStringArgs']]]] = None,
                 connection_urls: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionUrlArgs']]]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]] = None,
                 data_safe_status: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_status: Optional[pulumi.Input[str]] = None,
                 dataguard_region_type: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_tools_details: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 db_workload: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disaster_recovery_region_type: Optional[pulumi.Input[str]] = None,
                 disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']] = None,
                 encryption_key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseEncryptionKeyHistoryEntryArgs']]]] = None,
                 failed_data_recovery_in_seconds: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 in_memory_area_in_gbs: Optional[pulumi.Input[int]] = None,
                 in_memory_percentage: Optional[pulumi.Input[int]] = None,
                 infrastructure_type: Optional[pulumi.Input[str]] = None,
                 is_access_control_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_for_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_backup_retention_locked: Optional[pulumi.Input[bool]] = None,
                 is_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_dedicated: Optional[pulumi.Input[bool]] = None,
                 is_dev_tier: Optional[pulumi.Input[bool]] = None,
                 is_free_tier: Optional[pulumi.Input[bool]] = None,
                 is_local_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_connection_required: Optional[pulumi.Input[bool]] = None,
                 is_preview: Optional[pulumi.Input[bool]] = None,
                 is_preview_version_with_service_terms_accepted: Optional[pulumi.Input[bool]] = None,
                 is_reconnect_clone_enabled: Optional[pulumi.Input[bool]] = None,
                 is_refreshable_clone: Optional[pulumi.Input[bool]] = None,
                 is_remote_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_replicate_automatic_backups: Optional[pulumi.Input[bool]] = None,
                 is_shrink_only: Optional[pulumi.Input[bool]] = None,
                 key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseKeyHistoryEntryArgs']]]] = None,
                 key_store_id: Optional[pulumi.Input[str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[str]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_lifecycle_details: Optional[pulumi.Input[str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 local_adg_auto_failover_max_data_loss_limit: Optional[pulumi.Input[int]] = None,
                 local_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 local_standby_dbs: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLocalStandbyDbArgs']]]] = None,
                 long_term_backup_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]] = None,
                 max_cpu_core_count: Optional[pulumi.Input[int]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 net_services_architecture: Optional[pulumi.Input[str]] = None,
                 next_long_term_backup_time_stamp: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 open_mode: Optional[pulumi.Input[str]] = None,
                 operations_insights_status: Optional[pulumi.Input[str]] = None,
                 peer_db_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permission_level: Optional[pulumi.Input[str]] = None,
                 private_endpoint: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 private_endpoint_label: Optional[pulumi.Input[str]] = None,
                 provisionable_cpuses: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
                 public_connection_urls: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabasePublicConnectionUrlArgs']]]] = None,
                 public_endpoint: Optional[pulumi.Input[str]] = None,
                 refreshable_mode: Optional[pulumi.Input[str]] = None,
                 refreshable_status: Optional[pulumi.Input[str]] = None,
                 remote_disaster_recovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs']]]] = None,
                 remote_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 resource_pool_leader_id: Optional[pulumi.Input[str]] = None,
                 resource_pool_summary: Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 rotate_key_trigger: Optional[pulumi.Input[bool]] = None,
                 scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_console_url: Optional[pulumi.Input[str]] = None,
                 shrink_adb_trigger: Optional[pulumi.Input[int]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 standby_dbs: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseStandbyDbArgs']]]] = None,
                 standby_whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 supported_regions_to_clone_tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switchover_to: Optional[pulumi.Input[str]] = None,
                 switchover_to_remote_peer_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_data_guard_role_changed: Optional[pulumi.Input[str]] = None,
                 time_deletion_of_free_autonomous_database: Optional[pulumi.Input[str]] = None,
                 time_disaster_recovery_role_changed: Optional[pulumi.Input[str]] = None,
                 time_local_data_guard_enabled: Optional[pulumi.Input[str]] = None,
                 time_maintenance_begin: Optional[pulumi.Input[str]] = None,
                 time_maintenance_end: Optional[pulumi.Input[str]] = None,
                 time_of_auto_refresh_start: Optional[pulumi.Input[str]] = None,
                 time_of_joining_resource_pool: Optional[pulumi.Input[str]] = None,
                 time_of_last_failover: Optional[pulumi.Input[str]] = None,
                 time_of_last_refresh: Optional[pulumi.Input[str]] = None,
                 time_of_last_refresh_point: Optional[pulumi.Input[str]] = None,
                 time_of_last_switchover: Optional[pulumi.Input[str]] = None,
                 time_of_next_refresh: Optional[pulumi.Input[str]] = None,
                 time_reclamation_of_free_autonomous_database: Optional[pulumi.Input[str]] = None,
                 time_undeleted: Optional[pulumi.Input[str]] = None,
                 time_until_reconnect_clone_enabled: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input[str]] = None,
                 total_backup_storage_size_in_gbs: Optional[pulumi.Input[float]] = None,
                 use_latest_available_backup_time_stamp: Optional[pulumi.Input[bool]] = None,
                 used_data_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 used_data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabase resources.
        :param pulumi.Input[float] actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and system data, in terabytes (TB).
        :param pulumi.Input[str] admin_password: (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        :param pulumi.Input[float] allocated_storage_size_in_tbs: The amount of storage currently allocated for the database tables and billed for, rounded up. When auto-scaling is not enabled, this value is equal to the `dataStorageSizeInTBs` value. You can compare this value to the `actualUsedDataStorageSizeInTBs` value to determine if a manual shrink operation is appropriate for your allocated storage.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseApexDetailArgs']]] apex_details: Information about Oracle APEX Application Development.
        :param pulumi.Input[bool] are_primary_whitelisted_ips_used: (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        :param pulumi.Input[int] auto_refresh_frequency_in_seconds: (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        :param pulumi.Input[int] auto_refresh_point_lag_in_seconds: (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        :param pulumi.Input[str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        :param pulumi.Input[str] availability_domain: The availability domain of a local Autonomous Data Guard standby database of an Autonomous Database Serverless instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_upgrade_versions: List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseBackupConfigArgs']]] backup_configs: Autonomous Database configuration details for storing [manual backups](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/backup-restore.html#GUID-9035DFB8-4702-4CEB-8281-C2A303820809) in the [Object Storage](https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm) service.
        :param pulumi.Input[int] backup_retention_period_in_days: (Updatable) Retention period, in days, for backups.
        :param pulumi.Input[str] character_set: The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)
               
               For an Autonomous Database on dedicated infrastructure, the allowed values are:
               
               AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        :param pulumi.Input[str] clone_type: The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
               * `FULL` - This option creates a new database that includes all source database data.
               * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Autonomous Serverless Database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        :param pulumi.Input[float] compute_count: (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[str] compute_model: (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionStringArgs']]] connection_strings: The connection string used to connect to the Autonomous Database. The username for the Service Console is ADMIN. Use the password you entered when creating the Autonomous Database for the password value.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionUrlArgs']]] connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. Note that these URLs are provided by the console only for databases on [dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).  Example: `{"sqlDevWebUrl": "https://<hostname>/ords...", "apexUrl", "https://<hostname>/ords..."}`
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
               * The data type must be an *integer*.
               * The minimum number of cores for all types of autonomous database is *1*
               * The maximum number of cores is as follows:
               * Autonomous Database Serverless instances: The maximum number of cores is *128*.
               * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]] customer_contacts: (Updatable) Customer Contacts.
        :param pulumi.Input[str] data_safe_status: (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Notes**
               * This parameter is only supported for dedicated Exadata infrastructure.
               * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        :param pulumi.Input[int] data_storage_size_in_tbs: (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).
               
               **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        :param pulumi.Input[str] database_edition: (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        :param pulumi.Input[str] database_management_status: Status of Database Management for this Autonomous Database.
        :param pulumi.Input[str] dataguard_region_type: **Deprecated** (Optional) The Autonomous Data Guard region type of the Autonomous Database. For Autonomous Database Serverless instances, Data Guard associations have designated primary (`PRIMARY_DG_REGION`) and standby (`REMOTE_STANDBY_DG_REGION`) regions, and these region types do not change when the database changes roles. The standby regions in Data Guard associations can be the same region designated as the primary region, or they can be remote regions. Certain database administrative operations may be available only in the primary region of the Data Guard association, and cannot be performed when the database using the "primary" role is operating in a remote Data Guard standby region.
        :param pulumi.Input[str] db_name: The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]] db_tools_details: (Updatable) The list of database tools details.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_version: (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        :param pulumi.Input[str] db_workload: (Updatable) The Autonomous Database workload type. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disaster_recovery_region_type: **Deprecated** The disaster recovery (DR) region type of the Autonomous Database. For Serverless Autonomous Databases, DR associations have designated primary (`PRIMARY`) and standby (`REMOTE`) regions. These region types do not change when the database changes roles. The standby region in DR associations can be the same region as the primary region, or they can be in a remote regions. Some database administration operations may be available only in the primary region of the DR association, and cannot be performed when the database using the primary role is operating in a remote region.
        :param pulumi.Input[str] disaster_recovery_type: Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        :param pulumi.Input['AutonomousDatabaseEncryptionKeyArgs'] encryption_key: (Updatable) Details of the Autonomous Database encryption key.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseEncryptionKeyHistoryEntryArgs']]] encryption_key_history_entries: Key History Entry.
        :param pulumi.Input[int] failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data Guard failover.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
        :param pulumi.Input[int] in_memory_percentage: (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        :param pulumi.Input[str] infrastructure_type: The infrastructure type this resource belongs to.
        :param pulumi.Input[bool] is_access_control_enabled: (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.
               
               This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        :param pulumi.Input[bool] is_auto_scaling_for_storage_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        :param pulumi.Input[bool] is_backup_retention_locked: (Updatable) True if the Autonomous Database is backup retention locked.
        :param pulumi.Input[bool] is_data_guard_enabled: (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_dedicated: True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        :param pulumi.Input[bool] is_dev_tier: (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        :param pulumi.Input[bool] is_free_tier: (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        :param pulumi.Input[bool] is_local_data_guard_enabled: (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_mtls_connection_required: (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        :param pulumi.Input[bool] is_preview: Indicates if the Autonomous Database version is a preview version.
        :param pulumi.Input[bool] is_preview_version_with_service_terms_accepted: If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        :param pulumi.Input[bool] is_reconnect_clone_enabled: Indicates if the refreshable clone can be reconnected to its source database.
        :param pulumi.Input[bool] is_refreshable_clone: (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        :param pulumi.Input[bool] is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region Data Guard enabled. It takes boolean values. Not applicable to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        :param pulumi.Input[bool] is_shrink_only: (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseKeyHistoryEntryArgs']]] key_history_entries: Key History Entry.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault. This is used in Autonomous Databases on Serverless instances and dedicated Exadata infrastructure.
        :param pulumi.Input[str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[str] key_version_id: The OCID of the key version that is used in rotate key operations.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_lifecycle_details: KMS key lifecycle details.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        :param pulumi.Input[str] local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the Serverless Autonomous Database. Autonomous Data Guard (`ADG`) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based (`BACKUP_BASED`) DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLocalStandbyDbArgs']]] local_standby_dbs: Autonomous Data Guard local (same region) standby database details.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]] long_term_backup_schedules: Details for the long-term backup schedule.
        :param pulumi.Input[int] max_cpu_core_count: (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per OCPU or ECPU. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details. This parameter is not used for Autonomous database Serverless.
        :param pulumi.Input[str] ncharacter_set: The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[str] net_services_architecture: Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        :param pulumi.Input[str] next_long_term_backup_time_stamp: The date and time when the next long-term backup would be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to be made available to the database.
               
               
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
               The following points apply:
               * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
               * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.
               
               For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        :param pulumi.Input[str] open_mode: Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        :param pulumi.Input[str] operations_insights_status: (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] peer_db_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs.
        :param pulumi.Input[str] permission_level: The Autonomous Database permission level. Restricted mode allows access only by admin users.
        :param pulumi.Input[str] private_endpoint: The private endpoint for the resource. This parameter is not used in Autonomous Databases using Serverless infrastructure and Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[str] private_endpoint_ip: The private endpoint Ip address for the resource.
        :param pulumi.Input[str] private_endpoint_label: (Updatable) (Optional) (Updatable) The resource's private endpoint label.
               * Setting the endpoint label to a non-empty string creates a private endpoint database.
               * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
               * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] provisionable_cpuses: An array of CPU values that an Autonomous Database can be scaled to.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabasePublicConnectionUrlArgs']]] public_connection_urls: The Public URLs of Private Endpoint database for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN.
        :param pulumi.Input[str] public_endpoint: The public endpoint for the private endpoint enabled resource.
        :param pulumi.Input[str] refreshable_mode: (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[str] refreshable_status: The refresh status of the clone. REFRESHING indicates that the clone is currently being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs']]] remote_disaster_recovery_configurations: Configurations of a Disaster Recovery.
        :param pulumi.Input[str] remote_disaster_recovery_type: Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] resource_pool_leader_id: (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs'] resource_pool_summary: (Updatable) The configuration details for resource pool
        :param pulumi.Input[str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[bool] rotate_key_trigger: (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]] scheduled_operations: (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] secret_id: (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.
               
               This cannot be used in conjunction with adminPassword.
        :param pulumi.Input[int] secret_version_number: (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] service_console_url: The URL of the Service Console for the Autonomous Database.
        :param pulumi.Input[str] source: The source of the database:
               * Use `NONE` for creating a new Autonomous Database.
               * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
               * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
               * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.
               
               For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
               * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
               * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseStandbyDbArgs']]] standby_dbs: **Deprecated** Autonomous Data Guard standby database details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] standby_whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] state: The current state of the Autonomous Database.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
               * For Autonomous Database, setting this will disable public secure access to the database.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_regions_to_clone_tos: The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database.
        :param pulumi.Input[str] switchover_to: It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        :param pulumi.Input[str] switchover_to_remote_peer_id: (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] time_created: The date and time the Autonomous Database was created.
        :param pulumi.Input[str] time_data_guard_role_changed: The date and time the Autonomous Data Guard role was switched for the Autonomous Database. For databases that have standbys in both the primary Data Guard region and a remote Data Guard standby region, this is the latest timestamp of either the database using the "primary" role in the primary Data Guard region, or database located in the remote Data Guard standby region.
        :param pulumi.Input[str] time_deletion_of_free_autonomous_database: The date and time the Always Free database will be automatically deleted because of inactivity. If the database is in the STOPPED state and without activity until this time, it will be deleted.
        :param pulumi.Input[str] time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was switched for the standby Autonomous Database.
        :param pulumi.Input[str] time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database.
        :param pulumi.Input[str] time_maintenance_begin: The date and time when maintenance will begin.
        :param pulumi.Input[str] time_maintenance_end: The date and time when maintenance will end.
        :param pulumi.Input[str] time_of_auto_refresh_start: The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        :param pulumi.Input[str] time_of_last_failover: The timestamp of the last failover operation.
        :param pulumi.Input[str] time_of_last_refresh: The date and time when last refresh happened.
        :param pulumi.Input[str] time_of_last_refresh_point: The refresh point timestamp (UTC). The refresh point is the time to which the database was most recently refreshed. Data created after the refresh point is not included in the refresh.
        :param pulumi.Input[str] time_of_last_switchover: The timestamp of the last switchover operation for the Autonomous Database.
        :param pulumi.Input[str] time_of_next_refresh: The date and time of next refresh.
        :param pulumi.Input[str] time_reclamation_of_free_autonomous_database: The date and time the Always Free database will be stopped because of inactivity. If this time is reached without any database activity, the database will automatically be put into the STOPPED state.
        :param pulumi.Input[str] time_until_reconnect_clone_enabled: The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to its source database.
        :param pulumi.Input[str] timestamp: The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        :param pulumi.Input[float] total_backup_storage_size_in_gbs: The backup storage to the database.
        :param pulumi.Input[bool] use_latest_available_backup_time_stamp: Clone from latest available backup timestamp.
        :param pulumi.Input[int] used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
        :param pulumi.Input[int] used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        if actual_used_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "actual_used_data_storage_size_in_tbs", actual_used_data_storage_size_in_tbs)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if allocated_storage_size_in_tbs is not None:
            pulumi.set(__self__, "allocated_storage_size_in_tbs", allocated_storage_size_in_tbs)
        if apex_details is not None:
            pulumi.set(__self__, "apex_details", apex_details)
        if are_primary_whitelisted_ips_used is not None:
            pulumi.set(__self__, "are_primary_whitelisted_ips_used", are_primary_whitelisted_ips_used)
        if auto_refresh_frequency_in_seconds is not None:
            pulumi.set(__self__, "auto_refresh_frequency_in_seconds", auto_refresh_frequency_in_seconds)
        if auto_refresh_point_lag_in_seconds is not None:
            pulumi.set(__self__, "auto_refresh_point_lag_in_seconds", auto_refresh_point_lag_in_seconds)
        if autonomous_container_database_id is not None:
            pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_database_backup_id is not None:
            pulumi.set(__self__, "autonomous_database_backup_id", autonomous_database_backup_id)
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if autonomous_maintenance_schedule_type is not None:
            pulumi.set(__self__, "autonomous_maintenance_schedule_type", autonomous_maintenance_schedule_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if available_upgrade_versions is not None:
            pulumi.set(__self__, "available_upgrade_versions", available_upgrade_versions)
        if backup_configs is not None:
            pulumi.set(__self__, "backup_configs", backup_configs)
        if backup_retention_period_in_days is not None:
            pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        if byol_compute_count_limit is not None:
            pulumi.set(__self__, "byol_compute_count_limit", byol_compute_count_limit)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if clone_type is not None:
            pulumi.set(__self__, "clone_type", clone_type)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if connection_urls is not None:
            pulumi.set(__self__, "connection_urls", connection_urls)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_safe_status is not None:
            pulumi.set(__self__, "data_safe_status", data_safe_status)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if database_management_status is not None:
            pulumi.set(__self__, "database_management_status", database_management_status)
        if dataguard_region_type is not None:
            pulumi.set(__self__, "dataguard_region_type", dataguard_region_type)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_tools_details is not None:
            pulumi.set(__self__, "db_tools_details", db_tools_details)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disaster_recovery_region_type is not None:
            pulumi.set(__self__, "disaster_recovery_region_type", disaster_recovery_region_type)
        if disaster_recovery_type is not None:
            pulumi.set(__self__, "disaster_recovery_type", disaster_recovery_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_key_history_entries is not None:
            pulumi.set(__self__, "encryption_key_history_entries", encryption_key_history_entries)
        if failed_data_recovery_in_seconds is not None:
            pulumi.set(__self__, "failed_data_recovery_in_seconds", failed_data_recovery_in_seconds)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if in_memory_area_in_gbs is not None:
            pulumi.set(__self__, "in_memory_area_in_gbs", in_memory_area_in_gbs)
        if in_memory_percentage is not None:
            pulumi.set(__self__, "in_memory_percentage", in_memory_percentage)
        if infrastructure_type is not None:
            pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if is_access_control_enabled is not None:
            pulumi.set(__self__, "is_access_control_enabled", is_access_control_enabled)
        if is_auto_scaling_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if is_auto_scaling_for_storage_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_for_storage_enabled", is_auto_scaling_for_storage_enabled)
        if is_backup_retention_locked is not None:
            pulumi.set(__self__, "is_backup_retention_locked", is_backup_retention_locked)
        if is_data_guard_enabled is not None:
            pulumi.set(__self__, "is_data_guard_enabled", is_data_guard_enabled)
        if is_dedicated is not None:
            pulumi.set(__self__, "is_dedicated", is_dedicated)
        if is_dev_tier is not None:
            pulumi.set(__self__, "is_dev_tier", is_dev_tier)
        if is_free_tier is not None:
            pulumi.set(__self__, "is_free_tier", is_free_tier)
        if is_local_data_guard_enabled is not None:
            pulumi.set(__self__, "is_local_data_guard_enabled", is_local_data_guard_enabled)
        if is_mtls_connection_required is not None:
            pulumi.set(__self__, "is_mtls_connection_required", is_mtls_connection_required)
        if is_preview is not None:
            pulumi.set(__self__, "is_preview", is_preview)
        if is_preview_version_with_service_terms_accepted is not None:
            pulumi.set(__self__, "is_preview_version_with_service_terms_accepted", is_preview_version_with_service_terms_accepted)
        if is_reconnect_clone_enabled is not None:
            pulumi.set(__self__, "is_reconnect_clone_enabled", is_reconnect_clone_enabled)
        if is_refreshable_clone is not None:
            pulumi.set(__self__, "is_refreshable_clone", is_refreshable_clone)
        if is_remote_data_guard_enabled is not None:
            pulumi.set(__self__, "is_remote_data_guard_enabled", is_remote_data_guard_enabled)
        if is_replicate_automatic_backups is not None:
            pulumi.set(__self__, "is_replicate_automatic_backups", is_replicate_automatic_backups)
        if is_shrink_only is not None:
            warnings.warn("""The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""", DeprecationWarning)
            pulumi.log.warn("""is_shrink_only is deprecated: The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""")
        if is_shrink_only is not None:
            pulumi.set(__self__, "is_shrink_only", is_shrink_only)
        if key_history_entries is not None:
            pulumi.set(__self__, "key_history_entries", key_history_entries)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if key_version_id is not None:
            pulumi.set(__self__, "key_version_id", key_version_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_lifecycle_details is not None:
            pulumi.set(__self__, "kms_key_lifecycle_details", kms_key_lifecycle_details)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if local_adg_auto_failover_max_data_loss_limit is not None:
            pulumi.set(__self__, "local_adg_auto_failover_max_data_loss_limit", local_adg_auto_failover_max_data_loss_limit)
        if local_disaster_recovery_type is not None:
            pulumi.set(__self__, "local_disaster_recovery_type", local_disaster_recovery_type)
        if local_standby_dbs is not None:
            pulumi.set(__self__, "local_standby_dbs", local_standby_dbs)
        if long_term_backup_schedules is not None:
            pulumi.set(__self__, "long_term_backup_schedules", long_term_backup_schedules)
        if max_cpu_core_count is not None:
            pulumi.set(__self__, "max_cpu_core_count", max_cpu_core_count)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if net_services_architecture is not None:
            pulumi.set(__self__, "net_services_architecture", net_services_architecture)
        if next_long_term_backup_time_stamp is not None:
            pulumi.set(__self__, "next_long_term_backup_time_stamp", next_long_term_backup_time_stamp)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if open_mode is not None:
            pulumi.set(__self__, "open_mode", open_mode)
        if operations_insights_status is not None:
            pulumi.set(__self__, "operations_insights_status", operations_insights_status)
        if peer_db_ids is not None:
            pulumi.set(__self__, "peer_db_ids", peer_db_ids)
        if permission_level is not None:
            pulumi.set(__self__, "permission_level", permission_level)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if private_endpoint_label is not None:
            pulumi.set(__self__, "private_endpoint_label", private_endpoint_label)
        if provisionable_cpuses is not None:
            pulumi.set(__self__, "provisionable_cpuses", provisionable_cpuses)
        if public_connection_urls is not None:
            pulumi.set(__self__, "public_connection_urls", public_connection_urls)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if refreshable_mode is not None:
            pulumi.set(__self__, "refreshable_mode", refreshable_mode)
        if refreshable_status is not None:
            pulumi.set(__self__, "refreshable_status", refreshable_status)
        if remote_disaster_recovery_configurations is not None:
            pulumi.set(__self__, "remote_disaster_recovery_configurations", remote_disaster_recovery_configurations)
        if remote_disaster_recovery_type is not None:
            pulumi.set(__self__, "remote_disaster_recovery_type", remote_disaster_recovery_type)
        if resource_pool_leader_id is not None:
            pulumi.set(__self__, "resource_pool_leader_id", resource_pool_leader_id)
        if resource_pool_summary is not None:
            pulumi.set(__self__, "resource_pool_summary", resource_pool_summary)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if rotate_key_trigger is not None:
            pulumi.set(__self__, "rotate_key_trigger", rotate_key_trigger)
        if scheduled_operations is not None:
            pulumi.set(__self__, "scheduled_operations", scheduled_operations)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_number is not None:
            pulumi.set(__self__, "secret_version_number", secret_version_number)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if service_console_url is not None:
            pulumi.set(__self__, "service_console_url", service_console_url)
        if shrink_adb_trigger is not None:
            pulumi.set(__self__, "shrink_adb_trigger", shrink_adb_trigger)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if standby_dbs is not None:
            pulumi.set(__self__, "standby_dbs", standby_dbs)
        if standby_whitelisted_ips is not None:
            pulumi.set(__self__, "standby_whitelisted_ips", standby_whitelisted_ips)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if supported_regions_to_clone_tos is not None:
            pulumi.set(__self__, "supported_regions_to_clone_tos", supported_regions_to_clone_tos)
        if switchover_to is not None:
            pulumi.set(__self__, "switchover_to", switchover_to)
        if switchover_to_remote_peer_id is not None:
            pulumi.set(__self__, "switchover_to_remote_peer_id", switchover_to_remote_peer_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_data_guard_role_changed is not None:
            pulumi.set(__self__, "time_data_guard_role_changed", time_data_guard_role_changed)
        if time_deletion_of_free_autonomous_database is not None:
            pulumi.set(__self__, "time_deletion_of_free_autonomous_database", time_deletion_of_free_autonomous_database)
        if time_disaster_recovery_role_changed is not None:
            pulumi.set(__self__, "time_disaster_recovery_role_changed", time_disaster_recovery_role_changed)
        if time_local_data_guard_enabled is not None:
            pulumi.set(__self__, "time_local_data_guard_enabled", time_local_data_guard_enabled)
        if time_maintenance_begin is not None:
            pulumi.set(__self__, "time_maintenance_begin", time_maintenance_begin)
        if time_maintenance_end is not None:
            pulumi.set(__self__, "time_maintenance_end", time_maintenance_end)
        if time_of_auto_refresh_start is not None:
            pulumi.set(__self__, "time_of_auto_refresh_start", time_of_auto_refresh_start)
        if time_of_joining_resource_pool is not None:
            pulumi.set(__self__, "time_of_joining_resource_pool", time_of_joining_resource_pool)
        if time_of_last_failover is not None:
            pulumi.set(__self__, "time_of_last_failover", time_of_last_failover)
        if time_of_last_refresh is not None:
            pulumi.set(__self__, "time_of_last_refresh", time_of_last_refresh)
        if time_of_last_refresh_point is not None:
            pulumi.set(__self__, "time_of_last_refresh_point", time_of_last_refresh_point)
        if time_of_last_switchover is not None:
            pulumi.set(__self__, "time_of_last_switchover", time_of_last_switchover)
        if time_of_next_refresh is not None:
            pulumi.set(__self__, "time_of_next_refresh", time_of_next_refresh)
        if time_reclamation_of_free_autonomous_database is not None:
            pulumi.set(__self__, "time_reclamation_of_free_autonomous_database", time_reclamation_of_free_autonomous_database)
        if time_undeleted is not None:
            pulumi.set(__self__, "time_undeleted", time_undeleted)
        if time_until_reconnect_clone_enabled is not None:
            pulumi.set(__self__, "time_until_reconnect_clone_enabled", time_until_reconnect_clone_enabled)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if total_backup_storage_size_in_gbs is not None:
            pulumi.set(__self__, "total_backup_storage_size_in_gbs", total_backup_storage_size_in_gbs)
        if use_latest_available_backup_time_stamp is not None:
            pulumi.set(__self__, "use_latest_available_backup_time_stamp", use_latest_available_backup_time_stamp)
        if used_data_storage_size_in_gbs is not None:
            pulumi.set(__self__, "used_data_storage_size_in_gbs", used_data_storage_size_in_gbs)
        if used_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "used_data_storage_size_in_tbs", used_data_storage_size_in_tbs)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @property
    @pulumi.getter(name="actualUsedDataStorageSizeInTbs")
    def actual_used_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The current amount of storage in use for user and system data, in terabytes (TB).
        """
        return pulumi.get(self, "actual_used_data_storage_size_in_tbs")

    @actual_used_data_storage_size_in_tbs.setter
    def actual_used_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "actual_used_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="allocatedStorageSizeInTbs")
    def allocated_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of storage currently allocated for the database tables and billed for, rounded up. When auto-scaling is not enabled, this value is equal to the `dataStorageSizeInTBs` value. You can compare this value to the `actualUsedDataStorageSizeInTBs` value to determine if a manual shrink operation is appropriate for your allocated storage.
        """
        return pulumi.get(self, "allocated_storage_size_in_tbs")

    @allocated_storage_size_in_tbs.setter
    def allocated_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "allocated_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="apexDetails")
    def apex_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseApexDetailArgs']]]]:
        """
        Information about Oracle APEX Application Development.
        """
        return pulumi.get(self, "apex_details")

    @apex_details.setter
    def apex_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseApexDetailArgs']]]]):
        pulumi.set(self, "apex_details", value)

    @property
    @pulumi.getter(name="arePrimaryWhitelistedIpsUsed")
    def are_primary_whitelisted_ips_used(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        """
        return pulumi.get(self, "are_primary_whitelisted_ips_used")

    @are_primary_whitelisted_ips_used.setter
    def are_primary_whitelisted_ips_used(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_primary_whitelisted_ips_used", value)

    @property
    @pulumi.getter(name="autoRefreshFrequencyInSeconds")
    def auto_refresh_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        """
        return pulumi.get(self, "auto_refresh_frequency_in_seconds")

    @auto_refresh_frequency_in_seconds.setter
    def auto_refresh_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_refresh_frequency_in_seconds", value)

    @property
    @pulumi.getter(name="autoRefreshPointLagInSeconds")
    def auto_refresh_point_lag_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        """
        return pulumi.get(self, "auto_refresh_point_lag_in_seconds")

    @auto_refresh_point_lag_in_seconds.setter
    def auto_refresh_point_lag_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_refresh_point_lag_in_seconds", value)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="autonomousDatabaseBackupId")
    def autonomous_database_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_backup_id")

    @autonomous_database_backup_id.setter
    def autonomous_database_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_backup_id", value)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter(name="autonomousMaintenanceScheduleType")
    def autonomous_maintenance_schedule_type(self) -> Optional[pulumi.Input[str]]:
        """
        The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        """
        return pulumi.get(self, "autonomous_maintenance_schedule_type")

    @autonomous_maintenance_schedule_type.setter
    def autonomous_maintenance_schedule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_maintenance_schedule_type", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain of a local Autonomous Data Guard standby database of an Autonomous Database Serverless instance.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availableUpgradeVersions")
    def available_upgrade_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty.
        """
        return pulumi.get(self, "available_upgrade_versions")

    @available_upgrade_versions.setter
    def available_upgrade_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_upgrade_versions", value)

    @property
    @pulumi.getter(name="backupConfigs")
    def backup_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseBackupConfigArgs']]]]:
        """
        Autonomous Database configuration details for storing [manual backups](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/backup-restore.html#GUID-9035DFB8-4702-4CEB-8281-C2A303820809) in the [Object Storage](https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm) service.
        """
        return pulumi.get(self, "backup_configs")

    @backup_configs.setter
    def backup_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseBackupConfigArgs']]]]):
        pulumi.set(self, "backup_configs", value)

    @property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period_in_days", value)

    @property
    @pulumi.getter(name="byolComputeCountLimit")
    def byol_compute_count_limit(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "byol_compute_count_limit")

    @byol_compute_count_limit.setter
    def byol_compute_count_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "byol_compute_count_limit", value)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)

        For an Autonomous Database on dedicated infrastructure, the allowed values are:

        AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
        * `FULL` - This option creates a new database that includes all source database data.
        * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        """
        return pulumi.get(self, "clone_type")

    @clone_type.setter
    def clone_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "clone_type", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Autonomous Serverless Database.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionStringArgs']]]]:
        """
        The connection string used to connect to the Autonomous Database. The username for the Service Console is ADMIN. Use the password you entered when creating the Autonomous Database for the password value.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="connectionUrls")
    def connection_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionUrlArgs']]]]:
        """
        The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. Note that these URLs are provided by the console only for databases on [dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).  Example: `{"sqlDevWebUrl": "https://<hostname>/ords...", "apexUrl", "https://<hostname>/ords..."}`
        """
        return pulumi.get(self, "connection_urls")

    @connection_urls.setter
    def connection_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseConnectionUrlArgs']]]]):
        pulumi.set(self, "connection_urls", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
        * The data type must be an *integer*.
        * The minimum number of cores for all types of autonomous database is *1*
        * The maximum number of cores is as follows:
        * Autonomous Database Serverless instances: The maximum number of cores is *128*.
        * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]]:
        """
        (Updatable) Customer Contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseCustomerContactArgs']]]]):
        pulumi.set(self, "customer_contacts", value)

    @property
    @pulumi.getter(name="dataSafeStatus")
    def data_safe_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        """
        return pulumi.get(self, "data_safe_status")

    @data_safe_status.setter
    def data_safe_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_safe_status", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Notes**
        * This parameter is only supported for dedicated Exadata infrastructure.
        * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).

        **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseManagementStatus")
    def database_management_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of Database Management for this Autonomous Database.
        """
        return pulumi.get(self, "database_management_status")

    @database_management_status.setter
    def database_management_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_management_status", value)

    @property
    @pulumi.getter(name="dataguardRegionType")
    def dataguard_region_type(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated** (Optional) The Autonomous Data Guard region type of the Autonomous Database. For Autonomous Database Serverless instances, Data Guard associations have designated primary (`PRIMARY_DG_REGION`) and standby (`REMOTE_STANDBY_DG_REGION`) regions, and these region types do not change when the database changes roles. The standby regions in Data Guard associations can be the same region designated as the primary region, or they can be remote regions. Certain database administrative operations may be available only in the primary region of the Data Guard association, and cannot be performed when the database using the "primary" role is operating in a remote Data Guard standby region.
        """
        return pulumi.get(self, "dataguard_region_type")

    @dataguard_region_type.setter
    def dataguard_region_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataguard_region_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbToolsDetails")
    def db_tools_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]]:
        """
        (Updatable) The list of database tools details.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_tools_details")

    @db_tools_details.setter
    def db_tools_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseDbToolsDetailArgs']]]]):
        pulumi.set(self, "db_tools_details", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Autonomous Database workload type. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_workload", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="disasterRecoveryRegionType")
    def disaster_recovery_region_type(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated** The disaster recovery (DR) region type of the Autonomous Database. For Serverless Autonomous Databases, DR associations have designated primary (`PRIMARY`) and standby (`REMOTE`) regions. These region types do not change when the database changes roles. The standby region in DR associations can be the same region as the primary region, or they can be in a remote regions. Some database administration operations may be available only in the primary region of the DR association, and cannot be performed when the database using the primary role is operating in a remote region.
        """
        return pulumi.get(self, "disaster_recovery_region_type")

    @disaster_recovery_region_type.setter
    def disaster_recovery_region_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disaster_recovery_region_type", value)

    @property
    @pulumi.getter(name="disasterRecoveryType")
    def disaster_recovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "disaster_recovery_type")

    @disaster_recovery_type.setter
    def disaster_recovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disaster_recovery_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']]:
        """
        (Updatable) Details of the Autonomous Database encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['AutonomousDatabaseEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="encryptionKeyHistoryEntries")
    def encryption_key_history_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseEncryptionKeyHistoryEntryArgs']]]]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "encryption_key_history_entries")

    @encryption_key_history_entries.setter
    def encryption_key_history_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseEncryptionKeyHistoryEntryArgs']]]]):
        pulumi.set(self, "encryption_key_history_entries", value)

    @property
    @pulumi.getter(name="failedDataRecoveryInSeconds")
    def failed_data_recovery_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of seconds of data loss for a Data Guard failover.
        """
        return pulumi.get(self, "failed_data_recovery_in_seconds")

    @failed_data_recovery_in_seconds.setter
    def failed_data_recovery_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed_data_recovery_in_seconds", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inMemoryAreaInGbs")
    def in_memory_area_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The area assigned to In-Memory tables in Autonomous Database.
        """
        return pulumi.get(self, "in_memory_area_in_gbs")

    @in_memory_area_in_gbs.setter
    def in_memory_area_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "in_memory_area_in_gbs", value)

    @property
    @pulumi.getter(name="inMemoryPercentage")
    def in_memory_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        """
        return pulumi.get(self, "in_memory_percentage")

    @in_memory_percentage.setter
    def in_memory_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "in_memory_percentage", value)

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[pulumi.Input[str]]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @infrastructure_type.setter
    def infrastructure_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_type", value)

    @property
    @pulumi.getter(name="isAccessControlEnabled")
    def is_access_control_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.

        This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        """
        return pulumi.get(self, "is_access_control_enabled")

    @is_access_control_enabled.setter
    def is_access_control_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_access_control_enabled", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="isAutoScalingForStorageEnabled")
    def is_auto_scaling_for_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_auto_scaling_for_storage_enabled")

    @is_auto_scaling_for_storage_enabled.setter
    def is_auto_scaling_for_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_scaling_for_storage_enabled", value)

    @property
    @pulumi.getter(name="isBackupRetentionLocked")
    def is_backup_retention_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if the Autonomous Database is backup retention locked.
        """
        return pulumi.get(self, "is_backup_retention_locked")

    @is_backup_retention_locked.setter
    def is_backup_retention_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_backup_retention_locked", value)

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @is_data_guard_enabled.setter
    def is_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isDedicated")
    def is_dedicated(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        """
        return pulumi.get(self, "is_dedicated")

    @is_dedicated.setter
    def is_dedicated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dedicated", value)

    @property
    @pulumi.getter(name="isDevTier")
    def is_dev_tier(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        """
        return pulumi.get(self, "is_dev_tier")

    @is_dev_tier.setter
    def is_dev_tier(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_dev_tier", value)

    @property
    @pulumi.getter(name="isFreeTier")
    def is_free_tier(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        """
        return pulumi.get(self, "is_free_tier")

    @is_free_tier.setter
    def is_free_tier(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_free_tier", value)

    @property
    @pulumi.getter(name="isLocalDataGuardEnabled")
    def is_local_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_local_data_guard_enabled")

    @is_local_data_guard_enabled.setter
    def is_local_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_local_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isMtlsConnectionRequired")
    def is_mtls_connection_required(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        """
        return pulumi.get(self, "is_mtls_connection_required")

    @is_mtls_connection_required.setter
    def is_mtls_connection_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_connection_required", value)

    @property
    @pulumi.getter(name="isPreview")
    def is_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the Autonomous Database version is a preview version.
        """
        return pulumi.get(self, "is_preview")

    @is_preview.setter
    def is_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preview", value)

    @property
    @pulumi.getter(name="isPreviewVersionWithServiceTermsAccepted")
    def is_preview_version_with_service_terms_accepted(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        """
        return pulumi.get(self, "is_preview_version_with_service_terms_accepted")

    @is_preview_version_with_service_terms_accepted.setter
    def is_preview_version_with_service_terms_accepted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preview_version_with_service_terms_accepted", value)

    @property
    @pulumi.getter(name="isReconnectCloneEnabled")
    def is_reconnect_clone_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the refreshable clone can be reconnected to its source database.
        """
        return pulumi.get(self, "is_reconnect_clone_enabled")

    @is_reconnect_clone_enabled.setter
    def is_reconnect_clone_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_reconnect_clone_enabled", value)

    @property
    @pulumi.getter(name="isRefreshableClone")
    def is_refreshable_clone(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        """
        return pulumi.get(self, "is_refreshable_clone")

    @is_refreshable_clone.setter
    def is_refreshable_clone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_refreshable_clone", value)

    @property
    @pulumi.getter(name="isRemoteDataGuardEnabled")
    def is_remote_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Autonomous Database has Cross Region Data Guard enabled. It takes boolean values. Not applicable to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_remote_data_guard_enabled")

    @is_remote_data_guard_enabled.setter
    def is_remote_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_remote_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isReplicateAutomaticBackups")
    def is_replicate_automatic_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        """
        return pulumi.get(self, "is_replicate_automatic_backups")

    @is_replicate_automatic_backups.setter
    def is_replicate_automatic_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_replicate_automatic_backups", value)

    @property
    @pulumi.getter(name="isShrinkOnly")
    @_utilities.deprecated("""The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""")
    def is_shrink_only(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_shrink_only")

    @is_shrink_only.setter
    def is_shrink_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shrink_only", value)

    @property
    @pulumi.getter(name="keyHistoryEntries")
    def key_history_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseKeyHistoryEntryArgs']]]]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "key_history_entries")

    @key_history_entries.setter
    def key_history_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseKeyHistoryEntryArgs']]]]):
        pulumi.set(self, "key_history_entries", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault. This is used in Autonomous Databases on Serverless instances and dedicated Exadata infrastructure.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key version that is used in rotate key operations.
        """
        return pulumi.get(self, "key_version_id")

    @key_version_id.setter
    def key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyLifecycleDetails")
    def kms_key_lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key lifecycle details.
        """
        return pulumi.get(self, "kms_key_lifecycle_details")

    @kms_key_lifecycle_details.setter
    def kms_key_lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_lifecycle_details", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="localAdgAutoFailoverMaxDataLossLimit")
    def local_adg_auto_failover_max_data_loss_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        """
        return pulumi.get(self, "local_adg_auto_failover_max_data_loss_limit")

    @local_adg_auto_failover_max_data_loss_limit.setter
    def local_adg_auto_failover_max_data_loss_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_adg_auto_failover_max_data_loss_limit", value)

    @property
    @pulumi.getter(name="localDisasterRecoveryType")
    def local_disaster_recovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the local disaster recovery (DR) type of the Serverless Autonomous Database. Autonomous Data Guard (`ADG`) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based (`BACKUP_BASED`) DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "local_disaster_recovery_type")

    @local_disaster_recovery_type.setter
    def local_disaster_recovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_disaster_recovery_type", value)

    @property
    @pulumi.getter(name="localStandbyDbs")
    def local_standby_dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLocalStandbyDbArgs']]]]:
        """
        Autonomous Data Guard local (same region) standby database details.
        """
        return pulumi.get(self, "local_standby_dbs")

    @local_standby_dbs.setter
    def local_standby_dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLocalStandbyDbArgs']]]]):
        pulumi.set(self, "local_standby_dbs", value)

    @property
    @pulumi.getter(name="longTermBackupSchedules")
    def long_term_backup_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]]:
        """
        Details for the long-term backup schedule.
        """
        return pulumi.get(self, "long_term_backup_schedules")

    @long_term_backup_schedules.setter
    def long_term_backup_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseLongTermBackupScheduleArgs']]]]):
        pulumi.set(self, "long_term_backup_schedules", value)

    @property
    @pulumi.getter(name="maxCpuCoreCount")
    def max_cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        """
        return pulumi.get(self, "max_cpu_core_count")

    @max_cpu_core_count.setter
    def max_cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_core_count", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory (in GBs) enabled per OCPU or ECPU. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details. This parameter is not used for Autonomous database Serverless.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[str]]:
        """
        The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="netServicesArchitecture")
    def net_services_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        """
        return pulumi.get(self, "net_services_architecture")

    @net_services_architecture.setter
    def net_services_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_services_architecture", value)

    @property
    @pulumi.getter(name="nextLongTermBackupTimeStamp")
    def next_long_term_backup_time_stamp(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the next long-term backup would be created.
        """
        return pulumi.get(self, "next_long_term_backup_time_stamp")

    @next_long_term_backup_time_stamp.setter
    def next_long_term_backup_time_stamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_long_term_backup_time_stamp", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The number of OCPU cores to be made available to the database.


        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        The following points apply:
        * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
        * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.

        For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        """
        return pulumi.get(self, "open_mode")

    @open_mode.setter
    def open_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_mode", value)

    @property
    @pulumi.getter(name="operationsInsightsStatus")
    def operations_insights_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        """
        return pulumi.get(self, "operations_insights_status")

    @operations_insights_status.setter
    def operations_insights_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operations_insights_status", value)

    @property
    @pulumi.getter(name="peerDbIds")
    def peer_db_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs.
        """
        return pulumi.get(self, "peer_db_ids")

    @peer_db_ids.setter
    def peer_db_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "peer_db_ids", value)

    @property
    @pulumi.getter(name="permissionLevel")
    def permission_level(self) -> Optional[pulumi.Input[str]]:
        """
        The Autonomous Database permission level. Restricted mode allows access only by admin users.
        """
        return pulumi.get(self, "permission_level")

    @permission_level.setter
    def permission_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_level", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The private endpoint for the resource. This parameter is not used in Autonomous Databases using Serverless infrastructure and Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private endpoint Ip address for the resource.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_ip", value)

    @property
    @pulumi.getter(name="privateEndpointLabel")
    def private_endpoint_label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) (Optional) (Updatable) The resource's private endpoint label.
        * Setting the endpoint label to a non-empty string creates a private endpoint database.
        * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
        * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        """
        return pulumi.get(self, "private_endpoint_label")

    @private_endpoint_label.setter
    def private_endpoint_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_label", value)

    @property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        An array of CPU values that an Autonomous Database can be scaled to.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @provisionable_cpuses.setter
    def provisionable_cpuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "provisionable_cpuses", value)

    @property
    @pulumi.getter(name="publicConnectionUrls")
    def public_connection_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabasePublicConnectionUrlArgs']]]]:
        """
        The Public URLs of Private Endpoint database for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN.
        """
        return pulumi.get(self, "public_connection_urls")

    @public_connection_urls.setter
    def public_connection_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabasePublicConnectionUrlArgs']]]]):
        pulumi.set(self, "public_connection_urls", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The public endpoint for the private endpoint enabled resource.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter(name="refreshableMode")
    def refreshable_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        """
        return pulumi.get(self, "refreshable_mode")

    @refreshable_mode.setter
    def refreshable_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refreshable_mode", value)

    @property
    @pulumi.getter(name="refreshableStatus")
    def refreshable_status(self) -> Optional[pulumi.Input[str]]:
        """
        The refresh status of the clone. REFRESHING indicates that the clone is currently being refreshed with data from the source Autonomous Database.
        """
        return pulumi.get(self, "refreshable_status")

    @refreshable_status.setter
    def refreshable_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refreshable_status", value)

    @property
    @pulumi.getter(name="remoteDisasterRecoveryConfigurations")
    def remote_disaster_recovery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs']]]]:
        """
        Configurations of a Disaster Recovery.
        """
        return pulumi.get(self, "remote_disaster_recovery_configurations")

    @remote_disaster_recovery_configurations.setter
    def remote_disaster_recovery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs']]]]):
        pulumi.set(self, "remote_disaster_recovery_configurations", value)

    @property
    @pulumi.getter(name="remoteDisasterRecoveryType")
    def remote_disaster_recovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "remote_disaster_recovery_type")

    @remote_disaster_recovery_type.setter
    def remote_disaster_recovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_disaster_recovery_type", value)

    @property
    @pulumi.getter(name="resourcePoolLeaderId")
    def resource_pool_leader_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_pool_leader_id")

    @resource_pool_leader_id.setter
    def resource_pool_leader_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_pool_leader_id", value)

    @property
    @pulumi.getter(name="resourcePoolSummary")
    def resource_pool_summary(self) -> Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']]:
        """
        (Updatable) The configuration details for resource pool
        """
        return pulumi.get(self, "resource_pool_summary")

    @resource_pool_summary.setter
    def resource_pool_summary(self, value: Optional[pulumi.Input['AutonomousDatabaseResourcePoolSummaryArgs']]):
        pulumi.set(self, "resource_pool_summary", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="rotateKeyTrigger")
    def rotate_key_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        """
        return pulumi.get(self, "rotate_key_trigger")

    @rotate_key_trigger.setter
    def rotate_key_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rotate_key_trigger", value)

    @property
    @pulumi.getter(name="scheduledOperations")
    def scheduled_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]]:
        """
        (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "scheduled_operations")

    @scheduled_operations.setter
    def scheduled_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseScheduledOperationArgs']]]]):
        pulumi.set(self, "scheduled_operations", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.

        This cannot be used in conjunction with adminPassword.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        """
        return pulumi.get(self, "secret_version_number")

    @secret_version_number.setter
    def secret_version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secret_version_number", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter(name="serviceConsoleUrl")
    def service_console_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Service Console for the Autonomous Database.
        """
        return pulumi.get(self, "service_console_url")

    @service_console_url.setter
    def service_console_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_console_url", value)

    @property
    @pulumi.getter(name="shrinkAdbTrigger")
    def shrink_adb_trigger(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "shrink_adb_trigger")

    @shrink_adb_trigger.setter
    def shrink_adb_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shrink_adb_trigger", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the database:
        * Use `NONE` for creating a new Autonomous Database.
        * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
        * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
        * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.

        For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
        * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
        * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="standbyDbs")
    def standby_dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseStandbyDbArgs']]]]:
        """
        **Deprecated** Autonomous Data Guard standby database details.
        """
        return pulumi.get(self, "standby_dbs")

    @standby_dbs.setter
    def standby_dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousDatabaseStandbyDbArgs']]]]):
        pulumi.set(self, "standby_dbs", value)

    @property
    @pulumi.getter(name="standbyWhitelistedIps")
    def standby_whitelisted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "standby_whitelisted_ips")

    @standby_whitelisted_ips.setter
    def standby_whitelisted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "standby_whitelisted_ips", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Autonomous Database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
        * For Autonomous Database, setting this will disable public secure access to the database.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="supportedRegionsToCloneTos")
    def supported_regions_to_clone_tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database.
        """
        return pulumi.get(self, "supported_regions_to_clone_tos")

    @supported_regions_to_clone_tos.setter
    def supported_regions_to_clone_tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_regions_to_clone_tos", value)

    @property
    @pulumi.getter(name="switchoverTo")
    def switchover_to(self) -> Optional[pulumi.Input[str]]:
        """
        It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        """
        return pulumi.get(self, "switchover_to")

    @switchover_to.setter
    def switchover_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switchover_to", value)

    @property
    @pulumi.getter(name="switchoverToRemotePeerId")
    def switchover_to_remote_peer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        """
        return pulumi.get(self, "switchover_to_remote_peer_id")

    @switchover_to_remote_peer_id.setter
    def switchover_to_remote_peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switchover_to_remote_peer_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Autonomous Database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDataGuardRoleChanged")
    def time_data_guard_role_changed(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Autonomous Data Guard role was switched for the Autonomous Database. For databases that have standbys in both the primary Data Guard region and a remote Data Guard standby region, this is the latest timestamp of either the database using the "primary" role in the primary Data Guard region, or database located in the remote Data Guard standby region.
        """
        return pulumi.get(self, "time_data_guard_role_changed")

    @time_data_guard_role_changed.setter
    def time_data_guard_role_changed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_data_guard_role_changed", value)

    @property
    @pulumi.getter(name="timeDeletionOfFreeAutonomousDatabase")
    def time_deletion_of_free_autonomous_database(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Always Free database will be automatically deleted because of inactivity. If the database is in the STOPPED state and without activity until this time, it will be deleted.
        """
        return pulumi.get(self, "time_deletion_of_free_autonomous_database")

    @time_deletion_of_free_autonomous_database.setter
    def time_deletion_of_free_autonomous_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deletion_of_free_autonomous_database", value)

    @property
    @pulumi.getter(name="timeDisasterRecoveryRoleChanged")
    def time_disaster_recovery_role_changed(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Disaster Recovery role was switched for the standby Autonomous Database.
        """
        return pulumi.get(self, "time_disaster_recovery_role_changed")

    @time_disaster_recovery_role_changed.setter
    def time_disaster_recovery_role_changed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_disaster_recovery_role_changed", value)

    @property
    @pulumi.getter(name="timeLocalDataGuardEnabled")
    def time_local_data_guard_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database.
        """
        return pulumi.get(self, "time_local_data_guard_enabled")

    @time_local_data_guard_enabled.setter
    def time_local_data_guard_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_local_data_guard_enabled", value)

    @property
    @pulumi.getter(name="timeMaintenanceBegin")
    def time_maintenance_begin(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when maintenance will begin.
        """
        return pulumi.get(self, "time_maintenance_begin")

    @time_maintenance_begin.setter
    def time_maintenance_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_maintenance_begin", value)

    @property
    @pulumi.getter(name="timeMaintenanceEnd")
    def time_maintenance_end(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when maintenance will end.
        """
        return pulumi.get(self, "time_maintenance_end")

    @time_maintenance_end.setter
    def time_maintenance_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_maintenance_end", value)

    @property
    @pulumi.getter(name="timeOfAutoRefreshStart")
    def time_of_auto_refresh_start(self) -> Optional[pulumi.Input[str]]:
        """
        The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        """
        return pulumi.get(self, "time_of_auto_refresh_start")

    @time_of_auto_refresh_start.setter
    def time_of_auto_refresh_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_auto_refresh_start", value)

    @property
    @pulumi.getter(name="timeOfJoiningResourcePool")
    def time_of_joining_resource_pool(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_of_joining_resource_pool")

    @time_of_joining_resource_pool.setter
    def time_of_joining_resource_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_joining_resource_pool", value)

    @property
    @pulumi.getter(name="timeOfLastFailover")
    def time_of_last_failover(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the last failover operation.
        """
        return pulumi.get(self, "time_of_last_failover")

    @time_of_last_failover.setter
    def time_of_last_failover(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_last_failover", value)

    @property
    @pulumi.getter(name="timeOfLastRefresh")
    def time_of_last_refresh(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when last refresh happened.
        """
        return pulumi.get(self, "time_of_last_refresh")

    @time_of_last_refresh.setter
    def time_of_last_refresh(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_last_refresh", value)

    @property
    @pulumi.getter(name="timeOfLastRefreshPoint")
    def time_of_last_refresh_point(self) -> Optional[pulumi.Input[str]]:
        """
        The refresh point timestamp (UTC). The refresh point is the time to which the database was most recently refreshed. Data created after the refresh point is not included in the refresh.
        """
        return pulumi.get(self, "time_of_last_refresh_point")

    @time_of_last_refresh_point.setter
    def time_of_last_refresh_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_last_refresh_point", value)

    @property
    @pulumi.getter(name="timeOfLastSwitchover")
    def time_of_last_switchover(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the last switchover operation for the Autonomous Database.
        """
        return pulumi.get(self, "time_of_last_switchover")

    @time_of_last_switchover.setter
    def time_of_last_switchover(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_last_switchover", value)

    @property
    @pulumi.getter(name="timeOfNextRefresh")
    def time_of_next_refresh(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of next refresh.
        """
        return pulumi.get(self, "time_of_next_refresh")

    @time_of_next_refresh.setter
    def time_of_next_refresh(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_next_refresh", value)

    @property
    @pulumi.getter(name="timeReclamationOfFreeAutonomousDatabase")
    def time_reclamation_of_free_autonomous_database(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Always Free database will be stopped because of inactivity. If this time is reached without any database activity, the database will automatically be put into the STOPPED state.
        """
        return pulumi.get(self, "time_reclamation_of_free_autonomous_database")

    @time_reclamation_of_free_autonomous_database.setter
    def time_reclamation_of_free_autonomous_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_reclamation_of_free_autonomous_database", value)

    @property
    @pulumi.getter(name="timeUndeleted")
    def time_undeleted(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_undeleted")

    @time_undeleted.setter
    def time_undeleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_undeleted", value)

    @property
    @pulumi.getter(name="timeUntilReconnectCloneEnabled")
    def time_until_reconnect_clone_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to its source database.
        """
        return pulumi.get(self, "time_until_reconnect_clone_enabled")

    @time_until_reconnect_clone_enabled.setter
    def time_until_reconnect_clone_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_until_reconnect_clone_enabled", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp", value)

    @property
    @pulumi.getter(name="totalBackupStorageSizeInGbs")
    def total_backup_storage_size_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The backup storage to the database.
        """
        return pulumi.get(self, "total_backup_storage_size_in_gbs")

    @total_backup_storage_size_in_gbs.setter
    def total_backup_storage_size_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_backup_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="useLatestAvailableBackupTimeStamp")
    def use_latest_available_backup_time_stamp(self) -> Optional[pulumi.Input[bool]]:
        """
        Clone from latest available backup timestamp.
        """
        return pulumi.get(self, "use_latest_available_backup_time_stamp")

    @use_latest_available_backup_time_stamp.setter
    def use_latest_available_backup_time_stamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_available_backup_time_stamp", value)

    @property
    @pulumi.getter(name="usedDataStorageSizeInGbs")
    def used_data_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The storage space consumed by Autonomous Database in GBs.
        """
        return pulumi.get(self, "used_data_storage_size_in_gbs")

    @used_data_storage_size_in_gbs.setter
    def used_data_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_data_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="usedDataStorageSizeInTbs")
    def used_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of storage that has been used, in terabytes.
        """
        return pulumi.get(self, "used_data_storage_size_in_tbs")

    @used_data_storage_size_in_tbs.setter
    def used_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        return pulumi.get(self, "whitelisted_ips")

    @whitelisted_ips.setter
    def whitelisted_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelisted_ips", value)


class AutonomousDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 are_primary_whitelisted_ips_used: Optional[pulumi.Input[bool]] = None,
                 auto_refresh_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 auto_refresh_point_lag_in_seconds: Optional[pulumi.Input[int]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_maintenance_schedule_type: Optional[pulumi.Input[str]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 byol_compute_count_limit: Optional[pulumi.Input[float]] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 clone_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[float]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseCustomerContactArgs', 'AutonomousDatabaseCustomerContactArgsDict']]]]] = None,
                 data_safe_status: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_status: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_tools_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseDbToolsDetailArgs', 'AutonomousDatabaseDbToolsDetailArgsDict']]]]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 db_workload: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Union['AutonomousDatabaseEncryptionKeyArgs', 'AutonomousDatabaseEncryptionKeyArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 in_memory_percentage: Optional[pulumi.Input[int]] = None,
                 is_access_control_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_for_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_backup_retention_locked: Optional[pulumi.Input[bool]] = None,
                 is_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_dedicated: Optional[pulumi.Input[bool]] = None,
                 is_dev_tier: Optional[pulumi.Input[bool]] = None,
                 is_free_tier: Optional[pulumi.Input[bool]] = None,
                 is_local_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_connection_required: Optional[pulumi.Input[bool]] = None,
                 is_preview_version_with_service_terms_accepted: Optional[pulumi.Input[bool]] = None,
                 is_refreshable_clone: Optional[pulumi.Input[bool]] = None,
                 is_replicate_automatic_backups: Optional[pulumi.Input[bool]] = None,
                 is_shrink_only: Optional[pulumi.Input[bool]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 local_adg_auto_failover_max_data_loss_limit: Optional[pulumi.Input[int]] = None,
                 long_term_backup_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]]]] = None,
                 max_cpu_core_count: Optional[pulumi.Input[int]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 open_mode: Optional[pulumi.Input[str]] = None,
                 operations_insights_status: Optional[pulumi.Input[str]] = None,
                 permission_level: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 private_endpoint_label: Optional[pulumi.Input[str]] = None,
                 refreshable_mode: Optional[pulumi.Input[str]] = None,
                 remote_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 resource_pool_leader_id: Optional[pulumi.Input[str]] = None,
                 resource_pool_summary: Optional[pulumi.Input[Union['AutonomousDatabaseResourcePoolSummaryArgs', 'AutonomousDatabaseResourcePoolSummaryArgsDict']]] = None,
                 rotate_key_trigger: Optional[pulumi.Input[bool]] = None,
                 scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseScheduledOperationArgs', 'AutonomousDatabaseScheduledOperationArgsDict']]]]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shrink_adb_trigger: Optional[pulumi.Input[int]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 standby_whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 switchover_to: Optional[pulumi.Input[str]] = None,
                 switchover_to_remote_peer_id: Optional[pulumi.Input[str]] = None,
                 time_of_auto_refresh_start: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input[str]] = None,
                 use_latest_available_backup_time_stamp: Optional[pulumi.Input[bool]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new Autonomous Database.

        This API must be called on the remote region where the peer needs to be created.

        ## Import

        AutonomousDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabase:AutonomousDatabase test_autonomous_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_password: (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        :param pulumi.Input[bool] are_primary_whitelisted_ips_used: (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        :param pulumi.Input[int] auto_refresh_frequency_in_seconds: (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        :param pulumi.Input[int] auto_refresh_point_lag_in_seconds: (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        :param pulumi.Input[str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        :param pulumi.Input[int] backup_retention_period_in_days: (Updatable) Retention period, in days, for backups.
        :param pulumi.Input[str] character_set: The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)
               
               For an Autonomous Database on dedicated infrastructure, the allowed values are:
               
               AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        :param pulumi.Input[str] clone_type: The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
               * `FULL` - This option creates a new database that includes all source database data.
               * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        :param pulumi.Input[float] compute_count: (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[str] compute_model: (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
               * The data type must be an *integer*.
               * The minimum number of cores for all types of autonomous database is *1*
               * The maximum number of cores is as follows:
               * Autonomous Database Serverless instances: The maximum number of cores is *128*.
               * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseCustomerContactArgs', 'AutonomousDatabaseCustomerContactArgsDict']]]] customer_contacts: (Updatable) Customer Contacts.
        :param pulumi.Input[str] data_safe_status: (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Notes**
               * This parameter is only supported for dedicated Exadata infrastructure.
               * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        :param pulumi.Input[int] data_storage_size_in_tbs: (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).
               
               **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        :param pulumi.Input[str] database_edition: (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        :param pulumi.Input[str] database_management_status: Status of Database Management for this Autonomous Database.
        :param pulumi.Input[str] db_name: The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseDbToolsDetailArgs', 'AutonomousDatabaseDbToolsDetailArgsDict']]]] db_tools_details: (Updatable) The list of database tools details.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_version: (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        :param pulumi.Input[str] db_workload: (Updatable) The Autonomous Database workload type. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disaster_recovery_type: Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        :param pulumi.Input[Union['AutonomousDatabaseEncryptionKeyArgs', 'AutonomousDatabaseEncryptionKeyArgsDict']] encryption_key: (Updatable) Details of the Autonomous Database encryption key.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] in_memory_percentage: (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        :param pulumi.Input[bool] is_access_control_enabled: (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.
               
               This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        :param pulumi.Input[bool] is_auto_scaling_for_storage_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        :param pulumi.Input[bool] is_backup_retention_locked: (Updatable) True if the Autonomous Database is backup retention locked.
        :param pulumi.Input[bool] is_data_guard_enabled: (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_dedicated: True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        :param pulumi.Input[bool] is_dev_tier: (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        :param pulumi.Input[bool] is_free_tier: (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        :param pulumi.Input[bool] is_local_data_guard_enabled: (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_mtls_connection_required: (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        :param pulumi.Input[bool] is_preview_version_with_service_terms_accepted: If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        :param pulumi.Input[bool] is_refreshable_clone: (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        :param pulumi.Input[bool] is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        :param pulumi.Input[bool] is_shrink_only: (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] key_version_id: The OCID of the key version that is used in rotate key operations.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        :param pulumi.Input[int] local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]]] long_term_backup_schedules: Details for the long-term backup schedule.
        :param pulumi.Input[int] max_cpu_core_count: (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        :param pulumi.Input[str] ncharacter_set: The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to be made available to the database.
               
               
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
               The following points apply:
               * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
               * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.
               
               For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        :param pulumi.Input[str] open_mode: Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        :param pulumi.Input[str] operations_insights_status: (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        :param pulumi.Input[str] permission_level: The Autonomous Database permission level. Restricted mode allows access only by admin users.
        :param pulumi.Input[str] private_endpoint_ip: The private endpoint Ip address for the resource.
        :param pulumi.Input[str] private_endpoint_label: (Updatable) (Optional) (Updatable) The resource's private endpoint label.
               * Setting the endpoint label to a non-empty string creates a private endpoint database.
               * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
               * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        :param pulumi.Input[str] refreshable_mode: (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[str] remote_disaster_recovery_type: Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] resource_pool_leader_id: (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['AutonomousDatabaseResourcePoolSummaryArgs', 'AutonomousDatabaseResourcePoolSummaryArgsDict']] resource_pool_summary: (Updatable) The configuration details for resource pool
        :param pulumi.Input[bool] rotate_key_trigger: (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseScheduledOperationArgs', 'AutonomousDatabaseScheduledOperationArgsDict']]]] scheduled_operations: (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] secret_id: (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.
               
               This cannot be used in conjunction with adminPassword.
        :param pulumi.Input[int] secret_version_number: (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] source: The source of the database:
               * Use `NONE` for creating a new Autonomous Database.
               * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
               * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
               * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.
               
               For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
               * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
               * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] standby_whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] state: The current state of the Autonomous Database.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
               * For Autonomous Database, setting this will disable public secure access to the database.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[str] switchover_to: It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        :param pulumi.Input[str] switchover_to_remote_peer_id: (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        :param pulumi.Input[str] time_of_auto_refresh_start: The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        :param pulumi.Input[str] timestamp: The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        :param pulumi.Input[bool] use_latest_available_backup_time_stamp: Clone from latest available backup timestamp.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new Autonomous Database.

        This API must be called on the remote region where the peer needs to be created.

        ## Import

        AutonomousDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabase:AutonomousDatabase test_autonomous_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 are_primary_whitelisted_ips_used: Optional[pulumi.Input[bool]] = None,
                 auto_refresh_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 auto_refresh_point_lag_in_seconds: Optional[pulumi.Input[int]] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 autonomous_maintenance_schedule_type: Optional[pulumi.Input[str]] = None,
                 backup_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 byol_compute_count_limit: Optional[pulumi.Input[float]] = None,
                 character_set: Optional[pulumi.Input[str]] = None,
                 clone_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[float]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseCustomerContactArgs', 'AutonomousDatabaseCustomerContactArgsDict']]]]] = None,
                 data_safe_status: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_status: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_tools_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseDbToolsDetailArgs', 'AutonomousDatabaseDbToolsDetailArgsDict']]]]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 db_workload: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Union['AutonomousDatabaseEncryptionKeyArgs', 'AutonomousDatabaseEncryptionKeyArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 in_memory_percentage: Optional[pulumi.Input[int]] = None,
                 is_access_control_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_scaling_for_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_backup_retention_locked: Optional[pulumi.Input[bool]] = None,
                 is_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_dedicated: Optional[pulumi.Input[bool]] = None,
                 is_dev_tier: Optional[pulumi.Input[bool]] = None,
                 is_free_tier: Optional[pulumi.Input[bool]] = None,
                 is_local_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_mtls_connection_required: Optional[pulumi.Input[bool]] = None,
                 is_preview_version_with_service_terms_accepted: Optional[pulumi.Input[bool]] = None,
                 is_refreshable_clone: Optional[pulumi.Input[bool]] = None,
                 is_replicate_automatic_backups: Optional[pulumi.Input[bool]] = None,
                 is_shrink_only: Optional[pulumi.Input[bool]] = None,
                 key_version_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 local_adg_auto_failover_max_data_loss_limit: Optional[pulumi.Input[int]] = None,
                 long_term_backup_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]]]] = None,
                 max_cpu_core_count: Optional[pulumi.Input[int]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 open_mode: Optional[pulumi.Input[str]] = None,
                 operations_insights_status: Optional[pulumi.Input[str]] = None,
                 permission_level: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 private_endpoint_label: Optional[pulumi.Input[str]] = None,
                 refreshable_mode: Optional[pulumi.Input[str]] = None,
                 remote_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
                 resource_pool_leader_id: Optional[pulumi.Input[str]] = None,
                 resource_pool_summary: Optional[pulumi.Input[Union['AutonomousDatabaseResourcePoolSummaryArgs', 'AutonomousDatabaseResourcePoolSummaryArgsDict']]] = None,
                 rotate_key_trigger: Optional[pulumi.Input[bool]] = None,
                 scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseScheduledOperationArgs', 'AutonomousDatabaseScheduledOperationArgsDict']]]]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version_number: Optional[pulumi.Input[int]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 shrink_adb_trigger: Optional[pulumi.Input[int]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 standby_whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 switchover_to: Optional[pulumi.Input[str]] = None,
                 switchover_to_remote_peer_id: Optional[pulumi.Input[str]] = None,
                 time_of_auto_refresh_start: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input[str]] = None,
                 use_latest_available_backup_time_stamp: Optional[pulumi.Input[bool]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseArgs.__new__(AutonomousDatabaseArgs)

            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["are_primary_whitelisted_ips_used"] = are_primary_whitelisted_ips_used
            __props__.__dict__["auto_refresh_frequency_in_seconds"] = auto_refresh_frequency_in_seconds
            __props__.__dict__["auto_refresh_point_lag_in_seconds"] = auto_refresh_point_lag_in_seconds
            __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
            __props__.__dict__["autonomous_database_backup_id"] = autonomous_database_backup_id
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["autonomous_maintenance_schedule_type"] = autonomous_maintenance_schedule_type
            __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
            __props__.__dict__["byol_compute_count_limit"] = byol_compute_count_limit
            __props__.__dict__["character_set"] = character_set
            __props__.__dict__["clone_type"] = clone_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["compute_model"] = compute_model
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["customer_contacts"] = customer_contacts
            __props__.__dict__["data_safe_status"] = data_safe_status
            __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            __props__.__dict__["database_edition"] = database_edition
            __props__.__dict__["database_management_status"] = database_management_status
            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["db_tools_details"] = db_tools_details
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["db_workload"] = db_workload
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["disaster_recovery_type"] = disaster_recovery_type
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["in_memory_percentage"] = in_memory_percentage
            __props__.__dict__["is_access_control_enabled"] = is_access_control_enabled
            __props__.__dict__["is_auto_scaling_enabled"] = is_auto_scaling_enabled
            __props__.__dict__["is_auto_scaling_for_storage_enabled"] = is_auto_scaling_for_storage_enabled
            __props__.__dict__["is_backup_retention_locked"] = is_backup_retention_locked
            __props__.__dict__["is_data_guard_enabled"] = is_data_guard_enabled
            __props__.__dict__["is_dedicated"] = is_dedicated
            __props__.__dict__["is_dev_tier"] = is_dev_tier
            __props__.__dict__["is_free_tier"] = is_free_tier
            __props__.__dict__["is_local_data_guard_enabled"] = is_local_data_guard_enabled
            __props__.__dict__["is_mtls_connection_required"] = is_mtls_connection_required
            __props__.__dict__["is_preview_version_with_service_terms_accepted"] = is_preview_version_with_service_terms_accepted
            __props__.__dict__["is_refreshable_clone"] = is_refreshable_clone
            __props__.__dict__["is_replicate_automatic_backups"] = is_replicate_automatic_backups
            __props__.__dict__["is_shrink_only"] = is_shrink_only
            __props__.__dict__["key_version_id"] = key_version_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["local_adg_auto_failover_max_data_loss_limit"] = local_adg_auto_failover_max_data_loss_limit
            __props__.__dict__["long_term_backup_schedules"] = long_term_backup_schedules
            __props__.__dict__["max_cpu_core_count"] = max_cpu_core_count
            __props__.__dict__["ncharacter_set"] = ncharacter_set
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["ocpu_count"] = ocpu_count
            __props__.__dict__["open_mode"] = open_mode
            __props__.__dict__["operations_insights_status"] = operations_insights_status
            __props__.__dict__["permission_level"] = permission_level
            __props__.__dict__["private_endpoint_ip"] = private_endpoint_ip
            __props__.__dict__["private_endpoint_label"] = private_endpoint_label
            __props__.__dict__["refreshable_mode"] = refreshable_mode
            __props__.__dict__["remote_disaster_recovery_type"] = remote_disaster_recovery_type
            __props__.__dict__["resource_pool_leader_id"] = resource_pool_leader_id
            __props__.__dict__["resource_pool_summary"] = resource_pool_summary
            __props__.__dict__["rotate_key_trigger"] = rotate_key_trigger
            __props__.__dict__["scheduled_operations"] = scheduled_operations
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["secret_version_number"] = secret_version_number
            __props__.__dict__["security_attributes"] = security_attributes
            __props__.__dict__["shrink_adb_trigger"] = shrink_adb_trigger
            __props__.__dict__["source"] = source
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["standby_whitelisted_ips"] = standby_whitelisted_ips
            __props__.__dict__["state"] = state
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["switchover_to"] = switchover_to
            __props__.__dict__["switchover_to_remote_peer_id"] = switchover_to_remote_peer_id
            __props__.__dict__["time_of_auto_refresh_start"] = time_of_auto_refresh_start
            __props__.__dict__["timestamp"] = timestamp
            __props__.__dict__["use_latest_available_backup_time_stamp"] = use_latest_available_backup_time_stamp
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["whitelisted_ips"] = whitelisted_ips
            __props__.__dict__["actual_used_data_storage_size_in_tbs"] = None
            __props__.__dict__["allocated_storage_size_in_tbs"] = None
            __props__.__dict__["apex_details"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["available_upgrade_versions"] = None
            __props__.__dict__["backup_configs"] = None
            __props__.__dict__["cluster_placement_group_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["connection_urls"] = None
            __props__.__dict__["dataguard_region_type"] = None
            __props__.__dict__["disaster_recovery_region_type"] = None
            __props__.__dict__["encryption_key_history_entries"] = None
            __props__.__dict__["failed_data_recovery_in_seconds"] = None
            __props__.__dict__["in_memory_area_in_gbs"] = None
            __props__.__dict__["infrastructure_type"] = None
            __props__.__dict__["is_preview"] = None
            __props__.__dict__["is_reconnect_clone_enabled"] = None
            __props__.__dict__["is_remote_data_guard_enabled"] = None
            __props__.__dict__["key_history_entries"] = None
            __props__.__dict__["key_store_id"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["kms_key_lifecycle_details"] = None
            __props__.__dict__["kms_key_version_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["local_disaster_recovery_type"] = None
            __props__.__dict__["local_standby_dbs"] = None
            __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = None
            __props__.__dict__["net_services_architecture"] = None
            __props__.__dict__["next_long_term_backup_time_stamp"] = None
            __props__.__dict__["peer_db_ids"] = None
            __props__.__dict__["private_endpoint"] = None
            __props__.__dict__["provisionable_cpuses"] = None
            __props__.__dict__["public_connection_urls"] = None
            __props__.__dict__["public_endpoint"] = None
            __props__.__dict__["refreshable_status"] = None
            __props__.__dict__["remote_disaster_recovery_configurations"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["service_console_url"] = None
            __props__.__dict__["standby_dbs"] = None
            __props__.__dict__["supported_regions_to_clone_tos"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_data_guard_role_changed"] = None
            __props__.__dict__["time_deletion_of_free_autonomous_database"] = None
            __props__.__dict__["time_disaster_recovery_role_changed"] = None
            __props__.__dict__["time_local_data_guard_enabled"] = None
            __props__.__dict__["time_maintenance_begin"] = None
            __props__.__dict__["time_maintenance_end"] = None
            __props__.__dict__["time_of_joining_resource_pool"] = None
            __props__.__dict__["time_of_last_failover"] = None
            __props__.__dict__["time_of_last_refresh"] = None
            __props__.__dict__["time_of_last_refresh_point"] = None
            __props__.__dict__["time_of_last_switchover"] = None
            __props__.__dict__["time_of_next_refresh"] = None
            __props__.__dict__["time_reclamation_of_free_autonomous_database"] = None
            __props__.__dict__["time_undeleted"] = None
            __props__.__dict__["time_until_reconnect_clone_enabled"] = None
            __props__.__dict__["total_backup_storage_size_in_gbs"] = None
            __props__.__dict__["used_data_storage_size_in_gbs"] = None
            __props__.__dict__["used_data_storage_size_in_tbs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabase, __self__).__init__(
            'oci:Database/autonomousDatabase:AutonomousDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actual_used_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            admin_password: Optional[pulumi.Input[str]] = None,
            allocated_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            apex_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseApexDetailArgs', 'AutonomousDatabaseApexDetailArgsDict']]]]] = None,
            are_primary_whitelisted_ips_used: Optional[pulumi.Input[bool]] = None,
            auto_refresh_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
            auto_refresh_point_lag_in_seconds: Optional[pulumi.Input[int]] = None,
            autonomous_container_database_id: Optional[pulumi.Input[str]] = None,
            autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
            autonomous_database_id: Optional[pulumi.Input[str]] = None,
            autonomous_maintenance_schedule_type: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            available_upgrade_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseBackupConfigArgs', 'AutonomousDatabaseBackupConfigArgsDict']]]]] = None,
            backup_retention_period_in_days: Optional[pulumi.Input[int]] = None,
            byol_compute_count_limit: Optional[pulumi.Input[float]] = None,
            character_set: Optional[pulumi.Input[str]] = None,
            clone_type: Optional[pulumi.Input[str]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[float]] = None,
            compute_model: Optional[pulumi.Input[str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseConnectionStringArgs', 'AutonomousDatabaseConnectionStringArgsDict']]]]] = None,
            connection_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseConnectionUrlArgs', 'AutonomousDatabaseConnectionUrlArgsDict']]]]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseCustomerContactArgs', 'AutonomousDatabaseCustomerContactArgsDict']]]]] = None,
            data_safe_status: Optional[pulumi.Input[str]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
            database_edition: Optional[pulumi.Input[str]] = None,
            database_management_status: Optional[pulumi.Input[str]] = None,
            dataguard_region_type: Optional[pulumi.Input[str]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            db_tools_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseDbToolsDetailArgs', 'AutonomousDatabaseDbToolsDetailArgsDict']]]]] = None,
            db_version: Optional[pulumi.Input[str]] = None,
            db_workload: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            disaster_recovery_region_type: Optional[pulumi.Input[str]] = None,
            disaster_recovery_type: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[Union['AutonomousDatabaseEncryptionKeyArgs', 'AutonomousDatabaseEncryptionKeyArgsDict']]] = None,
            encryption_key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseEncryptionKeyHistoryEntryArgs', 'AutonomousDatabaseEncryptionKeyHistoryEntryArgsDict']]]]] = None,
            failed_data_recovery_in_seconds: Optional[pulumi.Input[int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            in_memory_area_in_gbs: Optional[pulumi.Input[int]] = None,
            in_memory_percentage: Optional[pulumi.Input[int]] = None,
            infrastructure_type: Optional[pulumi.Input[str]] = None,
            is_access_control_enabled: Optional[pulumi.Input[bool]] = None,
            is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
            is_auto_scaling_for_storage_enabled: Optional[pulumi.Input[bool]] = None,
            is_backup_retention_locked: Optional[pulumi.Input[bool]] = None,
            is_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
            is_dedicated: Optional[pulumi.Input[bool]] = None,
            is_dev_tier: Optional[pulumi.Input[bool]] = None,
            is_free_tier: Optional[pulumi.Input[bool]] = None,
            is_local_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
            is_mtls_connection_required: Optional[pulumi.Input[bool]] = None,
            is_preview: Optional[pulumi.Input[bool]] = None,
            is_preview_version_with_service_terms_accepted: Optional[pulumi.Input[bool]] = None,
            is_reconnect_clone_enabled: Optional[pulumi.Input[bool]] = None,
            is_refreshable_clone: Optional[pulumi.Input[bool]] = None,
            is_remote_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
            is_replicate_automatic_backups: Optional[pulumi.Input[bool]] = None,
            is_shrink_only: Optional[pulumi.Input[bool]] = None,
            key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseKeyHistoryEntryArgs', 'AutonomousDatabaseKeyHistoryEntryArgsDict']]]]] = None,
            key_store_id: Optional[pulumi.Input[str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[str]] = None,
            key_version_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            kms_key_lifecycle_details: Optional[pulumi.Input[str]] = None,
            kms_key_version_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            local_adg_auto_failover_max_data_loss_limit: Optional[pulumi.Input[int]] = None,
            local_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
            local_standby_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLocalStandbyDbArgs', 'AutonomousDatabaseLocalStandbyDbArgsDict']]]]] = None,
            long_term_backup_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]]]] = None,
            max_cpu_core_count: Optional[pulumi.Input[int]] = None,
            memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
            ncharacter_set: Optional[pulumi.Input[str]] = None,
            net_services_architecture: Optional[pulumi.Input[str]] = None,
            next_long_term_backup_time_stamp: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ocpu_count: Optional[pulumi.Input[float]] = None,
            open_mode: Optional[pulumi.Input[str]] = None,
            operations_insights_status: Optional[pulumi.Input[str]] = None,
            peer_db_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            permission_level: Optional[pulumi.Input[str]] = None,
            private_endpoint: Optional[pulumi.Input[str]] = None,
            private_endpoint_ip: Optional[pulumi.Input[str]] = None,
            private_endpoint_label: Optional[pulumi.Input[str]] = None,
            provisionable_cpuses: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
            public_connection_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabasePublicConnectionUrlArgs', 'AutonomousDatabasePublicConnectionUrlArgsDict']]]]] = None,
            public_endpoint: Optional[pulumi.Input[str]] = None,
            refreshable_mode: Optional[pulumi.Input[str]] = None,
            refreshable_status: Optional[pulumi.Input[str]] = None,
            remote_disaster_recovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs', 'AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgsDict']]]]] = None,
            remote_disaster_recovery_type: Optional[pulumi.Input[str]] = None,
            resource_pool_leader_id: Optional[pulumi.Input[str]] = None,
            resource_pool_summary: Optional[pulumi.Input[Union['AutonomousDatabaseResourcePoolSummaryArgs', 'AutonomousDatabaseResourcePoolSummaryArgsDict']]] = None,
            role: Optional[pulumi.Input[str]] = None,
            rotate_key_trigger: Optional[pulumi.Input[bool]] = None,
            scheduled_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseScheduledOperationArgs', 'AutonomousDatabaseScheduledOperationArgsDict']]]]] = None,
            secret_id: Optional[pulumi.Input[str]] = None,
            secret_version_number: Optional[pulumi.Input[int]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            service_console_url: Optional[pulumi.Input[str]] = None,
            shrink_adb_trigger: Optional[pulumi.Input[int]] = None,
            source: Optional[pulumi.Input[str]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            standby_dbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseStandbyDbArgs', 'AutonomousDatabaseStandbyDbArgsDict']]]]] = None,
            standby_whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            subscription_id: Optional[pulumi.Input[str]] = None,
            supported_regions_to_clone_tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            switchover_to: Optional[pulumi.Input[str]] = None,
            switchover_to_remote_peer_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_data_guard_role_changed: Optional[pulumi.Input[str]] = None,
            time_deletion_of_free_autonomous_database: Optional[pulumi.Input[str]] = None,
            time_disaster_recovery_role_changed: Optional[pulumi.Input[str]] = None,
            time_local_data_guard_enabled: Optional[pulumi.Input[str]] = None,
            time_maintenance_begin: Optional[pulumi.Input[str]] = None,
            time_maintenance_end: Optional[pulumi.Input[str]] = None,
            time_of_auto_refresh_start: Optional[pulumi.Input[str]] = None,
            time_of_joining_resource_pool: Optional[pulumi.Input[str]] = None,
            time_of_last_failover: Optional[pulumi.Input[str]] = None,
            time_of_last_refresh: Optional[pulumi.Input[str]] = None,
            time_of_last_refresh_point: Optional[pulumi.Input[str]] = None,
            time_of_last_switchover: Optional[pulumi.Input[str]] = None,
            time_of_next_refresh: Optional[pulumi.Input[str]] = None,
            time_reclamation_of_free_autonomous_database: Optional[pulumi.Input[str]] = None,
            time_undeleted: Optional[pulumi.Input[str]] = None,
            time_until_reconnect_clone_enabled: Optional[pulumi.Input[str]] = None,
            timestamp: Optional[pulumi.Input[str]] = None,
            total_backup_storage_size_in_gbs: Optional[pulumi.Input[float]] = None,
            use_latest_available_backup_time_stamp: Optional[pulumi.Input[bool]] = None,
            used_data_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            used_data_storage_size_in_tbs: Optional[pulumi.Input[int]] = None,
            vault_id: Optional[pulumi.Input[str]] = None,
            whitelisted_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AutonomousDatabase':
        """
        Get an existing AutonomousDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and system data, in terabytes (TB).
        :param pulumi.Input[str] admin_password: (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        :param pulumi.Input[float] allocated_storage_size_in_tbs: The amount of storage currently allocated for the database tables and billed for, rounded up. When auto-scaling is not enabled, this value is equal to the `dataStorageSizeInTBs` value. You can compare this value to the `actualUsedDataStorageSizeInTBs` value to determine if a manual shrink operation is appropriate for your allocated storage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseApexDetailArgs', 'AutonomousDatabaseApexDetailArgsDict']]]] apex_details: Information about Oracle APEX Application Development.
        :param pulumi.Input[bool] are_primary_whitelisted_ips_used: (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        :param pulumi.Input[int] auto_refresh_frequency_in_seconds: (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        :param pulumi.Input[int] auto_refresh_point_lag_in_seconds: (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        :param pulumi.Input[str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        :param pulumi.Input[str] autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        :param pulumi.Input[str] availability_domain: The availability domain of a local Autonomous Data Guard standby database of an Autonomous Database Serverless instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_upgrade_versions: List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseBackupConfigArgs', 'AutonomousDatabaseBackupConfigArgsDict']]]] backup_configs: Autonomous Database configuration details for storing [manual backups](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/backup-restore.html#GUID-9035DFB8-4702-4CEB-8281-C2A303820809) in the [Object Storage](https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm) service.
        :param pulumi.Input[int] backup_retention_period_in_days: (Updatable) Retention period, in days, for backups.
        :param pulumi.Input[str] character_set: The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)
               
               For an Autonomous Database on dedicated infrastructure, the allowed values are:
               
               AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        :param pulumi.Input[str] clone_type: The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
               * `FULL` - This option creates a new database that includes all source database data.
               * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Autonomous Serverless Database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        :param pulumi.Input[float] compute_count: (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        :param pulumi.Input[str] compute_model: (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseConnectionStringArgs', 'AutonomousDatabaseConnectionStringArgsDict']]]] connection_strings: The connection string used to connect to the Autonomous Database. The username for the Service Console is ADMIN. Use the password you entered when creating the Autonomous Database for the password value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseConnectionUrlArgs', 'AutonomousDatabaseConnectionUrlArgsDict']]]] connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. Note that these URLs are provided by the console only for databases on [dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).  Example: `{"sqlDevWebUrl": "https://<hostname>/ords...", "apexUrl", "https://<hostname>/ords..."}`
        :param pulumi.Input[int] cpu_core_count: (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
               * The data type must be an *integer*.
               * The minimum number of cores for all types of autonomous database is *1*
               * The maximum number of cores is as follows:
               * Autonomous Database Serverless instances: The maximum number of cores is *128*.
               * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseCustomerContactArgs', 'AutonomousDatabaseCustomerContactArgsDict']]]] customer_contacts: (Updatable) Customer Contacts.
        :param pulumi.Input[str] data_safe_status: (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Notes**
               * This parameter is only supported for dedicated Exadata infrastructure.
               * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        :param pulumi.Input[int] data_storage_size_in_tbs: (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).
               
               **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        :param pulumi.Input[str] database_edition: (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        :param pulumi.Input[str] database_management_status: Status of Database Management for this Autonomous Database.
        :param pulumi.Input[str] dataguard_region_type: **Deprecated** (Optional) The Autonomous Data Guard region type of the Autonomous Database. For Autonomous Database Serverless instances, Data Guard associations have designated primary (`PRIMARY_DG_REGION`) and standby (`REMOTE_STANDBY_DG_REGION`) regions, and these region types do not change when the database changes roles. The standby regions in Data Guard associations can be the same region designated as the primary region, or they can be remote regions. Certain database administrative operations may be available only in the primary region of the Data Guard association, and cannot be performed when the database using the "primary" role is operating in a remote Data Guard standby region.
        :param pulumi.Input[str] db_name: The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseDbToolsDetailArgs', 'AutonomousDatabaseDbToolsDetailArgsDict']]]] db_tools_details: (Updatable) The list of database tools details.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_version: (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        :param pulumi.Input[str] db_workload: (Updatable) The Autonomous Database workload type. The following values are valid:
               * OLTP - indicates an Autonomous Transaction Processing database
               * DW - indicates an Autonomous Data Warehouse database
               * AJD - indicates an Autonomous JSON Database
               * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disaster_recovery_region_type: **Deprecated** The disaster recovery (DR) region type of the Autonomous Database. For Serverless Autonomous Databases, DR associations have designated primary (`PRIMARY`) and standby (`REMOTE`) regions. These region types do not change when the database changes roles. The standby region in DR associations can be the same region as the primary region, or they can be in a remote regions. Some database administration operations may be available only in the primary region of the DR association, and cannot be performed when the database using the primary role is operating in a remote region.
        :param pulumi.Input[str] disaster_recovery_type: Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        :param pulumi.Input[Union['AutonomousDatabaseEncryptionKeyArgs', 'AutonomousDatabaseEncryptionKeyArgsDict']] encryption_key: (Updatable) Details of the Autonomous Database encryption key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseEncryptionKeyHistoryEntryArgs', 'AutonomousDatabaseEncryptionKeyHistoryEntryArgsDict']]]] encryption_key_history_entries: Key History Entry.
        :param pulumi.Input[int] failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data Guard failover.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
        :param pulumi.Input[int] in_memory_percentage: (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        :param pulumi.Input[str] infrastructure_type: The infrastructure type this resource belongs to.
        :param pulumi.Input[bool] is_access_control_enabled: (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.
               
               This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        :param pulumi.Input[bool] is_auto_scaling_for_storage_enabled: (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        :param pulumi.Input[bool] is_backup_retention_locked: (Updatable) True if the Autonomous Database is backup retention locked.
        :param pulumi.Input[bool] is_data_guard_enabled: (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_dedicated: True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        :param pulumi.Input[bool] is_dev_tier: (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        :param pulumi.Input[bool] is_free_tier: (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        :param pulumi.Input[bool] is_local_data_guard_enabled: (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_mtls_connection_required: (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        :param pulumi.Input[bool] is_preview: Indicates if the Autonomous Database version is a preview version.
        :param pulumi.Input[bool] is_preview_version_with_service_terms_accepted: If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        :param pulumi.Input[bool] is_reconnect_clone_enabled: Indicates if the refreshable clone can be reconnected to its source database.
        :param pulumi.Input[bool] is_refreshable_clone: (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        :param pulumi.Input[bool] is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region Data Guard enabled. It takes boolean values. Not applicable to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[bool] is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        :param pulumi.Input[bool] is_shrink_only: (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseKeyHistoryEntryArgs', 'AutonomousDatabaseKeyHistoryEntryArgsDict']]]] key_history_entries: Key History Entry.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault. This is used in Autonomous Databases on Serverless instances and dedicated Exadata infrastructure.
        :param pulumi.Input[str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[str] key_version_id: The OCID of the key version that is used in rotate key operations.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] kms_key_lifecycle_details: KMS key lifecycle details.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        :param pulumi.Input[str] local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the Serverless Autonomous Database. Autonomous Data Guard (`ADG`) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based (`BACKUP_BASED`) DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLocalStandbyDbArgs', 'AutonomousDatabaseLocalStandbyDbArgsDict']]]] local_standby_dbs: Autonomous Data Guard local (same region) standby database details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseLongTermBackupScheduleArgs', 'AutonomousDatabaseLongTermBackupScheduleArgsDict']]]] long_term_backup_schedules: Details for the long-term backup schedule.
        :param pulumi.Input[int] max_cpu_core_count: (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per OCPU or ECPU. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details. This parameter is not used for Autonomous database Serverless.
        :param pulumi.Input[str] ncharacter_set: The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        :param pulumi.Input[str] net_services_architecture: Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        :param pulumi.Input[str] next_long_term_backup_time_stamp: The date and time when the next long-term backup would be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: (Updatable) The number of OCPU cores to be made available to the database.
               
               
               * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
               The following points apply:
               * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
               * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.
               
               For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
               
               **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        :param pulumi.Input[str] open_mode: Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        :param pulumi.Input[str] operations_insights_status: (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] peer_db_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs.
        :param pulumi.Input[str] permission_level: The Autonomous Database permission level. Restricted mode allows access only by admin users.
        :param pulumi.Input[str] private_endpoint: The private endpoint for the resource. This parameter is not used in Autonomous Databases using Serverless infrastructure and Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[str] private_endpoint_ip: The private endpoint Ip address for the resource.
        :param pulumi.Input[str] private_endpoint_label: (Updatable) (Optional) (Updatable) The resource's private endpoint label.
               * Setting the endpoint label to a non-empty string creates a private endpoint database.
               * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
               * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] provisionable_cpuses: An array of CPU values that an Autonomous Database can be scaled to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabasePublicConnectionUrlArgs', 'AutonomousDatabasePublicConnectionUrlArgsDict']]]] public_connection_urls: The Public URLs of Private Endpoint database for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN.
        :param pulumi.Input[str] public_endpoint: The public endpoint for the private endpoint enabled resource.
        :param pulumi.Input[str] refreshable_mode: (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[str] refreshable_status: The refresh status of the clone. REFRESHING indicates that the clone is currently being refreshed with data from the source Autonomous Database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgs', 'AutonomousDatabaseRemoteDisasterRecoveryConfigurationArgsDict']]]] remote_disaster_recovery_configurations: Configurations of a Disaster Recovery.
        :param pulumi.Input[str] remote_disaster_recovery_type: Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        :param pulumi.Input[str] resource_pool_leader_id: (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['AutonomousDatabaseResourcePoolSummaryArgs', 'AutonomousDatabaseResourcePoolSummaryArgsDict']] resource_pool_summary: (Updatable) The configuration details for resource pool
        :param pulumi.Input[str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[bool] rotate_key_trigger: (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseScheduledOperationArgs', 'AutonomousDatabaseScheduledOperationArgsDict']]]] scheduled_operations: (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] secret_id: (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.
               
               This cannot be used in conjunction with adminPassword.
        :param pulumi.Input[int] secret_version_number: (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] security_attributes: (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        :param pulumi.Input[str] service_console_url: The URL of the Service Console for the Autonomous Database.
        :param pulumi.Input[str] source: The source of the database:
               * Use `NONE` for creating a new Autonomous Database.
               * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
               * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
               * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.
               
               For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
               * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
               * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        :param pulumi.Input[str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousDatabaseStandbyDbArgs', 'AutonomousDatabaseStandbyDbArgsDict']]]] standby_dbs: **Deprecated** Autonomous Data Guard standby database details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] standby_whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] state: The current state of the Autonomous Database.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.
               
               **Subnet Restrictions:**
               * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
               * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
               * For Autonomous Database, setting this will disable public secure access to the database.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_regions_to_clone_tos: The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database.
        :param pulumi.Input[str] switchover_to: It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        :param pulumi.Input[str] switchover_to_remote_peer_id: (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] time_created: The date and time the Autonomous Database was created.
        :param pulumi.Input[str] time_data_guard_role_changed: The date and time the Autonomous Data Guard role was switched for the Autonomous Database. For databases that have standbys in both the primary Data Guard region and a remote Data Guard standby region, this is the latest timestamp of either the database using the "primary" role in the primary Data Guard region, or database located in the remote Data Guard standby region.
        :param pulumi.Input[str] time_deletion_of_free_autonomous_database: The date and time the Always Free database will be automatically deleted because of inactivity. If the database is in the STOPPED state and without activity until this time, it will be deleted.
        :param pulumi.Input[str] time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was switched for the standby Autonomous Database.
        :param pulumi.Input[str] time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database.
        :param pulumi.Input[str] time_maintenance_begin: The date and time when maintenance will begin.
        :param pulumi.Input[str] time_maintenance_end: The date and time when maintenance will end.
        :param pulumi.Input[str] time_of_auto_refresh_start: The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        :param pulumi.Input[str] time_of_last_failover: The timestamp of the last failover operation.
        :param pulumi.Input[str] time_of_last_refresh: The date and time when last refresh happened.
        :param pulumi.Input[str] time_of_last_refresh_point: The refresh point timestamp (UTC). The refresh point is the time to which the database was most recently refreshed. Data created after the refresh point is not included in the refresh.
        :param pulumi.Input[str] time_of_last_switchover: The timestamp of the last switchover operation for the Autonomous Database.
        :param pulumi.Input[str] time_of_next_refresh: The date and time of next refresh.
        :param pulumi.Input[str] time_reclamation_of_free_autonomous_database: The date and time the Always Free database will be stopped because of inactivity. If this time is reached without any database activity, the database will automatically be put into the STOPPED state.
        :param pulumi.Input[str] time_until_reconnect_clone_enabled: The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to its source database.
        :param pulumi.Input[str] timestamp: The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        :param pulumi.Input[float] total_backup_storage_size_in_gbs: The backup storage to the database.
        :param pulumi.Input[bool] use_latest_available_backup_time_stamp: Clone from latest available backup timestamp.
        :param pulumi.Input[int] used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
        :param pulumi.Input[int] used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_ips: (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.
               
               For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`
               
               For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseState.__new__(_AutonomousDatabaseState)

        __props__.__dict__["actual_used_data_storage_size_in_tbs"] = actual_used_data_storage_size_in_tbs
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["allocated_storage_size_in_tbs"] = allocated_storage_size_in_tbs
        __props__.__dict__["apex_details"] = apex_details
        __props__.__dict__["are_primary_whitelisted_ips_used"] = are_primary_whitelisted_ips_used
        __props__.__dict__["auto_refresh_frequency_in_seconds"] = auto_refresh_frequency_in_seconds
        __props__.__dict__["auto_refresh_point_lag_in_seconds"] = auto_refresh_point_lag_in_seconds
        __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
        __props__.__dict__["autonomous_database_backup_id"] = autonomous_database_backup_id
        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["autonomous_maintenance_schedule_type"] = autonomous_maintenance_schedule_type
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["available_upgrade_versions"] = available_upgrade_versions
        __props__.__dict__["backup_configs"] = backup_configs
        __props__.__dict__["backup_retention_period_in_days"] = backup_retention_period_in_days
        __props__.__dict__["byol_compute_count_limit"] = byol_compute_count_limit
        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["clone_type"] = clone_type
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["connection_urls"] = connection_urls
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["customer_contacts"] = customer_contacts
        __props__.__dict__["data_safe_status"] = data_safe_status
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["database_management_status"] = database_management_status
        __props__.__dict__["dataguard_region_type"] = dataguard_region_type
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_tools_details"] = db_tools_details
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["db_workload"] = db_workload
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disaster_recovery_region_type"] = disaster_recovery_region_type
        __props__.__dict__["disaster_recovery_type"] = disaster_recovery_type
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["encryption_key_history_entries"] = encryption_key_history_entries
        __props__.__dict__["failed_data_recovery_in_seconds"] = failed_data_recovery_in_seconds
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["in_memory_area_in_gbs"] = in_memory_area_in_gbs
        __props__.__dict__["in_memory_percentage"] = in_memory_percentage
        __props__.__dict__["infrastructure_type"] = infrastructure_type
        __props__.__dict__["is_access_control_enabled"] = is_access_control_enabled
        __props__.__dict__["is_auto_scaling_enabled"] = is_auto_scaling_enabled
        __props__.__dict__["is_auto_scaling_for_storage_enabled"] = is_auto_scaling_for_storage_enabled
        __props__.__dict__["is_backup_retention_locked"] = is_backup_retention_locked
        __props__.__dict__["is_data_guard_enabled"] = is_data_guard_enabled
        __props__.__dict__["is_dedicated"] = is_dedicated
        __props__.__dict__["is_dev_tier"] = is_dev_tier
        __props__.__dict__["is_free_tier"] = is_free_tier
        __props__.__dict__["is_local_data_guard_enabled"] = is_local_data_guard_enabled
        __props__.__dict__["is_mtls_connection_required"] = is_mtls_connection_required
        __props__.__dict__["is_preview"] = is_preview
        __props__.__dict__["is_preview_version_with_service_terms_accepted"] = is_preview_version_with_service_terms_accepted
        __props__.__dict__["is_reconnect_clone_enabled"] = is_reconnect_clone_enabled
        __props__.__dict__["is_refreshable_clone"] = is_refreshable_clone
        __props__.__dict__["is_remote_data_guard_enabled"] = is_remote_data_guard_enabled
        __props__.__dict__["is_replicate_automatic_backups"] = is_replicate_automatic_backups
        __props__.__dict__["is_shrink_only"] = is_shrink_only
        __props__.__dict__["key_history_entries"] = key_history_entries
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["key_version_id"] = key_version_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_lifecycle_details"] = kms_key_lifecycle_details
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["local_adg_auto_failover_max_data_loss_limit"] = local_adg_auto_failover_max_data_loss_limit
        __props__.__dict__["local_disaster_recovery_type"] = local_disaster_recovery_type
        __props__.__dict__["local_standby_dbs"] = local_standby_dbs
        __props__.__dict__["long_term_backup_schedules"] = long_term_backup_schedules
        __props__.__dict__["max_cpu_core_count"] = max_cpu_core_count
        __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["net_services_architecture"] = net_services_architecture
        __props__.__dict__["next_long_term_backup_time_stamp"] = next_long_term_backup_time_stamp
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["ocpu_count"] = ocpu_count
        __props__.__dict__["open_mode"] = open_mode
        __props__.__dict__["operations_insights_status"] = operations_insights_status
        __props__.__dict__["peer_db_ids"] = peer_db_ids
        __props__.__dict__["permission_level"] = permission_level
        __props__.__dict__["private_endpoint"] = private_endpoint
        __props__.__dict__["private_endpoint_ip"] = private_endpoint_ip
        __props__.__dict__["private_endpoint_label"] = private_endpoint_label
        __props__.__dict__["provisionable_cpuses"] = provisionable_cpuses
        __props__.__dict__["public_connection_urls"] = public_connection_urls
        __props__.__dict__["public_endpoint"] = public_endpoint
        __props__.__dict__["refreshable_mode"] = refreshable_mode
        __props__.__dict__["refreshable_status"] = refreshable_status
        __props__.__dict__["remote_disaster_recovery_configurations"] = remote_disaster_recovery_configurations
        __props__.__dict__["remote_disaster_recovery_type"] = remote_disaster_recovery_type
        __props__.__dict__["resource_pool_leader_id"] = resource_pool_leader_id
        __props__.__dict__["resource_pool_summary"] = resource_pool_summary
        __props__.__dict__["role"] = role
        __props__.__dict__["rotate_key_trigger"] = rotate_key_trigger
        __props__.__dict__["scheduled_operations"] = scheduled_operations
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["secret_version_number"] = secret_version_number
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["service_console_url"] = service_console_url
        __props__.__dict__["shrink_adb_trigger"] = shrink_adb_trigger
        __props__.__dict__["source"] = source
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["standby_dbs"] = standby_dbs
        __props__.__dict__["standby_whitelisted_ips"] = standby_whitelisted_ips
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["supported_regions_to_clone_tos"] = supported_regions_to_clone_tos
        __props__.__dict__["switchover_to"] = switchover_to
        __props__.__dict__["switchover_to_remote_peer_id"] = switchover_to_remote_peer_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_data_guard_role_changed"] = time_data_guard_role_changed
        __props__.__dict__["time_deletion_of_free_autonomous_database"] = time_deletion_of_free_autonomous_database
        __props__.__dict__["time_disaster_recovery_role_changed"] = time_disaster_recovery_role_changed
        __props__.__dict__["time_local_data_guard_enabled"] = time_local_data_guard_enabled
        __props__.__dict__["time_maintenance_begin"] = time_maintenance_begin
        __props__.__dict__["time_maintenance_end"] = time_maintenance_end
        __props__.__dict__["time_of_auto_refresh_start"] = time_of_auto_refresh_start
        __props__.__dict__["time_of_joining_resource_pool"] = time_of_joining_resource_pool
        __props__.__dict__["time_of_last_failover"] = time_of_last_failover
        __props__.__dict__["time_of_last_refresh"] = time_of_last_refresh
        __props__.__dict__["time_of_last_refresh_point"] = time_of_last_refresh_point
        __props__.__dict__["time_of_last_switchover"] = time_of_last_switchover
        __props__.__dict__["time_of_next_refresh"] = time_of_next_refresh
        __props__.__dict__["time_reclamation_of_free_autonomous_database"] = time_reclamation_of_free_autonomous_database
        __props__.__dict__["time_undeleted"] = time_undeleted
        __props__.__dict__["time_until_reconnect_clone_enabled"] = time_until_reconnect_clone_enabled
        __props__.__dict__["timestamp"] = timestamp
        __props__.__dict__["total_backup_storage_size_in_gbs"] = total_backup_storage_size_in_gbs
        __props__.__dict__["use_latest_available_backup_time_stamp"] = use_latest_available_backup_time_stamp
        __props__.__dict__["used_data_storage_size_in_gbs"] = used_data_storage_size_in_gbs
        __props__.__dict__["used_data_storage_size_in_tbs"] = used_data_storage_size_in_tbs
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["whitelisted_ips"] = whitelisted_ips
        return AutonomousDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actualUsedDataStorageSizeInTbs")
    def actual_used_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The current amount of storage in use for user and system data, in terabytes (TB).
        """
        return pulumi.get(self, "actual_used_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[str]:
        """
        (Updatable) The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (") or the username "admin", regardless of casing. The password is mandatory if source value is "BACKUP_FROM_ID", "BACKUP_FROM_TIMESTAMP", "DATABASE" or "NONE".
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="allocatedStorageSizeInTbs")
    def allocated_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The amount of storage currently allocated for the database tables and billed for, rounded up. When auto-scaling is not enabled, this value is equal to the `dataStorageSizeInTBs` value. You can compare this value to the `actualUsedDataStorageSizeInTBs` value to determine if a manual shrink operation is appropriate for your allocated storage.
        """
        return pulumi.get(self, "allocated_storage_size_in_tbs")

    @property
    @pulumi.getter(name="apexDetails")
    def apex_details(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseApexDetail']]:
        """
        Information about Oracle APEX Application Development.
        """
        return pulumi.get(self, "apex_details")

    @property
    @pulumi.getter(name="arePrimaryWhitelistedIpsUsed")
    def are_primary_whitelisted_ips_used(self) -> pulumi.Output[bool]:
        """
        (Updatable) This field will be null if the Autonomous Database is not Data Guard enabled or Access Control is disabled. It's value would be `TRUE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses primary IP access control list (ACL) for standby. It's value would be `FALSE` if Autonomous Database is Data Guard enabled and Access Control is enabled and if the Autonomous Database uses different IP access control list (ACL) for standby compared to primary.
        """
        return pulumi.get(self, "are_primary_whitelisted_ips_used")

    @property
    @pulumi.getter(name="autoRefreshFrequencyInSeconds")
    def auto_refresh_frequency_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.
        """
        return pulumi.get(self, "auto_refresh_frequency_in_seconds")

    @property
    @pulumi.getter(name="autoRefreshPointLagInSeconds")
    def auto_refresh_point_lag_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.
        """
        return pulumi.get(self, "auto_refresh_point_lag_in_seconds")

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> pulumi.Output[str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @property
    @pulumi.getter(name="autonomousDatabaseBackupId")
    def autonomous_database_backup_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database Backup that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_backup_id")

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that you will clone to create a new Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="autonomousMaintenanceScheduleType")
    def autonomous_maintenance_schedule_type(self) -> pulumi.Output[str]:
        """
        The maintenance schedule type of the Autonomous Database Serverless instances. The EARLY maintenance schedule of this Autonomous Database follows a schedule that applies patches prior to the REGULAR schedule.The REGULAR maintenance schedule of this Autonomous Database follows the normal cycle.
        """
        return pulumi.get(self, "autonomous_maintenance_schedule_type")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain of a local Autonomous Data Guard standby database of an Autonomous Database Serverless instance.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableUpgradeVersions")
    def available_upgrade_versions(self) -> pulumi.Output[Sequence[str]]:
        """
        List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty.
        """
        return pulumi.get(self, "available_upgrade_versions")

    @property
    @pulumi.getter(name="backupConfigs")
    def backup_configs(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseBackupConfig']]:
        """
        Autonomous Database configuration details for storing [manual backups](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/backup-restore.html#GUID-9035DFB8-4702-4CEB-8281-C2A303820809) in the [Object Storage](https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm) service.
        """
        return pulumi.get(self, "backup_configs")

    @property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> pulumi.Output[int]:
        """
        (Updatable) Retention period, in days, for backups.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @property
    @pulumi.getter(name="byolComputeCountLimit")
    def byol_compute_count_limit(self) -> pulumi.Output[float]:
        return pulumi.get(self, "byol_compute_count_limit")

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[str]:
        """
        The character set for the autonomous database.  The default is AL32UTF8. Allowed values for an Autonomous Database on Serverless infrastructure as returned by [List Autonomous Database Character Sets](https://www.terraform.io/autonomousDatabaseCharacterSets)

        For an Autonomous Database on dedicated infrastructure, the allowed values are:

        AL32UTF8, AR8ADOS710, AR8ADOS720, AR8APTEC715, AR8ARABICMACS, AR8ASMO8X, AR8ISO8859P6, AR8MSWIN1256, AR8MUSSAD768, AR8NAFITHA711, AR8NAFITHA721, AR8SAKHR706, AR8SAKHR707, AZ8ISO8859P9E, BG8MSWIN, BG8PC437S, BLT8CP921, BLT8ISO8859P13, BLT8MSWIN1257, BLT8PC775, BN8BSCII, CDN8PC863, CEL8ISO8859P14, CL8ISO8859P5, CL8ISOIR111, CL8KOI8R, CL8KOI8U, CL8MACCYRILLICS, CL8MSWIN1251, EE8ISO8859P2, EE8MACCES, EE8MACCROATIANS, EE8MSWIN1250, EE8PC852, EL8DEC, EL8ISO8859P7, EL8MACGREEKS, EL8MSWIN1253, EL8PC437S, EL8PC851, EL8PC869, ET8MSWIN923, HU8ABMOD, HU8CWI2, IN8ISCII, IS8PC861, IW8ISO8859P8, IW8MACHEBREWS, IW8MSWIN1255, IW8PC1507, JA16EUC, JA16EUCTILDE, JA16SJIS, JA16SJISTILDE, JA16VMS, KO16KSC5601, KO16KSCCS, KO16MSWIN949, LA8ISO6937, LA8PASSPORT, LT8MSWIN921, LT8PC772, LT8PC774, LV8PC1117, LV8PC8LR, LV8RST104090, N8PC865, NE8ISO8859P10, NEE8ISO8859P4, RU8BESTA, RU8PC855, RU8PC866, SE8ISO8859P3, TH8MACTHAIS, TH8TISASCII, TR8DEC, TR8MACTURKISHS, TR8MSWIN1254, TR8PC857, US7ASCII, US8PC437, UTF8, VN8MSWIN1258, VN8VN3, WE8DEC, WE8DG, WE8ISO8859P1, WE8ISO8859P15, WE8ISO8859P9, WE8MACROMAN8S, WE8MSWIN1252, WE8NCR4970, WE8NEXTSTEP, WE8PC850, WE8PC858, WE8PC860, WE8ROMAN8, ZHS16CGB231280, ZHS16GBK, ZHT16BIG5, ZHT16CCDC, ZHT16DBT, ZHT16HKSCS, ZHT16MSWIN950, ZHT32EUC, ZHT32SOPS, ZHT32TRIS
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> pulumi.Output[str]:
        """
        The Autonomous Database clone type. This parameter is not used to create a refreshable clone type, and for refreshable clones one must use the (source=CLONE_TO_REFRESHABLE) parameter.
        * `FULL` - This option creates a new database that includes all source database data.
        * `METADATA` - This option creates a new database that includes the source database schema and select metadata, but not the source database data.
        """
        return pulumi.get(self, "clone_type")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Autonomous Serverless Database.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the Autonomous Database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[float]:
        """
        (Updatable) The compute amount available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous Database Serverless instance or an Autonomous Database on Dedicated Exadata Infrastructure. For an Autonomous Database Serverless instance, the 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseConnectionString']]:
        """
        The connection string used to connect to the Autonomous Database. The username for the Service Console is ADMIN. Use the password you entered when creating the Autonomous Database for the password value.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="connectionUrls")
    def connection_urls(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseConnectionUrl']]:
        """
        The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. Note that these URLs are provided by the console only for databases on [dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).  Example: `{"sqlDevWebUrl": "https://<hostname>/ords...", "apexUrl", "https://<hostname>/ords..."}`
        """
        return pulumi.get(self, "connection_urls")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of CPU cores to be made available to the database. For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        **Note:** This parameter cannot be used with the `ocpuCount` parameter. This input is ignored for Always Free resources.
        * The data type must be an *integer*.
        * The minimum number of cores for all types of autonomous database is *1*
        * The maximum number of cores is as follows:
        * Autonomous Database Serverless instances: The maximum number of cores is *128*.
        * Autonomous Databases on dedicated Exadata infrastructure: The maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.
        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseCustomerContact']]:
        """
        (Updatable) Customer Contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @property
    @pulumi.getter(name="dataSafeStatus")
    def data_safe_status(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of the Data Safe registration for this Autonomous Database. Could be REGISTERED or NOT_REGISTERED.
        """
        return pulumi.get(self, "data_safe_status")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) The size, in gigabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. The maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Notes**
        * This parameter is only supported for dedicated Exadata infrastructure.
        * This parameter cannot be used with the `dataStorageSizeInTBs` parameter.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[int]:
        """
        (Updatable) The size, in terabytes, of the data volume that will be created and attached to the database. This storage can later be scaled up if needed. For Autonomous Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.  A full Exadata service is allocated when the Autonomous Database size is set to the upper limit (384 TB).

        **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter. This input is ignored for Always Free resources.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle Database Edition that applies to the Autonomous databases. It can be set to `ENTERPRISE_EDITION` or `STANDARD_EDITION`.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseManagementStatus")
    def database_management_status(self) -> pulumi.Output[str]:
        """
        Status of Database Management for this Autonomous Database.
        """
        return pulumi.get(self, "database_management_status")

    @property
    @pulumi.getter(name="dataguardRegionType")
    def dataguard_region_type(self) -> pulumi.Output[str]:
        """
        **Deprecated** (Optional) The Autonomous Data Guard region type of the Autonomous Database. For Autonomous Database Serverless instances, Data Guard associations have designated primary (`PRIMARY_DG_REGION`) and standby (`REMOTE_STANDBY_DG_REGION`) regions, and these region types do not change when the database changes roles. The standby regions in Data Guard associations can be the same region designated as the primary region, or they can be remote regions. Certain database administrative operations may be available only in the primary region of the Data Guard association, and cannot be performed when the database using the "primary" role is operating in a remote Data Guard standby region.
        """
        return pulumi.get(self, "dataguard_region_type")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The database name. The name must begin with an alphabetic character and can contain a maximum of 14 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy. It is required in all cases except when creating a cross-region Autonomous Data Guard standby instance or a cross-region disaster recovery standby instance.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbToolsDetails")
    def db_tools_details(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseDbToolsDetail']]:
        """
        (Updatable) The list of database tools details.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_tools_details")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[str]:
        """
        (Updatable) A valid Oracle Database version for Autonomous Database.`db_workload` AJD and APEX are only supported for `db_version` `19c` and above.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Output[str]:
        """
        (Updatable) The Autonomous Database workload type. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. *Note: `db_workload` can only be updated from AJD to OLTP or from a free OLTP to AJD.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disasterRecoveryRegionType")
    def disaster_recovery_region_type(self) -> pulumi.Output[str]:
        """
        **Deprecated** The disaster recovery (DR) region type of the Autonomous Database. For Serverless Autonomous Databases, DR associations have designated primary (`PRIMARY`) and standby (`REMOTE`) regions. These region types do not change when the database changes roles. The standby region in DR associations can be the same region as the primary region, or they can be in a remote regions. Some database administration operations may be available only in the primary region of the DR association, and cannot be performed when the database using the primary role is operating in a remote region.
        """
        return pulumi.get(self, "disaster_recovery_region_type")

    @property
    @pulumi.getter(name="disasterRecoveryType")
    def disaster_recovery_type(self) -> pulumi.Output[str]:
        """
        Indicates the disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "disaster_recovery_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the Autonomous Database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output['outputs.AutonomousDatabaseEncryptionKey']:
        """
        (Updatable) Details of the Autonomous Database encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="encryptionKeyHistoryEntries")
    def encryption_key_history_entries(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseEncryptionKeyHistoryEntry']]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "encryption_key_history_entries")

    @property
    @pulumi.getter(name="failedDataRecoveryInSeconds")
    def failed_data_recovery_in_seconds(self) -> pulumi.Output[int]:
        """
        Indicates the number of seconds of data loss for a Data Guard failover.
        """
        return pulumi.get(self, "failed_data_recovery_in_seconds")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="inMemoryAreaInGbs")
    def in_memory_area_in_gbs(self) -> pulumi.Output[int]:
        """
        The area assigned to In-Memory tables in Autonomous Database.
        """
        return pulumi.get(self, "in_memory_area_in_gbs")

    @property
    @pulumi.getter(name="inMemoryPercentage")
    def in_memory_percentage(self) -> pulumi.Output[int]:
        """
        (Updatable) The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous Database. This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform.
        """
        return pulumi.get(self, "in_memory_percentage")

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> pulumi.Output[str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @property
    @pulumi.getter(name="isAccessControlEnabled")
    def is_access_control_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if the database-level access control is enabled. If disabled, database access is defined by the network security rules. If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional, if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console. When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.

        This property is applicable only to Autonomous Databases on the Exadata Cloud@Customer platform. For Autonomous Database Serverless instances, `whitelistedIps` is used.
        """
        return pulumi.get(self, "is_access_control_enabled")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database CPU core count. The default value is `TRUE`.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="isAutoScalingForStorageEnabled")
    def is_auto_scaling_for_storage_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Autonomous Database storage. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_auto_scaling_for_storage_enabled")

    @property
    @pulumi.getter(name="isBackupRetentionLocked")
    def is_backup_retention_locked(self) -> pulumi.Output[bool]:
        """
        (Updatable) True if the Autonomous Database is backup retention locked.
        """
        return pulumi.get(self, "is_backup_retention_locked")

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @property
    @pulumi.getter(name="isDedicated")
    def is_dedicated(self) -> pulumi.Output[bool]:
        """
        True if the database is on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm).
        """
        return pulumi.get(self, "is_dedicated")

    @property
    @pulumi.getter(name="isDevTier")
    def is_dev_tier(self) -> pulumi.Output[bool]:
        """
        (Updatable) Autonomous Database for Developers are free Autonomous Databases that developers can use to build and test new applications.With Autonomous these database instancess instances, you can try new Autonomous Database features for free and apply them to ongoing or new development projects. Developer database comes with limited resources and is, therefore, not suitable for large-scale testing and production deployments. When you need more compute or storage resources, you can transition to a paid database licensing by cloning your developer database into a regular Autonomous Database. See [Autonomous Database documentation](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/eddjo/index.html) for more details.
        """
        return pulumi.get(self, "is_dev_tier")

    @property
    @pulumi.getter(name="isFreeTier")
    def is_free_tier(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled. When `db_workload` is `AJD` or `APEX` it cannot be `true`.
        """
        return pulumi.get(self, "is_free_tier")

    @property
    @pulumi.getter(name="isLocalDataGuardEnabled")
    def is_local_data_guard_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. It takes boolean values. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_local_data_guard_enabled")

    @property
    @pulumi.getter(name="isMtlsConnectionRequired")
    def is_mtls_connection_required(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the Autonomous Database requires mTLS connections.
        """
        return pulumi.get(self, "is_mtls_connection_required")

    @property
    @pulumi.getter(name="isPreview")
    def is_preview(self) -> pulumi.Output[bool]:
        """
        Indicates if the Autonomous Database version is a preview version.
        """
        return pulumi.get(self, "is_preview")

    @property
    @pulumi.getter(name="isPreviewVersionWithServiceTermsAccepted")
    def is_preview_version_with_service_terms_accepted(self) -> pulumi.Output[bool]:
        """
        If set to `TRUE`, indicates that an Autonomous Database preview version is being provisioned, and that the preview version's terms of service have been accepted. Note that preview version software is only available for databases on [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html).
        """
        return pulumi.get(self, "is_preview_version_with_service_terms_accepted")

    @property
    @pulumi.getter(name="isReconnectCloneEnabled")
    def is_reconnect_clone_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if the refreshable clone can be reconnected to its source database.
        """
        return pulumi.get(self, "is_reconnect_clone_enabled")

    @property
    @pulumi.getter(name="isRefreshableClone")
    def is_refreshable_clone(self) -> pulumi.Output[bool]:
        """
        (Updatable) True for creating a refreshable clone and False for detaching the clone from source Autonomous Database. Detaching is one time operation and clone becomes a regular Autonomous Database.
        """
        return pulumi.get(self, "is_refreshable_clone")

    @property
    @pulumi.getter(name="isRemoteDataGuardEnabled")
    def is_remote_data_guard_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether the Autonomous Database has Cross Region Data Guard enabled. It takes boolean values. Not applicable to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_remote_data_guard_enabled")

    @property
    @pulumi.getter(name="isReplicateAutomaticBackups")
    def is_replicate_automatic_backups(self) -> pulumi.Output[bool]:
        """
        If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not replicated to the Standby database.
        """
        return pulumi.get(self, "is_replicate_automatic_backups")

    @property
    @pulumi.getter(name="isShrinkOnly")
    @_utilities.deprecated("""The 'is_shrink_only' field has been deprecated. Please use 'shrink_adb_trigger' instead.""")
    def is_shrink_only(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when enabled triggers the Shrinking of Autonomous Database once. To trigger Shrinking of ADB once again, this flag needs to be disabled and re-enabled again. It should not be passed during create database operation. It is only applicable on Serverless databases i.e. where `is_dedicated` is false.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_shrink_only")

    @property
    @pulumi.getter(name="keyHistoryEntries")
    def key_history_entries(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseKeyHistoryEntry']]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "key_history_entries")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault. This is used in Autonomous Databases on Serverless instances and dedicated Exadata infrastructure.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> pulumi.Output[Optional[str]]:
        """
        The OCID of the key version that is used in rotate key operations.
        """
        return pulumi.get(self, "key_version_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyLifecycleDetails")
    def kms_key_lifecycle_details(self) -> pulumi.Output[str]:
        """
        KMS key lifecycle details.
        """
        return pulumi.get(self, "kms_key_lifecycle_details")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle PaaS and IaaS services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Database service. Note that when provisioning an Autonomous Database on [dedicated Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adbddoverview.htm), this attribute must be null because the attribute is already set at the Autonomous Exadata Infrastructure level. When using [shared Exadata infrastructure](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/adboverview.htm#AEI), if a value is not specified, the system will supply the value of `BRING_YOUR_OWN_LICENSE`. It is a required field when `db_workload` is AJD and needs to be set to `LICENSE_INCLUDED` as AJD does not support default `license_model` value `BRING_YOUR_OWN_LICENSE`.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="localAdgAutoFailoverMaxDataLossLimit")
    def local_adg_auto_failover_max_data_loss_limit(self) -> pulumi.Output[int]:
        """
        Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard
        """
        return pulumi.get(self, "local_adg_auto_failover_max_data_loss_limit")

    @property
    @pulumi.getter(name="localDisasterRecoveryType")
    def local_disaster_recovery_type(self) -> pulumi.Output[str]:
        """
        Indicates the local disaster recovery (DR) type of the Serverless Autonomous Database. Autonomous Data Guard (`ADG`) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based (`BACKUP_BASED`) DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "local_disaster_recovery_type")

    @property
    @pulumi.getter(name="localStandbyDbs")
    def local_standby_dbs(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseLocalStandbyDb']]:
        """
        Autonomous Data Guard local (same region) standby database details.
        """
        return pulumi.get(self, "local_standby_dbs")

    @property
    @pulumi.getter(name="longTermBackupSchedules")
    def long_term_backup_schedules(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseLongTermBackupSchedule']]:
        """
        Details for the long-term backup schedule.
        """
        return pulumi.get(self, "long_term_backup_schedules")

    @property
    @pulumi.getter(name="maxCpuCoreCount")
    def max_cpu_core_count(self) -> pulumi.Output[int]:
        """
        (Updatable) **Deprecated.** The number of Max OCPU cores to be made available to the autonomous database with auto scaling of cpu enabled.
        """
        return pulumi.get(self, "max_cpu_core_count")

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Output[int]:
        """
        The amount of memory (in GBs) enabled per OCPU or ECPU. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details. This parameter is not used for Autonomous database Serverless.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[str]:
        """
        The national character set for the autonomous database.  The default is AL16UTF16. Allowed values are: AL16UTF16 or UTF8.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="netServicesArchitecture")
    def net_services_architecture(self) -> pulumi.Output[str]:
        """
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        """
        return pulumi.get(self, "net_services_architecture")

    @property
    @pulumi.getter(name="nextLongTermBackupTimeStamp")
    def next_long_term_backup_time_stamp(self) -> pulumi.Output[str]:
        """
        The date and time when the next long-term backup would be created.
        """
        return pulumi.get(self, "next_long_term_backup_time_stamp")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Output[float]:
        """
        (Updatable) The number of OCPU cores to be made available to the database.


        * Providing `computeModel` and `computeCount` is the preferred method for setting CPUs for both OCPU and ECPU.
        The following points apply:
        * For Autonomous Databases on dedicated Exadata infrastructure, to provision less than 1 core, enter a fractional value in an increment of 0.1. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. (Note that fractional OCPU values are not supported for Autonomous Databasese on shared Exadata infrastructure.)
        * To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available for the infrastructure shape. For example, you can provision 2 cores or 3 cores, but not 2.5 cores. This applies to Autonomous Databases on both shared and dedicated Exadata infrastructure.

        For Autonomous Databases on dedicated Exadata infrastructure, the maximum number of cores is determined by the infrastructure shape. See [Characteristics of Infrastructure Shapes](https://www.oracle.com/pls/topic/lookup?ctx=en/cloud/paas/autonomous-database&id=ATPFG-GUID-B0F033C1-CC5A-42F0-B2E7-3CECFEDA1FD1) for shape details.

        **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> pulumi.Output[str]:
        """
        Indicates the Autonomous Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.
        """
        return pulumi.get(self, "open_mode")

    @property
    @pulumi.getter(name="operationsInsightsStatus")
    def operations_insights_status(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of Operations Insights for this Autonomous Database. Values supported are `ENABLED` and `NOT_ENABLED`
        """
        return pulumi.get(self, "operations_insights_status")

    @property
    @pulumi.getter(name="peerDbIds")
    def peer_db_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs.
        """
        return pulumi.get(self, "peer_db_ids")

    @property
    @pulumi.getter(name="permissionLevel")
    def permission_level(self) -> pulumi.Output[str]:
        """
        The Autonomous Database permission level. Restricted mode allows access only by admin users.
        """
        return pulumi.get(self, "permission_level")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> pulumi.Output[str]:
        """
        The private endpoint for the resource. This parameter is not used in Autonomous Databases using Serverless infrastructure and Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> pulumi.Output[str]:
        """
        The private endpoint Ip address for the resource.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="privateEndpointLabel")
    def private_endpoint_label(self) -> pulumi.Output[str]:
        """
        (Updatable) (Optional) (Updatable) The resource's private endpoint label.
        * Setting the endpoint label to a non-empty string creates a private endpoint database.
        * Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
        * Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.
        """
        return pulumi.get(self, "private_endpoint_label")

    @property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> pulumi.Output[Sequence[float]]:
        """
        An array of CPU values that an Autonomous Database can be scaled to.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @property
    @pulumi.getter(name="publicConnectionUrls")
    def public_connection_urls(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabasePublicConnectionUrl']]:
        """
        The Public URLs of Private Endpoint database for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN.
        """
        return pulumi.get(self, "public_connection_urls")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> pulumi.Output[str]:
        """
        The public endpoint for the private endpoint enabled resource.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="refreshableMode")
    def refreshable_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous Database.
        """
        return pulumi.get(self, "refreshable_mode")

    @property
    @pulumi.getter(name="refreshableStatus")
    def refreshable_status(self) -> pulumi.Output[str]:
        """
        The refresh status of the clone. REFRESHING indicates that the clone is currently being refreshed with data from the source Autonomous Database.
        """
        return pulumi.get(self, "refreshable_status")

    @property
    @pulumi.getter(name="remoteDisasterRecoveryConfigurations")
    def remote_disaster_recovery_configurations(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseRemoteDisasterRecoveryConfiguration']]:
        """
        Configurations of a Disaster Recovery.
        """
        return pulumi.get(self, "remote_disaster_recovery_configurations")

    @property
    @pulumi.getter(name="remoteDisasterRecoveryType")
    def remote_disaster_recovery_type(self) -> pulumi.Output[str]:
        """
        Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover.
        """
        return pulumi.get(self, "remote_disaster_recovery_type")

    @property
    @pulumi.getter(name="resourcePoolLeaderId")
    def resource_pool_leader_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_pool_leader_id")

    @property
    @pulumi.getter(name="resourcePoolSummary")
    def resource_pool_summary(self) -> pulumi.Output['outputs.AutonomousDatabaseResourcePoolSummary']:
        """
        (Updatable) The configuration details for resource pool
        """
        return pulumi.get(self, "resource_pool_summary")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="rotateKeyTrigger")
    def rotate_key_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when flipped triggers rotation of KMS key. It is only applicable on dedicated databases i.e. where `is_dedicated` is true.
        """
        return pulumi.get(self, "rotate_key_trigger")

    @property
    @pulumi.getter(name="scheduledOperations")
    def scheduled_operations(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseScheduledOperation']]:
        """
        (Updatable) The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "scheduled_operations")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle Cloud Infrastructure vault secret [/Content/General/Concepts/identifiers.htm]OCID.

        This cannot be used in conjunction with adminPassword.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> pulumi.Output[int]:
        """
        (Updatable) The version of the vault secret. If no version is specified, the latest version will be used.
        """
        return pulumi.get(self, "secret_version_number")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter(name="serviceConsoleUrl")
    def service_console_url(self) -> pulumi.Output[str]:
        """
        The URL of the Service Console for the Autonomous Database.
        """
        return pulumi.get(self, "service_console_url")

    @property
    @pulumi.getter(name="shrinkAdbTrigger")
    def shrink_adb_trigger(self) -> pulumi.Output[int]:
        return pulumi.get(self, "shrink_adb_trigger")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of the database:
        * Use `NONE` for creating a new Autonomous Database.
        * Use `DATABASE` for creating a new Autonomous Database by cloning an existing running Autonomous Database from the latest timestamp, also provide the source database OCID in the `source_id` parameter.
        * Use `CROSS_REGION_DATAGUARD` to create a standby Data Guard database in another region, also provide the remote primary database OCID in the `source_id` parameter.
        * Use `CLONE_TO_REFRESHABLE` for creating a refreshable clone.

        For [Autonomous Database Serverless](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) instances, the following cloning options are available:
        * Use `BACKUP_FROM_ID` for creating a new Autonomous Database by cloning from a specified backup. Also provide the backup OCID in the `autonomous_database_backup_id` parameter.
        * Use `BACKUP_FROM_TIMESTAMP` for creating a point-in-time Autonomous Database clone using backups. Also provide the backup timestamp in the `timestamp` parameter. For more information, see [Cloning and Moving an Autonomous Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/clone-autonomous-database.html#GUID-D771796F-5081-4CFB-A7FF-0F893EABD7BC).
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source Autonomous Database that will be used to create a new standby database for the Data Guard association.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="standbyDbs")
    def standby_dbs(self) -> pulumi.Output[Sequence['outputs.AutonomousDatabaseStandbyDb']]:
        """
        **Deprecated** Autonomous Data Guard standby database details.
        """
        return pulumi.get(self, "standby_dbs")

    @property
    @pulumi.getter(name="standbyWhitelistedIps")
    def standby_whitelisted_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance. If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous Database uses `whitelisted_ips` primary's IP access control list (ACL) as `standbywhitelistedips` for the disaster recovery peer.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "standby_whitelisted_ips")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Autonomous Database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the resource is associated with. This the only parameter to configure private endpoint, VCN details are obtained from the `subnet_id`.

        **Subnet Restrictions:**
        * For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        * For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
        * For Autonomous Database, setting this will disable public secure access to the database.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and the backup subnet.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="supportedRegionsToCloneTos")
    def supported_regions_to_clone_tos(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database.
        """
        return pulumi.get(self, "supported_regions_to_clone_tos")

    @property
    @pulumi.getter(name="switchoverTo")
    def switchover_to(self) -> pulumi.Output[Optional[str]]:
        """
        It is applicable only when `is_local_data_guard_enabled` is true. Could be set to `PRIMARY` or `STANDBY`. Default value is `PRIMARY`.
        """
        return pulumi.get(self, "switchover_to")

    @property
    @pulumi.getter(name="switchoverToRemotePeerId")
    def switchover_to_remote_peer_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) It is applicable only when `dataguard_region_type` and `role` are set, and `is_dedicated` is false. For Autonomous Database Serverless instances, Data Guard associations have designated primary and standby regions, and these region types do not change when the database changes roles. It takes the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the remote peer to switchover to and the API is called from the remote region.
        """
        return pulumi.get(self, "switchover_to_remote_peer_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Autonomous Database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDataGuardRoleChanged")
    def time_data_guard_role_changed(self) -> pulumi.Output[str]:
        """
        The date and time the Autonomous Data Guard role was switched for the Autonomous Database. For databases that have standbys in both the primary Data Guard region and a remote Data Guard standby region, this is the latest timestamp of either the database using the "primary" role in the primary Data Guard region, or database located in the remote Data Guard standby region.
        """
        return pulumi.get(self, "time_data_guard_role_changed")

    @property
    @pulumi.getter(name="timeDeletionOfFreeAutonomousDatabase")
    def time_deletion_of_free_autonomous_database(self) -> pulumi.Output[str]:
        """
        The date and time the Always Free database will be automatically deleted because of inactivity. If the database is in the STOPPED state and without activity until this time, it will be deleted.
        """
        return pulumi.get(self, "time_deletion_of_free_autonomous_database")

    @property
    @pulumi.getter(name="timeDisasterRecoveryRoleChanged")
    def time_disaster_recovery_role_changed(self) -> pulumi.Output[str]:
        """
        The date and time the Disaster Recovery role was switched for the standby Autonomous Database.
        """
        return pulumi.get(self, "time_disaster_recovery_role_changed")

    @property
    @pulumi.getter(name="timeLocalDataGuardEnabled")
    def time_local_data_guard_enabled(self) -> pulumi.Output[str]:
        """
        The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database.
        """
        return pulumi.get(self, "time_local_data_guard_enabled")

    @property
    @pulumi.getter(name="timeMaintenanceBegin")
    def time_maintenance_begin(self) -> pulumi.Output[str]:
        """
        The date and time when maintenance will begin.
        """
        return pulumi.get(self, "time_maintenance_begin")

    @property
    @pulumi.getter(name="timeMaintenanceEnd")
    def time_maintenance_end(self) -> pulumi.Output[str]:
        """
        The date and time when maintenance will end.
        """
        return pulumi.get(self, "time_maintenance_end")

    @property
    @pulumi.getter(name="timeOfAutoRefreshStart")
    def time_of_auto_refresh_start(self) -> pulumi.Output[str]:
        """
        The the date and time that auto-refreshing will begin for an Autonomous Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.
        """
        return pulumi.get(self, "time_of_auto_refresh_start")

    @property
    @pulumi.getter(name="timeOfJoiningResourcePool")
    def time_of_joining_resource_pool(self) -> pulumi.Output[str]:
        return pulumi.get(self, "time_of_joining_resource_pool")

    @property
    @pulumi.getter(name="timeOfLastFailover")
    def time_of_last_failover(self) -> pulumi.Output[str]:
        """
        The timestamp of the last failover operation.
        """
        return pulumi.get(self, "time_of_last_failover")

    @property
    @pulumi.getter(name="timeOfLastRefresh")
    def time_of_last_refresh(self) -> pulumi.Output[str]:
        """
        The date and time when last refresh happened.
        """
        return pulumi.get(self, "time_of_last_refresh")

    @property
    @pulumi.getter(name="timeOfLastRefreshPoint")
    def time_of_last_refresh_point(self) -> pulumi.Output[str]:
        """
        The refresh point timestamp (UTC). The refresh point is the time to which the database was most recently refreshed. Data created after the refresh point is not included in the refresh.
        """
        return pulumi.get(self, "time_of_last_refresh_point")

    @property
    @pulumi.getter(name="timeOfLastSwitchover")
    def time_of_last_switchover(self) -> pulumi.Output[str]:
        """
        The timestamp of the last switchover operation for the Autonomous Database.
        """
        return pulumi.get(self, "time_of_last_switchover")

    @property
    @pulumi.getter(name="timeOfNextRefresh")
    def time_of_next_refresh(self) -> pulumi.Output[str]:
        """
        The date and time of next refresh.
        """
        return pulumi.get(self, "time_of_next_refresh")

    @property
    @pulumi.getter(name="timeReclamationOfFreeAutonomousDatabase")
    def time_reclamation_of_free_autonomous_database(self) -> pulumi.Output[str]:
        """
        The date and time the Always Free database will be stopped because of inactivity. If this time is reached without any database activity, the database will automatically be put into the STOPPED state.
        """
        return pulumi.get(self, "time_reclamation_of_free_autonomous_database")

    @property
    @pulumi.getter(name="timeUndeleted")
    def time_undeleted(self) -> pulumi.Output[str]:
        return pulumi.get(self, "time_undeleted")

    @property
    @pulumi.getter(name="timeUntilReconnectCloneEnabled")
    def time_until_reconnect_clone_enabled(self) -> pulumi.Output[str]:
        """
        The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to its source database.
        """
        return pulumi.get(self, "time_until_reconnect_clone_enabled")

    @property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[str]:
        """
        The timestamp specified for the point-in-time clone of the source Autonomous Database. The timestamp must be in the past.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="totalBackupStorageSizeInGbs")
    def total_backup_storage_size_in_gbs(self) -> pulumi.Output[float]:
        """
        The backup storage to the database.
        """
        return pulumi.get(self, "total_backup_storage_size_in_gbs")

    @property
    @pulumi.getter(name="useLatestAvailableBackupTimeStamp")
    def use_latest_available_backup_time_stamp(self) -> pulumi.Output[bool]:
        """
        Clone from latest available backup timestamp.
        """
        return pulumi.get(self, "use_latest_available_backup_time_stamp")

    @property
    @pulumi.getter(name="usedDataStorageSizeInGbs")
    def used_data_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The storage space consumed by Autonomous Database in GBs.
        """
        return pulumi.get(self, "used_data_storage_size_in_gbs")

    @property
    @pulumi.getter(name="usedDataStorageSizeInTbs")
    def used_data_storage_size_in_tbs(self) -> pulumi.Output[int]:
        """
        The amount of storage that has been used, in terabytes.
        """
        return pulumi.get(self, "used_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The client IP access control list (ACL). This feature is available for autonomous databases on [shared Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) and on Exadata Cloud@Customer. Only clients connecting from an IP address included in the ACL may access the Autonomous Database instance.

        For Autonomous Database Serverless instances, this is an array of CIDR (Classless Inter-Domain Routing) notations for a subnet or VCN OCID. Use a semicolon (;) as a deliminator between the VCN-specific subnets or IPs. Example: `["1.1.1.1","1.1.1.0/24","ocid1.vcn.oc1.sea.<unique_id>","ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1","ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16"]` For Exadata Cloud@Customer, this is an array of IP addresses or CIDR (Classless Inter-Domain Routing) notations. Example: `["1.1.1.1","1.1.1.0/24","1.1.2.25"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier. To remove all whitelisted IPs, set the field to a list with an empty string `[""]`.
        """
        return pulumi.get(self, "whitelisted_ips")

