# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFsuCyclesResult',
    'AwaitableGetFsuCyclesResult',
    'get_fsu_cycles',
    'get_fsu_cycles_output',
]

@pulumi.output_type
class GetFsuCyclesResult:
    """
    A collection of values returned by getFsuCycles.
    """
    def __init__(__self__, collection_type=None, compartment_id=None, display_name=None, filters=None, fsu_collection_id=None, fsu_cycle_summary_collections=None, id=None, state=None, target_version=None):
        if collection_type and not isinstance(collection_type, str):
            raise TypeError("Expected argument 'collection_type' to be a str")
        pulumi.set(__self__, "collection_type", collection_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fsu_collection_id and not isinstance(fsu_collection_id, str):
            raise TypeError("Expected argument 'fsu_collection_id' to be a str")
        pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        if fsu_cycle_summary_collections and not isinstance(fsu_cycle_summary_collections, list):
            raise TypeError("Expected argument 'fsu_cycle_summary_collections' to be a list")
        pulumi.set(__self__, "fsu_cycle_summary_collections", fsu_cycle_summary_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[str]:
        """
        Type of Collection this Exadata Fleet Update Cycle belongs to.
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Exadata Fleet Update Cycle display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFsuCyclesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> Optional[str]:
        """
        OCID identifier for the Collection ID the Exadata Fleet Update Cycle is assigned to.
        """
        return pulumi.get(self, "fsu_collection_id")

    @property
    @pulumi.getter(name="fsuCycleSummaryCollections")
    def fsu_cycle_summary_collections(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionResult']:
        """
        The list of fsu_cycle_summary_collection.
        """
        return pulumi.get(self, "fsu_cycle_summary_collections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[str]:
        return pulumi.get(self, "target_version")


class AwaitableGetFsuCyclesResult(GetFsuCyclesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFsuCyclesResult(
            collection_type=self.collection_type,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fsu_collection_id=self.fsu_collection_id,
            fsu_cycle_summary_collections=self.fsu_cycle_summary_collections,
            id=self.id,
            state=self.state,
            target_version=self.target_version)


def get_fsu_cycles(collection_type: Optional[str] = None,
                   compartment_id: Optional[str] = None,
                   display_name: Optional[str] = None,
                   filters: Optional[Sequence[Union['GetFsuCyclesFilterArgs', 'GetFsuCyclesFilterArgsDict']]] = None,
                   fsu_collection_id: Optional[str] = None,
                   state: Optional[str] = None,
                   target_version: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFsuCyclesResult:
    """
    This data source provides the list of Fsu Cycles in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a list of all Exadata Fleet Update Cycles in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_cycles = oci.FleetSoftwareUpdate.get_fsu_cycles(compartment_id=compartment_id,
        collection_type=fsu_cycle_collection_type,
        display_name=fsu_cycle_display_name,
        fsu_collection_id=test_fsu_collection["id"],
        state=fsu_cycle_state,
        target_version=fsu_cycle_target_version)
    ```


    :param str collection_type: A filter to return only resources whose Collection type matches the given type.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fsu_collection_id: A filter to return only resources whose fsuCollectionId matches the given fsuCollectionId.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str target_version: A filter to return only entries whose targetVersion matches the given targetVersion.
    """
    __args__ = dict()
    __args__['collectionType'] = collection_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fsuCollectionId'] = fsu_collection_id
    __args__['state'] = state
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetSoftwareUpdate/getFsuCycles:getFsuCycles', __args__, opts=opts, typ=GetFsuCyclesResult).value

    return AwaitableGetFsuCyclesResult(
        collection_type=pulumi.get(__ret__, 'collection_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fsu_collection_id=pulumi.get(__ret__, 'fsu_collection_id'),
        fsu_cycle_summary_collections=pulumi.get(__ret__, 'fsu_cycle_summary_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        target_version=pulumi.get(__ret__, 'target_version'))
def get_fsu_cycles_output(collection_type: Optional[pulumi.Input[Optional[str]]] = None,
                          compartment_id: Optional[pulumi.Input[str]] = None,
                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFsuCyclesFilterArgs', 'GetFsuCyclesFilterArgsDict']]]]] = None,
                          fsu_collection_id: Optional[pulumi.Input[Optional[str]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          target_version: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFsuCyclesResult]:
    """
    This data source provides the list of Fsu Cycles in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a list of all Exadata Fleet Update Cycles in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_cycles = oci.FleetSoftwareUpdate.get_fsu_cycles(compartment_id=compartment_id,
        collection_type=fsu_cycle_collection_type,
        display_name=fsu_cycle_display_name,
        fsu_collection_id=test_fsu_collection["id"],
        state=fsu_cycle_state,
        target_version=fsu_cycle_target_version)
    ```


    :param str collection_type: A filter to return only resources whose Collection type matches the given type.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fsu_collection_id: A filter to return only resources whose fsuCollectionId matches the given fsuCollectionId.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str target_version: A filter to return only entries whose targetVersion matches the given targetVersion.
    """
    __args__ = dict()
    __args__['collectionType'] = collection_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fsuCollectionId'] = fsu_collection_id
    __args__['state'] = state
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetSoftwareUpdate/getFsuCycles:getFsuCycles', __args__, opts=opts, typ=GetFsuCyclesResult)
    return __ret__.apply(lambda __response__: GetFsuCyclesResult(
        collection_type=pulumi.get(__response__, 'collection_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fsu_collection_id=pulumi.get(__response__, 'fsu_collection_id'),
        fsu_cycle_summary_collections=pulumi.get(__response__, 'fsu_cycle_summary_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        target_version=pulumi.get(__response__, 'target_version')))
