# Generated by Django 3.0 on 2019-12-29 13:07

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djsonrest.addons.jwt_auth.models.token
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Consumer',
            fields=[
                ('uid', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('key', models.CharField(max_length=128)),
                ('allowed_origin', models.CharField(help_text='Allowed origin which will be used in the Access-Control-Allow-Origin Header', max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Token',
            fields=[
                ('id', models.CharField(default=djsonrest.addons.jwt_auth.models.token.generate_token_id, max_length=64, primary_key=True, serialize=False)),
                ('issued_at', models.DateTimeField(auto_now_add=True)),
                ('expire_at', models.DateTimeField()),
                ('subject', models.CharField(max_length=128)),
                ('audience', models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='ConsumerIPRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip', models.CharField(help_text='IP Address or Subnet in CIDR Notation', max_length=196)),
                ('type', models.CharField(choices=[('allow', 'Allow'), ('deny', 'Deny')], max_length=8)),
                ('consumer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ip_rules', to='jwt_auth.Consumer')),
            ],
        ),
        migrations.AddField(
            model_name='consumer',
            name='tokens',
            field=models.ManyToManyField(related_name='consumer', to='jwt_auth.Token'),
        ),
        migrations.AddField(
            model_name='consumer',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='consumer', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='UserToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='user_token', to='jwt_auth.Token')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_tokens', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'token')},
            },
        ),
    ]
