"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class TimeToLive extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        core_1.Stack.of(this).node.addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_lambda_1.Function(this, 'DeleteStack', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_events_1.Rule(this, 'TimeToLive', {
            schedule: aws_events_1.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(deleteStack, {
            event: aws_events_1.RuleTargetInput.fromObject({
                stackId: core_1.Aws.STACK_ID,
            }),
        }));
    }
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    onPrepare() {
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (!this.node.findAll().includes(c)) {
                c.node.addDependency(this);
            }
        });
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        let count = 0;
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (c instanceof TimeToLive) {
                count++;
            }
        });
        if (count > 1) {
            return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
        }
        return [];
    }
}
exports.TimeToLive = TimeToLive;
//# sourceMappingURL=data:application/json;base64,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