# generated by datamodel-codegen:
#   filename:  api/lineage/searchLineageRequest.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import lineageDirection


class SearchLineageRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fqn: Annotated[str, Field(description='Entity Fqn to search lineage')]
    isConnectedVia: Annotated[Optional[bool], Field(None, description='Connected Via')]
    direction: lineageDirection.LineageDirection
    directionValue: Annotated[
        Optional[List[str]], Field(None, description='Lineage Direction Value.')
    ]
    upstreamDepth: Annotated[
        Optional[int], Field(3, description='The upstream depth of the lineage')
    ]
    downstreamDepth: Annotated[
        Optional[int], Field(3, description='The downstream depth of the lineage')
    ]
    layerFrom: Annotated[
        Optional[int], Field(0, description='Layer to start the search from.')
    ]
    layerSize: Annotated[
        Optional[int], Field(1000, description='Size of the search result.')
    ]
    queryFilter: Annotated[Optional[str], Field(None, description='Query Filter')]
    includeDeleted: Annotated[
        Optional[bool], Field(None, description='Include deleted entities')
    ]
    includeSourceFields: Annotated[
        Optional[List[str]], Field(None, description='Include source fields')
    ]
