# generated by datamodel-codegen:
#   filename:  entity/data/topic.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    schema,
    tagLabel,
    votes,
)
from ..services import messagingService


class CleanupPolicy(Enum):
    delete = 'delete'
    compact = 'compact'


class TopicConfig(BaseModel):
    pass


class TopicSampleData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    messages: Annotated[
        Optional[List[str]],
        Field(None, description='List of local sample messages for a topic.'),
    ]


class Topic(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies this topic instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies the topic.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="Name that uniquely identifies a topic in the format 'messagingServiceName.topicName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this topic. It could be title or label from the source services.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the topic instance.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the messaging cluster/service where this topic is hosted in.'
        ),
    ]
    serviceType: Annotated[
        Optional[messagingService.MessagingServiceType],
        Field(None, description='Service type where this topic is hosted in.'),
    ]
    messageSchema: Optional[schema.Topic] = None
    partitions: Annotated[
        int,
        Field(
            description='Number of partitions into which the topic is divided.', ge=1
        ),
    ]
    cleanupPolicies: Annotated[
        Optional[List[CleanupPolicy]],
        Field(
            None,
            description='Topic clean up policies. For Kafka - `cleanup.policy` configuration.',
        ),
    ]
    retentionTime: Annotated[
        Optional[float],
        Field(
            None,
            description='Retention time in milliseconds. For Kafka - `retention.ms` configuration.',
        ),
    ]
    replicationFactor: Annotated[
        Optional[int],
        Field(None, description='Replication Factor in integer (more than 1).'),
    ]
    maximumMessageSize: Annotated[
        Optional[int],
        Field(
            None,
            description='Maximum message size in bytes. For Kafka - `max.message.bytes` configuration.',
        ),
    ]
    minimumInSyncReplicas: Annotated[
        Optional[int],
        Field(
            None,
            description='Minimum number replicas in sync to control durability. For Kafka - `min.insync.replicas` configuration.',
        ),
    ]
    retentionSize: Annotated[
        Optional[float],
        Field(
            '-1',
            description='Maximum size of a partition in bytes before old data is discarded. For Kafka - `retention.bytes` configuration.',
        ),
    ]
    topicConfig: Annotated[
        Optional[TopicConfig],
        Field(None, description='Contains key/value pair of topic configuration.'),
    ]
    sampleData: Annotated[
        Optional[TopicSampleData], Field(None, description='Sample data for a topic.')
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this topic.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this table.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]], Field([], description='Tags for this table.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of topic.')
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the Topic belongs to. When not set, the Topic inherits the domain from the messaging service it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
