# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/domoDatabaseConnection.json
#   timestamp: 2025-07-18T13:46:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class DomoDatabaseType(Enum):
    DomoDatabase = 'DomoDatabase'


class DomoDatabaseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DomoDatabaseType],
        Field(
            DomoDatabaseType.DomoDatabase,
            description='Service Type',
            title='Service Type',
        ),
    ]
    clientId: Annotated[str, Field(description='Client ID for DOMO', title='Client ID')]
    secretToken: Annotated[
        CustomSecretStr,
        Field(description='Secret Token to connect DOMO', title='Secret Token'),
    ]
    accessToken: Annotated[
        Optional[str],
        Field(
            None, description='Access token to connect to DOMO', title='Access Token'
        ),
    ]
    apiHost: Annotated[
        Optional[str],
        Field(
            'api.domo.com',
            description='API Host to connect to DOMO instance',
            title='API Host',
        ),
    ]
    instanceDomain: Annotated[
        AnyUrl,
        Field(
            description='URL of your Domo instance, e.g., https://openmetadata.domo.com',
            title='Instance Domain',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
